/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.common;

import com.sun.wbem.apps.common.JSpinBox;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JIntSpinBox
extends JSpinBox {
    private static final Dimension MIN_SIZE = new Dimension(34, 17);
    private JSpinBox spinBox = this;
    public int floor;
    public int ceiling;
    public int increment = 1;
    private boolean bDoubleAught = false;

    public JIntSpinBox(int n, int n2, int n3) {
        this(n, n2, n3, 1);
    }

    public JIntSpinBox(int n, int n2, int n3, int n4) {
        super(n);
        this.spinBox.setMinimumSize(MIN_SIZE);
        this.setIncrement(n4);
        this.addListeners(n2, n3);
    }

    private void addListeners(int n, int n2) {
        this.spinBox.getUpButton().addActionListener(new UpBtnListener());
        this.spinBox.getDownButton().addActionListener(new DownBtnListener());
        this.floor = n;
        this.ceiling = n2;
        this.spinBox.getTextField().setDocument(new IntOnlyDocument());
    }

    public int getFloor() {
        if (this.floor == 0 && this.getDoubleAught()) {
            Integer n = new Integer(0);
            return n;
        }
        return this.floor;
    }

    public void setFloor(int n) {
        this.floor = n;
    }

    public int getCeiling() {
        if (this.ceiling == 0 && this.getDoubleAught()) {
            Integer n = new Integer(0);
            return n;
        }
        return this.ceiling;
    }

    public void setCeiling(int n) {
        this.ceiling = n;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int n) {
        this.increment = n;
    }

    public synchronized int getIntValue() {
        Integer n;
        if (this.getStringValue().equals("")) {
            return 0;
        }
        try {
            n = new Integer(this.getStringValue());
        }
        catch (NumberFormatException numberFormatException) {
            return this.increment;
        }
        return n;
    }

    public void setIntValue(int n) {
        int n2 = n;
        if (this.getDoubleAught() && n2 == 0) {
            this.spinBox.getTextField().setText("00");
        } else {
            if (n2 < this.floor) {
                n2 = this.floor;
            } else if (n2 > this.ceiling) {
                n2 = this.ceiling;
            }
            this.spinBox.getTextField().setText(Integer.toString(n2));
        }
    }

    public synchronized String getStringValue() {
        return this.spinBox.getTextField().getText();
    }

    public void removeValue() {
        this.spinBox.getTextField().setText("");
    }

    public void setEnabled(boolean bl) {
        this.spinBox.getUpButton().setEnabled(bl);
        this.spinBox.getDownButton().setEnabled(bl);
        this.spinBox.getTextField().setEnabled(bl);
    }

    public void setDoubleAught(boolean bl) {
        this.bDoubleAught = bl;
    }

    public boolean getDoubleAught() {
        return this.bDoubleAught;
    }

    private synchronized void doUp() {
        if (this.getStringValue().equals("")) {
            Integer n = new Integer(this.getFloor());
            this.setIntValue(n);
        } else {
            Integer n = new Integer(this.getIntValue() + this.getIncrement());
            if (n <= this.getCeiling()) {
                if (n < this.getFloor()) {
                    this.setIntValue(this.getFloor());
                } else {
                    this.setIntValue(n);
                }
                if (!this.spinBox.isWrapping() && n.intValue() == this.getCeiling()) {
                    this.spinBox.getUpButton().setEnabled(false);
                }
                if (!this.spinBox.getDownButton().isEnabled()) {
                    this.spinBox.getDownButton().setEnabled(true);
                }
            } else if (this.spinBox.isWrapping()) {
                n = new Integer(this.getFloor());
                this.setIntValue(n);
            } else {
                this.spinBox.getUpButton().setEnabled(false);
                this.spinBox.toolkit.beep();
                return;
            }
        }
    }

    private synchronized void doDown() {
        if (this.getStringValue().equals("")) {
            Integer n = new Integer(this.getCeiling());
            this.setIntValue(n);
        } else {
            Integer n = new Integer(this.getIntValue() - this.getIncrement());
            if (n >= this.getFloor()) {
                this.setIntValue(n);
                if (!this.spinBox.isWrapping() && n.intValue() == this.getFloor()) {
                    this.spinBox.getUpButton().setEnabled(false);
                }
                if (!this.spinBox.getUpButton().isEnabled()) {
                    this.spinBox.getUpButton().setEnabled(true);
                }
            } else if (this.spinBox.isWrapping()) {
                n = new Integer(this.getCeiling());
                this.setIntValue(n);
            } else {
                this.spinBox.getDownButton().setEnabled(false);
                this.spinBox.toolkit.beep();
                return;
            }
        }
    }

    public class DownBtnListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JIntSpinBox.this.doDown();
        }
    }

    public class UpBtnListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JIntSpinBox.this.doUp();
        }
    }

    public class IntOnlyDocument
    extends PlainDocument {
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < cArray2.length) {
                if (!(Character.isDigit(cArray[n3]) || n3 == 0 && cArray[n3] == '-' && JIntSpinBox.this.floor < 0)) {
                    ((JIntSpinBox)JIntSpinBox.this).spinBox.toolkit.beep();
                    return;
                }
                cArray2[n2++] = cArray[n3];
                ++n3;
            }
            String string2 = JIntSpinBox.this.getStringValue().substring(0, n);
            string2 = string2 + new String(cArray2, 0, n2);
            if ((string2 = string2 + JIntSpinBox.this.getStringValue().substring(n)).length() > 0) {
                if (string2.equals("-") && n2 == 1) {
                    super.insertString(n, new String(cArray2, 0, n2), attributeSet);
                } else {
                    Integer n4;
                    try {
                        n4 = new Integer(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        ((JIntSpinBox)JIntSpinBox.this).spinBox.toolkit.beep();
                        return;
                    }
                    int n5 = n4;
                    if (n5 <= JIntSpinBox.this.getCeiling()) {
                        super.insertString(n, new String(cArray2, 0, n2), attributeSet);
                        if (!JIntSpinBox.this.spinBox.isWrapping() && JIntSpinBox.this.spinBox.isEditable()) {
                            if (n5 < JIntSpinBox.this.getCeiling() && !JIntSpinBox.this.spinBox.getUpButton().isEnabled()) {
                                JIntSpinBox.this.spinBox.getUpButton().setEnabled(true);
                            } else if (n5 > JIntSpinBox.this.getFloor() && !JIntSpinBox.this.spinBox.getDownButton().isEnabled()) {
                                JIntSpinBox.this.spinBox.getDownButton().setEnabled(true);
                            }
                        }
                    } else {
                        super.insertString(n, null, attributeSet);
                    }
                }
            }
        }
    }
}

