/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.cimworkshop.CIMTableTabbedPane;
import com.sun.wbem.apps.cimworkshop.InstancePanel;
import com.sun.wbem.apps.cimworkshop.QueryFrame;
import com.sun.wbem.apps.common.CIMErrorDialog;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class QueryActionPanel
extends InstancePanel
implements ListSelectionListener,
ActionListener {
    private CIMTableTabbedPane tablePane;
    private QueryFrame queryFrame;
    private String queryString = null;

    public QueryActionPanel(CIMTableTabbedPane cIMTableTabbedPane, QueryFrame queryFrame, String string) {
        super(null, true);
        this.emptyInstances.setText(I18N.loadString("ERR_QUERY_RESULT"));
        this.queryString = string;
        this.tablePane = cIMTableTabbedPane;
        this.queryFrame = queryFrame;
        this.instanceList.getSelectionModel().addListSelectionListener(this);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.instanceList.getSelectedIndex();
        Util.setWaitCursor(this);
        if (!this.listModel.isEmpty() && n >= 0 && n < this.listModel.size()) {
            try {
                CIMObjectPath cIMObjectPath = (CIMObjectPath)this.listModel.elementAt(n);
                CIMInstance cIMInstance = this.cimClient.getInstance(cIMObjectPath, false, true, true, null);
                this.tablePane.populateTables(this.cimClient, (CIMElement)cIMInstance);
            }
            catch (CIMException cIMException) {
                this.tablePane.populateTables(null, null);
                CIMErrorDialog.display(this, cIMException);
            }
        } else {
            this.tablePane.populateTables(null, null);
        }
        Util.setDefaultCursor(this);
    }

    public void refreshInstanceList() {
        this.listModel.removeAllElements();
        try {
            Enumeration enumeration = this.cimClient.execQuery(new CIMObjectPath(), this.queryString, "WQL");
            while (enumeration.hasMoreElements()) {
                CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                CIMObjectPath cIMObjectPath = new CIMObjectPath();
                cIMObjectPath.setKeys(cIMInstance.getKeyValuePairs());
                cIMObjectPath.setObjectName(cIMInstance.getClassName());
                this.listModel.addElement(cIMObjectPath);
            }
        }
        catch (CIMException cIMException) {
            CIMErrorDialog.display(this, cIMException);
        }
        if (this.listModel.size() > 0) {
            this.instanceList.setSelectedIndex(0);
        }
        this.setViewPort();
    }
}

