/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.cimworkshop.CIMKeyPropertiesPanel;
import com.sun.wbem.apps.common.ActionString;
import com.sun.wbem.apps.common.AdminDialog;
import com.sun.wbem.apps.common.ContextHelpListener;
import com.sun.wbem.apps.common.GenInfoPanel;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.Util;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;

public class CreateInstanceDialog
extends AdminDialog
implements ActionListener,
TableModelListener {
    protected JButton btnOK;
    protected JButton btnCancel;
    protected GenInfoPanel infoPanel;
    protected CIMClient cimClient;
    protected CIMInstance newInstance;
    protected String selectedNameSpace;
    protected CIMKeyPropertiesPanel table;
    protected JTextArea msg;
    protected Vector properties;

    public CreateInstanceDialog(Frame frame, CIMClient cIMClient, CIMClass cIMClass) {
        super(frame, "", false);
        this.setTitle(I18N.loadStringFormat("TTL_ADD_INSTANCE", cIMClass.getName()));
        this.cimClient = cIMClient;
        this.infoPanel = this.getInfoPanel();
        JPanel jPanel = this.getRightPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        ActionString actionString = new ActionString("LBL_PROPERTIES");
        JLabel jLabel = new JLabel(actionString.getString() + ":");
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.newInstance = cIMClass.newInstance();
        this.table = new CIMKeyPropertiesPanel(this.cimClient, this.newInstance);
        this.table.setPreferredSize(new Dimension(300, 200));
        jLabel.setLabelFor(this.table.getTable());
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.table.addTableListener(this);
        this.btnOK = this.getOKBtn();
        this.btnOK.addActionListener(new OKCancelButtonListener());
        this.btnCancel = this.getCancelBtn();
        this.btnCancel.addActionListener(new OKCancelButtonListener());
        jPanel.add("North", jLabel);
        jPanel.add("Center", this.table);
        this.setDefaultFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "AddInstance_000.htm"), true);
        this.table.getTable().addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "AddInstance_000.htm"));
        this.pack();
        this.enableOKBtn();
        this.setLocation(Util.getCenterPoint(frame, this));
        this.setVisible(true);
    }

    protected void enableOKBtn() {
        Vector vector = this.table.getProperties();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CIMValue cIMValue;
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.isKey() || (cIMValue = cIMProperty.getValue()) != null && cIMValue.getValue() != null) continue;
            this.btnOK.setEnabled(false);
            return;
        }
        this.btnOK.setEnabled(true);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.enableOKBtn();
    }

    public CIMInstance getInstance() {
        return this.newInstance;
    }

    public void okClicked() {
        Vector vector = this.table.getProperties();
        Enumeration enumeration = vector.elements();
        this.newInstance.updatePropertyValues(vector);
        this.dispose();
    }

    public void cancelClicked() {
        this.newInstance = null;
        this.dispose();
    }

    public void windowOpened(WindowEvent windowEvent) {
        super.windowOpened(windowEvent);
        JTable jTable = this.table.getTable();
        jTable.requestFocus();
        if (jTable.getRowCount() > 0) {
            this.table.selectValueCell(0);
        }
    }

    class OKCancelButtonListener
    implements ActionListener {
        OKCancelButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == CreateInstanceDialog.this.btnCancel) {
                CreateInstanceDialog.this.cancelClicked();
            } else if (actionEvent.getSource() == CreateInstanceDialog.this.btnOK) {
                CreateInstanceDialog.this.okClicked();
            }
        }
    }
}

