/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.SelectableLabel;
import com.sun.admin.patchmgr.client.DownloadPatchWizard;
import com.sun.admin.patchmgr.client.PatchContextHelpListener;
import com.sun.admin.patchmgr.client.VPatchMgr;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DownloadReviewCard
extends VWizardCard {
    private VPatchMgr theApp;
    private ResourceBundle bundle;
    private DownloadPatchWizard wiz;
    private ActionString actionString;
    private GenInfoPanel infoPanel;
    private PatchContextHelpListener overviewHelpListener;
    private PatchContextHelpListener patchHelp;
    private PatchContextHelpListener dirHelp;
    private PatchContextHelpListener textHelp;
    private SelectableLabel textFileField;
    private SelectableLabel dirField;
    private JList reviewList;
    private JLabel selLbl = new JLabel();
    private JLabel fileLbl = new JLabel();
    private JLabel patchLbl = new JLabel();
    private JLabel dirLbl = new JLabel();
    public static final int HELP_CACHE_SIZE = 4;
    private static final String DOWNLOAD_WIZ_S4_OVERVIEW = "download_wiz_s4_overview";
    private static final String DOWNLOAD_WIZ_S4_FILE = "download_wiz_s4_file";
    private static final String DOWNLOAD_WIZ_S4_DOWN_DIR = "download_wiz_s4_down_dir";
    private static final String DOWNLOAD_WIZ_S4_PATCHES = "download_wiz_s4_patches";
    public static final int VISIBLE_ROWS = 5;

    public DownloadReviewCard(VPatchMgr vPatchMgr, DownloadPatchWizard downloadPatchWizard) {
        this.theApp = vPatchMgr;
        this.bundle = vPatchMgr.getResourceBundle();
        this.wiz = downloadPatchWizard;
        super.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"download_review_step"));
        this.constructStep();
    }

    private void constructStep() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.initLabel(this.fileLbl, "dl_wiz_file_lbl");
        this.textFileField = new SelectableLabel("", 18);
        this.fileLbl.setLabelFor((Component)this.textFileField);
        this.initLabel(this.patchLbl, "dl_wiz_id_list");
        this.reviewList = new JList();
        this.reviewList.setVisibleRowCount(5);
        this.reviewList.setBackground(this.getBackground());
        String string = "RXXXXXX-XX ";
        this.reviewList.setPrototypeCellValue(string);
        Font font = this.patchLbl.getFont();
        if (font != null) {
            this.reviewList.setFixedCellHeight(font.getSize() + 3);
        } else {
            this.reviewList.setFixedCellHeight(18);
        }
        this.patchLbl.setLabelFor(this.reviewList);
        JScrollPane jScrollPane = new JScrollPane(this.reviewList);
        jScrollPane.getViewport().add(this.reviewList, null, -1);
        double d = 5 * this.reviewList.getFixedCellHeight();
        double d2 = jScrollPane.getPreferredSize().getHeight() - jScrollPane.getViewport().getPreferredSize().getHeight();
        d += d2;
        d2 = jScrollPane.getVerticalScrollBar().getPreferredSize().getWidth();
        double d3 = (double)this.reviewList.getFixedCellWidth() + d2;
        jScrollPane.setPreferredSize(new Dimension((int)d3, (int)d));
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        int n = 0;
        JPanel jPanel = new JPanel();
        Constraints.constrain((Container)((Object)this), (Component)jPanel, (int)0, (int)n, (int)2, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)0, (int)0, (int)0);
        this.initLabel(this.dirLbl, "dl_wiz_dir_lbl");
        String string2 = this.wiz.getDownloadDir();
        this.dirField = new SelectableLabel("", 18);
        this.dirLbl.setLabelFor((Component)this.dirField);
        Constraints.constrain((Container)((Object)this), (Component)this.fileLbl, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)5, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)((Object)this), (Component)this.textFileField, (int)1, (int)n, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (int)5, (int)12, (int)0, (int)5);
        Constraints.constrain((Container)((Object)this), (Component)this.patchLbl, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)5, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)((Object)this), (Component)jScrollPane, (int)1, (int)n, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (int)5, (int)12, (int)0, (int)5);
        Constraints.constrain((Container)((Object)this), (Component)this.dirLbl, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)5, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)((Object)this), (Component)this.dirField, (int)1, (int)n, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)1.0, (int)5, (int)12, (int)0, (int)5);
        this.textFileField.addFocusListener((FocusListener)((Object)this.textHelp));
        this.reviewList.addFocusListener((FocusListener)((Object)this.patchHelp));
        this.dirField.addFocusListener((FocusListener)((Object)this.dirHelp));
    }

    public void loadHelp() {
        Vector vector = new Vector(4);
        this.infoPanel = this.wiz.getInfoPanel();
        this.overviewHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, DOWNLOAD_WIZ_S4_OVERVIEW);
        this.patchHelp = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, DOWNLOAD_WIZ_S4_PATCHES);
        this.dirHelp = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, DOWNLOAD_WIZ_S4_DOWN_DIR);
        this.textHelp = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, DOWNLOAD_WIZ_S4_FILE);
        ContextHelpListener.loadHelp(vector);
    }

    private void initLabel(JLabel jLabel, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
    }

    public void start() {
        super.start();
        this.updateStatus();
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.canmoveforward", "vwp.true");
        this.setProperty("vwp.finishstate", "vwp.true");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.overviewHelpListener), true);
    }

    public boolean stop(boolean bl) {
        if (bl) {
            this.wiz.doFinish();
        }
        return true;
    }

    protected void updateStatus() {
        if (this.wiz.getSpecificFlag()) {
            this.remove((Component)this.textFileField);
            this.remove(this.fileLbl);
        } else {
            this.removeAll();
            this.constructStep();
            this.textFileField.setText(this.wiz.getTextFilename());
        }
        this.invalidate();
        this.validate();
        this.repaint();
        Vector vector = this.wiz.getPatchIDList();
        this.reviewList.setListData(vector);
        String string = this.wiz.getDownloadDir();
        this.dirField.setText(string);
    }

    public boolean isSubStep() {
        return false;
    }

    public void reset() {
    }
}

