/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.patchmgr.client.AnalyzeAddPatchWizard;
import com.sun.admin.patchmgr.client.PatchContextHelpListener;
import com.sun.admin.patchmgr.client.VPatchMgr;
import com.sun.admin.patchmgr.common.AssessedPatchData;
import com.sun.admin.patchmgr.common.DownloadPatchesResults;
import com.sun.admin.patchmgr.common.RemoteFileData;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AnalyzeDownloadCard
extends VWizardCard {
    private VPatchMgr theApp;
    private ResourceBundle bundle;
    private AnalyzeAddPatchWizard wiz;
    private ActionString actionString;
    private GenInfoPanel infoPanel;
    private PatchContextHelpListener overviewHelpListener;
    private JTextField downloadField;
    private DownloadPatchesResults downLoadResults;
    private Vector assessedPatchIds;
    private boolean isDownloadCompleted = false;
    private boolean hasDownloadStarted = false;
    private boolean suppressErrorDlg = false;
    private boolean isItReallyOKToMoveForward = false;
    private boolean onlyDoThisOnce = false;
    private static final String SPACE = " ";
    public static final int HELP_CACHE_SIZE = 2;
    private static final String ANALYZE_WIZ_S3_OVERVIEW = "analyze_wiz_s3_overview";
    private static final String ANALYZE_WIZ_S3_DOWN_DIR = "analyze_wiz_s3_down_dir";

    public AnalyzeDownloadCard(VPatchMgr vPatchMgr, AnalyzeAddPatchWizard analyzeAddPatchWizard) {
        this.theApp = vPatchMgr;
        this.bundle = vPatchMgr.getResourceBundle();
        this.wiz = analyzeAddPatchWizard;
        super.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"analyze_step3_title"));
        this.constructStep();
    }

    private void constructStep() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.actionString = new ActionString(this.bundle, "aa_wiz_download_lbl");
        JLabel jLabel = new JLabel(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
        Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)24, (int)12, (int)0, (int)0);
        this.downloadField = new JTextField("", 20);
        this.downloadField.getDocument().addDocumentListener(new DownloadFieldListener());
        this.downloadField.setMinimumSize(this.downloadField.getPreferredSize());
        jLabel.setLabelFor(this.downloadField);
        Constraints.constrain((Container)((Object)this), (Component)this.downloadField, (int)1, (int)0, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)24, (int)12, (int)0, (int)0);
    }

    public void loadHelp() {
        Vector vector = new Vector(2);
        this.infoPanel = this.wiz.getInfoPanel();
        this.overviewHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, ANALYZE_WIZ_S3_OVERVIEW);
        PatchContextHelpListener patchContextHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, ANALYZE_WIZ_S3_DOWN_DIR);
        this.downloadField.addFocusListener((FocusListener)((Object)patchContextHelpListener));
        ContextHelpListener.loadHelp(vector);
    }

    public void start() {
        super.start();
        this.downloadField.requestFocus();
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.finishstate", "vwp.false");
        this.setProperty("vwp.canmoveforward", "vwp.false");
        String string = this.wiz.getDownloadDir();
        if (string != null && string.length() > 0) {
            this.downloadField.setText(string);
        }
        this.infoPanel.setFocusListener((FocusListener)((Object)this.overviewHelpListener), true);
    }

    public boolean stop(boolean bl) {
        String string = "analyzebackoutdir";
        this.getManager().setNext(this.getManager().getCurrent(), string);
        if (!bl) {
            return true;
        }
        if (!this.onlyDoThisOnce) {
            this.checkBeforeMoving();
        }
        return this.isItReallyOKToMoveForward;
    }

    public boolean checkBeforeMoving() {
        Object object;
        this.onlyDoThisOnce = true;
        String string = this.downloadField.getText();
        if (string == null || string.length() == 0) {
            new ErrorDialog(null, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"aa_wiz_bad_dirname"));
            this.onlyDoThisOnce = false;
            return false;
        }
        try {
            object = this.theApp.getpatchM().getDirInfo(string);
            if (!((RemoteFileData)object).isDirectory()) {
                String string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_aa_bad_dir_name");
                Object[] objectArray = new Object[]{string};
                new ErrorDialog(null, MessageFormat.format(string2, objectArray));
                this.onlyDoThisOnce = false;
                return false;
            }
        }
        catch (AdminException adminException) {
            this.downloadField.setText("");
            this.theApp.reportErrorException((Exception)((Object)adminException));
            this.onlyDoThisOnce = false;
            return false;
        }
        this.wiz.setDownloadDir(string);
        object = this.wiz.getPatchList();
        int n = Math.max(this.title.length(), 10);
        this.wiz.downloadThread = new Thread((Vector)object){
            private final /* synthetic */ Vector val$patchlist;
            {
                this.val$patchlist = vector;
            }

            public void run() {
                try {
                    AnalyzeDownloadCard.this.hasDownloadStarted = true;
                    AnalyzeDownloadCard.this.isDownloadCompleted = false;
                    AnalyzeDownloadCard.this.setProperty("vwp.canmovebackward", "vwp.false");
                    AnalyzeDownloadCard.this.setProperty("vwp.canmoveforward", "vwp.false");
                    String string = ResourceStrings.getString((ResourceBundle)AnalyzeDownloadCard.this.bundle, (String)"DownloadPatchTitle");
                    int n = Math.max(string.length(), 10);
                    ((AnalyzeDownloadCard)AnalyzeDownloadCard.this).wiz.progressPanel = new ProgressPanel(AnalyzeDownloadCard.this.theApp.getFrame(), 1, n, true);
                    ((AnalyzeDownloadCard)AnalyzeDownloadCard.this).wiz.progressPanel.setValue(0);
                    ((AnalyzeDownloadCard)AnalyzeDownloadCard.this).wiz.progressPanel.setIndeterminate(true);
                    ((AnalyzeDownloadCard)AnalyzeDownloadCard.this).wiz.progressPanel.setTitle(string);
                    String string2 = ResourceStrings.getString((ResourceBundle)AnalyzeDownloadCard.this.bundle, (String)"DownloadingPatchesStatus");
                    ((AnalyzeDownloadCard)AnalyzeDownloadCard.this).wiz.progressPanel.setText(string2);
                    String string3 = AnalyzeDownloadCard.this.wiz.getDownloadDir();
                    ((AnalyzeDownloadCard)AnalyzeDownloadCard.this).wiz.progressPanel.setVisible(true);
                    int n2 = 0;
                    if (this.val$patchlist != null) {
                        n2 = this.val$patchlist.size();
                    }
                    Vector<String> vector = new Vector<String>(n2);
                    AssessedPatchData assessedPatchData = null;
                    int n3 = 0;
                    while (n3 < n2) {
                        assessedPatchData = (AssessedPatchData)this.val$patchlist.elementAt(n3);
                        vector.addElement(assessedPatchData.getPatchId());
                        ++n3;
                    }
                    try {
                        AnalyzeDownloadCard.this.downLoadResults = AnalyzeDownloadCard.this.theApp.getpatchM().downloadPatchesInJarFormat(vector, string3);
                    }
                    catch (Exception exception) {
                        ((AnalyzeDownloadCard)AnalyzeDownloadCard.this).wiz.progressPanel.dispose();
                        if (!AnalyzeDownloadCard.this.suppressErrorDlg) {
                            AnalyzeDownloadCard.this.theApp.reportErrorException(exception);
                        }
                        AnalyzeDownloadCard.this.hasDownloadStarted = false;
                        AnalyzeDownloadCard.this.onlyDoThisOnce = false;
                    }
                    Vector vector2 = AnalyzeDownloadCard.this.downLoadResults.getPatchesNotDownloaded();
                    StringBuffer stringBuffer = new StringBuffer(50);
                    int n4 = vector2 != null ? vector2.size() : 0;
                    int n5 = 0;
                    while (n5 < n4) {
                        stringBuffer.append((String)vector2.elementAt(n5));
                        stringBuffer.append(AnalyzeDownloadCard.SPACE);
                        ++n5;
                    }
                    if (stringBuffer.length() > 0) {
                        ((AnalyzeDownloadCard)AnalyzeDownloadCard.this).wiz.progressPanel.setIndeterminate(false);
                        if (!AnalyzeDownloadCard.this.suppressErrorDlg) {
                            ErrorDialog errorDialog = new ErrorDialog(AnalyzeDownloadCard.this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)AnalyzeDownloadCard.this.bundle, (String)"err_analyze_download_msg"));
                        }
                        AnalyzeDownloadCard.this.wiz.setSkipResetMethods(true);
                        AnalyzeDownloadCard.this.wiz.setPreventCancel(false);
                        AnalyzeDownloadCard.this.wiz.cancelWizard();
                    } else {
                        ((AnalyzeDownloadCard)AnalyzeDownloadCard.this).wiz.progressPanel.setIndeterminate(false);
                        if (!AnalyzeDownloadCard.this.suppressErrorDlg) {
                            Object[] objectArray = new Object[]{string3};
                            string2 = ResourceStrings.getString((ResourceBundle)AnalyzeDownloadCard.this.bundle, (String)"info_download_msg");
                            ErrorDialog errorDialog = new ErrorDialog(AnalyzeDownloadCard.this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)AnalyzeDownloadCard.this.bundle, (String)"generic_info_title"), MessageFormat.format(string2, objectArray), true);
                        }
                    }
                    ((AnalyzeDownloadCard)AnalyzeDownloadCard.this).wiz.progressPanel.setIndeterminate(false);
                    ((AnalyzeDownloadCard)AnalyzeDownloadCard.this).wiz.progressPanel.dispose();
                    AnalyzeDownloadCard.this.isDownloadCompleted = true;
                    AnalyzeDownloadCard.this.isItReallyOKToMoveForward = true;
                    AnalyzeDownloadCard.this.setProperty("vwp.canmovebackward", "vwp.true");
                    AnalyzeDownloadCard.this.setProperty("vwp.canmoveforward", "vwp.true");
                    AnalyzeDownloadCard.this.wiz.moveForward();
                }
                catch (Exception exception) {
                    AnalyzeDownloadCard.this.onlyDoThisOnce = false;
                    AnalyzeDownloadCard.this.setProperty("vwp.canmovebackward", "vwp.true");
                    AnalyzeDownloadCard.this.setProperty("vwp.canmoveforward", "vwp.true");
                    if (((AnalyzeDownloadCard)AnalyzeDownloadCard.this).wiz.progressPanel != null) {
                        ((AnalyzeDownloadCard)AnalyzeDownloadCard.this).wiz.progressPanel.dispose();
                    }
                    AnalyzeDownloadCard.this.isDownloadCompleted = false;
                }
            }
        };
        this.wiz.downloadThread.start();
        return true;
    }

    public boolean isSubStep() {
        return false;
    }

    public void reset() {
        this.wiz.setPreventCancel(false);
        if (this.hasDownloadStarted && !this.isDownloadCompleted) {
            String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"aa_progress_download_msg");
            Object[] objectArray = new Object[]{this.wiz.getDownloadDir()};
            JPanel jPanel = new JPanel(new GridBagLayout());
            FlowArea flowArea = new FlowArea(MessageFormat.format(string, objectArray), 30);
            Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)1.0, (int)5, (int)5, (int)5, (int)5);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AnalyzeDownloadCard.this.wiz.setPreventCancel(true);
                }
            };
            WarningDialog warningDialog = new WarningDialog(this.theApp.getFrame(), jPanel, actionListener, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"wrn_btn_resume"));
            if (!this.wiz.getPreventCancel()) {
                this.suppressErrorDlg = true;
                if (this.wiz.progressPanel != null) {
                    this.wiz.progressPanel.dispose();
                }
                return;
            }
            if (this.wiz.progressPanel != null) {
                this.wiz.progressPanel.toFront();
            }
            return;
        }
        if (!this.isDownloadCompleted) {
            this.wiz.getManager().getCard("recommendedpatches").reset();
            if (this.wiz.getPreventCancel()) {
                if (this.wiz.progressPanel != null) {
                    this.wiz.progressPanel.requestFocus();
                }
                return;
            }
            if (this.wiz.progressPanel != null) {
                this.wiz.progressPanel.dispose();
            }
        } else {
            this.wiz.getManager().getCard("analyzebackoutdir").reset();
        }
    }

    class DownloadFieldListener
    implements DocumentListener {
        DownloadFieldListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            String string = AnalyzeDownloadCard.this.downloadField.getText();
            if (string != null && string.length() > 0) {
                AnalyzeDownloadCard.this.setProperty("vwp.canmoveforward", "vwp.true");
            } else {
                AnalyzeDownloadCard.this.setProperty("vwp.canmoveforward", "vwp.false");
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }
    }
}

