/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.security;

import java.io.Serializable;
import java.security.PublicKey;

public class SecurityMessage
implements Serializable {
    static final long serialVersionUID = 200L;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int HELLO = 0;
    private static final int CHALLENGE = 1;
    private static final int RESPONSE = 2;
    private static final int RESULT = 3;
    private static final int ERROR = 4;
    private int type;
    private byte[] userDigest;
    private byte[] salt;
    private byte[] challenge;
    private byte[] response;
    private byte[] authenticator;
    private byte[] checksum;
    private byte[] sessionId;
    private byte[] nameSpace;
    private PublicKey pubkey;
    private String message;

    public static String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hex[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(hex[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isHello() {
        return this.type == 0;
    }

    public boolean isChallenge() {
        return this.type == 1;
    }

    public boolean isResponse() {
        return this.type == 2;
    }

    public boolean isResult() {
        return this.type == 3;
    }

    public boolean isError() {
        return this.type == 4;
    }

    public byte[] getUserDigest() {
        return this.userDigest;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getChallenge() {
        return this.challenge;
    }

    public byte[] getResponse() {
        return this.response;
    }

    public byte[] getAuthenticator() {
        return this.authenticator;
    }

    public String getMessage() {
        return this.message;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public byte[] getNameSpace() {
        return this.nameSpace;
    }

    public PublicKey getPublicKey() {
        return this.pubkey;
    }

    public static SecurityMessage error(String string) {
        SecurityMessage securityMessage = new SecurityMessage();
        securityMessage.type = 4;
        securityMessage.message = string;
        return securityMessage;
    }

    public static SecurityMessage result(byte[] byArray, PublicKey publicKey, byte[] byArray2, byte[] byArray3) {
        SecurityMessage securityMessage = new SecurityMessage();
        securityMessage.type = 3;
        securityMessage.sessionId = byArray;
        securityMessage.response = byArray2;
        securityMessage.pubkey = publicKey;
        securityMessage.checksum = byArray3;
        return securityMessage;
    }

    public static SecurityMessage response(byte[] byArray, PublicKey publicKey, byte[] byArray2, byte[] byArray3) {
        SecurityMessage securityMessage = new SecurityMessage();
        securityMessage.type = 2;
        securityMessage.response = byArray;
        securityMessage.sessionId = byArray2;
        securityMessage.pubkey = publicKey;
        securityMessage.checksum = byArray3;
        return securityMessage;
    }

    public static SecurityMessage challenge(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        SecurityMessage securityMessage = new SecurityMessage();
        securityMessage.type = 1;
        securityMessage.salt = byArray2;
        securityMessage.challenge = byArray;
        securityMessage.checksum = byArray4;
        securityMessage.sessionId = byArray3;
        return securityMessage;
    }

    public static SecurityMessage hello(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        SecurityMessage securityMessage = new SecurityMessage();
        securityMessage.type = 0;
        securityMessage.userDigest = byArray2;
        securityMessage.challenge = byArray;
        securityMessage.nameSpace = byArray3;
        securityMessage.checksum = byArray4;
        return securityMessage;
    }

    public String toString() {
        String string;
        switch (this.type) {
            case 0: {
                string = "c->s  user(" + SecurityMessage.toHex(this.userDigest) + ")\n, challenge(" + SecurityMessage.toHex(this.challenge) + ")" + ")\n, namespace(" + SecurityMessage.toHex(this.nameSpace) + ")";
                break;
            }
            case 1: {
                string = "s->c  salt(" + SecurityMessage.toHex(this.salt) + ")\n, sessionId(" + SecurityMessage.toHex(this.sessionId) + ")" + ")\n, challenge(" + SecurityMessage.toHex(this.challenge) + ")";
                break;
            }
            case 2: {
                string = "c->s  response(" + SecurityMessage.toHex(this.response) + "),\n      sessionId(" + SecurityMessage.toHex(this.sessionId) + ")";
                break;
            }
            case 3: {
                string = "s->c  session(" + SecurityMessage.toHex(this.sessionId) + ")" + ",\n response(" + SecurityMessage.toHex(this.response) + ")";
                break;
            }
            case 4: {
                string = "s->c  error(" + this.message + ")";
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type: " + this.type);
            }
        }
        string = string + "\nchecksum(" + SecurityMessage.toHex(this.checksum) + ")";
        return string;
    }
}

