/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.wbem.client.adapter.http.transport.HttpParseException;

final class StartLine {
    final int major;
    final int minor;
    final boolean isRequest;
    final String method;
    final String uri;
    final int status;
    final String reason;

    StartLine(int n, int n2, String string, String string2) {
        this.major = n;
        this.minor = n2;
        this.method = string;
        this.uri = string2;
        this.status = -1;
        this.reason = null;
        this.isRequest = true;
    }

    StartLine(int n, int n2, int n3, String string) {
        this.major = n;
        this.minor = n2;
        this.status = n3;
        this.reason = string;
        this.method = null;
        this.uri = null;
        this.isRequest = false;
    }

    StartLine(InputStream inputStream) throws IOException {
        String string = new DataInputStream(inputStream).readLine();
        if (string == null) {
            throw new HttpParseException("unexpected EOF in start line");
        }
        if (string.length() == 0) {
            throw new HttpParseException("empty start line");
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "", true);
            if (string.startsWith("HTTP")) {
                if (!stringTokenizer.nextToken("/").equals("HTTP")) {
                    throw new HttpParseException();
                }
                stringTokenizer.nextToken();
                this.major = Integer.parseInt(stringTokenizer.nextToken("."));
                stringTokenizer.nextToken();
                this.minor = Integer.parseInt(stringTokenizer.nextToken(" "));
                stringTokenizer.nextToken();
                this.status = Integer.parseInt(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                this.reason = stringTokenizer.nextToken("\n");
                this.method = null;
                this.uri = null;
                this.isRequest = false;
            } else {
                this.method = stringTokenizer.nextToken(" ");
                stringTokenizer.nextToken();
                this.uri = stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                if (!stringTokenizer.nextToken("/").equals("HTTP")) {
                    throw new HttpParseException();
                }
                stringTokenizer.nextToken();
                this.major = Integer.parseInt(stringTokenizer.nextToken("."));
                stringTokenizer.nextToken();
                this.minor = Integer.parseInt(stringTokenizer.nextToken("\n"));
                this.status = -1;
                this.reason = null;
                this.isRequest = true;
            }
        }
        catch (Exception exception) {
            throw new HttpParseException("invalid start line");
        }
    }

    void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        String string = "HTTP/" + this.major + "." + this.minor;
        if (this.isRequest) {
            dataOutputStream.writeBytes(this.method + " " + this.uri + " " + string + "\r\n");
        } else {
            dataOutputStream.writeBytes(string + " " + this.status + " " + this.reason + "\r\n");
        }
    }

    static int compareVersions(int n, int n2, int n3, int n4) {
        if (n != n3) {
            return n > n3 ? 1 : -1;
        }
        if (n2 != n4) {
            return n2 > n4 ? 1 : -1;
        }
        return 0;
    }
}

