/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.JListEditor;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.patchmgr.client.DownloadPatchWizard;
import com.sun.admin.patchmgr.client.PatchContextHelpListener;
import com.sun.admin.patchmgr.client.VPatchMgr;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;

public class DownloadSpecificListCard
extends VWizardCard {
    private VPatchMgr theApp;
    private ResourceBundle bundle;
    private DownloadPatchWizard wiz;
    private ActionString actionString;
    private GenInfoPanel infoPanel;
    private PatchContextHelpListener overviewHelpListener;
    private JListEditor patchListEditor;
    private static final int VISIBLE_ROWS = 8;
    private boolean enterKey = false;
    public static final int HELP_CACHE_SIZE = 4;
    private static final String DOWNLOAD_STEP2a_OVERVIEW = "download_wiz_s2a_overview";
    private static final String DOWNLOAD_STEP2_PATCH = "download_wiz_s2_patch_id";
    private static final String DOWNLOAD_STEP2a_ADD = "download_wiz_s2a_add";
    private static final String DOWNLOAD_STEP2a_DELETE = "download_wiz_s2a_delete";

    public DownloadSpecificListCard(VPatchMgr vPatchMgr, DownloadPatchWizard downloadPatchWizard) {
        this.theApp = vPatchMgr;
        this.bundle = vPatchMgr.getResourceBundle();
        this.wiz = downloadPatchWizard;
        super.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"download_specific_patchids_step"));
        this.constructStep();
    }

    private void constructStep() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel();
        this.setLabelMnemonic(jLabel, "dl_wiz_patchid_number");
        Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)24, (int)12, (int)0, (int)0);
        this.patchListEditor = new JListEditor(new Vector(0), false);
        this.patchListEditor.setVerifyListener((ActionListener)new AddKeyListener());
        this.patchListEditor.setColumns(11);
        this.patchListEditor.setVisibleRows(8);
        this.patchListEditor.setUpAddShortcut();
        this.patchListEditor.setLabel(jLabel);
        Constraints.constrain((Container)((Object)this), (Component)this.patchListEditor, (int)1, (int)0, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)24, (int)12, (int)0, (int)0);
    }

    public void loadHelp() {
        Vector vector = new Vector(4);
        this.infoPanel = this.wiz.getInfoPanel();
        this.overviewHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, DOWNLOAD_STEP2a_OVERVIEW);
        PatchContextHelpListener patchContextHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, DOWNLOAD_STEP2_PATCH);
        PatchContextHelpListener patchContextHelpListener2 = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, DOWNLOAD_STEP2a_ADD);
        PatchContextHelpListener patchContextHelpListener3 = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, DOWNLOAD_STEP2a_DELETE);
        this.patchListEditor.setFocusListeners((FocusListener)((Object)patchContextHelpListener), null, (FocusListener)((Object)patchContextHelpListener2), (FocusListener)((Object)patchContextHelpListener3), null, null);
        ContextHelpListener.loadHelp(vector);
    }

    private void setLabelMnemonic(JLabel jLabel, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
    }

    public void start() {
        if (this.enterKey) {
            this.enterKey = false;
            return;
        }
        super.start();
        this.patchListEditor.requestFocus();
        this.updateStatus();
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.finishstate", "vwp.false");
        this.getManager().setPrevious(this.getManager().getCurrent(), "selectmodecard");
        this.patchListEditor.setOutItems(new Vector(0));
        Vector vector = this.wiz.getPatchIDList();
        int n = 0;
        if (vector != null) {
            n = vector.size();
            this.patchListEditor.setOutItems(vector);
        }
        if (n == 0) {
            this.setProperty("vwp.canmoveforward", "vwp.false");
        } else {
            this.setProperty("vwp.canmoveforward", "vwp.true");
        }
        this.infoPanel.setFocusListener((FocusListener)((Object)this.overviewHelpListener), true);
    }

    private void updateStatus() {
        if (this.patchListEditor.getOutItems().size() > 0) {
            this.setProperty("vwp.canmoveforward", "vwp.true");
        } else {
            this.setProperty("vwp.canmoveforward", "vwp.false");
        }
    }

    public boolean stop(boolean bl) {
        if (!bl) {
            return true;
        }
        Vector vector = new Vector();
        vector = this.patchListEditor.getOutItems();
        if (vector.size() == 0) {
            this.setProperty("vwp.canmoveforward", "vwp.false");
            this.wiz.setPatchIDList(new Vector(0));
            return false;
        }
        if (this.enterKey) {
            return false;
        }
        this.wiz.setPatchIDList(vector);
        this.getManager().setNext(this.getManager().getCurrent(), "downloaddircard");
        return true;
    }

    public boolean isSubStep() {
        return false;
    }

    public void reset() {
    }

    class AddKeyListener
    implements ActionListener {
        AddKeyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand().trim();
            if (string == null || string.length() == 0) {
                DownloadSpecificListCard.this.patchListEditor.acceptInput(false);
                DownloadSpecificListCard.this.updateStatus();
                return;
            }
            if (!DownloadPatchWizard.isValidPatchID(string)) {
                String string2 = ResourceStrings.getString((ResourceBundle)DownloadSpecificListCard.this.bundle, (String)"er_invalid_patchid");
                Object[] objectArray = new Object[]{string};
                new ErrorDialog(null, MessageFormat.format(string2, objectArray));
                DownloadSpecificListCard.this.patchListEditor.acceptInput(false);
                DownloadSpecificListCard.this.updateStatus();
                return;
            }
            DownloadSpecificListCard.this.patchListEditor.acceptInput(true);
            DownloadSpecificListCard.this.updateStatus();
        }
    }
}

