/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.patchmgr.client.AnalyzeAddPatchWizard;
import com.sun.admin.patchmgr.client.CommonBackoutCard;
import com.sun.admin.patchmgr.client.PatchContextHelpListener;
import com.sun.admin.patchmgr.client.VPatchMgr;
import com.sun.admin.patchmgr.common.RemoteFileData;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JPanel;

public class AnalyzeBackoutCard
extends CommonBackoutCard {
    private VPatchMgr theApp;
    private ResourceBundle bundle;
    private AnalyzeAddPatchWizard wiz;
    private GenInfoPanel infoPanel;
    private PatchContextHelpListener overviewHelpListener;
    private String backoutDirName;
    protected Hashtable spooledPatchHashT = new Hashtable();
    private static final String SPACE = " ";
    private static final String NEXTLINE = "\n";
    public static final int HELP_CACHE_SIZE = 3;
    private static final String ANALYZE_WIZ_S4_OVERVIEW = "analyze_wiz_s4_overview";
    private static final String ANALYZE_WIZ_S4_RADIO_BTNS = "analyze_wiz_s4_backout_radio";
    private static final String ANALYZE_WIZ_S4_CUSTOM = "analyze_wiz_s4_backout_custom";

    public AnalyzeBackoutCard(VPatchMgr vPatchMgr, AnalyzeAddPatchWizard analyzeAddPatchWizard) {
        super(vPatchMgr);
        this.theApp = vPatchMgr;
        this.bundle = vPatchMgr.getResourceBundle();
        this.wiz = analyzeAddPatchWizard;
        super.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"analyze_step4_title"));
    }

    public void loadHelp() {
        Vector vector = new Vector(3);
        this.infoPanel = this.wiz.getInfoPanel();
        this.overviewHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, ANALYZE_WIZ_S4_OVERVIEW);
        PatchContextHelpListener patchContextHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, ANALYZE_WIZ_S4_RADIO_BTNS);
        PatchContextHelpListener patchContextHelpListener2 = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, ANALYZE_WIZ_S4_CUSTOM);
        this.bp.setFocusListeners((FocusListener)((Object)patchContextHelpListener), (FocusListener)((Object)patchContextHelpListener), (FocusListener)((Object)patchContextHelpListener2));
        ContextHelpListener.loadHelp(vector);
    }

    public void start() {
        super.start();
        this.setProperty("vwp.canmovebackward", "vwp.false");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.overviewHelpListener), true);
    }

    public boolean stop(boolean bl) {
        if (!bl) {
            this.wiz.isItOKToInstall = true;
            return true;
        }
        if (!this.isDataOK()) {
            return false;
        }
        if (bl) {
            this.wiz.isItOKToInstall = true;
            this.backoutDirName = this.bp.isDefaultSelected() ? "" : this.bp.getBackoutDir();
            if (this.backoutDirName.length() > 0) {
                try {
                    RemoteFileData remoteFileData = this.theApp.getpatchM().getDirInfo(this.backoutDirName);
                    if (!remoteFileData.isDirectory()) {
                        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"aa_wiz_bad_dirname");
                        new ErrorDialog(null, string);
                        return false;
                    }
                }
                catch (AdminException adminException) {
                    this.theApp.reportErrorException((Exception)((Object)adminException));
                    return false;
                }
            }
            this.wiz.setBackoutDir(this.backoutDirName);
        }
        return true;
    }

    public void reset() {
        this.wiz.setPreventCancel(false);
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"aa_download_msg");
        Object[] objectArray = new Object[]{this.wiz.getDownloadDir()};
        JPanel jPanel = new JPanel(new GridBagLayout());
        FlowArea flowArea = new FlowArea(MessageFormat.format(string, objectArray), 30);
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)1.0, (int)5, (int)5, (int)5, (int)5);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeBackoutCard.this.wiz.setPreventCancel(true);
            }
        };
        WarningDialog warningDialog = new WarningDialog(this.theApp.getFrame(), jPanel, actionListener, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"wrn_btn_resume"));
    }
}

