/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import com.sun.iiim.IIIMEvent;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class IIIMKeyEvent
extends IIIMEvent {
    private int keyCode = 0;
    private char keyChar = (char)65535;
    private int modifier = 0;
    private long when = 0L;
    private String keyString = null;
    private boolean triggerPress = false;
    static Hashtable modifierTable = null;
    static Hashtable keyTable = null;

    public IIIMKeyEvent(String string) {
        super(7);
        this.keyString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            this.modifier |= this.getModifier(string3);
            string2 = string3;
        }
        this.setCharCode(string2);
    }

    public boolean match(KeyEvent keyEvent) {
        int n = keyEvent.getID();
        switch (n) {
            case 401: {
                if (this.keyCode != keyEvent.getKeyCode() || keyEvent.getModifiers() != this.modifier) break;
                this.triggerPress = true;
                return true;
            }
            case 400: {
                if (!this.triggerPress) break;
                return true;
            }
            case 402: {
                if (this.keyCode != keyEvent.getKeyCode() || !this.triggerPress) break;
                this.triggerPress = false;
                return true;
            }
        }
        return false;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public char getKeyChar() {
        return this.keyChar;
    }

    public long getWhen() {
        return this.when;
    }

    public String toString() {
        return this.keyString;
    }

    private int getModifier(String string) {
        Integer n = (Integer)modifierTable.get(string.toLowerCase());
        if (n == null) {
            return 0;
        }
        return n;
    }

    private void setCharCode(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (string.length() > 1) {
            Integer n = (Integer)keyTable.get(string.toUpperCase());
            if (n != null) {
                this.keyCode = n;
            }
        } else {
            this.keyChar = string.charAt(0);
        }
    }

    static {
        modifierTable = new Hashtable();
        modifierTable.put("shift", new Integer(1));
        modifierTable.put("control", new Integer(2));
        modifierTable.put("meta", new Integer(4));
        modifierTable.put("alt", new Integer(8));
        modifierTable.put("alt_graph", new Integer(32));
        modifierTable.put("button1", new Integer(16));
        modifierTable.put("button2", new Integer(8));
        modifierTable.put("button3", new Integer(4));
        keyTable = new Hashtable();
        keyTable.put("ENTER", new Integer(10));
        keyTable.put("BACK_SPACE", new Integer(8));
        keyTable.put("TAB", new Integer(9));
        keyTable.put("CANCEL", new Integer(3));
        keyTable.put("CLEAR", new Integer(12));
        keyTable.put("SHIFT", new Integer(16));
        keyTable.put("CONTROL", new Integer(17));
        keyTable.put("ALT", new Integer(18));
        keyTable.put("PAUSE", new Integer(19));
        keyTable.put("CAPS_LOCK", new Integer(20));
        keyTable.put("ESCAPE", new Integer(27));
        keyTable.put("SPACE", new Integer(32));
        keyTable.put("PAGE_UP", new Integer(33));
        keyTable.put("PAGE_DOWN", new Integer(34));
        keyTable.put("END", new Integer(35));
        keyTable.put("HOME", new Integer(36));
        keyTable.put("LEFT", new Integer(37));
        keyTable.put("UP", new Integer(38));
        keyTable.put("RIGHT", new Integer(39));
        keyTable.put("DOWN", new Integer(40));
        keyTable.put("COMMA", new Integer(44));
        keyTable.put("MINUS", new Integer(45));
        keyTable.put("PERIOD", new Integer(46));
        keyTable.put("SLASH", new Integer(47));
        keyTable.put("SEMICOLON", new Integer(59));
        keyTable.put("EQUALS", new Integer(61));
        keyTable.put("OPEN_BRACKET", new Integer(91));
        keyTable.put("BACK_SLASH", new Integer(92));
        keyTable.put("CLOSE_BRACKET", new Integer(93));
        keyTable.put("NUMPAD0", new Integer(96));
        keyTable.put("NUMPAD1", new Integer(97));
        keyTable.put("NUMPAD2", new Integer(98));
        keyTable.put("NUMPAD3", new Integer(99));
        keyTable.put("NUMPAD4", new Integer(100));
        keyTable.put("NUMPAD5", new Integer(101));
        keyTable.put("NUMPAD6", new Integer(102));
        keyTable.put("NUMPAD7", new Integer(103));
        keyTable.put("NUMPAD8", new Integer(104));
        keyTable.put("NUMPAD9", new Integer(105));
        keyTable.put("MULTIPLY", new Integer(106));
        keyTable.put("ADD", new Integer(107));
        keyTable.put("SEPARATER", new Integer(108));
        keyTable.put("SUBTRACT", new Integer(109));
        keyTable.put("DECIMAL", new Integer(110));
        keyTable.put("DIVIDE", new Integer(111));
        keyTable.put("DELETE", new Integer(127));
        keyTable.put("NUM_LOCK", new Integer(144));
        keyTable.put("SCROLL_LOCK", new Integer(145));
        keyTable.put("F1", new Integer(112));
        keyTable.put("F2", new Integer(113));
        keyTable.put("F3", new Integer(114));
        keyTable.put("F4", new Integer(115));
        keyTable.put("F5", new Integer(116));
        keyTable.put("F6", new Integer(117));
        keyTable.put("F7", new Integer(118));
        keyTable.put("F8", new Integer(119));
        keyTable.put("F9", new Integer(120));
        keyTable.put("F10", new Integer(121));
        keyTable.put("F11", new Integer(122));
        keyTable.put("F12", new Integer(123));
        keyTable.put("F13", new Integer(61440));
        keyTable.put("F14", new Integer(61441));
        keyTable.put("F15", new Integer(61442));
        keyTable.put("F16", new Integer(61443));
        keyTable.put("F17", new Integer(61444));
        keyTable.put("F18", new Integer(61445));
        keyTable.put("F19", new Integer(61446));
        keyTable.put("F20", new Integer(61447));
        keyTable.put("F21", new Integer(61448));
        keyTable.put("F22", new Integer(61449));
        keyTable.put("F23", new Integer(61450));
        keyTable.put("F24", new Integer(61451));
        keyTable.put("PRINTSCREEN", new Integer(154));
        keyTable.put("INSERT", new Integer(155));
        keyTable.put("HELP", new Integer(156));
        keyTable.put("META", new Integer(157));
        keyTable.put("BACK_QUOTE", new Integer(192));
        keyTable.put("QUOTE", new Integer(222));
        keyTable.put("KP_UP", new Integer(224));
        keyTable.put("KP_DOWN", new Integer(225));
        keyTable.put("KP_LEFT", new Integer(226));
        keyTable.put("KP_RIGHT", new Integer(227));
        keyTable.put("DEAD_GRAVE", new Integer(128));
        keyTable.put("DEAD_ACUTE", new Integer(129));
        keyTable.put("DEAD_CIRCUMFLEX", new Integer(130));
        keyTable.put("DEAD_TILDE", new Integer(131));
        keyTable.put("DEAD_MACRON", new Integer(132));
        keyTable.put("DEAD_BREVE", new Integer(133));
        keyTable.put("DEAD_ABOVEDOT", new Integer(134));
        keyTable.put("DEAD_DIAERESIS", new Integer(135));
        keyTable.put("DEAD_ABOVERING", new Integer(136));
        keyTable.put("DEAD_DOUBLEACUTE", new Integer(137));
        keyTable.put("DEAD_CARON", new Integer(138));
        keyTable.put("DEAD_CEDILLA", new Integer(139));
        keyTable.put("DEAD_OGONEK", new Integer(140));
        keyTable.put("DEAD_IOTA", new Integer(141));
        keyTable.put("DEAD_VOICED_SOUND", new Integer(142));
        keyTable.put("DEAD_SEMIVOICED_SOUND", new Integer(143));
        keyTable.put("AMPERSAND", new Integer(150));
        keyTable.put("ASTERISK", new Integer(151));
        keyTable.put("QUOTEDBL", new Integer(152));
        keyTable.put("LESS", new Integer(153));
        keyTable.put("GREATER", new Integer(160));
        keyTable.put("BRACELEFT", new Integer(161));
        keyTable.put("BRACERIGHT", new Integer(162));
        keyTable.put("AT", new Integer(512));
        keyTable.put("COLON", new Integer(513));
        keyTable.put("CIRCUMFLEX", new Integer(514));
        keyTable.put("DOLLAR", new Integer(515));
        keyTable.put("EURO_SIGN", new Integer(516));
        keyTable.put("EXCLAMATION_MARK", new Integer(517));
        keyTable.put("INVERTED_EXCLAMATION_MARK", new Integer(518));
        keyTable.put("LEFT_PARENTHESIS", new Integer(519));
        keyTable.put("NUMBER_SIGN", new Integer(520));
        keyTable.put("PLUS", new Integer(521));
        keyTable.put("RIGHT_PARENTHESIS", new Integer(522));
        keyTable.put("UNDERSCORE", new Integer(523));
        keyTable.put("FINAL", new Integer(24));
        keyTable.put("CONVERT", new Integer(28));
        keyTable.put("NONCONVERT", new Integer(29));
        keyTable.put("ACCEPT", new Integer(30));
        keyTable.put("MODECHANGE", new Integer(31));
        keyTable.put("KANA", new Integer(21));
        keyTable.put("KANJI", new Integer(25));
        keyTable.put("ALPHANUMERIC", new Integer(240));
        keyTable.put("KATAKANA", new Integer(241));
        keyTable.put("HIRAGANA", new Integer(242));
        keyTable.put("FULL_WIDTH", new Integer(243));
        keyTable.put("HALF_WIDTH", new Integer(244));
        keyTable.put("ROMAN_CHARACTERS", new Integer(245));
        keyTable.put("ALL_CANDIDATES", new Integer(256));
        keyTable.put("PREVIOUS_CONDIDATE", new Integer(257));
        keyTable.put("CODE_INPUT", new Integer(258));
        keyTable.put("JAPANESE_KATAKANA", new Integer(259));
        keyTable.put("JAPANESE_HIRAGANA", new Integer(260));
        keyTable.put("JAPANESE_ROMAN", new Integer(261));
        keyTable.put("CUT", new Integer(65489));
        keyTable.put("COPY", new Integer(65485));
        keyTable.put("PASTE", new Integer(65487));
        keyTable.put("UNDO", new Integer(65483));
        keyTable.put("AGAIN", new Integer(65481));
        keyTable.put("FIND", new Integer(65488));
        keyTable.put("PROPS", new Integer(65482));
        keyTable.put("STOP", new Integer(65480));
        keyTable.put("COMPOSE", new Integer(65312));
        keyTable.put("ALT_GRAPH", new Integer(65406));
    }
}

