/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Label;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import sun.awt.im.iiimp.LookupPane;

class FocusLabel
extends Label
implements KeyListener,
MouseListener {
    private boolean focused = false;
    private boolean pressed = false;
    private LookupPane target;
    private int index;
    private AttributedCharacterIterator labelIterator;
    private AttributedCharacterIterator candidateIterator;

    FocusLabel(String string) {
        super(string);
        this.setAlignment(0);
        this.enableInputMethods(false);
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    FocusLabel() {
        this(null);
    }

    void setFocus(boolean bl) {
        this.focused = bl;
    }

    void setTarget(LookupPane lookupPane, int n) {
        this.target = lookupPane;
        this.index = n;
    }

    public void setText(String string) {
        super.setText(string);
        this.setFocus(false);
    }

    public void setIterator(AttributedCharacterIterator attributedCharacterIterator, AttributedCharacterIterator attributedCharacterIterator2) {
        super.setText(FocusLabel.iteratorToString(attributedCharacterIterator) + " : " + FocusLabel.iteratorToString(attributedCharacterIterator2));
        this.labelIterator = attributedCharacterIterator;
        this.candidateIterator = attributedCharacterIterator2;
    }

    public static String iteratorToString(CharacterIterator characterIterator) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = characterIterator.first();
        while (c != '\uffff') {
            stringBuffer.append(c);
            c = characterIterator.next();
        }
        return stringBuffer.toString();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        if (this.candidateIterator == null) {
            super.paint(graphics);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            graphics2D.setColor(color2);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Font font = graphics2D.getFont();
            Rectangle2D rectangle2D = font.getStringBounds(FocusLabel.iteratorToString(this.labelIterator), fontRenderContext);
            Rectangle2D rectangle2D2 = font.getStringBounds(" : ", fontRenderContext);
            Rectangle2D rectangle2D3 = font.getStringBounds(FocusLabel.iteratorToString(this.candidateIterator), fontRenderContext);
            int n = (int)((double)dimension.width - (rectangle2D.getWidth() + rectangle2D2.getWidth() + rectangle2D3.getWidth())) / 2;
            int n2 = (int)((double)dimension.height + (rectangle2D.getHeight() + rectangle2D2.getHeight() + rectangle2D3.getHeight())) / 2;
            graphics.drawString(this.labelIterator, n, n2);
            graphics.drawString(" : ", n + (int)rectangle2D.getWidth(), n2);
            graphics.drawString(this.candidateIterator, n + (int)(rectangle2D.getWidth() + rectangle2D2.getWidth()), n2);
        }
        if (this.focused) {
            if (this.pressed) {
                graphics.setColor(color.darker());
            } else {
                graphics.setColor(color.brighter());
            }
            graphics.drawLine(1, 1, dimension.width - 1, 1);
            graphics.drawLine(1, 1, 1, dimension.height - 1);
            if (this.pressed) {
                graphics.setColor(color.brighter());
            } else {
                graphics.setColor(color.darker());
            }
            graphics.drawLine(1, dimension.height - 1, dimension.width - 1, dimension.height - 1);
            graphics.drawLine(dimension.width - 1, 1, dimension.width - 1, dimension.height - 1);
            this.requestFocus();
        } else {
            graphics.setColor(color);
            graphics.drawRect(1, 1, dimension.width - 2, dimension.height - 2);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.target != null) {
            this.target.clicked(this.index);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.target != null) {
            this.setFocus(true);
            this.repaint();
            this.target.changeFocus(this.index);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.target != null) {
            this.setFocus(false);
            this.pressed = false;
            this.repaint();
            this.target.forwardEvent(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.pressed = true;
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.pressed = false;
        this.repaint();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.target != null) {
            this.target.forwardEvent(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.target != null) {
            this.target.forwardEvent(keyEvent);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.target != null) {
            this.target.forwardEvent(keyEvent);
        }
    }
}

