/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import com.sun.iiim.IIIMStatusEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.AttributedCharacterIterator;
import sun.awt.im.iiimp.Manager;

class StatusPane
extends Panel
implements MouseMotionListener,
MouseListener {
    private String text = "";
    private AttributedCharacterIterator iterator;
    private boolean dragged = false;
    int x = 0;
    int y = 0;
    int oldx = 0;
    int oldy = 0;
    Cursor cursor = null;

    public StatusPane() {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    void handleEvent(IIIMStatusEvent iIIMStatusEvent) {
        this.text = "";
        this.setData(iIIMStatusEvent.getIterator());
        this.repaint();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.black);
        graphics.fill3DRect(rectangle.width - 2, 0, 2, rectangle.height, true);
        graphics.fill3DRect(0, rectangle.height - 2, rectangle.width, 2, true);
        graphics.setColor(Color.white);
        graphics.fill3DRect(0, 0, 2, rectangle.height, true);
        graphics.fill3DRect(0, 0, rectangle.width, 2, true);
        graphics.setColor(Color.black);
        if (Manager.COLOR_SUPPORT) {
            graphics.drawString(this.iterator, 12, 14);
        } else {
            graphics.drawString(this.text, 12, 14);
        }
    }

    void setData(AttributedCharacterIterator attributedCharacterIterator) {
        this.iterator = attributedCharacterIterator;
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            this.text = this.text + c;
            c = attributedCharacterIterator.next();
        }
    }

    String getData() {
        return this.text;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.x = mouseEvent.getX();
        this.y = mouseEvent.getY();
        if (!this.dragged) {
            this.oldx = this.x;
            this.oldy = this.y;
            this.dragged = true;
            this.cursor = this.getCursor();
            this.setCursor(new Cursor(13));
            return;
        }
        Point point = this.getParent().getLocationOnScreen();
        point.x += this.x - this.oldx;
        point.y += this.y - this.oldy;
        this.getParent().setLocation(point);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragged = false;
        this.setCursor(this.cursor);
    }
}

