/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import com.sun.iiim.IIIMPreeditEvent;
import com.sun.iiim.IIIMPreeditListener;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import sun.awt.im.iiimp.IIIMWindow;
import sun.awt.im.iiimp.Manager;
import sun.awt.im.iiimp.PreeditPane;

class PreeditWindow
extends IIIMWindow
implements IIIMPreeditListener {
    String style = Manager.getProperty("iiimf.preedit.style");
    PreeditPane pane;
    int columWidth;
    int columHeight;
    int offset = 20;

    public PreeditWindow() {
        if (this.style == null) {
            this.style = "ROOTWINDOW";
        }
    }

    void init() {
        this.window = new Dialog(new Frame(""));
        ((Dialog)this.window).setResizable(true);
        ((Dialog)this.window).setTitle("Preedit Window");
        Font font = new Font("Monospaced", 0, 12);
        FontMetrics fontMetrics = this.window.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getMaxAdvance();
        int n3 = fontMetrics.getAscent();
        this.columWidth = n2;
        this.columHeight = n + 2;
        this.window.setFont(font);
        this.pane = new PreeditPane();
        this.pane.setFont(font);
        this.window.add(this.pane);
        this.window.pack();
    }

    public void preeditStart(IIIMPreeditEvent iIIMPreeditEvent) {
    }

    public void preeditDone(IIIMPreeditEvent iIIMPreeditEvent) {
    }

    public void preeditDraw(IIIMPreeditEvent iIIMPreeditEvent) {
    }

    public void dispatchEvent(IIIMPreeditEvent iIIMPreeditEvent) {
        if (this.pane == null) {
            this.init();
        }
        this.pane.handleEvent(iIIMPreeditEvent);
        Insets insets = this.window.getInsets();
        int n = insets.left + insets.right + this.pane.width();
        int n2 = insets.top + insets.bottom + this.pane.height();
        this.window.setSize(n, n2);
        this.calculatePosition();
        this.window.show();
    }

    public void setStyle(String string) {
        this.style = string;
    }

    public String getStyle() {
        return this.style;
    }

    void calculatePosition() {
        Cloneable cloneable;
        Cloneable cloneable2;
        Component component;
        Component component2 = component = this.getClientComponent();
        while (!(component2 instanceof Frame)) {
            component2 = component.getParent();
        }
        if (this.style.equals("BELOWSPOT") && component instanceof InputMethodRequests) {
            cloneable2 = ((InputMethodRequests)((Object)component)).getTextLocation(TextHitInfo.leading(0));
            cloneable = new Point();
            ((Point)cloneable).x = ((Rectangle)cloneable2).x;
            ((Point)cloneable).y = ((Rectangle)cloneable2).y + (int)((Rectangle)cloneable2).getHeight() + this.offset;
            this.window.setLocation((Point)cloneable);
        } else {
            cloneable2 = component2.getLocation();
            cloneable = component2.getSize();
            double d = ((Point)cloneable2).getX();
            double d2 = ((Point)cloneable2).getY() + cloneable.getHeight();
            this.window.setLocation((int)d, (int)d2);
        }
        cloneable2 = this.window.getLocation();
        double d = ((Point)cloneable2).getX();
        double d3 = ((Point)cloneable2).getY();
        Dimension dimension = this.window.getSize();
        if (d + dimension.getWidth() > (double)IIIMWindow.screenWidth) {
            d = (double)IIIMWindow.screenWidth - dimension.getWidth();
        }
        if (d3 + dimension.getHeight() > (double)IIIMWindow.screenHeight) {
            d3 = (double)IIIMWindow.screenHeight - dimension.getHeight();
        }
        this.window.setLocation((int)d, (int)d3);
    }
}

