/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import com.sun.iiim.IIIMLookupEvent;
import com.sun.iiim.IIIMLookupListener;
import com.sun.iiim.IIIMStatusEvent;
import com.sun.iiim.IIIMStatusListener;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import sun.awt.im.iiimp.IIIMWindow;
import sun.awt.im.iiimp.LookupPane;
import sun.awt.im.iiimp.Manager;
import sun.awt.im.iiimp.StatusPane;

class CompositeWindow
extends IIIMWindow
implements IIIMLookupListener,
IIIMStatusListener {
    private String style = Manager.getProperty("iiimf.preedit.style");
    int columHeight;
    int columWidth;
    FontMetrics fm;
    LookupPane lookupPane;
    StatusPane statusPane;
    int offset = 24;

    public CompositeWindow() {
        this.init();
    }

    void init() {
        this.window = new Dialog(new Frame(""));
        ((Dialog)this.window).setResizable(true);
        ((Dialog)this.window).setTitle("Input Window");
        Font font = new Font("Monospaced", 0, 12);
        this.fm = this.window.getFontMetrics(font);
        int n = this.fm.getHeight();
        int n2 = this.fm.getMaxAdvance();
        int n3 = this.fm.getAscent();
        this.columWidth = n2;
        this.columHeight = n + 2;
        this.window.setFont(font);
        this.lookupPane = new LookupPane();
        this.window.add(this.lookupPane);
        this.statusPane = new StatusPane();
        this.window.add(this.statusPane);
        this.window.pack();
    }

    public void setStyle(String string) {
        this.style = string;
    }

    public String getStyle() {
        return this.style;
    }

    public void setLocation(int n, int n2) {
        this.window.setLocation(n, n2);
    }

    public void calculatePosition() {
        Component component;
        Component component2 = component = this.getClientComponent();
        Insets insets = this.window.getInsets();
        while (!(component2 instanceof Frame)) {
            component2 = component2.getParent();
        }
        if (this.style.equals("BELOWSPOT") && component instanceof InputMethodRequests) {
            Rectangle rectangle = ((InputMethodRequests)((Object)component)).getTextLocation(TextHitInfo.leading(0));
            Point point = new Point();
            point.x = rectangle.x;
            point.y = rectangle.x + (int)rectangle.getHeight() + this.offset;
            point.y += insets.top + insets.bottom + this.fm.getHeight();
            this.window.setLocation(point);
        } else {
            Point point = component2.getLocation();
            Dimension dimension = component2.getSize();
            double d = point.getX();
            double d2 = point.getY() + dimension.getHeight() + (double)insets.top + (double)insets.bottom + (double)this.fm.getHeight();
            this.window.setLocation((int)d, (int)d2);
        }
    }

    public void lookupStart(IIIMLookupEvent iIIMLookupEvent) {
    }

    public void lookupDone(IIIMLookupEvent iIIMLookupEvent) {
    }

    public void lookupDraw(IIIMLookupEvent iIIMLookupEvent) {
    }

    public void lookupProcess(IIIMLookupEvent iIIMLookupEvent) {
    }

    public void dispatchEvent(IIIMLookupEvent iIIMLookupEvent) {
        this.lookupPane.handleEvent(iIIMLookupEvent);
        this.window.doLayout();
        this.window.show();
    }

    public void statusStart(IIIMStatusEvent iIIMStatusEvent) {
    }

    public void statusDone(IIIMStatusEvent iIIMStatusEvent) {
    }

    public void statusDraw(IIIMStatusEvent iIIMStatusEvent) {
    }

    public void dispatchEvent(IIIMStatusEvent iIIMStatusEvent) {
        this.statusPane.handleEvent(iIIMStatusEvent);
        this.window.doLayout();
        this.window.show();
    }
}

