/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager;

import java.util.Enumeration;
import java.util.Vector;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.manager.SnmpVar;
import javax.management.snmp.manager.Timestamp;

public class SnmpVarbindList
extends Vector {
    public String identity = "VarbindList ";
    Timestamp timestamp;

    public SnmpVarbindList() {
        super(5, 5);
    }

    public SnmpVarbindList(String string) {
        super(5, 5);
        this.identity = string;
    }

    public SnmpVarbindList(String string, Vector vector) {
        this(vector);
        this.identity = string;
    }

    public SnmpVarbindList(Vector vector) {
        super(vector.size(), 5);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            SnmpOid snmpOid = snmpVarBind.oid;
            SnmpValue snmpValue = snmpVarBind.value;
            SnmpVar snmpVar = new SnmpVar(snmpOid, snmpValue);
            this.addElement(snmpVar);
        }
    }

    public SnmpVarbindList(SnmpVarbindList snmpVarbindList) {
        super(snmpVarbindList.size(), 5);
        snmpVarbindList.copyInto(this.elementData);
        this.elementCount = snmpVarbindList.size();
    }

    public synchronized void addInstance(String string) throws SnmpStatusException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ((SnmpVar)this.elementData[n2]).addInstance(string);
            ++n2;
        }
    }

    public synchronized void addVarbindList(SnmpVarbindList snmpVarbindList) {
        this.ensureCapacity(snmpVarbindList.size() + this.size());
        int n = 0;
        while (n < snmpVarbindList.size()) {
            this.addElement(snmpVarbindList.getSnmpVarAt(n));
            ++n;
        }
    }

    public synchronized void addVariable(String string) throws SnmpStatusException {
        SnmpVar snmpVar = new SnmpVar(string);
        this.addVariable(snmpVar);
    }

    public synchronized void addVariable(SnmpVar snmpVar) {
        this.addElement(snmpVar);
    }

    public synchronized void addVariable(String[] stringArray) throws SnmpStatusException {
        this.addVariable(stringArray, null);
    }

    public final synchronized void addVariable(String[] stringArray, String string) throws SnmpStatusException {
        int n = 0;
        while (n < stringArray.length) {
            SnmpVar snmpVar = new SnmpVar(stringArray[n]);
            snmpVar.addInstance(string);
            this.addElement(snmpVar);
            ++n;
        }
    }

    public synchronized boolean checkForUnspecifiedValue() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            SnmpVar snmpVar = (SnmpVar)this.elementData[n2];
            if (snmpVar.unspecifiedValue()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public synchronized boolean checkForValidValues() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            SnmpVar snmpVar = (SnmpVar)this.elementData[n2];
            if (!snmpVar.validValue()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public synchronized Object clone() {
        return this.cloneWithValue();
    }

    public synchronized SnmpVarbindList cloneWithValue() {
        SnmpVarbindList snmpVarbindList = new SnmpVarbindList();
        snmpVarbindList.setTimestamp(this.getTimestamp());
        snmpVarbindList.ensureCapacity(this.size());
        int n = 0;
        while (n < this.size()) {
            SnmpVar snmpVar = (SnmpVar)this.elementData[n];
            snmpVarbindList.addElement(snmpVar.clone());
            ++n;
        }
        return snmpVarbindList;
    }

    public synchronized SnmpVarbindList cloneWithoutValue() {
        SnmpVarbindList snmpVarbindList = new SnmpVarbindList();
        int n = this.size();
        snmpVarbindList.ensureCapacity(n);
        int n2 = 0;
        while (n2 < n) {
            SnmpVar snmpVar = (SnmpVar)this.elementData[n2];
            snmpVarbindList.addElement(snmpVar.cloneWithoutValue());
            ++n2;
        }
        return snmpVarbindList;
    }

    public final synchronized void concat(Vector vector) {
        this.ensureCapacity(this.size() + vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addElement(enumeration.nextElement());
        }
    }

    public void finalize() {
        this.removeAllElements();
    }

    public final synchronized SnmpVar getSnmpVarAt(int n) {
        return (SnmpVar)this.elementAt(n);
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public synchronized Enumeration getVarbindEnumeration() {
        return this.elements();
    }

    public synchronized int getVariableCount() {
        return this.size();
    }

    public synchronized int indexOfOid(SnmpOid snmpOid) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            SnmpVar snmpVar = (SnmpVar)this.elementData[n2];
            if (snmpOid.equals(snmpVar.getOid())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public synchronized int indexOfOid(SnmpVar snmpVar) {
        return this.indexOfOid(snmpVar, 0, this.size());
    }

    public synchronized int indexOfOid(SnmpVar snmpVar, int n, int n2) {
        SnmpOid snmpOid = snmpVar.getOid();
        int n3 = n;
        while (n3 < n2) {
            SnmpVar snmpVar2 = (SnmpVar)this.elementData[n3];
            if (snmpOid.equals(snmpVar2.getOid())) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public String oidListToString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        int n = 0;
        while (n < this.elementCount) {
            SnmpVar snmpVar = (SnmpVar)this.elementData[n];
            stringBuffer.append(String.valueOf(snmpVar.getOid().toString()) + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public synchronized boolean removeVarbindList(SnmpVarbindList snmpVarbindList) {
        boolean bl = true;
        int n = 0;
        while (n < snmpVarbindList.size()) {
            bl = this.removeElement(snmpVarbindList.getSnmpVarAt(n));
            ++n;
        }
        return bl;
    }

    public synchronized boolean removeVariable(String string) throws SnmpStatusException {
        SnmpVar snmpVar = new SnmpVar(string);
        int n = this.indexOfOid(snmpVar);
        try {
            this.removeElementAt(n);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public synchronized boolean removeVariable(SnmpVar snmpVar) {
        return this.removeElement(snmpVar);
    }

    public synchronized boolean removeVariable(String[] stringArray) throws SnmpStatusException {
        return this.removeVariable(stringArray, null);
    }

    public synchronized boolean removeVariable(String[] stringArray, String string) throws SnmpStatusException {
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            SnmpVar snmpVar = new SnmpVar(stringArray[n]);
            snmpVar.addInstance(string);
            int n2 = this.indexOfOid(snmpVar);
            try {
                this.removeElementAt(n2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public final synchronized void replaceVariable(SnmpVar snmpVar, int n) {
        this.setElementAt(snmpVar, n);
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public final synchronized void setVarbindList(Vector vector) {
        this.setVarbindList(vector, false);
    }

    public final synchronized void setVarbindList(Vector vector, boolean bl) {
        Vector vector2 = vector;
        synchronized (vector2) {
            int n = vector.size();
            this.setSize(n);
            vector.copyInto(this.elementData);
            if (bl) {
                int n2 = 0;
                while (n2 < n) {
                    SnmpVar snmpVar = (SnmpVar)this.elementData[n2];
                    this.elementData[n2] = snmpVar.clone();
                    ++n2;
                }
            }
        }
    }

    public synchronized SnmpVarbindList splitAt(int n) {
        SnmpVarbindList snmpVarbindList = null;
        if (n > this.elementCount) {
            return snmpVarbindList;
        }
        snmpVarbindList = new SnmpVarbindList();
        int n2 = this.size();
        int n3 = n;
        while (n3 < n2) {
            snmpVarbindList.addElement(this.elementData[n3]);
            ++n3;
        }
        this.elementCount = n;
        this.trimToSize();
        return snmpVarbindList;
    }

    public synchronized Vector toVector(boolean bl) {
        int n = this.elementCount;
        if (!bl) {
            return (Vector)super.clone();
        }
        Vector<Object> vector = new Vector<Object>(n, 5);
        int n2 = 0;
        while (n2 < n) {
            SnmpVar snmpVar = (SnmpVar)this.elementData[n2];
            vector.addElement(snmpVar.clone());
            ++n2;
        }
        return vector;
    }

    public synchronized String vbListToString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        int n = 0;
        while (n < this.elementCount) {
            stringBuffer.append(String.valueOf(this.elementData[n].toString()) + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

