/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager;

import com.sun.jdmk.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import javax.management.snmp.SnmpDefinitions;
import javax.management.snmp.SnmpMessage;
import javax.management.snmp.SnmpPduBulk;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.SnmpPduPacket;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpTooBigException;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.manager.ReqRedirectSrv;
import javax.management.snmp.manager.RequestCounter;
import javax.management.snmp.manager.SnmpHandler;
import javax.management.snmp.manager.SnmpParameters;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpPollRequest;
import javax.management.snmp.manager.SnmpQManager;
import javax.management.snmp.manager.SnmpSession;
import javax.management.snmp.manager.SnmpSocket;
import javax.management.snmp.manager.SnmpTooBig;
import javax.management.snmp.manager.SnmpVar;
import javax.management.snmp.manager.SnmpVarbindList;
import javax.management.snmp.manager.Timestamp;

public class SnmpRequest
implements Serializable,
SnmpDefinitions {
    private static RequestCounter requestCounter = new RequestCounter();
    SnmpVarbindList varbindList = null;
    int errorStatus = 0;
    int errorIndex = 0;
    int command = 0;
    private SnmpPeer thePeer;
    private SnmpSession session;
    private SnmpHandler callback = null;
    private int nonRepeaters = 0;
    private int maxRepetitions = 0;
    private ReqRedirectSrv proxy;
    private SnmpPduPacket requestPdu;
    private SnmpPduRequest responsePdu;
    Timestamp responseTimestamp = null;
    private SnmpVar[] internalVb = null;
    private String reason = null;
    private int options = 7;
    private static final int CREATED_BY_USER = 1;
    private static final int CREATED_INTERNALLY = 2;
    private int mode = 1;
    private static final int stBase = 1;
    public static final int stInProgress = 1;
    public static final int stWaitingToSend = 3;
    public static final int stWaitingForReply = 5;
    public static final int stReceivedReply = 9;
    public static final int stAborted = 16;
    public static final int stTimeout = 32;
    public static final int stInternalError = 64;
    public static final int stResultsAvailable = 128;
    public static final int stNeverUsed = 256;
    private int retry = 0;
    private int timeout = 5000;
    private int reqState = 256;
    private long prevPollTime = 0L;
    private long nextPollTime = 0L;
    private long waitTimeForResponse;
    private Date debugDate = new Date();
    private int requestId = 0;
    String dbgTag = "SnmpRequest";

    SnmpRequest(SnmpSession snmpSession, SnmpPeer snmpPeer, SnmpHandler snmpHandler, int n) throws SnmpStatusException {
        this.session = snmpSession;
        this.thePeer = snmpPeer;
        this.callback = snmpHandler;
        switch (n) {
            case 160: 
            case 161: 
            case 163: 
            case 165: 
            case 166: {
                this.command = n;
                break;
            }
            case 253: {
                this.command = 161;
                break;
            }
            default: {
                throw new SnmpStatusException("Unsupported Command. " + n);
            }
        }
        this.session.addRequest(this);
        this.setTimeout(this.thePeer.getTimeout());
    }

    SnmpRequest(SnmpSession snmpSession, SnmpPeer snmpPeer, SnmpHandler snmpHandler, int n, int n2) throws SnmpStatusException {
        this(snmpSession, snmpPeer, snmpHandler, 165);
        this.nonRepeaters = n;
        this.maxRepetitions = n2;
    }

    void action() {
        if (!this.inProgress()) {
            return;
        }
        while (true) {
            try {
                if (this.retry == 0) {
                    this.invokeOnReady();
                } else if (this.retry < this.getMaxRetry()) {
                    this.invokeOnRetry();
                } else {
                    this.invokeOnTimeout();
                }
                return;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                ++this.retry;
                if (this.isDebugOn()) {
                    this.debug("action", "Request hit out of memory situation...");
                }
                Thread.currentThread();
                Thread.yield();
                continue;
            }
            break;
        }
    }

    public final boolean allowMultiplex() {
        return (this.options & 1) == 1;
    }

    public final void cancelRequest() {
        if (this.proxy != null) {
            ReqRedirectSrv reqRedirectSrv = this.proxy;
            this.proxy = null;
            reqRedirectSrv.cancel(this);
        }
        this.errorStatus = 225;
        this.stopRequest();
        this.deleteRequest();
        this.notifyClient();
    }

    private final synchronized SnmpPduPacket constructPduPacket() {
        SnmpPduPacket snmpPduPacket = null;
        Exception exception = null;
        try {
            if (this.command == 165) {
                SnmpPduBulk snmpPduBulk = new SnmpPduBulk();
                snmpPduBulk.nonRepeaters = this.nonRepeaters;
                snmpPduBulk.maxRepetitions = this.maxRepetitions;
                snmpPduPacket = snmpPduBulk;
            } else {
                SnmpPduRequest snmpPduRequest;
                snmpPduPacket = snmpPduRequest = new SnmpPduRequest();
                snmpPduPacket.type = this.command;
            }
            snmpPduPacket.version = this.command == 166 ? 1 : this.getParam().getProtocolVersion();
            snmpPduPacket.community = this.getParam().encodeAuthentication(this.command);
            snmpPduPacket.requestId = this.getRequestId();
            snmpPduPacket.varBindList = this.internalVb;
            if (this.isTraceOn()) {
                this.trace("constructPduPacket", "Packet built");
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            exception = snmpStatusException;
            this.errorStatus = 227;
            this.reason = snmpStatusException.getMessage();
        }
        catch (Exception exception2) {
            exception = exception2;
            this.errorStatus = 242;
            this.reason = exception2.getMessage();
        }
        if (exception != null) {
            if (this.isDebugOn()) {
                this.debug("constructPduPacket", exception);
            }
            snmpPduPacket = null;
            this.queueResponse();
        }
        return snmpPduPacket;
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }

    final synchronized void deleteRequest() {
        this.session.deleteRequest(this);
    }

    public void finalize() {
        this.callback = null;
        this.varbindList = null;
        this.session = null;
        this.thePeer = null;
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVb = null;
    }

    public boolean fixPduOnError() {
        return (this.options & 2) == 2 && this.command != 165;
    }

    public boolean fixTooBigError() {
        return (this.options & 4) == 4 && this.command != 165;
    }

    final synchronized boolean fixVarbindList(SnmpVar[] snmpVarArray, int n) {
        int n2 = n;
        SnmpVar snmpVar = null;
        if (this.isTraceOn()) {
            this.trace("fixVarbindList", "Fix Pdu at index " + n);
        }
        int n3 = 0;
        while (n3 < snmpVarArray.length) {
            if (snmpVarArray[n3] != null && --n < 0) break;
            ++n3;
        }
        if (n3 >= snmpVarArray.length) {
            this.reason = "Fix varbind.: Can't find varbind with idx = " + n2;
            if (this.isDebugOn()) {
                this.debug("fixVarbindList", this.reason);
            }
            return false;
        }
        snmpVar = snmpVarArray[n3];
        snmpVarArray[n3] = null;
        switch (this.getCommand()) {
            case 160: {
                snmpVar.setValueNoSuchInstance();
                break;
            }
            case 161: {
                snmpVar.setValueEndOfMibView();
                break;
            }
        }
        return true;
    }

    public final synchronized long getAbsMaxTimeToWait() {
        if (this.prevPollTime == 0L) {
            return System.currentTimeMillis();
        }
        return this.waitTimeForResponse;
    }

    public final synchronized long getAbsNextPollTime() {
        return this.nextPollTime;
    }

    public final int getCommand() {
        return this.command;
    }

    public final synchronized int getErrorIndex() {
        return this.errorIndex;
    }

    public final synchronized int getErrorStatus() {
        return this.errorStatus;
    }

    public final int getMaxRetry() {
        if (this.command == 163) {
            return 1;
        }
        return this.getPeer().getMaxRetries();
    }

    public final int getOptions() {
        return this.options;
    }

    public final SnmpParameters getParam() {
        return this.thePeer.getSnmpParam();
    }

    public final SnmpPeer getPeer() {
        return this.thePeer;
    }

    public final synchronized long getPollTimestamp() {
        return this.prevPollTime;
    }

    final synchronized String getRequestCreationType() {
        switch (this.mode) {
            case 1: {
                return "UserCreated.";
            }
            case 2: {
                return "Internal_" + this.callback.getClass().getName();
            }
        }
        return "UnknownRequest????";
    }

    public final synchronized int getRequestId() {
        return this.requestId;
    }

    public final synchronized int getRequestStatus() {
        return this.reqState;
    }

    public final synchronized SnmpVarbindList getRequestVbList() {
        return this.varbindList;
    }

    public final synchronized SnmpVarbindList getResponseVbList() {
        if (this.inProgress()) {
            return null;
        }
        return this.varbindList;
    }

    public final synchronized int getRetryCount() {
        return this.retry;
    }

    public final SnmpSession getSnmpSession() {
        return this.session;
    }

    final synchronized SnmpVarbindList getVarbindList() {
        return this.varbindList;
    }

    private void handleError(String string) {
        this.setRequestStatus(128);
        if (this.isDebugOn()) {
            this.debug("handleError", "Snmp error/index = " + SnmpRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Invoking error user defined callback...\n" + this.getVarbindList().vbListToString());
        }
        this.deleteRequest();
        this.notifyClient();
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVb = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollData(this, this.getErrorStatus(), this.getErrorIndex(), this.getVarbindList());
            }
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("handleError", "Exception generated by user callback");
                this.debug("handleError", exception);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (this.isDebugOn()) {
                this.debug("handleError", "OutOfMemory Error generated by user callback");
                this.debug("handleError", outOfMemoryError);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    void handleInternalError(String string) {
        this.setRequestStatus(64);
        if (this.reason == null) {
            this.reason = string;
        }
        if (this.isDebugOn()) {
            this.debug("handleInternalError", "Snmp error/index = " + SnmpRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Invoking internal error user defined callback...\n" + this.getVarbindList().vbListToString());
        }
        this.deleteRequest();
        this.notifyClient();
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVb = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpInternalError(this, this.reason);
            }
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("handleInternalError", "Exception generated by user callback");
                this.debug("handleInternalError", exception);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (this.isDebugOn()) {
                this.debug("handleInternalError", "OutOfMemory Error generated by user callback");
                this.debug("handleInternalError", outOfMemoryError);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    void handleSuccess() {
        this.setRequestStatus(128);
        if (this.isTraceOn()) {
            this.trace("handleSuccess", "Invoking user defined callback...");
        }
        if (!(this instanceof SnmpPollRequest)) {
            this.deleteRequest();
        }
        this.notifyClient();
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVb = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollData(this, this.errorStatus, this.errorIndex, this.getVarbindList());
            }
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("handleSuccess", "Exception generated by user callback");
                this.debug("handleSuccess", exception);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (this.isDebugOn()) {
                this.debug("handleSuccess", "OutOfMemory Error generated by user callback");
                this.debug("handleSuccess", outOfMemoryError);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    private void handleTimeout() {
        this.setRequestStatus(32);
        if (this.isDebugOn()) {
            this.debug("handleTimeout", "Snmp error/index = " + SnmpRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Invoking timeout user defined callback...");
        }
        this.deleteRequest();
        this.notifyClient();
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVb = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollTimeout(this);
            }
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("handleTimeout", "Exception generated by user callback");
                this.debug("handleTimeout", exception);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (this.isDebugOn()) {
                this.debug("handleTimeout", "OutOfMemory Error generated by user callback");
                this.debug("handleTimeout", outOfMemoryError);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    private boolean handleTooBigError() {
        if (!this.fixTooBigError()) {
            return false;
        }
        if (this.varbindList.size() < 2) {
            this.setErrorStatusAndIndex(232, 0);
            return false;
        }
        try {
            if (this.isTraceOn()) {
                this.trace("handleTooBigError", "Handling Too big error");
            }
            this.proxy = new SnmpTooBig(this, this.getVarbindList());
            return true;
        }
        catch (Exception exception) {
            this.reason = exception.getMessage();
            this.setErrorStatusAndIndex(240, 0);
            return false;
        }
    }

    public final synchronized boolean inProgress() {
        return (this.reqState & 1) == 1;
    }

    final synchronized void initNewRequest() {
        this.requestId = requestCounter.getNewId();
    }

    private synchronized void initializeAndFire(long l) {
        this.responsePdu = null;
        this.requestPdu = null;
        this.reason = null;
        this.proxy = null;
        if (l == 0L) {
            this.startRequest(System.currentTimeMillis());
        } else {
            this.startRequest(l);
        }
        this.setErrorStatusAndIndex(0, 0);
    }

    private final void invokeOnReady() {
        if (this.requestPdu == null) {
            if (this.varbindList.size() > this.getPeer().getVarbindLimit()) {
                if (this.isDebugOn()) {
                    this.debug("invokeOnReady", "Attempt too big. vblist exceeds max allowed for peer. Actual = " + this.varbindList.size() + " Allowed = " + this.getPeer().getVarbindLimit());
                }
                this.setErrorStatusAndIndex(231, 0);
                if (!this.handleTooBigError()) {
                    this.queueResponse();
                }
                return;
            }
            this.requestPdu = this.constructPduPacket();
        }
        if (this.requestPdu != null && !this.sendPdu()) {
            this.queueResponse();
        }
    }

    final void invokeOnResponse(Object object) {
        if (object != null) {
            if (object instanceof SnmpPduRequest) {
                this.responsePdu = (SnmpPduRequest)object;
            } else {
                return;
            }
        }
        this.setRequestStatus(9);
        this.queueResponse();
    }

    private final void invokeOnRetry() {
        this.invokeOnReady();
    }

    private final void invokeOnTimeout() {
        this.errorStatus = 224;
        this.queueResponse();
    }

    public final synchronized boolean isAborted() {
        return (this.reqState & 0x10) == 16;
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    public boolean isInternalRequest() {
        return this.mode == 2;
    }

    public final synchronized boolean isResultAvailable() {
        return this.reqState == 128;
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    public final synchronized void notifyClient() {
        this.notifyAll();
    }

    private final synchronized void parsePduPacket(SnmpPduRequest snmpPduRequest) throws SnmpStatusException {
        if (snmpPduRequest == null) {
            return;
        }
        this.errorStatus = snmpPduRequest.errorStatus;
        this.errorIndex = snmpPduRequest.errorIndex;
        if (this.errorStatus == 0) {
            if (this.command == 165) {
                this.updateVarbindList(snmpPduRequest.varBindList);
            } else {
                this.updateInternalVbWithResult(this.command, snmpPduRequest.varBindList);
            }
            this.responseTimestamp = new Timestamp();
            this.getVarbindList().setTimestamp(this.responseTimestamp);
            return;
        }
        if (this.errorStatus != 0) {
            --this.errorIndex;
        }
        switch (this.errorStatus) {
            case 2: {
                if (!this.fixPduOnError()) break;
                if (this.fixVarbindList(this.internalVb, this.errorIndex)) {
                    if (this.getVarbindList().checkForUnspecifiedValue()) {
                        this.setErrorStatusAndIndex(230, 0);
                        break;
                    }
                    this.setErrorStatusAndIndex(0, 0);
                    break;
                }
                this.setErrorStatusAndIndex(240, 0);
                break;
            }
            case 1: {
                if (!this.fixTooBigError() || this.varbindList.size() <= 1) break;
                this.setErrorStatusAndIndex(231, 0);
                break;
            }
        }
        if (this.isTraceOn()) {
            this.trace("parsePduPacket", "received response. ErrorStatus/ErrorIndex = " + this.errorStatus + "/" + this.errorIndex);
        }
    }

    final void processResponse() throws SnmpStatusException {
        if (this.isTraceOn()) {
            this.trace("processResponse", "errstatus = " + this.errorStatus);
        }
        if (!this.inProgress()) {
            this.responsePdu = null;
            return;
        }
        if (this.errorStatus >= 240) {
            this.handleInternalError("Internal Error...");
            return;
        }
        try {
            this.parsePduPacket(this.responsePdu);
            this.responsePdu = null;
            switch (this.errorStatus) {
                case 0: {
                    this.handleSuccess();
                    return;
                }
                case 224: {
                    this.handleTimeout();
                    return;
                }
                case 240: {
                    this.handleInternalError("Unknown internal error.  deal with it later!");
                    return;
                }
                case 231: {
                    this.setErrorStatusAndIndex(1, 0);
                    if (this.handleTooBigError()) {
                        return;
                    }
                    this.handleError("Cannot handle too-big situation...");
                    return;
                }
                case 230: {
                    this.initializeAndFire(0L);
                    return;
                }
            }
            if (this.command != 163 && this.command != 165) {
                this.translateErrorIndex();
            }
            this.handleError("Error status set in packet...!!");
            return;
        }
        catch (SnmpStatusException snmpStatusException) {
            this.errorStatus = 226;
            this.reason = snmpStatusException.getMessage();
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("processResponse", exception);
            }
            this.reason = exception.getMessage();
        }
        this.handleInternalError(this.reason);
    }

    private final void queueResponse() {
        this.getSnmpSession().addResponse(this);
    }

    private void schedulePoll() {
        this.retry = 0;
        this.initNewRequest();
        this.setRequestStatus(3);
        SnmpQManager.getTheInstance().addRequest(this);
    }

    private boolean sendPdu() {
        try {
            this.responseTimestamp = null;
            this.responsePdu = null;
            SnmpPduFactory snmpPduFactory = this.thePeer.getPduFactory();
            SnmpMessage snmpMessage = snmpPduFactory.encodePdu(this.requestPdu, this.thePeer.getMaxSnmpPktSize());
            if (snmpMessage == null) {
                if (this.isDebugOn()) {
                    this.debug("sendPdu", "pdu factory returned a null value");
                }
                throw new SnmpStatusException(242);
            }
            int n = this.thePeer.getMaxSnmpPktSize();
            byte[] byArray = new byte[n];
            int n2 = snmpMessage.encodeMessage(byArray);
            if (this.isTraceOn()) {
                this.trace("sendPdu", "Dump : \n" + snmpMessage.printMessage());
            }
            this.sendPduPacket(byArray, n2);
            return true;
        }
        catch (SnmpTooBigException snmpTooBigException) {
            if (this.isDebugOn()) {
                this.debug("sendPdu", snmpTooBigException);
            }
            this.setErrorStatusAndIndex(228, snmpTooBigException.getVarBindCount());
            this.requestPdu = null;
            this.reason = snmpTooBigException.getMessage();
            if (this.isDebugOn()) {
                this.debug("sendPdu", "Packet Overflow while building Request");
            }
            return this.handleTooBigError();
        }
        catch (IOException iOException) {
            this.setErrorStatusAndIndex(241, 0);
            this.reason = iOException.getMessage();
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("sendPdu", exception);
            }
            this.setErrorStatusAndIndex(242, 0);
            this.reason = exception.getMessage();
        }
        return false;
    }

    final void sendPduPacket(byte[] byArray, int n) throws IOException {
        SnmpSocket snmpSocket;
        if (this.isTraceOn()) {
            this.trace("sendPduPacket", "Send to peer. " + this.thePeer.toString() + "Length = " + n + "\nDump : \n" + SnmpMessage.dumpHexBuffer(byArray, 0, n));
        }
        SnmpSocket snmpSocket2 = snmpSocket = this.getSnmpSession().getSocket();
        synchronized (snmpSocket2) {
            snmpSocket.sendPacket(byArray, n, this.thePeer.getDestAddr(), this.thePeer.getDestPort());
            this.setRequestSentTime(System.currentTimeMillis());
        }
    }

    final synchronized void setCallback(SnmpHandler snmpHandler) {
        this.callback = snmpHandler;
    }

    final synchronized void setErrorStatusAndIndex(int n, int n2) {
        this.errorStatus = n;
        this.errorIndex = n2;
    }

    final void setInternalRequest() {
        this.mode = 2;
    }

    public final synchronized void setOptions(int n) {
        if (!this.inProgress()) {
            this.options = n;
            if (!this.fixPduOnError() || !this.fixTooBigError()) {
                this.options &= 0xFFFFFFFE;
            }
        }
    }

    final synchronized void setPreviousPollTimestamp(long l) {
        this.prevPollTime = l;
    }

    final void setProxyObject(ReqRedirectSrv reqRedirectSrv) {
        this.proxy = reqRedirectSrv;
    }

    final void setRequestSentTime(long l) {
        ++this.retry;
        this.setPreviousPollTimestamp(l);
        this.waitTimeForResponse = this.prevPollTime + (long)(this.timeout * this.retry);
        this.setRequestStatus(5);
        if (this.isTraceOn()) {
            this.trace("setRequestSentTime", "Request Successfully sent");
        }
        SnmpQManager.getTheInstance().addWaiting(this);
    }

    final synchronized void setRequestStatus(int n) {
        this.reqState = n;
    }

    final synchronized void setTimeout(int n) {
        this.timeout = n;
    }

    final synchronized void setVarbindList(SnmpVarbindList snmpVarbindList) {
        this.varbindList = snmpVarbindList;
        if (this.internalVb == null || this.internalVb.length != this.varbindList.size()) {
            this.internalVb = new SnmpVar[this.varbindList.size()];
        }
        this.varbindList.copyInto(this.internalVb);
    }

    public static String snmpErrorToString(int n) {
        switch (n) {
            case 0: {
                return "NoError";
            }
            case 1: {
                return "TooBig";
            }
            case 2: {
                return "NoSuchName";
            }
            case 3: {
                return "BadValue";
            }
            case 4: {
                return "ReadOnly";
            }
            case 5: {
                return "GeneralError";
            }
            case 225: {
                return "UserAborted";
            }
            case 227: {
                return "EncodingError";
            }
            case 228: {
                return "RequestPacketOverflow";
            }
            case 229: {
                return "EndOfTable";
            }
            case 240: {
                return "InternalError";
            }
            case 224: {
                return "Timeout";
            }
        }
        return "Unknown Error = " + n;
    }

    synchronized void start(SnmpVarbindList snmpVarbindList, long l) throws SnmpStatusException {
        this.start(snmpVarbindList, true, l);
    }

    synchronized void start(SnmpVarbindList snmpVarbindList, boolean bl, long l) throws SnmpStatusException {
        if (this.inProgress()) {
            throw new SnmpStatusException("Request already in progress.");
        }
        switch (this.getCommand()) {
            case 163: {
                if (this.getParam().getProtocolVersion() == 1) {
                    this.options = 0;
                }
                if (bl) {
                    this.setVarbindList((SnmpVarbindList)snmpVarbindList.clone());
                    break;
                }
                this.setVarbindList(snmpVarbindList);
                break;
            }
            case 160: 
            case 161: 
            case 165: {
                if (bl) {
                    this.setVarbindList(snmpVarbindList.cloneWithoutValue());
                    break;
                }
                this.setVarbindList(snmpVarbindList);
                break;
            }
            case 166: {
                this.setVarbindList(snmpVarbindList);
                break;
            }
            default: {
                throw new SnmpStatusException("Unsupported Command.  Should never happen. ??!! " + this.getCommand());
            }
        }
        this.initializeAndFire(l);
    }

    private synchronized void startRequest(long l) {
        this.nextPollTime = l;
        this.prevPollTime = 0L;
        this.schedulePoll();
    }

    static final String statusDescription(int n) {
        switch (n) {
            case 3: {
                return "Waiting to send.";
            }
            case 5: {
                return "Waiting for reply.";
            }
            case 9: {
                return "Response arrived.";
            }
            case 16: {
                return "Aborted by user.";
            }
            case 32: {
                return "Timeout Occured.";
            }
            case 64: {
                return "Internal error.";
            }
            case 128: {
                return "Results available";
            }
            case 256: {
                return "Request in createAndWait state";
            }
        }
        return "Unknown Request state.";
    }

    void stopRequest() {
        SnmpRequest snmpRequest = this;
        synchronized (snmpRequest) {
            this.setRequestStatus(16);
        }
        SnmpQManager.getTheInstance().removeRequest(this);
        snmpRequest = this;
        synchronized (snmpRequest) {
            this.requestId = 0;
        }
    }

    long timeRemainingForAction(long l) {
        switch (this.reqState) {
            case 3: {
                return this.nextPollTime - l;
            }
            case 5: {
                return this.waitTimeForResponse - l;
            }
        }
        return -1L;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append(String.valueOf(this.tostring()) + " " + this.getRequestCreationType());
        stringBuffer.append("\n" + this.thePeer.toString());
        stringBuffer.append(" SnmpCmd = " + SnmpPduPacket.pduTypeToString(this.command));
        stringBuffer.append("  RequestOptions = " + this.options);
        return stringBuffer.toString();
    }

    private synchronized String tostring() {
        StringBuffer stringBuffer = new StringBuffer("RequestId = " + this.requestId);
        stringBuffer.append("   Status = " + SnmpRequest.statusDescription(this.reqState));
        stringBuffer.append("  Timeout/MaxRetry/Retry = " + this.timeout * this.retry + "/" + this.getMaxRetry() + "/" + this.retry);
        if (this.prevPollTime > 0L) {
            this.debugDate.setTime(this.prevPollTime);
            stringBuffer.append("\nPrevPolled = " + this.debugDate.toString());
        } else {
            stringBuffer.append("\nNeverPolled");
        }
        stringBuffer.append(" / RemainingTime(millis) = " + this.timeRemainingForAction(System.currentTimeMillis()));
        return stringBuffer.toString();
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    final void translateErrorIndex() {
        if (!this.fixPduOnError()) {
            return;
        }
        SnmpVarbindList snmpVarbindList = this.getVarbindList();
        int n = snmpVarbindList.size();
        int n2 = 0;
        while (n2 < n) {
            if (!snmpVarbindList.getSnmpVarAt(n2).hasVbException()) {
                --this.errorIndex;
                if (this.errorIndex == 0) {
                    this.errorIndex = n2;
                    return;
                }
            }
            ++n2;
        }
    }

    private void updateInternalVbWithResult(int n, SnmpVarBind[] snmpVarBindArray) {
        if (snmpVarBindArray == null || snmpVarBindArray.length == 0) {
            return;
        }
        int n2 = 0;
        switch (n) {
            case 160: 
            case 163: 
            case 166: {
                int n3 = 0;
                while (n3 < this.internalVb.length && n2 < snmpVarBindArray.length) {
                    SnmpVar snmpVar = this.internalVb[n3];
                    if (snmpVar != null) {
                        SnmpVarBind snmpVarBind = snmpVarBindArray[n2];
                        snmpVar.setSnmpValue(snmpVarBind.value);
                        ++n2;
                    }
                    ++n3;
                }
                break;
            }
            case 161: {
                int n4 = 0;
                while (n4 < this.internalVb.length && n2 < snmpVarBindArray.length) {
                    SnmpVar snmpVar = this.internalVb[n4];
                    if (snmpVar != null) {
                        SnmpVarBind snmpVarBind = snmpVarBindArray[n2];
                        snmpVar.setSnmpValue(snmpVarBind.value);
                        snmpVar.oid = snmpVarBind.oid;
                        ++n2;
                    }
                    ++n4;
                }
                break;
            }
        }
    }

    private void updateVarbindList(SnmpVarBind[] snmpVarBindArray) {
        this.varbindList = new SnmpVarbindList();
        int n = 0;
        while (n < snmpVarBindArray.length) {
            SnmpVarBind snmpVarBind = snmpVarBindArray[n];
            SnmpVar snmpVar = new SnmpVar(snmpVarBind.oid);
            snmpVar.setSnmpValue(snmpVarBind.value);
            this.varbindList.addVariable(snmpVar);
            ++n;
        }
    }

    public final boolean waitForCompletion(long l) throws SnmpStatusException {
        if (!this.inProgress()) {
            return true;
        }
        if (this instanceof SnmpPollRequest) {
            throw new SnmpStatusException("Not supported for SnmpPollRequest objects");
        }
        if (this.session.thisSessionContext()) {
            SnmpHandler snmpHandler = this.callback;
            this.callback = null;
            this.session.waitForResponse(this, l);
            this.callback = snmpHandler;
        } else {
            SnmpRequest snmpRequest = this;
            synchronized (snmpRequest) {
                SnmpHandler snmpHandler = this.callback;
                try {
                    this.callback = null;
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {}
                this.callback = snmpHandler;
            }
        }
        return this.inProgress() ^ true;
    }
}

