/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager;

import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.manager.SnmpHandler;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpSession;
import javax.management.snmp.manager.SnmpVar;
import javax.management.snmp.manager.SnmpVarbindList;

final class SnmpPollRequest
extends SnmpRequest {
    private SnmpOid oidKey = null;
    private SnmpVarbindList initialVarbindList = null;
    private int freq = -1;
    static int WALK_ROW_INTERVAL = 100;

    public SnmpPollRequest(SnmpSession snmpSession, SnmpPeer snmpPeer, SnmpHandler snmpHandler, int n) throws SnmpStatusException {
        super(snmpSession, snmpPeer, snmpHandler, n);
    }

    final synchronized boolean checkIfEndOfTable() {
        SnmpVar snmpVar = this.varbindList.getSnmpVarAt(0);
        if (snmpVar.hasVbException() || snmpVar.getOid().compareTo(this.oidKey) >= 0) {
            this.errorStatus = 229;
            return true;
        }
        return false;
    }

    public synchronized int getPollFrequency() {
        return this.freq;
    }

    synchronized void handleSuccess() {
        SnmpVarbindList snmpVarbindList = this.initialVarbindList;
        long l = this.getPollFrequency();
        if (this.oidKey != null) {
            if (!this.checkIfEndOfTable()) {
                snmpVarbindList = this.getVarbindList();
                l = WALK_ROW_INTERVAL;
            } else {
                l = -1L;
            }
        }
        super.handleSuccess();
        if (this.isAborted() || this.inProgress()) {
            return;
        }
        if (l < 0L) {
            this.deleteRequest();
            return;
        }
        l += this.getPollTimestamp();
        this.setErrorStatusAndIndex(0, 0);
        try {
            super.start(snmpVarbindList, true, l);
        }
        catch (SnmpStatusException snmpStatusException) {
            this.handleInternalError(String.valueOf(snmpStatusException.getMessage()) + "  While trying to continue polling.");
        }
    }

    private void init() {
        this.oidKey = null;
        this.initialVarbindList = null;
    }

    public final synchronized void setPollFrequency(int n) {
        this.setPollFrequency(n, 0);
    }

    public final synchronized void setPollFrequency(int n, int n2) {
        this.freq = n * 1000 + n2;
    }

    public final synchronized void startPoll(SnmpVarbindList snmpVarbindList, SnmpOid snmpOid, boolean bl, int n) throws SnmpStatusException {
        this.oidKey = snmpOid;
        this.initialVarbindList = snmpVarbindList.cloneWithoutValue();
        super.start(snmpVarbindList, true, n);
    }

    public final synchronized void startPoll(SnmpVarbindList snmpVarbindList, boolean bl, int n) throws SnmpStatusException {
        this.oidKey = null;
        this.initialVarbindList = snmpVarbindList.cloneWithoutValue();
        this.start(snmpVarbindList, true, n);
    }

    public final synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(String.valueOf(super.toString()) + "\n");
        if (this.oidKey == null) {
            stringBuffer.append("Polling Mode.  Frequency = " + this.freq);
        } else {
            stringBuffer.append("Mib walking facility");
        }
        return stringBuffer.toString();
    }
}

