/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.HttpConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.discovery.DiscoveryCommon;
import com.sun.jdmk.discovery.DiscoveryMsg;
import com.sun.jdmk.discovery.DiscoveryPDU;
import com.sun.jdmk.discovery.ResponsePDU;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;

class ActualResponder
extends DiscoveryCommon {
    public boolean stopRequested;
    private MBeanServer cmf;
    private String mbeanServerName;
    private String ImplementationName;
    private String ImplementationVendor;
    private String ImplementationVersion;
    private String SpecificationName;
    private String SpecificationVendor;
    private String SpecificationVersion;
    private int ttl;
    private boolean sendEvent;
    private boolean spy;

    public ActualResponder(String string, int n, int n2, MBeanServer mBeanServer, String string2) throws IOException {
        block6: {
            super(string, n);
            this.stopRequested = false;
            this.cmf = null;
            this.mbeanServerName = null;
            this.ImplementationName = null;
            this.ImplementationVendor = null;
            this.ImplementationVersion = null;
            this.SpecificationName = null;
            this.SpecificationVendor = null;
            this.SpecificationVersion = null;
            this.ttl = 1;
            this.sendEvent = true;
            this.spy = false;
            if (this.isTraceOn()) {
                this.trace("constructor ", "group = " + string + ", " + "port  = " + n);
            }
            this.localClassName = "com.sun.jdmk.discovery.ActualResponder";
            this.ttl = n2;
            if (string2 != null) {
                if (this.isTraceOn()) {
                    this.trace("constructor ", "constructor spy = '" + string2 + "'");
                }
                if (string2.compareTo("act_as_a_spy") == 0) {
                    this.spy = true;
                }
            }
            this.cmf = mBeanServer;
            try {
                ObjectName objectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
                this.mbeanServerName = (String)mBeanServer.getAttribute(objectName, "MBeanServerId");
                this.SpecificationName = (String)mBeanServer.getAttribute(objectName, "SpecificationName");
                this.SpecificationVendor = (String)mBeanServer.getAttribute(objectName, "SpecificationVendor");
                this.SpecificationVersion = (String)mBeanServer.getAttribute(objectName, "SpecificationVersion");
                this.ImplementationName = (String)mBeanServer.getAttribute(objectName, "ImplementationName");
                this.ImplementationVendor = (String)mBeanServer.getAttribute(objectName, "ImplementationVendor");
                this.ImplementationVersion = (String)mBeanServer.getAttribute(objectName, "ImplementationVersion");
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block6;
                this.debug("constructor ", exception);
            }
        }
    }

    private void formatPdu(ResponsePDU responsePDU, DiscoveryPDU discoveryPDU, boolean bl) {
        block41: {
            Iterator iterator;
            Set set;
            ObjectName objectName;
            block40: {
                Iterator iterator2;
                block39: {
                    ConnectorAddress connectorAddress;
                    Iterator iterator3;
                    block38: {
                        if (!bl) {
                            responsePDU.setTimeStamp(discoveryPDU.getTimeStamp());
                        } else {
                            responsePDU.setTimeStamp("");
                        }
                        responsePDU.setEvent(bl);
                        if (!bl) {
                            responsePDU.setTimeToLive(discoveryPDU.getTimeToLive());
                        } else {
                            responsePDU.setTimeToLive(this.ttl);
                        }
                        if (!bl) {
                            responsePDU.setEmittedGroup(discoveryPDU.getEmittedGroup());
                        } else {
                            responsePDU.setEmittedGroup(this.multicastGroup);
                        }
                        responsePDU.setHost(this.localHostName);
                        boolean bl2 = bl;
                        Object var5_5 = null;
                        if (discoveryPDU != null) {
                            bl2 |= discoveryPDU.getObjectRequired();
                        }
                        if (!bl2) break block41;
                        objectName = null;
                        try {
                            objectName = new ObjectName("*:*");
                        }
                        catch (MalformedObjectNameException malformedObjectNameException) {
                            if (this.isDebugOn()) {
                                this.debug("formatPdu ", malformedObjectNameException);
                            }
                            return;
                        }
                        String string = "com.sun.jdmk.comm.RmiConnectorServer";
                        try {
                            set = this.cmf.queryNames(objectName, Query.match(Query.classattr(), Query.value(string)));
                            if (this.isTraceOn()) {
                                iterator3 = set.iterator();
                                while (iterator3.hasNext()) {
                                    iterator2 = (ObjectName)iterator3.next();
                                    this.trace("formatPdu ", "Add\t'" + iterator2 + "' in response msg");
                                }
                            }
                            iterator3 = set.iterator();
                            while (iterator3.hasNext()) {
                                iterator2 = (ObjectName)iterator3.next();
                                try {
                                    iterator = (String)this.cmf.getAttribute((ObjectName)((Object)iterator2), "Host");
                                    int n = (Integer)this.cmf.getAttribute((ObjectName)((Object)iterator2), "Port");
                                    String string2 = (String)this.cmf.getAttribute((ObjectName)((Object)iterator2), "ServiceName");
                                    connectorAddress = new RmiConnectorAddress((String)((Object)iterator), n, string2);
                                    responsePDU.addObjectList((ObjectName)((Object)iterator2), connectorAddress);
                                }
                                catch (Exception exception) {
                                    if (!this.isDebugOn()) continue;
                                    this.debug("formatPdu ", exception);
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (!this.isTraceOn()) break block38;
                            this.trace("formatPdu ", "Unable to get Mbean for " + string);
                            this.trace("formatPdu ", exception);
                        }
                    }
                    iterator3 = "com.sun.jdmk.comm.HttpConnectorServer";
                    try {
                        set = this.cmf.queryNames(objectName, Query.match(Query.classattr(), Query.value((String)((Object)iterator3))));
                        if (this.isTraceOn()) {
                            iterator2 = set.iterator();
                            while (iterator2.hasNext()) {
                                iterator = (ObjectName)iterator2.next();
                                this.trace("formatPdu ", "Add\t'" + iterator + "' in response msg");
                            }
                        }
                        iterator2 = set.iterator();
                        while (iterator2.hasNext()) {
                            iterator = (ObjectName)iterator2.next();
                            try {
                                String string = (String)this.cmf.getAttribute((ObjectName)((Object)iterator), "Host");
                                int n = (Integer)this.cmf.getAttribute((ObjectName)((Object)iterator), "Port");
                                connectorAddress = new HttpConnectorAddress(string, n);
                                responsePDU.addObjectList((ObjectName)((Object)iterator), connectorAddress);
                            }
                            catch (Exception exception) {
                                if (!this.isDebugOn()) continue;
                                this.debug("formatPdu ", exception);
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (!this.isTraceOn()) break block39;
                        this.trace("formatPdu ", "Unable to get Mbean for " + iterator3);
                        this.trace("formatPdu ", exception);
                    }
                }
                iterator2 = "com.sun.jdmk.comm.HtmlAdaptorServer";
                try {
                    set = this.cmf.queryNames(objectName, Query.match(Query.classattr(), Query.value((String)((Object)iterator2))));
                    if (this.isTraceOn()) {
                        iterator = set.iterator();
                        while (iterator.hasNext()) {
                            ObjectName objectName2 = (ObjectName)iterator.next();
                            this.trace("formatPdu ", "Add\t'" + objectName2 + "' in response msg");
                        }
                    }
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        ObjectName objectName3 = (ObjectName)iterator.next();
                        try {
                            responsePDU.addObjectList(objectName3, null);
                        }
                        catch (Exception exception) {
                            if (!this.isDebugOn()) continue;
                            this.debug("formatPdu ", exception);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!this.isTraceOn()) break block40;
                    this.trace("formatPdu ", "Unable to get Mbean for " + iterator2);
                    this.trace("formatPdu ", exception);
                }
            }
            iterator = "com.sun.jdmk.comm.SnmpAdaptorServer";
            try {
                set = this.cmf.queryNames(objectName, Query.match(Query.classattr(), Query.value((String)((Object)iterator))));
                if (this.isTraceOn()) {
                    Iterator iterator4 = set.iterator();
                    while (iterator4.hasNext()) {
                        ObjectName objectName4 = (ObjectName)iterator4.next();
                        this.trace("formatPdu ", "Add\t'" + objectName4 + "' in response msg");
                    }
                }
                Iterator iterator5 = set.iterator();
                while (iterator5.hasNext()) {
                    ObjectName objectName5 = (ObjectName)iterator5.next();
                    try {
                        responsePDU.addObjectList(objectName5, null);
                    }
                    catch (Exception exception) {
                        if (!this.isDebugOn()) continue;
                        this.debug("formatPdu ", exception);
                    }
                }
            }
            catch (Exception exception) {
                if (!this.isTraceOn()) break block41;
                this.trace("formatPdu ", "Unable to get Mbean for " + iterator);
                this.trace("formatPdu ", exception);
            }
        }
    }

    public void noEvent() {
        this.sendEvent = false;
    }

    private void processMsg(DiscoveryPDU discoveryPDU) throws IOException {
        int n;
        InetAddress inetAddress;
        if (discoveryPDU == null) {
            if (this.isTraceOn()) {
                this.trace("processMsg ", "received null pdu");
            }
            return;
        }
        if (this.isTraceOn()) {
            this.trace("processMsg ", "received pdu '" + discoveryPDU.printState() + "'");
        }
        if (discoveryPDU.getHost() != null) {
            if (this.localHostName.compareTo(discoveryPDU.getHost()) != 0) {
                if (this.isTraceOn()) {
                    this.trace("processMsg", "local host ('" + this.localHostName + "') is not '" + discoveryPDU.getHost() + "' - No answer is required ");
                }
                return;
            }
            if (this.isTraceOn()) {
                this.trace("processMsg", " Request is for this host ('" + this.localHostName + "')");
            }
        } else if (this.isTraceOn()) {
            this.trace("processMsg", " Request is for all host ");
        }
        if (this.isTraceOn()) {
            this.trace("processMsg ", "Format response PDU");
        }
        ResponsePDU responsePDU = new ResponsePDU(this.mbeanServerName, this.SpecificationName, this.SpecificationVendor, this.SpecificationVersion, this.ImplementationName, this.ImplementationVendor, this.ImplementationVersion);
        this.formatPdu(responsePDU, discoveryPDU, false);
        if (this.isTraceOn()) {
            this.trace("processMsg ", "Check point to point response");
        }
        if (discoveryPDU.getReturnAddr()) {
            if (this.isTraceOn()) {
                this.trace("processMsg ", "Point to point response using  Port " + discoveryPDU.getReturnPort() + " on Host " + discoveryPDU.getReturnHost());
            }
            inetAddress = discoveryPDU.getReturnHost();
            n = discoveryPDU.getReturnPort();
        } else {
            if (this.isTraceOn()) {
                this.trace("processMsg", "Use multicast socket for response");
            }
            inetAddress = this.multicastGroup;
            n = this.multicastPort;
        }
        try {
            this.setTimeToLive(responsePDU.getTimeToLive());
            this.sendMsg(responsePDU, inetAddress, n);
        }
        catch (IOException iOException) {
            if (this.isTraceOn()) {
                this.trace("processMsg ", "Unable to send response !");
            }
            throw iOException;
        }
    }

    public void run() {
        block19: {
            if (!this.spy && this.sendEvent) {
                this.sendEvent(0);
            }
            while (!this.stopRequested) {
                try {
                    if (this.isTraceOn()) {
                        this.trace("run ", " -------------------- Start Waiting -------------------- ");
                    }
                    if (this.spy) {
                        DiscoveryMsg discoveryMsg = this.receiveMsg(this);
                        if (!this.isTraceOn()) continue;
                        this.trace("run ", "(SPY) receive : " + discoveryMsg.printState());
                        continue;
                    }
                    DiscoveryPDU discoveryPDU = (DiscoveryPDU)this.receiveMsg(this);
                    this.processMsg(discoveryPDU);
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (this.isTraceOn()) {
                        this.trace("run ", "Stop execution ");
                    }
                    this.stopRequested = true;
                }
                catch (IOException iOException) {
                    if (this.isTraceOn()) {
                        this.trace("run ", "Not a discovering msg - continue - ");
                    }
                    if (!this.spy || !this.isDebugOn()) continue;
                    this.debug("run ", iOException);
                }
                catch (ClassCastException classCastException) {
                    if (this.isTraceOn()) {
                        this.trace("run ", "Not a discovering msg - continue - ");
                    }
                    if (!this.spy || !this.isDebugOn()) continue;
                    this.debug("run ", classCastException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (this.isTraceOn()) {
                        this.trace("run ", "Not a discovering msg - continue - ");
                    }
                    if (!this.spy || !this.isDebugOn()) continue;
                    this.debug("run ", classNotFoundException);
                }
            }
            if (this.sendEvent) {
                this.sendEvent(1);
            }
            if (this.isTraceOn()) {
                this.trace("run ", "Call leave group");
            }
            try {
                this.disconnectFromGroup();
            }
            catch (IOException iOException) {
                if (this.isDebugOn()) {
                    this.debug("start ", iOException);
                }
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block19;
                this.debug("start ", exception);
            }
        }
        this.close();
    }

    private void sendEvent(int n) {
        block3: {
            if (this.isTraceOn()) {
                this.trace("sendEvent ", "Format Event PDU");
            }
            ResponsePDU responsePDU = new ResponsePDU(this.mbeanServerName, this.SpecificationName, this.SpecificationVendor, this.SpecificationVersion, this.ImplementationName, this.ImplementationVendor, this.ImplementationVersion);
            this.formatPdu(responsePDU, null, true);
            responsePDU.setAgentState(n);
            try {
                this.sendMsg(responsePDU, this.multicastGroup, this.multicastPort);
            }
            catch (IOException iOException) {
                if (!this.isTraceOn()) break block3;
                this.trace("sendEvent ", "Unable to send event !");
                this.trace("sendEvent ", iOException);
            }
        }
    }
}

