/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.SnmpAdaptorServerMBean;
import com.sun.jdmk.comm.SnmpMibTree;
import com.sun.jdmk.comm.SnmpRequestHandler;
import com.sun.jdmk.snmp.IPAcl.IPAcl;
import com.sun.jdmk.snmp.IPAcl.JdmkAcl;
import com.sun.jdmk.snmp.SnmpPduFactoryBER;
import com.sun.jdmk.snmp.agent.SnmpMibAgent;
import com.sun.jdmk.snmp.agent.SnmpMibHandler;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.snmp.SnmpDefinitions;
import javax.management.snmp.SnmpIpAddress;
import javax.management.snmp.SnmpMessage;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.SnmpPduPacket;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.SnmpPduTrap;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpTimeticks;
import javax.management.snmp.SnmpTooBigException;
import javax.management.snmp.SnmpVarBind;

public class SnmpAdaptorServer
extends CommunicatorServer
implements SnmpAdaptorServerMBean,
MBeanRegistration,
SnmpDefinitions,
SnmpMibHandler {
    private int trapPort;
    private InetAddress address;
    private Object ipacl;
    private SnmpPduFactory pduFactory;
    private boolean authRespEnabled;
    private boolean authTrapEnabled;
    private SnmpOid enterpriseOid;
    private int bufferSize;
    private transient long startUpTime;
    private transient DatagramSocket socket;
    private transient DatagramSocket trapSocket;
    private transient DatagramPacket packet;
    private transient Vector mibs;
    private transient SnmpMibTree root;
    private transient boolean useAcl;
    private int snmpOutTraps;
    private int snmpOutGetResponses;
    private int snmpOutGenErrs;
    private int snmpOutBadValues;
    private int snmpOutNoSuchNames;
    private int snmpOutTooBigs;
    private int snmpOutPkts;
    private int snmpInASNParseErrs;
    private int snmpInBadCommunityUses;
    private int snmpInBadCommunityNames;
    private int snmpInBadVersions;
    private int snmpInGetRequests;
    private int snmpInGetNexts;
    private int snmpInSetRequests;
    private int snmpInPkts;
    private int snmpInTotalReqVars;
    private int snmpInTotalSetVars;
    private static final String InterruptSysCallMsg = "Interrupted system call";
    private static final SnmpOid sysUpTimeOid = new SnmpOid("1.3.6.1.2.1.1.3.0");
    private static final SnmpOid snmpTrapOidOid = new SnmpOid("1.3.6.1.6.3.1.1.4.1.0");

    public SnmpAdaptorServer() {
        this(null, 161, null);
    }

    public SnmpAdaptorServer(int n) {
        this(null, n, null);
    }

    public SnmpAdaptorServer(int n, InetAddress inetAddress) {
        this(null, n, inetAddress);
    }

    public SnmpAdaptorServer(IPAcl iPAcl) {
        this(iPAcl, 161, null);
    }

    public SnmpAdaptorServer(IPAcl iPAcl, int n) {
        this(iPAcl, n, null);
    }

    public SnmpAdaptorServer(IPAcl iPAcl, int n, InetAddress inetAddress) {
        block3: {
            super(4);
            this.trapPort = 162;
            this.address = null;
            this.ipacl = null;
            this.pduFactory = null;
            this.authRespEnabled = true;
            this.authTrapEnabled = true;
            this.enterpriseOid = new SnmpOid("1.3.6.1.4.1.42");
            this.bufferSize = 1024;
            this.startUpTime = 0L;
            this.socket = null;
            this.trapSocket = null;
            this.packet = null;
            this.mibs = new Vector();
            this.useAcl = true;
            this.snmpOutTraps = 0;
            this.snmpOutGetResponses = 0;
            this.snmpOutGenErrs = 0;
            this.snmpOutBadValues = 0;
            this.snmpOutNoSuchNames = 0;
            this.snmpOutTooBigs = 0;
            this.snmpOutPkts = 0;
            this.snmpInASNParseErrs = 0;
            this.snmpInBadCommunityUses = 0;
            this.snmpInBadCommunityNames = 0;
            this.snmpInBadVersions = 0;
            this.snmpInGetRequests = 0;
            this.snmpInGetNexts = 0;
            this.snmpInSetRequests = 0;
            this.snmpInPkts = 0;
            this.snmpInTotalReqVars = 0;
            this.snmpInTotalSetVars = 0;
            if (iPAcl == null) {
                try {
                    iPAcl = new JdmkAcl("SNMP protocol adaptor IP ACL");
                }
                catch (UnknownHostException unknownHostException) {
                    if (!this.isDebugOn()) break block3;
                    this.debug("constructor", "UnknowHostException when creating ACL");
                    this.debug("constructor", unknownHostException);
                }
            }
        }
        this.init(iPAcl, n, inetAddress);
    }

    public SnmpAdaptorServer(IPAcl iPAcl, InetAddress inetAddress) {
        this(iPAcl, 161, inetAddress);
    }

    public SnmpAdaptorServer(InetAddress inetAddress) {
        this(null, 161, inetAddress);
    }

    public SnmpAdaptorServer(boolean bl, int n, InetAddress inetAddress) {
        JdmkAcl jdmkAcl;
        block3: {
            super(4);
            this.trapPort = 162;
            this.address = null;
            this.ipacl = null;
            this.pduFactory = null;
            this.authRespEnabled = true;
            this.authTrapEnabled = true;
            this.enterpriseOid = new SnmpOid("1.3.6.1.4.1.42");
            this.bufferSize = 1024;
            this.startUpTime = 0L;
            this.socket = null;
            this.trapSocket = null;
            this.packet = null;
            this.mibs = new Vector();
            this.useAcl = true;
            this.snmpOutTraps = 0;
            this.snmpOutGetResponses = 0;
            this.snmpOutGenErrs = 0;
            this.snmpOutBadValues = 0;
            this.snmpOutNoSuchNames = 0;
            this.snmpOutTooBigs = 0;
            this.snmpOutPkts = 0;
            this.snmpInASNParseErrs = 0;
            this.snmpInBadCommunityUses = 0;
            this.snmpInBadCommunityNames = 0;
            this.snmpInBadVersions = 0;
            this.snmpInGetRequests = 0;
            this.snmpInGetNexts = 0;
            this.snmpInSetRequests = 0;
            this.snmpInPkts = 0;
            this.snmpInTotalReqVars = 0;
            this.snmpInTotalSetVars = 0;
            this.useAcl = bl;
            jdmkAcl = null;
            if (bl) {
                try {
                    jdmkAcl = new JdmkAcl("SNMP protocol adaptor IP ACL");
                }
                catch (UnknownHostException unknownHostException) {
                    if (!this.isDebugOn()) break block3;
                    this.debug("constructor", "UnknowHostException when creating ACL");
                    this.debug("constructor", unknownHostException);
                }
            }
        }
        this.init(jdmkAcl, n, inetAddress);
    }

    public SnmpMibHandler addMib(SnmpMibAgent snmpMibAgent) throws IllegalArgumentException {
        if (snmpMibAgent == null) {
            throw new IllegalArgumentException();
        }
        this.mibs.addElement(snmpMibAgent);
        this.root.register(snmpMibAgent);
        this.root.setDefaultAgent(snmpMibAgent);
        return this;
    }

    private synchronized void closeTrapSocketIfNeeded() {
        if (this.trapSocket != null && this.state != 0) {
            this.trapSocket.close();
            this.trapSocket = null;
        }
    }

    protected void doBind() throws CommunicationException, InterruptedException {
        try {
            this.socket = new DatagramSocket(this.port, this.address);
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            if (this.isDebugOn()) {
                this.debug("doBind", "cannot bind on port " + this.port);
            }
            throw new CommunicationException(socketException);
        }
    }

    protected void doError(Exception exception) throws CommunicationException {
    }

    protected void doProcess() throws CommunicationException, InterruptedException {
    }

    protected void doReceive() throws CommunicationException, InterruptedException {
        try {
            this.packet = new DatagramPacket(new byte[this.bufferSize], this.bufferSize);
            this.socket.receive(this.packet);
            new SnmpRequestHandler(this, this.servedClientCount, this.socket, this.packet, this.root, this.mibs, this.ipacl, this.pduFactory, this.mbs, this.objectName);
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException(socketException);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.toString());
        }
        catch (CommunicationException communicationException) {
            throw communicationException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
        if (this.isTraceOn()) {
            this.trace("doReceive", "received a message");
        }
    }

    protected void doUnbind() throws CommunicationException, InterruptedException {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        this.closeTrapSocketIfNeeded();
    }

    protected void finalize() {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    public int getActiveClientCount() {
        return super.getActiveClientCount();
    }

    public boolean getAuthRespEnabled() {
        return this.authRespEnabled;
    }

    public boolean getAuthTrapEnabled() {
        return this.authTrapEnabled;
    }

    public Integer getBufferSize() {
        return new Integer(this.bufferSize);
    }

    public String getEnterpriseOid() {
        return this.enterpriseOid.toString();
    }

    public IPAcl getIPAcl() {
        return (IPAcl)this.ipacl;
    }

    public int getMaxActiveClientCount() {
        return super.getMaxActiveClientCount();
    }

    public String[] getMibs() {
        String[] stringArray = new String[this.mibs.size()];
        int n = 0;
        Enumeration enumeration = this.mibs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpMibAgent snmpMibAgent = (SnmpMibAgent)enumeration.nextElement();
            stringArray[n++] = snmpMibAgent.getMibName();
        }
        return stringArray;
    }

    public String getProtocol() {
        return "snmp";
    }

    public int getServedClientCount() {
        return super.getServedClientCount();
    }

    public Long getSnmpInASNParseErrs() {
        return new Long(this.snmpInASNParseErrs);
    }

    public Long getSnmpInBadCommunityNames() {
        return new Long(this.snmpInBadCommunityNames);
    }

    public Long getSnmpInBadCommunityUses() {
        return new Long(this.snmpInBadCommunityUses);
    }

    public Long getSnmpInBadVersions() {
        return new Long(this.snmpInBadVersions);
    }

    public Long getSnmpInGetNexts() {
        return new Long(this.snmpInGetNexts);
    }

    public Long getSnmpInGetRequests() {
        return new Long(this.snmpInGetRequests);
    }

    public Long getSnmpInPkts() {
        return new Long(this.snmpInPkts);
    }

    public Long getSnmpInSetRequests() {
        return new Long(this.snmpInSetRequests);
    }

    public Long getSnmpInTotalReqVars() {
        return new Long(this.snmpInTotalReqVars);
    }

    public Long getSnmpInTotalSetVars() {
        return new Long(this.snmpInTotalSetVars);
    }

    public Long getSnmpOutBadValues() {
        return new Long(this.snmpOutBadValues);
    }

    public Long getSnmpOutGenErrs() {
        return new Long(this.snmpOutGenErrs);
    }

    public Long getSnmpOutGetResponses() {
        return new Long(this.snmpOutGetResponses);
    }

    public Long getSnmpOutNoSuchNames() {
        return new Long(this.snmpOutNoSuchNames);
    }

    public Long getSnmpOutPkts() {
        return new Long(this.snmpOutPkts);
    }

    public Long getSnmpOutTooBigs() {
        return new Long(this.snmpOutTooBigs);
    }

    public Long getSnmpOutTraps() {
        return new Long(this.snmpOutTraps);
    }

    private long getSysUpTime() {
        return (System.currentTimeMillis() - this.startUpTime) / 10L;
    }

    public Integer getTrapPort() {
        return new Integer(this.trapPort);
    }

    void incSnmpInASNParseErrs(int n) {
        this.snmpInASNParseErrs += n;
    }

    void incSnmpInBadCommunityNames(int n) {
        this.snmpInBadCommunityNames += n;
    }

    void incSnmpInBadCommunityUses(int n) {
        this.snmpInBadCommunityUses += n;
    }

    void incSnmpInBadVersions(int n) {
        this.snmpInBadVersions += n;
    }

    private void init(Object object, int n, InetAddress inetAddress) {
        this.root = new SnmpMibTree();
        this.startUpTime = System.currentTimeMillis();
        this.maxActiveClientCount = 10;
        this.pduFactory = new SnmpPduFactoryBER();
        this.port = n;
        this.ipacl = object;
        this.address = inetAddress;
        if (this.ipacl == null && this.useAcl) {
            throw new IllegalArgumentException("ACL object cannot be null");
        }
    }

    String makeDebugTag() {
        return "SnmpAdaptorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    private synchronized void openTrapSocketIfNeeded() throws SocketException {
        if (this.trapSocket == null) {
            this.trapSocket = new DatagramSocket();
            if (this.isTraceOn()) {
                this.trace("openTrapSocketIfNeeded", "using port " + this.trapSocket.getLocalPort() + " to send traps");
            }
        }
    }

    public void postDeregister() {
        super.postDeregister();
    }

    public void postRegister(Boolean bl) {
        super.postRegister(bl);
    }

    public void preDeregister() throws Exception {
        super.preDeregister();
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (objectName == null) {
            objectName = new ObjectName(String.valueOf(mBeanServer.getDefaultDomain()) + ":" + "name=SnmpAdaptorServer");
        }
        return super.preRegister(mBeanServer, objectName);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.mibs = new Vector();
    }

    public boolean removeMib(SnmpMibAgent snmpMibAgent) {
        this.root.unregister(snmpMibAgent);
        return this.mibs.removeElement(snmpMibAgent);
    }

    private void sendTrapMessage(SnmpMessage snmpMessage) throws IOException, SnmpTooBigException {
        byte[] byArray = new byte[this.bufferSize];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        int n = snmpMessage.encodeMessage(byArray);
        datagramPacket.setLength(n);
        datagramPacket.setAddress(snmpMessage.address);
        datagramPacket.setPort(snmpMessage.port);
        if (this.isTraceOn()) {
            this.trace("sendTrapMessage", "sending trap to " + snmpMessage.address + ":" + snmpMessage.port);
        }
        this.trapSocket.send(datagramPacket);
        if (this.isTraceOn()) {
            this.trace("sendTrapMessage", "sent to " + snmpMessage.address + ":" + snmpMessage.port);
        }
        ++this.snmpOutTraps;
        ++this.snmpOutPkts;
    }

    private void sendTrapPdu(InetAddress inetAddress, String string, SnmpPduPacket snmpPduPacket) throws SnmpStatusException, IOException {
        block7: {
            SnmpMessage snmpMessage = null;
            try {
                snmpMessage = this.pduFactory.encodePdu(snmpPduPacket, this.bufferSize);
                if (snmpMessage == null) {
                    throw new SnmpStatusException(16);
                }
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.isDebugOn()) {
                    this.debug("sendTrapPdu", "trap pdu is too big");
                    this.debug("sendTrapPdu", "trap hasn't been sent to the specified host");
                }
                throw new SnmpStatusException(1);
            }
            this.openTrapSocketIfNeeded();
            if (inetAddress != null) {
                snmpMessage.address = inetAddress;
                snmpMessage.community = string.getBytes();
                try {
                    this.sendTrapMessage(snmpMessage);
                }
                catch (SnmpTooBigException snmpTooBigException) {
                    if (!this.isDebugOn()) break block7;
                    this.debug("sendTrapPdu", "trap pdu is too big");
                    this.debug("sendTrapPdu", "trap hasn't been sent to " + snmpMessage.address);
                }
            }
        }
        this.closeTrapSocketIfNeeded();
    }

    private void sendTrapPdu(SnmpPduPacket snmpPduPacket) throws SnmpStatusException, IOException {
        block14: {
            SnmpMessage snmpMessage = null;
            try {
                snmpMessage = this.pduFactory.encodePdu(snmpPduPacket, this.bufferSize);
                if (snmpMessage == null) {
                    throw new SnmpStatusException(16);
                }
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.isDebugOn()) {
                    this.debug("sendTrapPdu", "trap pdu is too big");
                    this.debug("sendTrapPdu", "trap hasn't been sent to anyone");
                }
                throw new SnmpStatusException(1);
            }
            int n = 0;
            this.openTrapSocketIfNeeded();
            if (this.ipacl != null) {
                Enumeration enumeration = ((IPAcl)this.ipacl).getTrapDestinations();
                while (enumeration.hasMoreElements()) {
                    snmpMessage.address = (InetAddress)enumeration.nextElement();
                    Enumeration enumeration2 = ((IPAcl)this.ipacl).getTrapCommunities(snmpMessage.address);
                    while (enumeration2.hasMoreElements()) {
                        snmpMessage.community = ((String)enumeration2.nextElement()).getBytes();
                        try {
                            this.sendTrapMessage(snmpMessage);
                            ++n;
                        }
                        catch (SnmpTooBigException snmpTooBigException) {
                            if (!this.isDebugOn()) continue;
                            this.debug("sendTrapPdu", "trap pdu is too big");
                            this.debug("sendTrapPdu", "trap hasn't been sent to " + snmpMessage.address);
                        }
                    }
                }
            }
            if (n == 0) {
                try {
                    snmpMessage.address = InetAddress.getLocalHost();
                    this.sendTrapMessage(snmpMessage);
                }
                catch (SnmpTooBigException snmpTooBigException) {
                    if (this.isDebugOn()) {
                        this.debug("sendTrapPdu", "trap pdu is too big");
                        this.debug("sendTrapPdu", "trap hasn't been sent");
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    if (!this.isDebugOn()) break block14;
                    this.debug("sendTrapPdu", "cannot get the local host");
                    this.debug("sendTrapPdu", "trap hasn't been sent");
                }
            }
        }
        this.closeTrapSocketIfNeeded();
    }

    public void sendV1Trap(int n, int n2, Vector vector) throws IOException, SnmpStatusException {
        if (this.isTraceOn()) {
            this.trace("sendV1Trap", "generic=" + n + ", specific=" + n2);
        }
        SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
        snmpPduTrap.address = null;
        snmpPduTrap.port = this.trapPort;
        snmpPduTrap.type = 164;
        snmpPduTrap.version = 0;
        snmpPduTrap.community = null;
        snmpPduTrap.enterprise = this.enterpriseOid;
        snmpPduTrap.genericTrap = n;
        snmpPduTrap.specificTrap = n2;
        snmpPduTrap.timeStamp = this.getSysUpTime();
        if (vector != null) {
            snmpPduTrap.varBindList = new SnmpVarBind[vector.size()];
            vector.copyInto(snmpPduTrap.varBindList);
        } else {
            snmpPduTrap.varBindList = null;
        }
        try {
            snmpPduTrap.agentAddr = new SnmpIpAddress(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            snmpPduTrap.agentAddr = new SnmpIpAddress("0.0.0.0");
        }
        this.sendTrapPdu(snmpPduTrap);
    }

    public void sendV1Trap(InetAddress inetAddress, String string, int n, int n2, Vector vector) throws IOException, SnmpStatusException {
        if (this.isTraceOn()) {
            this.trace("sendV1Trap", "generic=" + n + ", specific=" + n2);
        }
        SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
        snmpPduTrap.address = null;
        snmpPduTrap.port = this.trapPort;
        snmpPduTrap.type = 164;
        snmpPduTrap.version = 0;
        snmpPduTrap.community = null;
        snmpPduTrap.enterprise = this.enterpriseOid;
        snmpPduTrap.genericTrap = n;
        snmpPduTrap.specificTrap = n2;
        snmpPduTrap.timeStamp = this.getSysUpTime();
        if (vector != null) {
            snmpPduTrap.varBindList = new SnmpVarBind[vector.size()];
            vector.copyInto(snmpPduTrap.varBindList);
        } else {
            snmpPduTrap.varBindList = null;
        }
        try {
            snmpPduTrap.agentAddr = new SnmpIpAddress(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            snmpPduTrap.agentAddr = new SnmpIpAddress("0.0.0.0");
        }
        this.sendTrapPdu(inetAddress, string, snmpPduTrap);
    }

    public void sendV2Trap(InetAddress inetAddress, String string, SnmpOid snmpOid, Vector vector) throws IOException, SnmpStatusException {
        if (this.isTraceOn()) {
            this.trace("sendV2Trap", "trapOid=" + snmpOid);
        }
        SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
        snmpPduRequest.address = null;
        snmpPduRequest.port = this.trapPort;
        snmpPduRequest.type = 167;
        snmpPduRequest.version = 1;
        snmpPduRequest.community = null;
        Vector<SnmpVarBind> vector2 = vector != null ? (Vector<SnmpVarBind>)vector.clone() : new Vector<SnmpVarBind>(2);
        SnmpTimeticks snmpTimeticks = new SnmpTimeticks(this.getSysUpTime());
        vector2.insertElementAt(new SnmpVarBind(snmpTrapOidOid, snmpOid), 0);
        vector2.insertElementAt(new SnmpVarBind(sysUpTimeOid, snmpTimeticks), 0);
        snmpPduRequest.varBindList = new SnmpVarBind[vector2.size()];
        vector2.copyInto(snmpPduRequest.varBindList);
        this.sendTrapPdu(inetAddress, string, snmpPduRequest);
    }

    public void sendV2Trap(SnmpOid snmpOid, Vector vector) throws IOException, SnmpStatusException {
        if (this.isTraceOn()) {
            this.trace("sendV2Trap", "trapOid=" + snmpOid);
        }
        SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
        snmpPduRequest.address = null;
        snmpPduRequest.port = this.trapPort;
        snmpPduRequest.type = 167;
        snmpPduRequest.version = 1;
        snmpPduRequest.community = null;
        Vector<SnmpVarBind> vector2 = vector != null ? (Vector<SnmpVarBind>)vector.clone() : new Vector<SnmpVarBind>(2);
        SnmpTimeticks snmpTimeticks = new SnmpTimeticks(this.getSysUpTime());
        vector2.insertElementAt(new SnmpVarBind(snmpTrapOidOid, snmpOid), 0);
        vector2.insertElementAt(new SnmpVarBind(sysUpTimeOid, snmpTimeticks), 0);
        snmpPduRequest.varBindList = new SnmpVarBind[vector2.size()];
        vector2.copyInto(snmpPduRequest.varBindList);
        this.sendTrapPdu(snmpPduRequest);
    }

    public void setAuthRespEnabled(boolean bl) {
        this.authRespEnabled = bl;
    }

    public void setAuthTrapEnabled(boolean bl) {
        this.authTrapEnabled = bl;
    }

    public void setBufferSize(Integer n) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.bufferSize = n;
    }

    public void setEnterpriseOid(String string) throws IllegalArgumentException {
        this.enterpriseOid = new SnmpOid(string);
    }

    public void setMaxActiveClientCount(int n) throws IllegalStateException {
        super.setMaxActiveClientCount(n);
    }

    public void setTrapPort(Integer n) {
        int n2 = n;
        if (n2 < 0) {
            throw new IllegalArgumentException("Trap port cannot be a negative value");
        }
        this.trapPort = n2;
    }

    public void stop() {
        block4: {
            if (this.isTraceOn()) {
                this.trace("stop", "Stopping: using port " + this.port);
            }
            if (!this.isActive()) break block4;
            super.stop();
            try {
                DatagramSocket datagramSocket = new DatagramSocket(0);
                byte[] byArray = new byte[1];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, 1, InetAddress.getLocalHost(), this.port);
                if (this.isTraceOn()) {
                    this.trace("stop", "Sending: using port " + this.port);
                }
                datagramSocket.send(datagramPacket);
                datagramSocket.close();
            }
            catch (Throwable throwable) {
                if (!this.isDebugOn()) break block4;
                this.debug("stop", throwable);
            }
        }
    }

    void updateErrorCounters(int n) {
        switch (n) {
            case 0: {
                ++this.snmpOutGetResponses;
                break;
            }
            case 5: {
                ++this.snmpOutGenErrs;
                break;
            }
            case 3: {
                ++this.snmpOutBadValues;
                break;
            }
            case 2: {
                ++this.snmpOutNoSuchNames;
                break;
            }
            case 1: {
                ++this.snmpOutTooBigs;
                break;
            }
        }
        ++this.snmpOutPkts;
    }

    void updateRequestCounters(int n) {
        switch (n) {
            case 160: {
                ++this.snmpInGetRequests;
                break;
            }
            case 161: {
                ++this.snmpInGetNexts;
                break;
            }
            case 163: {
                ++this.snmpInSetRequests;
                break;
            }
        }
        ++this.snmpInPkts;
    }

    void updateVarCounters(int n, int n2) {
        switch (n) {
            case 160: 
            case 161: 
            case 165: {
                this.snmpInTotalReqVars += n2;
                break;
            }
            case 163: {
                this.snmpInTotalSetVars += n2;
                break;
            }
        }
    }

    public void usePduFactory(SnmpPduFactory snmpPduFactory) {
        this.pduFactory = snmpPduFactory == null ? new SnmpPduFactoryBER() : snmpPduFactory;
    }
}

