/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.HttpBody;
import com.sun.jdmk.comm.HttpMessage;
import com.sun.jdmk.comm.MalformedHttpException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class HttpRequest
extends HttpMessage {
    public int method = 0;
    public String requestURI = null;
    public String authorization = null;
    public static final int METHOD_GET = 1;
    public static final int METHOD_POST = 2;
    static final String MALFORMED_REQUEST_LINE = "Malformed request line";
    static final String MALFORMED_HEADER_LINE = "Malformed header line";
    static final String UNSUPPORTED_METHOD = "Unsupported HTTP method";
    static final String PREFIX_AUTHORIZATION = "Authorization: ";

    public HttpRequest(HttpBody httpBody) {
        super(httpBody);
    }

    public String getURIPath() {
        return this.requestURI;
    }

    public void readFrom(InputStream inputStream) throws IOException, MalformedHttpException {
        this.method = 0;
        this.requestURI = null;
        this.httpVersion = null;
        this.authorization = null;
        this.date = null;
        this.connection = null;
        this.contentType = null;
        this.contentLength = 0;
        try {
            String string = HttpRequest.readLine(inputStream);
            while (string.length() == 0) {
                string = HttpRequest.readLine(inputStream);
            }
            int n = string.indexOf(32);
            int n2 = string.indexOf(32, n + 1);
            if (n == -1 || n2 == -1) {
                throw new MalformedHttpException(MALFORMED_REQUEST_LINE);
            }
            String string2 = string.substring(0, n);
            if (string2.equals("GET")) {
                this.method = 1;
            } else if (string2.equals("POST")) {
                this.method = 2;
            } else {
                throw new MalformedHttpException(UNSUPPORTED_METHOD);
            }
            this.requestURI = string.substring(n + 1, n2);
            this.httpVersion = string.substring(n2 + 1);
            if (this.requestURI.length() == 0 || this.httpVersion.length() == 0) {
                throw new MalformedHttpException(MALFORMED_REQUEST_LINE);
            }
            String string3 = HttpRequest.readLine(inputStream);
            while (string3.length() >= 1) {
                if (string3.toLowerCase().startsWith("Content-Length: ".toLowerCase())) {
                    this.contentLength = Integer.parseInt(string3.substring("Content-Length: ".length()));
                } else if (string3.toLowerCase().startsWith("Content-Type: ".toLowerCase())) {
                    this.contentType = string3.substring("Content-Type: ".length());
                } else if (string3.toLowerCase().startsWith(PREFIX_AUTHORIZATION.toLowerCase())) {
                    this.authorization = string3.substring(PREFIX_AUTHORIZATION.length());
                } else if (string3.toLowerCase().startsWith("Date: ".toLowerCase())) {
                    this.date = string3.substring("Date: ".length());
                } else if (string3.toLowerCase().startsWith("Connection: ".toLowerCase())) {
                    this.connection = string3.substring("Connection: ".length());
                }
                string3 = HttpRequest.readLine(inputStream);
            }
            if (this.contentLength >= 1) {
                this.body.readFrom(inputStream, this.contentLength);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedHttpException(numberFormatException.toString());
        }
    }

    static String readLine(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = inputStream.read();
        int n2 = inputStream.read();
        while (n2 != -1 && (n != 13 || n2 != 10)) {
            stringBuffer.append((char)n);
            n = n2;
            n2 = inputStream.read();
        }
        if (n2 == -1) {
            throw new EOFException();
        }
        return stringBuffer.toString();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.method == 1) {
            stringBuffer.append("GET");
        } else if (this.method == 2) {
            stringBuffer.append("POST");
        } else {
            throw new IllegalArgumentException("Unsupported method " + this.method);
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.requestURI);
        stringBuffer.append(' ');
        stringBuffer.append(this.httpVersion);
        stringBuffer.append("\r\n");
        this.contentLength = this.body.getByteCount();
        if (this.contentLength >= 1) {
            stringBuffer.append("Content-Length: ");
            stringBuffer.append(this.contentLength);
            stringBuffer.append("\r\n");
        }
        if (this.authorization != null) {
            stringBuffer.append(PREFIX_AUTHORIZATION);
            stringBuffer.append(this.authorization);
            stringBuffer.append("\r\n");
        }
        if (this.date != null) {
            stringBuffer.append("Date: ");
            stringBuffer.append(this.date);
            stringBuffer.append("\r\n");
        }
        if (this.connection != null) {
            stringBuffer.append("Connection: ");
            stringBuffer.append(this.connection);
            stringBuffer.append("\r\n");
        }
        if (this.contentType != null) {
            stringBuffer.append("Content-Type: ");
            stringBuffer.append(this.contentType);
            stringBuffer.append("\r\n");
        }
        stringBuffer.append("\r\n");
        outputStream.write(stringBuffer.toString().getBytes());
        if (this.contentLength >= 1) {
            this.body.writeTo(outputStream);
        }
    }
}

