/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.ServerNotificationDispatcher;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class HeartBeatServerHandler {
    private static String localClassName = "HeartBeatServerHandler";
    private MBeanServer mbs;
    private static String mbsId;
    private ServerNotificationDispatcher snd;
    private static long counter;
    private static String uniqueId;
    private Hashtable clients = new Hashtable();

    static {
        counter = 0L;
    }

    public HeartBeatServerHandler(MBeanServer mBeanServer, ServerNotificationDispatcher serverNotificationDispatcher) {
        if (this.isTraceOn()) {
            this.trace("Constructor", "Create HeartBeatServerHandler.");
        }
        this.mbs = mBeanServer;
        this.snd = serverNotificationDispatcher;
        try {
            mbsId = (String)mBeanServer.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
        }
        catch (Exception exception) {
            mbsId = "unknown";
        }
    }

    public void cleanup(String string) {
        HBClientInfo hBClientInfo = (HBClientInfo)this.clients.get(string);
        if (hBClientInfo != null) {
            Long l = hBClientInfo.getNotifSessionId();
            if (l != null) {
                this.snd.remoteTerminate(l);
            }
            this.clients.remove(hBClientInfo);
        }
    }

    private void debug(String string, Exception exception) {
        Trace.send(2, 8192, localClassName, string, exception);
    }

    private void debug(String string, String string2) {
        Trace.send(2, 8192, localClassName, string, string2);
    }

    private void debug(String string, String string2, Exception exception) {
        Trace.send(2, 8192, string, string2, exception);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 8192, string, string2, string3);
    }

    private static String getSessionId() {
        if (counter == Long.MAX_VALUE) {
            counter = 0L;
        }
        String string = String.valueOf(counter) + "_" + mbsId;
        ++counter;
        return string;
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 8192);
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 8192);
    }

    public String pingHeartBeatServer(String string, int n, int n2, Long l) {
        HBClientInfo hBClientInfo;
        if (string == null) {
            String string2 = HeartBeatServerHandler.getSessionId();
            if (this.isTraceOn()) {
                this.trace("HeartBeatServerHandler", "pingHeartBeatServer", "Ping received from new client: SessionId = " + string2);
            }
            HBClientInfo hBClientInfo2 = new HBClientInfo(string2, n, n2, l);
            this.clients.put(string2, hBClientInfo2);
            if (n <= 0) {
                hBClientInfo2.stopWaitPing(n);
            } else {
                hBClientInfo2.startWaitPing();
            }
            return string2;
        }
        if (this.isTraceOn()) {
            this.trace("HeartBeatServerHandler", "pingHeartBeatServer", "Ping received from existing client: SessionId = " + string);
        }
        if ((hBClientInfo = (HBClientInfo)this.clients.get(string)) != null) {
            hBClientInfo.setPeriod(n);
            hBClientInfo.setNRetries(n2);
            hBClientInfo.setNotifSessionId(l);
            if (n <= 0) {
                hBClientInfo.stopWaitPing(n);
            } else {
                hBClientInfo.startWaitPing();
            }
            return string;
        }
        return null;
    }

    private void trace(String string, Exception exception) {
        Trace.send(1, 8192, localClassName, string, exception);
    }

    private void trace(String string, String string2) {
        Trace.send(1, 8192, localClassName, string, string2);
    }

    private void trace(String string, String string2, Exception exception) {
        Trace.send(1, 8192, string, string2, exception);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 8192, string, string2, string3);
    }

    private class HBClientInfo {
        private String hbSessionId;
        private int period;
        private int nretries;
        private Long notifSessionId;
        private long timeout;
        private long newThreadEndTime;
        private WaitPing threadWaitPing;

        public HBClientInfo(String string, int n, int n2, Long l) {
            this.hbSessionId = string;
            this.period = n;
            this.nretries = n2;
            this.notifSessionId = l;
        }

        public void cleanupHBClientInfo() {
            HeartBeatServerHandler.this.cleanup(this.hbSessionId);
        }

        public int getNRetries() {
            return this.nretries;
        }

        public Long getNotifSessionId() {
            return this.notifSessionId;
        }

        public int getPeriod() {
            return this.period;
        }

        public void setNRetries(int n) {
            this.nretries = n;
        }

        public void setNotifSessionId(Long l) {
            this.notifSessionId = l;
        }

        public void setPeriod(int n) {
            this.period = n;
        }

        public synchronized void startWaitPing() {
            this.timeout = this.nretries == 0 ? (long)((double)this.period + (double)this.period * 0.2) : (long)((double)(this.period * this.nretries) + (double)(this.period * this.nretries) * 0.2);
            this.newThreadEndTime = System.currentTimeMillis() + this.timeout;
            if (this.threadWaitPing == null || !this.threadWaitPing.isAlive()) {
                this.threadWaitPing = new WaitPing();
                this.threadWaitPing.start();
            }
        }

        public synchronized void stopWaitPing(int n) {
            if (this.threadWaitPing != null) {
                this.threadWaitPing.terminate(n);
                this.threadWaitPing.interrupt();
                this.threadWaitPing = null;
            }
        }

        private class WaitPing
        extends Thread {
            private long actualThreadEndTime = 0L;
            private boolean toBeTerminated = false;

            WaitPing() {
            }

            public void run() {
                while (!this.toBeTerminated && HBClientInfo.this.timeout > 0L) {
                    try {
                        Thread.sleep(HBClientInfo.this.timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        if (this.toBeTerminated) break;
                    }
                    this.actualThreadEndTime = System.currentTimeMillis();
                    if (this.actualThreadEndTime <= HBClientInfo.this.newThreadEndTime || this.toBeTerminated) continue;
                    this.toBeTerminated = true;
                    if (HeartBeatServerHandler.this.isTraceOn()) {
                        HeartBeatServerHandler.this.trace("WaitPing", "run", "Cleaning up: Client with SessionId = " + HBClientInfo.this.hbSessionId + " died.");
                    }
                    HBClientInfo.this.cleanupHBClientInfo();
                }
            }

            public void terminate(int n) {
                this.toBeTerminated = true;
                if (n == -1) {
                    if (HeartBeatServerHandler.this.isTraceOn()) {
                        HeartBeatServerHandler.this.trace("WaitPing", "terminate", "Cleaning up: Client with SessionId = " + HBClientInfo.this.hbSessionId + " disconnected.");
                    }
                    HBClientInfo.this.cleanupHBClientInfo();
                } else if (HeartBeatServerHandler.this.isTraceOn()) {
                    HeartBeatServerHandler.this.trace("WaitPing", "terminate", "Ping stopped for client with SessionId = " + HBClientInfo.this.hbSessionId);
                }
            }
        }
    }
}

