/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp;

class BerEncoder {
    public static final int BooleanTag = 1;
    public static final int IntegerTag = 2;
    public static final int OctetStringTag = 4;
    public static final int NullTag = 5;
    public static final int OidTag = 6;
    public static final int SequenceTag = 48;
    protected byte[] bytes = null;
    protected int start = -1;
    protected int[] stackBuf = new int[200];
    protected int stackTop = 0;

    public BerEncoder(byte[] byArray) {
        this.bytes = byArray;
        this.start = byArray.length;
        this.stackTop = 0;
    }

    public void closeSequence() {
        this.closeSequence(48);
    }

    public void closeSequence(int n) {
        int n2 = this.stackBuf[--this.stackTop];
        this.putLength(n2 - this.start);
        this.putTag(n);
    }

    public void openSequence() {
        this.stackBuf[this.stackTop++] = this.start;
    }

    public void putAny(byte[] byArray) {
        this.putAny(byArray, byArray.length);
    }

    public void putAny(byte[] byArray, int n) {
        int n2 = n - 1;
        while (n2 >= 0) {
            this.bytes[--this.start] = byArray[n2];
            --n2;
        }
    }

    public void putInteger(int n) {
        this.putInteger(n, 2);
    }

    public void putInteger(int n, int n2) {
        this.putIntegerValue(n);
        this.putTag(n2);
    }

    public void putInteger(long l) {
        this.putInteger(l, 2);
    }

    public void putInteger(long l, int n) {
        this.putIntegerValue(l);
        this.putTag(n);
    }

    /*
     * Unable to fully structure code
     */
    protected void putIntegerValue(int var1_1) {
        block3: {
            var2_2 = this.start;
            var3_3 = 2139095040;
            var4_4 = 4;
            if (var1_1 >= 0) ** GOTO lbl12
            while ((var3_3 & var1_1) == var3_3 && var4_4 > 1) {
                var3_3 >>= 8;
                --var4_4;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var3_3 >>= 8;
                --var4_4;
lbl12:
                // 2 sources

                ** while ((var3_3 & var1_1) == 0 && var4_4 > 1)
            }
        }
        var5_5 = 0;
        while (var5_5 < var4_4) {
            this.bytes[--this.start] = (byte)var1_1;
            var1_1 >>= 8;
            ++var5_5;
        }
        this.putLength(var2_2 - this.start);
    }

    /*
     * Unable to fully structure code
     */
    protected void putIntegerValue(long var1_1) {
        block3: {
            var3_2 = this.start;
            var4_3 = 9187343239835811840L;
            var6_4 = 8;
            if (var1_1 >= 0L) ** GOTO lbl12
            while ((var4_3 & var1_1) == var4_3 && var6_4 > 1) {
                var4_3 >>= 8;
                --var6_4;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var4_3 >>= 8;
                --var6_4;
lbl12:
                // 2 sources

                ** while ((var4_3 & var1_1) == 0L && var6_4 > 1)
            }
        }
        var7_5 = 0;
        while (var7_5 < var6_4) {
            this.bytes[--this.start] = (byte)var1_1;
            var1_1 >>= 8;
            ++var7_5;
        }
        this.putLength(var3_2 - this.start);
    }

    protected void putLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n < 128) {
            this.bytes[--this.start] = (byte)n;
        } else if (n < 256) {
            this.bytes[--this.start] = (byte)n;
            this.bytes[--this.start] = -127;
        } else if (n < 65536) {
            this.bytes[--this.start] = (byte)n;
            this.bytes[--this.start] = (byte)(n >> 8);
            this.bytes[--this.start] = -126;
        } else if (n < 0xFFFFA6) {
            this.bytes[--this.start] = (byte)n;
            this.bytes[--this.start] = (byte)(n >> 8);
            this.bytes[--this.start] = (byte)(n >> 16);
            this.bytes[--this.start] = -125;
        } else {
            this.bytes[--this.start] = (byte)n;
            this.bytes[--this.start] = (byte)(n >> 8);
            this.bytes[--this.start] = (byte)(n >> 16);
            this.bytes[--this.start] = (byte)(n >> 24);
            this.bytes[--this.start] = -124;
        }
    }

    public void putNull() {
        this.putNull(5);
    }

    public void putNull(int n) {
        this.putLength(0);
        this.putTag(n);
    }

    public void putOctetString(byte[] byArray) {
        this.putOctetString(byArray, 4);
    }

    public void putOctetString(byte[] byArray, int n) {
        this.putStringValue(byArray);
        this.putTag(n);
    }

    public void putOid(long[] lArray) {
        this.putOid(lArray, 6);
    }

    public void putOid(long[] lArray, int n) {
        this.putOidValue(lArray);
        this.putTag(n);
    }

    protected void putOidValue(long[] lArray) {
        int n = this.start;
        if (lArray.length < 2 || lArray[0] > 2L || lArray[1] >= 40L) {
            throw new IllegalArgumentException();
        }
        int n2 = lArray.length - 1;
        while (n2 >= 2) {
            long l = lArray[n2];
            if (l < 0L) {
                throw new IllegalArgumentException();
            }
            if (l < 128L) {
                this.bytes[--this.start] = (byte)l;
            } else {
                this.bytes[--this.start] = (byte)(l & 0x7FL);
                l >>= 7;
                while (l != 0L) {
                    this.bytes[--this.start] = (byte)(l | 0x80L);
                    l >>= 7;
                }
            }
            --n2;
        }
        this.bytes[--this.start] = (byte)(lArray[0] * 40L + lArray[1]);
        this.putLength(n - this.start);
    }

    protected void putStringValue(byte[] byArray) {
        int n = byArray.length - 1;
        while (n >= 0) {
            this.bytes[--this.start] = byArray[n];
            --n;
        }
        this.putLength(byArray.length);
    }

    /*
     * Unable to fully structure code
     */
    protected void putTag(int var1_1) {
        block1: {
            if (var1_1 >= 256) ** GOTO lbl6
            this.bytes[--this.start] = (byte)var1_1;
            break block1;
lbl-1000:
            // 1 sources

            {
                this.bytes[--this.start] = (byte)(var1_1 & 127);
                var1_1 <<= 7;
lbl6:
                // 2 sources

                ** while (var1_1 != 0)
            }
        }
    }

    public int trim() {
        int n = this.bytes.length - this.start;
        int n2 = this.start;
        while (n2 < this.bytes.length) {
            this.bytes[n2 - this.start] = this.bytes[n2];
            ++n2;
        }
        this.start = this.bytes.length;
        this.stackTop = 0;
        return n;
    }
}

