/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Date;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ReflectionException;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.MonitorSettingException;
import javax.management.monitor.StringAlarmClock;
import javax.management.monitor.StringMonitorMBean;

public class StringMonitor
extends Monitor
implements StringMonitorMBean {
    private String stringToCompare = new String();
    private boolean notifyMatch = false;
    private boolean notifyDiffer = false;
    private transient String derivedGauge = new String();
    private transient long derivedGaugeTimestamp = new Date().getTime();
    private transient int status = 2;
    private static final int MATCHING = 0;
    private static final int DIFFERING = 1;
    private static final int MATCHING_OR_DIFFERING = 2;
    private transient StringAlarmClock alarmClock = null;

    public StringMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    public String getDerivedGauge() {
        return this.derivedGauge;
    }

    public long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{MonitorNotification.RUNTIME_ERROR, MonitorNotification.OBSERVED_OBJECT_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR, MonitorNotification.STRING_TO_COMPARE_VALUE_MATCHED, MonitorNotification.STRING_TO_COMPARE_VALUE_DIFFERED};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, "javax.management.MonitorNotification", "Notifications sent by the StringMonitor MBean")};
        return mBeanNotificationInfoArray;
    }

    public boolean getNotifyDiffer() {
        return this.notifyDiffer;
    }

    public boolean getNotifyMatch() {
        return this.notifyMatch;
    }

    public String getStringToCompare() {
        return this.stringToCompare;
    }

    String makeDebugTag() {
        return "StringMonitor";
    }

    void notifyAlarmClock() {
        block16: {
            Object object = null;
            String string = null;
            try {
                if (!this.isActive()) break block16;
                if (this.getObservedObject() == null || this.getObservedAttribute() == null) {
                    this.alarmClock = new StringAlarmClock(this, this.getGranularityPeriod());
                    this.alarmClock.start();
                    return;
                }
                try {
                    object = this.server.getAttribute(this.getObservedObject(), this.getObservedAttribute());
                }
                catch (NullPointerException nullPointerException) {
                    if ((this.alreadyNotified & 8) != 0) {
                        this.alarmClock = new StringAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.RUNTIME_ERROR;
                    this.alreadyNotified |= 8;
                    throw new MonitorSettingException("The string monitor must be registered in the MBean server.");
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if ((this.alreadyNotified & 1) != 0) {
                        this.alarmClock = new StringAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.OBSERVED_OBJECT_ERROR;
                    this.alreadyNotified |= 1;
                    throw new MonitorSettingException("The observed object must be registered in the MBean server.");
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    if ((this.alreadyNotified & 2) != 0) {
                        this.alarmClock = new StringAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.alreadyNotified |= 2;
                    throw new MonitorSettingException("The observed attribute must be accessible in the observed object.");
                }
                catch (MBeanException mBeanException) {
                    if ((this.alreadyNotified & 8) != 0) {
                        this.alarmClock = new StringAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.RUNTIME_ERROR;
                    this.alreadyNotified |= 8;
                    throw new MonitorSettingException(mBeanException.getMessage());
                }
                catch (ReflectionException reflectionException) {
                    if ((this.alreadyNotified & 2) != 0) {
                        this.alarmClock = new StringAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.alreadyNotified |= 2;
                    throw new MonitorSettingException(reflectionException.getMessage());
                }
                if (!(object instanceof String)) {
                    if ((this.alreadyNotified & 4) != 0) {
                        this.alarmClock = new StringAlarmClock(this, this.getGranularityPeriod());
                        this.alarmClock.start();
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR;
                    this.alreadyNotified |= 4;
                    throw new MonitorSettingException("The observed attribute type must be a string type.");
                }
                this.alreadyNotified = 0;
                this.updateDerivedGauge(object);
                this.updateNotifications();
                this.alarmClock = new StringAlarmClock(this, this.getGranularityPeriod());
                this.alarmClock.start();
            }
            catch (MonitorSettingException monitorSettingException) {
                this.sendNotification(string, this.derivedGaugeTimestamp, monitorSettingException.getMessage(), this.derivedGauge, null);
                this.status = 2;
                this.alarmClock = new StringAlarmClock(this, this.getGranularityPeriod());
                this.alarmClock.start();
            }
        }
    }

    public void setNotifyDiffer(boolean bl) {
        this.notifyDiffer = bl;
    }

    public void setNotifyMatch(boolean bl) {
        this.notifyMatch = bl;
    }

    public void setStringToCompare(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("The string to compare cannot be null.");
        }
        this.stringToCompare = string;
        this.status = 2;
    }

    public synchronized void start() {
        if (this.isTraceOn()) {
            this.trace("start", "start the string monitor");
        }
        if (!this.isActive()) {
            this.alarmClock = new StringAlarmClock(this, this.getGranularityPeriod());
            this.alarmClock.start();
            this.isActive = true;
            this.status = 2;
        } else if (this.isTraceOn()) {
            this.trace("start", "the string monitor is already activated");
        }
    }

    public synchronized void stop() {
        if (this.isTraceOn()) {
            this.trace("stop", "stop the string monitor");
        }
        if (this.isActive()) {
            if (this.alarmClock != null) {
                this.alarmClock.interrupt();
                try {
                    this.alarmClock.join();
                }
                catch (InterruptedException interruptedException) {}
                this.alarmClock = null;
            }
            this.isActive = false;
        } else if (this.isTraceOn()) {
            this.trace("stop", "the string monitor is already deactivated");
        }
    }

    private void updateDerivedGauge(Object object) {
        this.derivedGaugeTimestamp = new Date().getTime();
        this.derivedGauge = (String)object;
    }

    private void updateNotifications() {
        Object var1_1 = null;
        if (this.status == 2) {
            if (this.derivedGauge.equals(this.stringToCompare)) {
                if (this.notifyMatch) {
                    this.sendNotification(MonitorNotification.STRING_TO_COMPARE_VALUE_MATCHED, this.derivedGaugeTimestamp, "", this.derivedGauge, this.stringToCompare);
                }
                this.status = 1;
            } else {
                if (this.notifyDiffer) {
                    this.sendNotification(MonitorNotification.STRING_TO_COMPARE_VALUE_DIFFERED, this.derivedGaugeTimestamp, "", this.derivedGauge, this.stringToCompare);
                }
                this.status = 0;
            }
        } else if (this.status == 0) {
            if (this.derivedGauge.equals(this.stringToCompare)) {
                if (this.notifyMatch) {
                    this.sendNotification(MonitorNotification.STRING_TO_COMPARE_VALUE_MATCHED, this.derivedGaugeTimestamp, "", this.derivedGauge, this.stringToCompare);
                }
                this.status = 1;
            }
        } else if (this.status == 1 && !this.derivedGauge.equals(this.stringToCompare)) {
            if (this.notifyDiffer) {
                this.sendNotification(MonitorNotification.STRING_TO_COMPARE_VALUE_DIFFERED, this.derivedGaugeTimestamp, "", this.derivedGauge, this.stringToCompare);
            }
            this.status = 0;
        }
    }
}

