/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.management.IntrospectionException;
import javax.management.MBeanFeatureInfo;

public class MBeanAttributeInfo
extends MBeanFeatureInfo
implements Serializable,
Cloneable {
    private transient Method readMethod = null;
    private transient Method writeMethod = null;
    private String attributeType = null;
    private boolean isWrite = false;
    private boolean isRead = false;
    private boolean is = false;

    public MBeanAttributeInfo(String string, String string2, String string3, boolean bl, boolean bl2) {
        super(string, string3);
        this.attributeType = string2;
        this.isRead = bl;
        this.isWrite = bl2;
    }

    public MBeanAttributeInfo(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        super(string, string3);
        this.attributeType = string2;
        this.isRead = bl;
        this.isWrite = bl2;
        if (bl3 && !bl) {
            throw new IllegalArgumentException("Cannot have an \"is\" getter for a non-readable attribute.");
        }
        if (bl3 && !string2.equals("java.lang.Boolean") && !string2.equals("boolean")) {
            throw new IllegalArgumentException("Cannot have an \"is\" getter for a non-boolean attribute.");
        }
        this.is = bl3;
    }

    public MBeanAttributeInfo(String string, String string2, Method method, Method method2) throws IntrospectionException {
        super(string, string2);
        this.readMethod = method;
        this.writeMethod = method2;
        this.findAttributeType();
        this.findAttributeRights();
    }

    MBeanAttributeInfo(MBeanAttributeInfo mBeanAttributeInfo) {
        super(mBeanAttributeInfo.name, mBeanAttributeInfo.description);
        this.attributeType = mBeanAttributeInfo.attributeType;
        this.isRead = mBeanAttributeInfo.isRead;
        this.isWrite = mBeanAttributeInfo.isWrite;
        this.is = mBeanAttributeInfo.is;
    }

    public Object clone() {
        return new MBeanAttributeInfo(this);
    }

    private void findAttributeRights() {
        if (this.readMethod != null) {
            this.isRead = true;
            if (this.readMethod.getName().startsWith("is")) {
                this.is = true;
            }
        }
        if (this.writeMethod != null) {
            this.isWrite = true;
        }
    }

    private void findAttributeType() throws IntrospectionException {
        Class<?> clazz = null;
        this.attributeType = null;
        if (this.readMethod != null) {
            if (this.readMethod.getParameterTypes().length != 0) {
                throw new IntrospectionException("bad read method arg count");
            }
            clazz = this.readMethod.getReturnType();
            if (clazz == Void.TYPE) {
                throw new IntrospectionException("read method " + this.readMethod.getName() + " returns void");
            }
        }
        if (this.writeMethod != null) {
            Class<?>[] classArray = this.writeMethod.getParameterTypes();
            if (classArray.length != 1) {
                throw new IntrospectionException("bad write method arg count");
            }
            if (clazz != null && clazz != classArray[0]) {
                throw new IntrospectionException("type mismatch between read and write methods");
            }
            clazz = classArray[0];
        }
        this.attributeType = clazz.getName();
    }

    public String getType() {
        return this.attributeType;
    }

    public boolean isIs() {
        return this.is;
    }

    public boolean isReadable() {
        return this.isRead;
    }

    public boolean isWritable() {
        return this.isWrite;
    }
}

