/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.snmp.agent.SnmpIndex;
import com.sun.jdmk.snmp.agent.SnmpMib;
import com.sun.jdmk.snmp.agent.SnmpMibNode;
import com.sun.jdmk.snmp.agent.SnmpMibTableMBean;
import com.sun.jdmk.snmp.agent.SnmpTableEntryNotification;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;

public abstract class SnmpMibTable
extends SnmpMibNode
implements SnmpMibTableMBean,
NotificationBroadcaster,
Serializable {
    protected int nodeId = 1;
    protected SnmpMib theMib;
    private int size = 0;
    private Vector indexes = new Vector();
    private Vector oids = new Vector();
    private Vector entries = new Vector();
    private Hashtable handbackTable = new Hashtable();
    private Hashtable filterTable = new Hashtable();
    transient long sequenceNumber = 0L;

    public SnmpMibTable(SnmpMib snmpMib) {
        this.theMib = snmpMib;
    }

    public synchronized void addEntry(SnmpIndex snmpIndex, Object object) throws SnmpStatusException {
        SnmpOid snmpOid = this.buildOidFromIndex(snmpIndex);
        if (this.size == 0) {
            this.indexes.addElement(snmpIndex);
            this.oids.addElement(snmpOid);
            this.entries.addElement(object);
            ++this.size;
            this.sendNotification(SnmpTableEntryNotification.SNMP_ENTRY_ADDED, new Date().getTime(), object);
            return;
        }
        int n = 0;
        n = this.getInsertionPoint(snmpOid);
        if (n == this.size) {
            this.indexes.addElement(snmpIndex);
            this.oids.addElement(snmpOid);
            this.entries.addElement(object);
            ++this.size;
        } else {
            try {
                this.indexes.insertElementAt(snmpIndex, n);
                this.oids.insertElementAt(snmpOid, n);
                this.entries.insertElementAt(object, n);
                ++this.size;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        this.sendNotification(SnmpTableEntryNotification.SNMP_ENTRY_ADDED, new Date().getTime(), object);
    }

    public synchronized void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        Vector<Object> vector = (Vector<Object>)this.handbackTable.get(notificationListener);
        Vector<NotificationFilter> vector2 = (Vector<NotificationFilter>)this.filterTable.get(notificationListener);
        if (vector == null) {
            vector = new Vector<Object>();
            vector2 = new Vector<NotificationFilter>();
            this.handbackTable.put(notificationListener, vector);
            this.filterTable.put(notificationListener, vector2);
        }
        vector.addElement(object);
        vector2.addElement(notificationFilter);
    }

    protected abstract SnmpOid buildOidFromIndex(SnmpIndex var1) throws SnmpStatusException;

    protected abstract SnmpIndex buildSnmpIndex(long[] var1, int var2) throws SnmpStatusException;

    public void check(SnmpValue snmpValue, long[] lArray, int n) throws SnmpStatusException {
        this.validateOid(lArray, n);
        SnmpIndex snmpIndex = this.buildSnmpIndex(lArray, n + 2);
        Object object = this.getEntry(snmpIndex);
        this.checkValueOfEntry(snmpValue, object, lArray[n + 1]);
    }

    protected abstract void checkValueOfEntry(SnmpValue var1, Object var2, long var3) throws SnmpStatusException;

    private int findObject(SnmpIndex snmpIndex) {
        try {
            SnmpOid snmpOid = this.buildOidFromIndex(snmpIndex);
            return this.findObject(snmpOid);
        }
        catch (SnmpStatusException snmpStatusException) {
            return -1;
        }
    }

    private int findObject(SnmpOid snmpOid) {
        int n = 0;
        int n2 = this.size - 1;
        int n3 = n + (n2 - n) / 2;
        while (n <= n2) {
            SnmpOid snmpOid2 = (SnmpOid)this.oids.elementAt(n3);
            int n4 = snmpOid.compareTo(snmpOid2);
            if (n4 == 0) {
                return n3;
            }
            if (snmpOid.equals(snmpOid2)) {
                return n3;
            }
            if (n4 > 0) {
                n = n3 + 1;
            } else {
                n2 = n3 - 1;
            }
            n3 = n + (n2 - n) / 2;
        }
        return -1;
    }

    public SnmpValue get(long[] lArray, int n) throws SnmpStatusException {
        this.validateOid(lArray, n);
        SnmpIndex snmpIndex = this.buildSnmpIndex(lArray, n + 2);
        return this.getValueOfEntry(snmpIndex, lArray[n + 1]);
    }

    public Object[] getBasicEntries() {
        Object[] objectArray = new Object[this.size];
        this.entries.copyInto(objectArray);
        return objectArray;
    }

    public synchronized Object getEntry(SnmpIndex snmpIndex) throws SnmpStatusException {
        int n = this.findObject(snmpIndex);
        if (n == -1) {
            throw new SnmpStatusException(224);
        }
        return this.entries.elementAt(n);
    }

    private int getInsertionPoint(SnmpIndex snmpIndex) throws SnmpStatusException {
        SnmpOid snmpOid = this.buildOidFromIndex(snmpIndex);
        return this.getInsertionPoint(snmpOid);
    }

    private int getInsertionPoint(SnmpOid snmpOid) throws SnmpStatusException {
        int n = 0;
        int n2 = this.size - 1;
        int n3 = n + (n2 - n) / 2;
        while (n <= n2) {
            SnmpOid snmpOid2 = (SnmpOid)this.oids.elementAt(n3);
            int n4 = snmpOid.compareTo(snmpOid2);
            if (n4 == 0) {
                throw new SnmpStatusException(n3);
            }
            if (n4 > 0) {
                n = n3 + 1;
            } else {
                n2 = n3 - 1;
            }
            n3 = n + (n2 - n) / 2;
        }
        return n3;
    }

    public SnmpVarBind getNext(long[] lArray, int n) throws SnmpStatusException {
        long l = -1L;
        int n2 = lArray.length;
        if (n >= n2) {
            lArray = new long[]{this.nodeId};
            n = 0;
            n2 = 1;
        } else {
            if (lArray[n] > (long)this.nodeId) {
                throw new SnmpStatusException(2);
            }
            if (lArray[n] < (long)this.nodeId) {
                lArray = new long[]{this.nodeId};
                n = 0;
                n2 = 0;
            } else if (n + 1 < n2) {
                l = lArray[n + 1];
            }
        }
        SnmpIndex snmpIndex = null;
        if (n == n2 - 1) {
            snmpIndex = this.getNextIndex(null);
            return this.getNextVarEntry(snmpIndex, l);
        }
        if (n == n2 - 2) {
            snmpIndex = this.getNextIndex(null);
            try {
                SnmpValue snmpValue = this.getValueOfEntry(snmpIndex, l);
                SnmpOid snmpOid = this.buildOidFromIndex(snmpIndex);
                snmpOid.insert(l);
                snmpOid.insert(this.nodeId);
                return new SnmpVarBind(snmpOid, snmpValue);
            }
            catch (SnmpStatusException snmpStatusException) {
                return this.getNextVarEntry(snmpIndex, l);
            }
        }
        try {
            SnmpOid snmpOid = this.getNextOid(lArray, n + 2);
            snmpIndex = this.buildSnmpIndex(snmpOid.longValue(), 0);
            SnmpValue snmpValue = this.getValueOfEntry(snmpIndex, l);
            snmpOid.insert(l);
            snmpOid.insert(this.nodeId);
            return new SnmpVarBind(snmpOid, snmpValue);
        }
        catch (SnmpStatusException snmpStatusException) {
            snmpIndex = this.getNextIndex(null);
            return this.getNextVarEntry(snmpIndex, l);
        }
    }

    SnmpIndex getNextIndex(SnmpIndex snmpIndex) throws SnmpStatusException {
        if (this.size == 0) {
            throw new SnmpStatusException(2);
        }
        if (snmpIndex == null) {
            return (SnmpIndex)this.indexes.firstElement();
        }
        SnmpIndex snmpIndex2 = (SnmpIndex)this.indexes.lastElement();
        if (snmpIndex2.equals(snmpIndex)) {
            throw new SnmpStatusException(2);
        }
        SnmpOid snmpOid = this.buildOidFromIndex(snmpIndex);
        int n = this.findObject(snmpOid);
        if (n == -1) {
            n = this.getInsertionPoint(snmpOid);
            try {
                snmpIndex2 = (SnmpIndex)this.indexes.elementAt(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new SnmpStatusException(2);
            }
        }
        if (n == this.size) {
            throw new SnmpStatusException(2);
        }
        try {
            snmpIndex2 = (SnmpIndex)this.indexes.elementAt(n + 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
        return snmpIndex2;
    }

    protected SnmpOid getNextOid(long[] lArray, int n) throws SnmpStatusException {
        if (this.size == 0) {
            throw new SnmpStatusException(2);
        }
        int n2 = lArray.length - n;
        long[] lArray2 = new long[n2];
        int n3 = 0;
        while (n3 < n2) {
            lArray2[n3] = lArray[n + n3];
            ++n3;
        }
        SnmpOid snmpOid = new SnmpOid(lArray2);
        SnmpOid snmpOid2 = (SnmpOid)this.oids.lastElement();
        if (snmpOid2.equals(snmpOid)) {
            throw new SnmpStatusException(2);
        }
        int n4 = this.findObject(snmpOid);
        if (n4 == -1) {
            n4 = this.getInsertionPoint(snmpOid);
            try {
                snmpOid2 = (SnmpOid)this.oids.elementAt(n4);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new SnmpStatusException(2);
            }
        }
        if (n4 == this.size) {
            throw new SnmpStatusException(2);
        }
        try {
            snmpOid2 = (SnmpOid)this.oids.elementAt(n4 + 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
        return (SnmpOid)snmpOid2.clone();
    }

    protected abstract SnmpVarBind getNextVarEntry(SnmpIndex var1, long var2) throws SnmpStatusException;

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{SnmpTableEntryNotification.SNMP_ENTRY_ADDED, SnmpTableEntryNotification.SNMP_ENTRY_REMOVED};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, "com.sun.jdmk.snmp.agent.SnmpTableEntryNotification", "Notifications sent by the SnmpMibTable")};
        return mBeanNotificationInfoArray;
    }

    public int getSize() {
        return this.size;
    }

    protected abstract SnmpValue getValueOfEntry(SnmpIndex var1, long var2) throws SnmpStatusException;

    public synchronized void removeEntry(Object object) {
        int n = this.entries.indexOf(object);
        if (n == -1) {
            return;
        }
        this.entries.removeElementAt(n);
        this.indexes.removeElementAt(n);
        this.oids.removeElementAt(n);
        --this.size;
        this.sendNotification(SnmpTableEntryNotification.SNMP_ENTRY_REMOVED, new Date().getTime(), object);
    }

    public synchronized void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        Vector vector = (Vector)this.handbackTable.get(notificationListener);
        Vector vector2 = (Vector)this.filterTable.get(notificationListener);
        if (vector == null) {
            throw new ListenerNotFoundException("listener");
        }
        this.handbackTable.remove(notificationListener);
        this.filterTable.remove(notificationListener);
    }

    private void sendNotification(String string, long l, Object object) {
        Serializable serializable = this;
        synchronized (serializable) {
            ++this.sequenceNumber;
        }
        serializable = new SnmpTableEntryNotification(string, (Object)this, this.sequenceNumber, l, object);
        this.sendNotification((Notification)serializable);
    }

    private synchronized void sendNotification(Notification notification) {
        Enumeration enumeration = this.handbackTable.keys();
        while (enumeration.hasMoreElements()) {
            NotificationListener notificationListener = (NotificationListener)enumeration.nextElement();
            Vector vector = (Vector)this.handbackTable.get(notificationListener);
            Vector vector2 = (Vector)this.filterTable.get(notificationListener);
            Enumeration enumeration2 = vector2.elements();
            Enumeration enumeration3 = vector.elements();
            while (enumeration3.hasMoreElements()) {
                Object e = enumeration3.nextElement();
                NotificationFilter notificationFilter = (NotificationFilter)enumeration2.nextElement();
                if (notificationFilter != null && (notificationFilter == null || !notificationFilter.isNotificationEnabled(notification))) continue;
                notificationListener.handleNotification(notification, e);
            }
        }
    }

    public SnmpValue set(SnmpValue snmpValue, long[] lArray, int n) throws SnmpStatusException {
        this.validateOid(lArray, n);
        SnmpIndex snmpIndex = this.buildSnmpIndex(lArray, n + 2);
        return this.setValueOfEntry(snmpValue, snmpIndex, lArray[n + 1]);
    }

    protected abstract SnmpValue setValueOfEntry(SnmpValue var1, SnmpIndex var2, long var3) throws SnmpStatusException;

    void validateOid(long[] lArray, int n) throws SnmpStatusException {
        int n2 = lArray.length;
        if (n + 2 >= n2) {
            throw new SnmpStatusException(6);
        }
        if (lArray[n] != (long)this.nodeId) {
            throw new SnmpStatusException(6);
        }
    }
}

