/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.Trace;
import com.sun.jdmk.discovery.DiscoveryMsg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;

abstract class DiscoveryCommon
extends MulticastSocket
implements Runnable {
    protected int infoType;
    protected String localClassName;
    protected String dbgTag;
    protected int multicastPort;
    protected InetAddress multicastGroup;
    protected InetAddress localHost;
    protected String localHostName;
    protected InetAddress selectedHost;
    protected String selectedHostName;

    public DiscoveryCommon(String string, int n) throws IOException {
        block6: {
            block5: {
                super(n);
                this.infoType = 4096;
                this.dbgTag = this.localClassName = "com.sun.jdmk.discovery.DiscoveryCommon";
                if (this.isTraceOn()) {
                    this.trace("constructor ", "group = " + string + ", " + "port  = " + n);
                }
                try {
                    this.multicastGroup = InetAddress.getByName(string);
                }
                catch (UnknownHostException unknownHostException) {
                    if (!this.isDebugOn()) break block5;
                    this.debug("constructor ", unknownHostException);
                }
            }
            this.multicastPort = n;
            try {
                this.localHost = InetAddress.getLocalHost();
                this.localHostName = InetAddress.getLocalHost().getHostName();
                this.selectedHost = InetAddress.getLocalHost();
                this.selectedHostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                if (!this.isDebugOn()) break block6;
                this.debug("constructor ", unknownHostException);
            }
        }
    }

    public void connectToGroup() throws IOException {
        if (this.isTraceOn()) {
            this.trace("connectToGroup", "join Group " + this.multicastGroup);
        }
        this.joinGroup(this.multicastGroup);
    }

    protected void debug(String string, Exception exception) {
        this.debug(this.localClassName, string, exception);
    }

    protected void debug(String string, String string2) {
        this.debug(this.localClassName, string, string2);
    }

    protected void debug(String string, String string2, Exception exception) {
        Trace.send(2, this.infoType, string, string2, exception);
    }

    protected void debug(String string, String string2, String string3) {
        Trace.send(2, this.infoType, string, string2, string3);
    }

    void disconnectFromGroup() throws IOException {
        if (this.isTraceOn()) {
            this.trace("disconnectFromGroup", "leave Group " + this.multicastGroup);
        }
        this.leaveGroup(this.multicastGroup);
    }

    public InetAddress getHostAddr() {
        return this.selectedHost;
    }

    public String getHostName() {
        return this.selectedHostName;
    }

    public InetAddress getLocalHostAddr() {
        return this.localHost;
    }

    public String getLocalHostName() {
        return this.localHostName;
    }

    protected boolean isDebugOn() {
        return Trace.isSelected(2, this.infoType);
    }

    protected boolean isTraceOn() {
        return Trace.isSelected(1, this.infoType);
    }

    private Object objectDeserialization(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.isDebugOn()) {
                this.debug("objectDeserialization", classNotFoundException);
            }
            throw classNotFoundException;
        }
        catch (OptionalDataException optionalDataException) {
            if (this.isDebugOn()) {
                this.debug("objectDeserialization", optionalDataException);
            }
            throw new IOException(optionalDataException.getMessage());
        }
    }

    private byte[] objectSerialization(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream.toByteArray();
    }

    protected synchronized DiscoveryMsg receiveMsg(DatagramSocket datagramSocket) throws IOException, ClassNotFoundException, InvalidClassException, InterruptedIOException {
        byte[] byArray;
        DiscoveryMsg discoveryMsg;
        InetAddress inetAddress;
        byte[] byArray2 = new byte[100000];
        DatagramPacket datagramPacket = new DatagramPacket(byArray2, byArray2.length);
        if (this.isTraceOn()) {
            this.trace("receiveMsg ", "Start waiting");
        }
        datagramSocket.receive(datagramPacket);
        if (this.isTraceOn()) {
            this.trace("receiveMsg ", "We Receive something");
        }
        if (!(inetAddress = (discoveryMsg = (DiscoveryMsg)this.objectDeserialization(byArray = datagramPacket.getData())).getEmittedGroup()).equals(this.multicastGroup)) {
            if (this.isTraceOn()) {
                this.trace("receiveMsg ", "Receive a msg for another group");
            }
            throw new IOException();
        }
        if (this.isTraceOn()) {
            this.trace("receiveMsg ", "Receive a msg");
        }
        return discoveryMsg;
    }

    public void run() {
    }

    protected synchronized void sendMsg(DiscoveryMsg discoveryMsg, InetAddress inetAddress, int n) throws IOException {
        byte[] byArray = null;
        try {
            byArray = this.objectSerialization(discoveryMsg);
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("sendMsg ", iOException);
            }
            throw iOException;
        }
        if (this.isTraceOn()) {
            this.trace("sendMsg", "destination address = " + inetAddress + " Port = " + n);
            this.trace("sendMsg", "Send msg '" + discoveryMsg.printState() + "'");
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        this.setTimeToLive(discoveryMsg.getTimeToLive());
        this.send(datagramPacket);
    }

    protected void trace(String string, Exception exception) {
        this.trace(this.localClassName, string, exception);
    }

    protected void trace(String string, String string2) {
        this.trace(this.localClassName, string, string2);
    }

    protected void trace(String string, String string2, Exception exception) {
        Trace.send(1, this.infoType, string, string2, exception);
    }

    protected void trace(String string, String string2, String string3) {
        Trace.send(1, this.infoType, string, string2, string3);
    }
}

