/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.HeartBeatServerHandler;
import com.sun.jdmk.comm.RmiConnectorServerObject;
import com.sun.jdmk.comm.ServerNotificationDispatcher;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

class RmiConnectorServerObjectImpl
extends UnicastRemoteObject
implements RmiConnectorServerObject {
    private int infoType = 256;
    private String localClassName;
    private String dbgTag = this.localClassName = "RmiConnectorServerObjectImpl";
    private MBeanServer mbeanServer = null;
    private boolean needRmiLoader = true;
    private String host;
    private String serviceName = null;
    private int port;
    private boolean isActive = false;
    private ServerNotificationDispatcher serverNotificationDispatcher = null;
    private HeartBeatServerHandler heartbeatServerHandler = null;

    public RmiConnectorServerObjectImpl(MBeanServer mBeanServer, String string, int n, ServerNotificationDispatcher serverNotificationDispatcher, HeartBeatServerHandler heartBeatServerHandler) throws RemoteException {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            this.host = "localhost";
        }
        this.mbeanServer = mBeanServer;
        this.serviceName = string;
        this.port = n;
        this.serviceName = RmiConnectorServerObjectImpl.makeManagedObjFactoryName(this.host, n, string);
        this.dbgTag = this.makeDebugTag();
        this.serverNotificationDispatcher = serverNotificationDispatcher;
        this.heartbeatServerHandler = heartBeatServerHandler;
    }

    void bind() throws CommunicationException, RemoteException {
        Registry registry = null;
        try {
            if (this.isDebugOn()) {
                this.debug("bind", "Register object in RmiRegistry ; name=" + this.serviceName);
            }
            Naming.bind(this.serviceName, this);
            if (this.isDebugOn()) {
                this.debug("bind", "Done");
            }
        }
        catch (AlreadyBoundException alreadyBoundException) {
            throw new CommunicationException(alreadyBoundException, "Fails to register " + this.serviceName);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CommunicationException(malformedURLException, "Fails to register " + this.serviceName);
        }
        catch (AccessException accessException) {
            throw new CommunicationException(accessException, "Fails to register " + this.serviceName);
        }
        catch (RemoteException remoteException) {
            if (this.isDebugOn()) {
                this.debug("bind", "Create Rmi registry port=" + this.port);
            }
            registry = LocateRegistry.createRegistry(this.port);
            if (this.isDebugOn()) {
                this.debug("bind", "Done");
            }
            try {
                if (this.isDebugOn()) {
                    this.debug("bind", "Register object in RmiRegistry ; name=" + this.serviceName);
                }
                Naming.bind(this.serviceName, this);
                if (this.isDebugOn()) {
                    this.debug("bind", "Done");
                }
            }
            catch (Exception exception) {
                throw new CommunicationException(exception, "Fails to register " + this.serviceName);
            }
        }
        this.isActive = true;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, RemoteException {
        this.stopIfNotActive("createMBean(className,name)");
        if (this.isTraceOn()) {
            this.trace("createMBean(className,name)", "MBean class name = " + string + " ; MBean name = " + objectName);
        }
        return this.mbeanServer.createMBean(string, objectName);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, RemoteException {
        this.stopIfNotActive("createMBean(className,name,loaderName)");
        if (this.isTraceOn()) {
            this.trace("createMBean(className,name,loaderName)", "MBean class name = " + string + " ; MBean name = " + objectName);
        }
        return this.mbeanServer.createMBean(string, objectName, objectName2);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, RemoteException {
        this.stopIfNotActive("createMBean(className,name,loaderName,params,signature)");
        if (this.isTraceOn()) {
            this.trace("createMBean(className,name,loaderName,params,signature)", "MBean class name = " + string + " ; MBean name = " + objectName);
        }
        return this.mbeanServer.createMBean(string, objectName, objectName2, objectArray, stringArray);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, RemoteException {
        this.stopIfNotActive("createMBean(className,name,params,signature)");
        if (this.isTraceOn()) {
            this.trace("createMBean(className,name,params,signature)", "MBean class name = " + string + " ; MBean name = " + objectName);
        }
        return this.mbeanServer.createMBean(string, objectName, objectArray, stringArray);
    }

    private void debug(String string, String string2) {
        this.debug(this.localClassName, string, string2);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, this.infoType, string, string2, string3);
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, RemoteException {
        this.stopIfNotActive("getAttribute");
        if (this.isTraceOn()) {
            this.trace("getAttribute", "MBean name=\"" + objectName + "\" ; MBean attribute=\"" + string + "\"");
        }
        Object object = this.mbeanServer.getAttribute(objectName, string);
        if (this.isDebugOn()) {
            this.debug("getAttribute", "result=\"" + object.toString() + "\"");
        }
        return object;
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException, RemoteException {
        this.stopIfNotActive("getAttributes(name,attributes)");
        if (this.isTraceOn()) {
            this.trace("getAttributes(name,attributes)", "MBean name=\"" + objectName);
        }
        return this.mbeanServer.getAttributes(objectName, stringArray);
    }

    public String getDefaultDomain() throws RemoteException {
        this.stopIfNotActive("getDefaultDomain()");
        if (this.isTraceOn()) {
            this.trace("getDefaultDomain()", "");
        }
        return this.mbeanServer.getDefaultDomain();
    }

    public Integer getMBeanCount() throws RemoteException {
        this.stopIfNotActive("getMBeanCount()");
        if (this.isTraceOn()) {
            this.trace("getMBeanCount()", "");
        }
        return this.mbeanServer.getMBeanCount();
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, RemoteException {
        this.stopIfNotActive("getMBeanInfo(name)");
        if (this.isTraceOn()) {
            this.trace("getMBeanInfo(name)", "");
        }
        return this.mbeanServer.getMBeanInfo(objectName);
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException, RemoteException {
        this.stopIfNotActive("getObjectInstance(name)");
        if (this.isTraceOn()) {
            this.trace("getObjectInstance(name)", "MBean name = " + objectName);
        }
        return this.mbeanServer.getObjectInstance(objectName);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, RemoteException {
        this.stopIfNotActive("invoke(name,actionName,params,signature)");
        if (this.isTraceOn()) {
            this.trace("invoke(name,actionName,params,signature)", "");
        }
        return this.mbeanServer.invoke(objectName, string, objectArray, stringArray);
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, this.infoType);
    }

    public boolean isRegistered(ObjectName objectName) throws RemoteException {
        this.stopIfNotActive("isRegistered(name)");
        if (this.isTraceOn()) {
            this.trace("isRegistered(name)", "MBean name = " + objectName);
        }
        return this.mbeanServer.isRegistered(objectName);
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, this.infoType);
    }

    private String makeDebugTag() {
        return String.valueOf(this.localClassName) + "[" + this.port + ":" + this.serviceName + "]";
    }

    static String makeManagedObjFactoryName(String string, int n, String string2) {
        return "rmi://" + string + ":" + n + "/" + string2;
    }

    public String pingHeartBeatServer(String string, int n, int n2, Long l) throws RemoteException {
        this.stopIfNotActive("pingHeartBeatServer()");
        return this.heartbeatServerHandler.pingHeartBeatServer(string, n, n2, l);
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) throws RemoteException {
        this.stopIfNotActive("queryMBeans(name,query)");
        if (this.isTraceOn()) {
            this.trace("queryMBeans(name,query)", "MBean name = " + objectName);
        }
        return this.mbeanServer.queryMBeans(objectName, queryExp);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) throws RemoteException {
        this.stopIfNotActive("queryNames(name,query)");
        if (this.isTraceOn()) {
            this.trace("queryNames(name,query)", "MBean name = " + objectName);
        }
        return this.mbeanServer.queryNames(objectName, queryExp);
    }

    public Object[] remoteRequest(int n, Object[] objectArray) throws Exception, RemoteException {
        this.stopIfNotActive("remoteRequest()");
        return this.serverNotificationDispatcher.remoteRequest(n, objectArray);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, RemoteException {
        this.stopIfNotActive("setAttribute");
        if (this.isTraceOn()) {
            this.trace("setAttribute", "MBean name=\"" + objectName + "\" ; MBean attribute=\"" + attribute + "\"");
        }
        this.mbeanServer.setAttribute(objectName, attribute);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException, RemoteException {
        this.stopIfNotActive("setAttributes(name,attributes)");
        if (this.isTraceOn()) {
            this.trace("setAttributes(name,attributes)", "MBean name=\"" + objectName);
        }
        return this.mbeanServer.setAttributes(objectName, attributeList);
    }

    private void stopIfNotActive(String string) throws RemoteException {
        if (!this.isActive) {
            if (this.isTraceOn()) {
                this.trace("methodName", "Connector is OFFLINE.");
            }
            throw new RemoteException("Connector is OFFLINE.");
        }
    }

    private void trace(String string, String string2) {
        this.trace(this.localClassName, string, string2);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, this.infoType, string, string2, string3);
    }

    void unbind() {
        try {
            if (this.isDebugOn()) {
                this.debug("unbind", "Unregister object in RmiRegistry ; name=" + this.serviceName);
            }
            Naming.unbind(this.serviceName);
            if (this.isDebugOn()) {
                this.debug("unbind", "Done");
            }
        }
        catch (Exception exception) {}
        this.isActive = false;
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, RemoteException {
        this.stopIfNotActive("unregisterMBean(name)");
        if (this.isTraceOn()) {
            this.trace("unregisterMBean(name)", "MBean name = " + objectName);
        }
        this.mbeanServer.unregisterMBean(objectName);
    }
}

