/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.HeartBeatServerHandler;
import com.sun.jdmk.comm.NotificationBackConnector;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorServerMBean;
import com.sun.jdmk.comm.RmiConnectorServerObjectImpl;
import com.sun.jdmk.comm.RmiNotificationForwarder;
import com.sun.jdmk.comm.ServerNotificationDispatcher;
import com.sun.jdmk.comm.ServerNotificationHandlerInternal;
import java.net.InetAddress;
import java.rmi.RemoteException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class RmiConnectorServer
extends CommunicatorServer
implements MBeanRegistration,
RmiConnectorServerMBean {
    private static int defaultPort = 1099;
    private String localHost = "localhost";
    private static String defaultServiceName = "name=RmiConnectorServer";
    private static String serviceName = null;
    private transient RmiConnectorServerObjectImpl rmiConnector = null;
    private transient MBeanServer mbeanServer = null;
    private ServerNotificationDispatcher serverNotificationDispatcher = null;
    private RmiNotificationForwarder rmiNotificationForwarder = null;
    private HeartBeatServerHandler heartbeatServerHandler = null;

    public RmiConnectorServer() {
        this(defaultPort, defaultServiceName);
    }

    public RmiConnectorServer(int n) {
        this(n, defaultServiceName);
    }

    public RmiConnectorServer(int n, String string) {
        super(1);
        this.port = n;
        serviceName = string;
        try {
            this.localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            if (this.isTraceOn()) {
                this.trace("RmiConnectorServer constructor", "Set host to the default value (" + this.localHost + ")");
            }
            this.localHost = "localhost";
        }
    }

    public RmiConnectorServer(String string) {
        this(defaultPort, string);
    }

    protected void doBind() throws CommunicationException, InterruptedException {
        try {
            if (this.rmiConnector == null) {
                if (this.isTraceOn()) {
                    this.trace("doBind", "Create the RMI object server");
                }
                if (this.isDebugOn()) {
                    this.debug("doBind", "serviceName=" + serviceName + " ; port=" + this.port);
                }
                this.rmiConnector = new RmiConnectorServerObjectImpl(this.mbeanServer, serviceName, this.port, this.serverNotificationDispatcher, this.heartbeatServerHandler);
            }
            this.rmiConnector.bind();
            if (this.isTraceOn()) {
                this.trace("doBind", "Bind RMI object server");
            }
        }
        catch (RemoteException remoteException) {
            if (this.isDebugOn()) {
                this.debug("doBind", "Got Exception" + remoteException.getMessage());
            }
            throw new CommunicationException(remoteException);
        }
    }

    protected void doError(Exception exception) throws CommunicationException {
    }

    protected void doProcess() throws CommunicationException, InterruptedException {
    }

    /*
     * Exception decompiling
     */
    protected void doReceive() throws CommunicationException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void doUnbind() throws CommunicationException, InterruptedException {
        if (this.isTraceOn()) {
            this.trace("doUnbind", "Unbind RMI object server");
        }
        this.rmiConnector.unbind();
    }

    public String getProtocol() {
        return "rmi";
    }

    public String getServiceName() {
        return serviceName;
    }

    protected String makeDebugTag() {
        return "RmiConnectorServer[" + this.getProtocol() + ":" + this.getPort() + ":" + this.getServiceName() + "]";
    }

    public void postDeregister() {
        super.postDeregister();
    }

    public void postRegister(Boolean bl) {
        super.postRegister(bl);
        this.serverNotificationDispatcher = new ServerNotificationDispatcher(new NotificationHandlerInternal(this), this.mbeanServer);
        this.heartbeatServerHandler = new HeartBeatServerHandler(this.mbs, this.serverNotificationDispatcher);
    }

    public void preDeregister() throws Exception {
        super.preDeregister();
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        Object var3_3 = null;
        if (objectName == null) {
            objectName = new ObjectName(String.valueOf(mBeanServer.getDefaultDomain()) + ":" + "name=RmiConnectorServer");
        }
        this.mbeanServer = mBeanServer;
        super.preRegister(mBeanServer, objectName);
        return objectName;
    }

    public void setServiceName(String string) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        serviceName = string;
        this.dbgTag = this.makeDebugTag();
    }

    NotificationBackConnector startPush(ConnectorAddress connectorAddress) {
        if (!(connectorAddress instanceof RmiConnectorAddress)) {
            throw new IllegalArgumentException("Expected RmiConnectorAddress class, got " + connectorAddress.getClass().getName());
        }
        try {
            RmiNotificationForwarder rmiNotificationForwarder = new RmiNotificationForwarder((RmiConnectorAddress)connectorAddress, this);
            return rmiNotificationForwarder;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CommunicationException(illegalAccessException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException);
        }
    }

    void stopPush(NotificationBackConnector notificationBackConnector) {
        if (!(notificationBackConnector instanceof RmiNotificationForwarder)) {
            throw new IllegalArgumentException("Invalid Rmi NotificationBackConnector");
        }
        ((RmiNotificationForwarder)notificationBackConnector).disconnect();
    }

    private class NotificationHandlerInternal
    implements ServerNotificationHandlerInternal {
        private RmiConnectorServer connector;

        public NotificationHandlerInternal(RmiConnectorServer rmiConnectorServer2) {
            this.connector = rmiConnectorServer2;
        }

        public NotificationBackConnector startPush(ConnectorAddress connectorAddress) {
            return this.connector.startPush(connectorAddress);
        }

        public void stopPush(NotificationBackConnector notificationBackConnector) {
            this.connector.stopPush(notificationBackConnector);
        }
    }
}

