/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.BASE64Decoder;
import com.sun.jdmk.comm.ClientHandler;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import com.sun.jdmk.comm.HtmlAdminPage;
import com.sun.jdmk.comm.HtmlArrayPage;
import com.sun.jdmk.comm.HtmlInvokePage;
import com.sun.jdmk.comm.HtmlMasterPage;
import com.sun.jdmk.comm.HtmlObjectPage;
import com.sun.jdmk.comm.HtmlPage;
import com.sun.jdmk.comm.HttpBody;
import com.sun.jdmk.comm.HttpMessage;
import com.sun.jdmk.comm.HttpRequest;
import com.sun.jdmk.comm.HttpResponse;
import com.sun.jdmk.comm.MalformedHttpException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

class HtmlRequestHandler
extends ClientHandler {
    private Socket sockClient = null;
    private String bgPageColor = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";

    public HtmlRequestHandler(Socket socket, HtmlAdaptorServer htmlAdaptorServer, MBeanServer mBeanServer, ObjectName objectName, int n) {
        super(htmlAdaptorServer, n, mBeanServer, objectName);
        this.sockClient = socket;
        this.thread.start();
    }

    protected boolean authenticateRequest(HttpRequest httpRequest) throws IOException {
        if (this.isTraceOn()) {
            this.trace("authenticateRequest", "Authenticate the HTML request, using the 'Basic Authentication Scheme'");
        }
        boolean bl = true;
        HtmlAdaptorServer htmlAdaptorServer = (HtmlAdaptorServer)this.adaptorServer;
        if (htmlAdaptorServer.isAuthenticationOn()) {
            if (httpRequest.authorization == null || !httpRequest.authorization.startsWith("Basic ")) {
                bl = false;
            } else {
                String string = httpRequest.authorization.substring(6);
                byte[] byArray = new BASE64Decoder().decodeBuffer(string);
                String string2 = new String(byArray);
                bl = htmlAdaptorServer.checkChallengeResponse(string2);
            }
        }
        return bl;
    }

    public void doRun() {
        Object object2;
        if (this.isTraceOn()) {
            this.trace("doRun", "Start Html request handler");
        }
        try {
            block24: {
                try {
                    object2 = new HttpRequest(new HttpBody());
                    boolean bl = true;
                    while (bl) {
                        HttpResponse httpResponse = null;
                        try {
                            ((HttpRequest)object2).readFrom(this.sockClient.getInputStream());
                            httpResponse = this.processRequest((HttpRequest)object2);
                        }
                        catch (MalformedHttpException malformedHttpException) {
                            if (this.isDebugOn()) {
                                this.debug("doRun", "Malformed HTTP request rejected. [Exception=" + malformedHttpException + "]");
                            }
                            httpResponse = this.makeErrorResponse(400);
                        }
                        httpResponse.writeTo(this.sockClient.getOutputStream());
                        boolean bl2 = bl = ((HttpMessage)object2).hasKeepAliveFlag() && httpResponse.statusCode == 200 && !this.interruptCalled;
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (this.isDebugOn()) {
                        this.debug("doRun", "Request handler interrupted");
                    }
                }
                catch (EOFException eOFException) {
                    if (this.isDebugOn()) {
                        this.debug("doRun", "Connection closed by peer");
                    }
                }
                catch (SocketException socketException) {
                    if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                        if (this.isDebugOn()) {
                            this.debug("doRun", "Request handler interrupted");
                        }
                    } else if (this.isDebugOn()) {
                        this.debug("doRun", "I/O exception. [Exception=" + socketException + "]");
                    }
                }
                catch (IOException iOException) {
                    if (!this.isDebugOn()) break block24;
                    this.debug("doRun", "I/O exception. [Exception=" + iOException + "]");
                }
            }
            Object var2_8 = null;
        }
        catch (Throwable throwable) {
            block26: {
                Object var2_9 = null;
                try {
                    this.sockClient.close();
                    if (this.isDebugOn()) {
                        this.debug("doRun", "Socket is now closed");
                    }
                }
                catch (IOException iOException) {
                    if (!this.isDebugOn()) break block26;
                    this.debug("doRun", "Socket closed with [Exception=" + iOException + "]");
                }
            }
            throw throwable;
        }
        try {
            this.sockClient.close();
            if (this.isDebugOn()) {
                this.debug("doRun", "Socket is now closed");
            }
        }
        catch (IOException object2) {
            if (this.isDebugOn()) {
                this.debug("doRun", "Socket closed with [Exception=" + object2 + "]");
            }
        }
    }

    protected String makeDebugTag() {
        return "HtmlRequestHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "][" + this.requestId + "]";
    }

    protected HttpResponse makeErrorResponse(int n) {
        return this.makeErrorResponse(n, null);
    }

    protected HttpResponse makeErrorResponse(int n, String string) {
        String string2 = new String("<HTML>\r\n<BODY>\r\n<HR><P><FONT SIZE=+3 COLOR=red><B>" + n + "</B></FONT><P>" + "\r\n" + "<HR><P>" + string + "</P>" + "\r\n" + "</BODY>" + "\r\n" + "</HTML>" + "\r\n");
        HttpResponse httpResponse = new HttpResponse(new HttpBody(string2.getBytes()));
        httpResponse.statusCode = n;
        httpResponse.contentType = "text/html";
        httpResponse.date = new Date().toString();
        httpResponse.server = "JDMK4.1/Java2";
        httpResponse.wwwAuthenticate = n == 401 ? "Basic realm=\"JDMK\"" : null;
        return httpResponse;
    }

    protected HttpResponse makeOkResponse(String string) {
        HttpBody httpBody = new HttpBody(string.getBytes());
        HttpResponse httpResponse = new HttpResponse(httpBody);
        httpResponse.statusCode = 200;
        httpResponse.contentType = "text/html";
        httpResponse.date = new Date().toString();
        httpResponse.server = "JDMK4.1/Java2";
        return httpResponse;
    }

    protected HttpResponse processGetRequest(HttpRequest httpRequest) throws IOException {
        String string;
        int n;
        block45: {
            Object object;
            Object object2;
            HtmlAdaptorServer htmlAdaptorServer;
            String string2;
            block44: {
                string2 = httpRequest.getURIPath();
                n = 200;
                string = null;
                htmlAdaptorServer = (HtmlAdaptorServer)this.adaptorServer;
                Object var6_6 = null;
                if (this.isTraceOn()) {
                    this.trace("processGetRequest", "Process a GET request = " + string2);
                }
                if (htmlAdaptorServer.getParser() == null) break block44;
                object2 = new String[]{string2};
                object = new String[]{"java.lang.String"};
                try {
                    string = (String)this.mbs.invoke(htmlAdaptorServer.getParser(), "parseRequest", (Object[])object2, (String[])object);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if (this.isDebugOn()) {
                        this.debug("processGetRequest", "Invalid user's parser = " + instanceNotFoundException);
                    }
                    htmlAdaptorServer.resetParser();
                    return this.makeErrorResponse(459, "Instance Not Found<P>Invalid user's parser: " + htmlAdaptorServer.getParser().toString() + " is unknown");
                }
                catch (MBeanException mBeanException) {
                    if (this.isDebugOn()) {
                        this.debug("processGetRequest", "Parser exception = " + mBeanException.getTargetException());
                    }
                    htmlAdaptorServer.resetParser();
                    return this.makeErrorResponse(472, "MBean Failure<P>" + htmlAdaptorServer.getParser().toString() + " throws <BR>" + mBeanException.getTargetException());
                }
                catch (ReflectionException reflectionException) {
                    if (this.isDebugOn()) {
                        this.debug("processGetRequest", "MBeanServer reflection exception = " + reflectionException.getTargetException());
                    }
                    htmlAdaptorServer.resetParser();
                    return this.makeErrorResponse(470, "Reflection<P>MBeanServer throws:<BR>" + reflectionException.getTargetException() + "<BR> when reflecting: " + htmlAdaptorServer.getParser().toString());
                }
                if (string != null) break block45;
            }
            if (string2.startsWith("/Request/")) {
                object2 = string2.substring(9);
                if (((String)object2).equals("getDomain")) {
                    string = String.valueOf(this.mbs.getDefaultDomain()) + ":";
                } else {
                    n = 400;
                }
            } else if (string2.startsWith("/ViewObjectRes")) {
                object2 = string2.substring("/ViewObjectRes".length());
                object = new HtmlObjectPage(this.mbs, true, true, htmlAdaptorServer);
                ((HtmlObjectPage)object).buildPage((String)object2);
                string = ((HtmlPage)object).getPage();
            } else if (string2.startsWith("/AutoRefresh")) {
                object2 = string2.substring("/AutoRefresh".length());
                object = new HtmlObjectPage(this.mbs, true, true, htmlAdaptorServer);
                ((HtmlObjectPage)object).buildMeta((String)object2);
                ((HtmlObjectPage)object).buildPage(((String)object2).substring(0, ((String)object2).indexOf("?period=")));
                string = ((HtmlPage)object).getPage();
            } else if (string2.startsWith("/ViewProperty")) {
                object2 = string2.substring("/ViewProperty".length());
                object = new HtmlArrayPage(this.mbs, true, true, htmlAdaptorServer);
                ((HtmlArrayPage)object).buildPage((String)object2);
                string = ((HtmlPage)object).getPage();
            } else if (string2.startsWith("/SetForm")) {
                String string3 = string2.substring("/SetForm".length());
                int n2 = string3.indexOf(47, 1);
                int n3 = string3.indexOf(63);
                if (n2 < 0 || n3 < 0) {
                    n = 400;
                } else {
                    String string4 = string3.substring(n3);
                    string3 = string3.substring(0, n3);
                    HtmlObjectPage htmlObjectPage = new HtmlObjectPage(this.mbs, true, true, htmlAdaptorServer);
                    if (this.isTraceOn()) {
                        this.trace("processGetRequest", "SetForm for [objName=" + string3 + " ,request=" + string4 + "]");
                    }
                    if (!htmlObjectPage.setObjectValue(string3, string4)) {
                        string = htmlObjectPage.getPage();
                    } else {
                        htmlObjectPage.buildPage(string3);
                        string = htmlObjectPage.getPage();
                    }
                }
            } else if (string2.startsWith("/Admin")) {
                object2 = string2.substring("/Admin".length());
                object2 = ((String)object2).trim();
                object = new HtmlAdminPage(this.mbs, true, true);
                ((HtmlAdminPage)object).buildPage((String)object2);
                string = ((HtmlPage)object).getPage();
            } else if (string2.startsWith("/InvokeAction")) {
                object2 = string2.substring("/InvokeAction".length());
                object2 = ((String)object2).trim();
                object = new HtmlInvokePage(this.mbs, true, true);
                ((HtmlInvokePage)object).buildPage((String)object2);
                string = ((HtmlPage)object).getPage();
            } else if (string2.equals("/") || string2.startsWith("/Filter")) {
                object2 = new HtmlMasterPage(this.mbs, true, true);
                ((HtmlMasterPage)object2).buildPage(string2);
                string = ((HtmlPage)object2).getPage();
            } else {
                n = 400;
            }
            if (htmlAdaptorServer.getParser() != null) {
                Object[] objectArray = new String[]{string};
                String[] stringArray = new String[]{"java.lang.String"};
                try {
                    string = (String)this.mbs.invoke(htmlAdaptorServer.getParser(), "parsePage", objectArray, stringArray);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if (this.isDebugOn()) {
                        this.debug("processGetRequest", "Invalid user's parser [" + instanceNotFoundException + "]");
                    }
                    htmlAdaptorServer.resetParser();
                    return this.makeErrorResponse(459, "Instance Not Found<P>Invalid user's parser:" + htmlAdaptorServer.getParser().toString() + " is unknown");
                }
                catch (MBeanException mBeanException) {
                    if (this.isDebugOn()) {
                        this.debug("processGetRequest", "Parser exception. [Exception=" + mBeanException.getTargetException() + "]");
                    }
                    htmlAdaptorServer.resetParser();
                    return this.makeErrorResponse(472, "MBean Failure<P>" + htmlAdaptorServer.getParser().toString() + " throws <BR>" + mBeanException.getTargetException());
                }
                catch (ReflectionException reflectionException) {
                    if (this.isDebugOn()) {
                        this.debug("processGetRequest", "MBeanServer reflection. [Exception=" + reflectionException.getTargetException() + "]");
                    }
                    htmlAdaptorServer.resetParser();
                    return this.makeErrorResponse(470, "Reflection<P>MBeanServer throws:<BR>" + reflectionException.getTargetException() + "<BR> when reflecting: " + htmlAdaptorServer.getParser().toString());
                }
            }
        }
        if (string != null && n == 200) {
            return this.makeOkResponse(string);
        }
        if (this.isDebugOn()) {
            this.debug("processGetRequest", "Bad request: request not supported or HTML page empty");
        }
        return this.makeErrorResponse(400);
    }

    protected HttpResponse processRequest(HttpRequest httpRequest) throws IOException {
        if (this.isTraceOn()) {
            this.trace("processRequest", "Process the Html request");
        }
        HttpResponse httpResponse = null;
        if (!this.authenticateRequest(httpRequest)) {
            if (this.isTraceOn()) {
                this.trace("processRequest", "Authentication failed");
            }
            httpResponse = this.makeErrorResponse(401);
        } else if (httpRequest.method == 1) {
            httpResponse = this.processGetRequest(httpRequest);
        } else {
            if (this.isTraceOn()) {
                this.trace("processRequest", "Bad request: request not supported");
            }
            httpResponse = this.makeErrorResponse(400);
        }
        httpResponse.connection = httpRequest.connection;
        return httpResponse;
    }
}

