/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ClientHandler;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.GenericHttpNotificationReceiver;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpBody;
import com.sun.jdmk.comm.HttpRequest;
import com.sun.jdmk.comm.HttpResponse;
import com.sun.jdmk.comm.MalformedHttpException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.SocketException;
import java.util.Date;

class GenericHttpNotificationReceiverHandler
extends ClientHandler {
    private GenericHttpSocket sockClient = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";

    public GenericHttpNotificationReceiverHandler(GenericHttpNotificationReceiver genericHttpNotificationReceiver, int n, GenericHttpSocket genericHttpSocket) {
        super(genericHttpNotificationReceiver, n, null, null);
        this.sockClient = genericHttpSocket;
        this.thread.start();
    }

    private void closeClient() {
        if (this.isTraceOn()) {
            this.trace("closeClient", "Close client ...");
        }
        if (this.sockClient != null) {
            try {
                try {
                    this.sockClient.doDisconnect();
                }
                catch (IOException iOException) {
                }
                catch (CommunicationException communicationException) {
                }
                Object var2_1 = null;
                this.sockClient = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.sockClient = null;
                throw throwable;
            }
        }
    }

    public void doRun() {
        try {
            block19: {
                try {
                    HttpRequest httpRequest = new HttpRequest(new HttpBody());
                    boolean bl = true;
                    while (bl) {
                        HttpResponse httpResponse = null;
                        try {
                            httpRequest.readFrom(this.sockClient.doGetInputStream());
                            httpResponse = this.processRequest(httpRequest);
                        }
                        catch (MalformedHttpException malformedHttpException) {
                            if (this.isDebugOn()) {
                                this.debug("doRun", "Malformed HTTP request rejected");
                            }
                            httpResponse = this.makeErrorResponse(400, "Bad Request");
                        }
                        httpResponse.connection = httpRequest.connection;
                        httpResponse.writeTo(this.sockClient.doGetOutputStream());
                        boolean bl2 = bl = httpResponse.hasKeepAliveFlag() && !this.interruptCalled;
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (this.isDebugOn()) {
                        this.debug("doRun", "Request handler interrupted");
                    }
                }
                catch (EOFException eOFException) {
                    if (this.isDebugOn()) {
                        this.debug("doRun", "Connection closed by peer");
                    }
                }
                catch (SocketException socketException) {
                    if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                        if (this.isDebugOn()) {
                            this.debug("doRun", "Request handler interrupted");
                        }
                    } else if (this.isDebugOn()) {
                        this.debug("doRun", "I/O exception " + socketException);
                    }
                }
                catch (IOException iOException) {
                    if (!this.isDebugOn()) break block19;
                    this.debug("doRun", "I/O exception " + iOException);
                }
            }
            Object var2_6 = null;
            this.closeClient();
            if (this.isDebugOn()) {
                this.debug("doRun", "Socket is now closed");
            }
        }
        catch (Throwable throwable) {
            Object var2_7 = null;
            this.closeClient();
            if (this.isDebugOn()) {
                this.debug("doRun", "Socket is now closed");
            }
            throw throwable;
        }
    }

    protected String makeDebugTag() {
        return "GenericHttpNotificationReceiverHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "][" + this.requestId + "]";
    }

    protected HttpResponse makeErrorResponse(int n, String string) {
        HttpResponse httpResponse = new HttpResponse(new HttpBody());
        httpResponse.statusCode = n;
        httpResponse.reasonPhrase = string;
        httpResponse.contentType = "application/octet-stream";
        httpResponse.date = new Date().toString();
        httpResponse.server = "JDMK4.1/Java2";
        return httpResponse;
    }

    protected HttpResponse makeExceptionResponse(Exception exception) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = this.serialize("Exception", exception);
        }
        catch (IOException iOException) {
            this.makeErrorResponse(400, "Bad Request");
        }
        HttpBody httpBody = new HttpBody(byteArrayOutputStream.toByteArray());
        HttpResponse httpResponse = new HttpResponse(httpBody);
        httpResponse.statusCode = 400;
        httpResponse.reasonPhrase = "Bad Request";
        httpResponse.contentType = "application/octet-stream";
        httpResponse.date = new Date().toString();
        httpResponse.server = "JDMK4.1/Java2";
        return httpResponse;
    }

    protected HttpResponse makeOkResponse(byte[] byArray) {
        HttpBody httpBody = new HttpBody(byArray);
        HttpResponse httpResponse = new HttpResponse(httpBody);
        httpResponse.statusCode = 200;
        httpResponse.reasonPhrase = "OK";
        httpResponse.contentType = "application/octet-stream";
        httpResponse.date = new Date().toString();
        httpResponse.server = "JDMK4.1/Java2";
        return httpResponse;
    }

    protected HttpResponse processPostRequest(HttpRequest httpRequest) throws IOException {
        String string = null;
        Integer n = null;
        Object[] objectArray = null;
        if (this.isTraceOn()) {
            this.trace("processPostRequest", "Process a POST request = " + httpRequest.getURIPath());
        }
        if (httpRequest.contentLength == 0) {
            return this.makeErrorResponse(400, "Bad Request");
        }
        Object[] objectArray2 = null;
        String string2 = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(httpRequest.body.getBytes());
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            string = (String)objectInputStream.readObject();
            if (this.isTraceOn()) {
                this.trace("doRun", "Remote operation: " + string);
            }
            if (!string.equals("remoteRequest")) {
                if (this.isTraceOn()) {
                    this.trace("doRun", "Unknown remote operation: " + string);
                }
                return this.makeErrorResponse(400, "Bad Request");
            }
            n = (Integer)objectInputStream.readObject();
            objectArray = (Object[])objectInputStream.readObject();
            objectArray2 = this.remoteRequest(n, objectArray);
            string2 = "Object[]";
        }
        catch (Exception exception) {
            if (this.isTraceOn()) {
                this.trace("doRun", String.valueOf(string) + ":" + exception.getMessage());
            }
            return this.makeExceptionResponse(exception);
        }
        byteArrayOutputStream = this.serialize(string2, objectArray2);
        return this.makeOkResponse(byteArrayOutputStream.toByteArray());
    }

    protected HttpResponse processRequest(HttpRequest httpRequest) throws IOException {
        if (this.isTraceOn()) {
            this.trace("processRequest", "Process the HTTP request");
        }
        HttpResponse httpResponse = null;
        if (httpRequest.method == 2) {
            httpResponse = this.processPostRequest(httpRequest);
        } else {
            if (this.isDebugOn()) {
                this.debug("processRequest", "Bad request: Request method not supported");
            }
            httpResponse = this.makeErrorResponse(400, "Bad Request");
        }
        return httpResponse;
    }

    private Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        if (this.isTraceOn()) {
            this.trace("remoteRequest", "remoteRequest");
        }
        GenericHttpNotificationReceiver genericHttpNotificationReceiver = (GenericHttpNotificationReceiver)this.adaptorServer;
        return genericHttpNotificationReceiver.dispatcher.remoteRequest(n, objectArray);
    }

    private ByteArrayOutputStream serialize(String string, Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(string);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream;
    }
}

