/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.GenericProxy;
import com.sun.jdmk.Proxy;
import com.sun.jdmk.ProxyMBeanInstantiationException;
import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.AuthSchemeInfo;
import com.sun.jdmk.comm.BASE64Decoder;
import com.sun.jdmk.comm.BASE64Encoder;
import com.sun.jdmk.comm.ClientNotificationDispatcher;
import com.sun.jdmk.comm.ClientNotificationHandlerInternal;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.DefaultMapper;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpNotificationReceiver;
import com.sun.jdmk.comm.GenericHttpSocketFactory;
import com.sun.jdmk.comm.HeartBeatClientHandler;
import com.sun.jdmk.comm.HeartBeatClientHandlerImpl;
import com.sun.jdmk.comm.HeartBeatInternalClientHandler;
import com.sun.jdmk.comm.Mapper;
import com.sun.jdmk.comm.RemoteMBeanServer;
import com.sun.jdmk.comm.UnauthorizedSecurityException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public abstract class GenericHttpConnectorClient
implements RemoteMBeanServer,
HeartBeatClientHandler,
Serializable {
    transient Hashtable authSchemeInfoList = null;
    transient GenericHttpConnectorAddress httpConnAddr = null;
    transient GenericHttpSocketFactory factory = null;
    private transient boolean connected = false;
    private String mbeanServerId = null;
    private transient Mapper mapper = null;
    private transient Mapper defaultMapper = null;
    private transient ClassLoader classloader = null;
    private transient Hashtable proxyHandles = new Hashtable();
    private transient Hashtable genericHandles = new Hashtable();
    private GenericHttpNotificationReceiver notificationReceiver = null;
    private ClientNotificationDispatcher notificationClientHandler = null;
    private HeartBeatClientHandlerImpl heartbeatClientHandler = null;

    public GenericHttpConnectorClient() {
        this.factory = this.getSocketFactory();
        this.mapper = this.defaultMapper = new DefaultMapper();
        this.notificationClientHandler = new ClientNotificationDispatcher(new NotificationHandlerInternal(this));
        this.heartbeatClientHandler = new HeartBeatClientHandlerImpl(new HeartBeatInternalClientHandlerImpl(this), this.notificationClientHandler);
    }

    /*
     * Unable to fully structure code
     */
    private String HMAC_MD5(byte[] var1_1, byte[] var2_2) {
        var3_3 = 64;
        var4_4 = null;
        try {
            var4_4 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException v0) {}
        if (var2_2.length > 64) {
            var2_2 = var4_4.digest(var2_2);
        }
        var5_5 = new byte[64];
        var6_6 = new byte[64];
        var8_7 = 0;
        ** GOTO lbl21
        {
            var5_5[var8_7] = var2_2[var8_7];
            var6_6[var8_7] = var2_2[var8_7];
            ++var8_7;
            do {
                if (var8_7 < var2_2.length) continue block2;
                var5_5[var8_7] = 0;
                var6_6[var8_7] = 0;
                ++var8_7;
lbl21:
                // 2 sources

            } while (var8_7 < 64);
        }
        var8_7 = 0;
        while (var8_7 < 64) {
            v1 = var8_7;
            var5_5[v1] = (byte)(var5_5[v1] ^ 54);
            v2 = var8_7++;
            var6_6[v2] = (byte)(var6_6[v2] ^ 92);
        }
        var4_4.update(var5_5);
        var4_4.update(var1_1);
        var7_8 = var4_4.digest();
        var4_4.update(var6_6);
        var4_4.update(var7_8);
        var7_8 = var4_4.digest();
        var9_9 = new StringBuffer();
        var8_7 = 0;
        while (var8_7 < var7_8.length) {
            if ((var7_8[var8_7] & 255) < 16) {
                var9_9.append("0" + Integer.toHexString(var7_8[var8_7] & 255));
            } else {
                var9_9.append(Integer.toHexString(var7_8[var8_7] & 255));
            }
            ++var8_7;
        }
        return var9_9.toString();
    }

    public void addHeartBeatNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (this.isTraceOn()) {
            this.trace("addHeartBeatNotificationListener", "addHeartBeatNotificationListener");
        }
        this.heartbeatClientHandler.addHeartBeatNotificationListener(notificationListener, notificationFilter, object);
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        if (this.isTraceOn()) {
            this.trace("addNotificationListener", "addNotificationListener");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.addNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    public void addProxy(Proxy proxy) {
        if (this.isTraceOn()) {
            this.trace("addProxy", "addProxy");
        }
        if (proxy == null) {
            throw new IllegalArgumentException("Cannot add null proxy reference to this ConnectorClient");
        }
        ObjectName objectName = proxy.getMBeanObjectInstance().getObjectName();
        if (proxy instanceof GenericProxy) {
            this.genericHandles.put(objectName, proxy);
        } else {
            this.proxyHandles.put(objectName, proxy);
        }
        proxy.setRemoteMBeanServer(this);
    }

    public void clearCache() {
        if (this.isTraceOn()) {
            this.trace("clearCache", "clearCache");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.clearCache();
    }

    public String connect(ConnectorAddress connectorAddress) {
        if (this.isTraceOn()) {
            this.trace("connect", "connect");
        }
        if (connectorAddress == null) {
            throw new IllegalArgumentException("mbeanServerAddress cannot be null");
        }
        if (!(connectorAddress instanceof GenericHttpConnectorAddress)) {
            throw new IllegalArgumentException("mbeanServerAddress must be an instance of GenericHttpConnectorAddress");
        }
        if (this.connected) {
            throw new CommunicationException("ConnectorClient already connected to RemoteMBeanServer");
        }
        this.httpConnAddr = (GenericHttpConnectorAddress)((GenericHttpConnectorAddress)connectorAddress).clone();
        AuthInfo authInfo = this.httpConnAddr.getAuthInfo();
        if (authInfo != null) {
            if (authInfo.getLogin() == null || authInfo.getPassword() == null) {
                throw new IllegalArgumentException("Login/Password cannot be null");
            }
            this.authSchemeInfoList = new Hashtable();
        }
        String string = null;
        try {
            string = this.getMBeanServerId2();
        }
        catch (UnauthorizedSecurityException unauthorizedSecurityException) {
            throw unauthorizedSecurityException;
        }
        catch (CommunicationException communicationException) {
            throw communicationException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception, "Connection failed");
        }
        if (this.mbeanServerId != null) {
            if (!this.mbeanServerId.equals(string)) {
                throw new IllegalArgumentException("ConnectorClient trying to connect to a different RemoteMBeanServer");
            }
        } else {
            this.mbeanServerId = string;
        }
        this.heartbeatClientHandler.notifyConnectionEstablished();
        this.heartbeatClientHandler.startPinging();
        this.connected = true;
        return this.mbeanServerId;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        if (this.isTraceOn()) {
            this.trace("createMBean", "createMBean");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add("createMBean");
        arrayList.add(string);
        arrayList.add(objectName);
        try {
            return (ObjectInstance)this.invokeRemoteOperation(arrayList);
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw notCompliantMBeanException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("createMBean", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("createMBean", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        if (this.isTraceOn()) {
            this.trace("createMBean", "createMBean");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(4);
        arrayList.add("createMBeanLoader");
        arrayList.add(string);
        arrayList.add(objectName);
        arrayList.add(objectName2);
        try {
            return (ObjectInstance)this.invokeRemoteOperation(arrayList);
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw notCompliantMBeanException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("createMBean", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("createMBean", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        if (this.isTraceOn()) {
            this.trace("createMBean", "createMBean");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(6);
        arrayList.add("createMBeanLoaderParams");
        arrayList.add(string);
        arrayList.add(objectName);
        arrayList.add(objectName2);
        arrayList.add(objectArray);
        arrayList.add(stringArray);
        try {
            return (ObjectInstance)this.invokeRemoteOperation(arrayList);
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw notCompliantMBeanException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("createMBean", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("createMBean", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        if (this.isTraceOn()) {
            this.trace("createMBean", "createMBean");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(5);
        arrayList.add("createMBeanParams");
        arrayList.add(string);
        arrayList.add(objectName);
        arrayList.add(objectArray);
        arrayList.add(stringArray);
        try {
            return (ObjectInstance)this.invokeRemoteOperation(arrayList);
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw notCompliantMBeanException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("createMBean", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("createMBean", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    private void debug(String string, String string2) {
        Trace.send(2, 3856, "GenericHttpConnectorClient", string, string2);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 3856, string, string2, string3);
    }

    public void disconnect() {
        if (this.isTraceOn()) {
            this.trace("disconnect", "disconnect");
        }
        if (this.connected) {
            this.notificationClientHandler.stopListening();
            this.heartbeatClientHandler.stopPinging(-1);
            this.heartbeatClientHandler.notifyConnectionTerminated();
            this.httpConnAddr = null;
            this.authSchemeInfoList = null;
            this.connected = false;
        }
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (this.isTraceOn()) {
            this.trace("getAttribute", "getAttribute");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add("getAttribute");
        arrayList.add(objectName);
        arrayList.add(string);
        try {
            return this.invokeRemoteOperation(arrayList);
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw attributeNotFoundException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("getAttribute", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("getAttribute", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException {
        if (this.isTraceOn()) {
            this.trace("getAttributes", "getAttributes");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add("getAttributes");
        arrayList.add(objectName);
        arrayList.add(stringArray);
        try {
            return (AttributeList)this.invokeRemoteOperation(arrayList);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("getAttributes", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("getAttributes", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    public int getCacheSize() {
        if (this.isTraceOn()) {
            this.trace("getCacheSize", "getCacheSize");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getCacheSize();
    }

    public String getClassForProxyMBean(ObjectInstance objectInstance) throws ProxyMBeanInstantiationException {
        if (this.isTraceOn()) {
            this.trace("getClassForProxyMBean", "getClassForProxyMBean");
        }
        if (objectInstance == null) {
            throw new IllegalArgumentException("ObjectInstance cannot be null");
        }
        return this.mapper.getClassForProxyMBean(objectInstance);
    }

    public ClassLoader getClassLoader() {
        if (this.isTraceOn()) {
            this.trace("getClassLoader", "getClassLoader");
        }
        return this.classloader;
    }

    public String getDefaultDomain() {
        if (this.isTraceOn()) {
            this.trace("getDefaultDomain", "getDefaultDomain");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("getDefaultDomain");
        try {
            return (String)this.invokeRemoteOperation(arrayList);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("getDefaultDomain", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("getDefaultDomain", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    public Set getGenericProxies(Set set) {
        if (this.isTraceOn()) {
            this.trace("getGenericProxies", "getGenericProxies");
        }
        if (set == null) {
            throw new IllegalArgumentException("Set of ObjectInstance cannot be null");
        }
        HashSet<GenericProxy> hashSet = new HashSet<GenericProxy>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectInstance objectInstance = (ObjectInstance)iterator.next();
            hashSet.add(this.getGenericProxy(objectInstance));
        }
        return hashSet;
    }

    public GenericProxy getGenericProxy(ObjectInstance objectInstance) {
        if (this.isTraceOn()) {
            this.trace("getGenericProxy", "getGenericProxy");
        }
        if (objectInstance == null) {
            throw new IllegalArgumentException("ObjectInstance cannot be null");
        }
        GenericProxy genericProxy = (GenericProxy)this.genericHandles.get(objectInstance.getObjectName());
        if (genericProxy != null) {
            return genericProxy;
        }
        genericProxy = new GenericProxy(objectInstance);
        genericProxy.bind(this);
        return genericProxy;
    }

    public int getHeartBeatPeriod() {
        if (this.isTraceOn()) {
            this.trace("getHeartBeatPeriod", "getHeartBeatPeriod");
        }
        return this.heartbeatClientHandler.getHeartBeatPeriod();
    }

    public int getHeartBeatRetries() {
        if (this.isTraceOn()) {
            this.trace("getHeartBeatRetries", "getHeartBeatRetries");
        }
        return this.heartbeatClientHandler.getHeartBeatRetries();
    }

    public Integer getMBeanCount() {
        if (this.isTraceOn()) {
            this.trace("getMBeanCount", "getMBeanCount");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("getMBeanCount");
        try {
            return (Integer)this.invokeRemoteOperation(arrayList);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("getMBeanCount", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("getMBeanCount", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (this.isTraceOn()) {
            this.trace("getMBeanInfo", "getMBeanInfo");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add("getMBeanInfo");
        arrayList.add(objectName);
        try {
            return (MBeanInfo)this.invokeRemoteOperation(arrayList);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (IntrospectionException introspectionException) {
            throw introspectionException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("getMBeanInfo", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("getMBeanInfo", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    public ConnectorAddress getMBeanServerAddress() {
        if (this.isTraceOn()) {
            this.trace("getMBeanServerAddress", "getMBeanServerAddress");
        }
        if (!this.connected) {
            return null;
        }
        return this.httpConnAddr;
    }

    public String getMBeanServerId() {
        if (this.isTraceOn()) {
            this.trace("getMBeanServerId", "getMBeanServerId");
        }
        return this.mbeanServerId;
    }

    private String getMBeanServerId2() {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("getMBeanServerId");
        try {
            return (String)this.invokeRemoteOperation(arrayList);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("getMBeanServerId", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("getMBeanServerId", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    public Mapper getMapper() {
        if (this.isTraceOn()) {
            this.trace("getMapper", "getMapper");
        }
        if (this.mapper == this.defaultMapper) {
            return null;
        }
        return this.mapper;
    }

    public int getMode() {
        if (this.isTraceOn()) {
            this.trace("getMode", "getMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getMode();
    }

    abstract GenericHttpNotificationReceiver getNotificationReceiver(GenericHttpConnectorClient var1, ClientNotificationDispatcher var2);

    public void getNotifications() {
        if (this.isTraceOn()) {
            this.trace("getNotifications", "getNotifications");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.getNotifications();
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        if (this.isTraceOn()) {
            this.trace("getObjectInstance", "getObjectInstance");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add("getObjectInstance");
        arrayList.add(objectName);
        try {
            return (ObjectInstance)this.invokeRemoteOperation(arrayList);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("getObjectInstance", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("getObjectInstance", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    public int getOverflowCount() {
        if (this.isTraceOn()) {
            this.trace("getOverflowCount", "getOverflowCount");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getOverflowCount();
    }

    public int getOverflowMode() {
        if (this.isTraceOn()) {
            this.trace("getOverflowMode", "getOverflowMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getOverflowMode();
    }

    public int getPeriod() {
        if (this.isTraceOn()) {
            this.trace("getPeriod", "getPeriod");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.getPeriod();
    }

    public Proxy getProxyMBean(ObjectInstance objectInstance) throws ProxyMBeanInstantiationException {
        if (this.isTraceOn()) {
            this.trace("getProxyMBean", "getProxyMBean");
        }
        if (objectInstance == null) {
            throw new IllegalArgumentException("ObjectInstance cannot be null");
        }
        Proxy proxy = (Proxy)this.proxyHandles.get(objectInstance.getObjectName());
        if (proxy != null) {
            return proxy;
        }
        String string = this.getClassForProxyMBean(objectInstance);
        Class<?> clazz = null;
        try {
            clazz = this.classloader == null ? Class.forName(string) : this.classloader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ProxyMBeanInstantiationException(classNotFoundException);
        }
        try {
            Class[] classArray = new Class[]{objectInstance.getClass()};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{objectInstance};
            proxy = (Proxy)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new ProxyMBeanInstantiationException(exception, "Cannot create object " + clazz.toString());
        }
        proxy.bind(this);
        return proxy;
    }

    public Set getProxyMBeans(Set set) throws ProxyMBeanInstantiationException {
        if (this.isTraceOn()) {
            this.trace("getProxyMBeans", "getProxyMBeans");
        }
        if (set == null) {
            throw new IllegalArgumentException("Set of ObjectInstance cannot be null");
        }
        HashSet<Proxy> hashSet = new HashSet<Proxy>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectInstance objectInstance = (ObjectInstance)iterator.next();
            hashSet.add(this.getProxyMBean(objectInstance));
        }
        return hashSet;
    }

    abstract GenericHttpSocketFactory getSocketFactory();

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (this.isTraceOn()) {
            this.trace("invoke", "invoke");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(5);
        arrayList.add("invoke");
        arrayList.add(objectName);
        arrayList.add(string);
        arrayList.add(objectArray);
        arrayList.add(stringArray);
        try {
            return this.invokeRemoteOperation(arrayList);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("invoke", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("invoke", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    private Object invokeRemoteOperation(ArrayList arrayList) throws Exception {
        byte[] byArray = this.sendHttp(arrayList, false);
        if (byArray.length == 0) {
            throw new IllegalAccessException("Entity Body in HTTP Response is empty");
        }
        Object object = this.readObjectValue(byArray);
        if (object instanceof Exception) {
            throw (Exception)object;
        }
        return object;
    }

    public boolean isConnected() {
        if (this.isTraceOn()) {
            this.trace("isConnected", "isConnected");
        }
        return this.connected;
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 3856);
    }

    public boolean isRegistered(ObjectName objectName) {
        if (this.isTraceOn()) {
            this.trace("isRegistered", "isRegistered");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add("isRegistered");
        arrayList.add(objectName);
        try {
            return (Boolean)this.invokeRemoteOperation(arrayList);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("isRegistered", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("isRegistered", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 3856);
    }

    String pingHeartBeatServer(String string, int n, int n2, Long l) {
        if (this.isTraceOn()) {
            this.trace("pingHeartBeatServer", "pingHeartBeatServer");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(5);
        arrayList.add("pingHeartBeatServer");
        arrayList.add(string);
        arrayList.add(new Integer(n));
        arrayList.add(new Integer(n2));
        arrayList.add(l);
        try {
            return (String)this.invokeRemoteOperation(arrayList);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("pingHeartBeatServer", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("pingHeartBeatServer", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        if (this.isTraceOn()) {
            this.trace("queryMBeans", "queryMBeans");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add("queryMBeans");
        arrayList.add(objectName);
        arrayList.add(queryExp);
        try {
            return (Set)this.invokeRemoteOperation(arrayList);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("queryMBeans", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("queryMBeans", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        if (this.isTraceOn()) {
            this.trace("queryNames", "queryNames");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add("queryNames");
        arrayList.add(objectName);
        arrayList.add(queryExp);
        try {
            return (Set)this.invokeRemoteOperation(arrayList);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("queryNames", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("queryNames", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    private Object readObjectValue(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        String string = (String)objectInputStream.readObject();
        if (this.isDebugOn()) {
            this.debug("readObjectValue", "Received object of type " + string);
        }
        return objectInputStream.readObject();
    }

    Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        if (this.isTraceOn()) {
            this.trace("remoteRequest", "remoteRequest");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add("remoteRequest");
        arrayList.add(new Integer(n));
        arrayList.add(objectArray);
        try {
            return (Object[])this.invokeRemoteOperation(arrayList);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            throw listenerNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("remoteRequest", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("remoteRequest", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    public void removeHeartBeatNotificationListener(NotificationListener notificationListener) {
        if (this.isTraceOn()) {
            this.trace("removeHeartBeatNotificationListener", "removeHeartBeatNotificationListener");
        }
        this.heartbeatClientHandler.removeHeartBeatNotificationListener(notificationListener);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.isTraceOn()) {
            this.trace("removeNotificationListener", "removeNotificationListener");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.removeNotificationListener(objectName, notificationListener);
    }

    public void removeProxy(Proxy proxy) {
        if (this.isTraceOn()) {
            this.trace("removeProxy", "removeProxy");
        }
        if (proxy == null) {
            throw new IllegalArgumentException("Cannot remove null proxy reference from this ConnectorClient");
        }
        ObjectName objectName = proxy.getMBeanObjectInstance().getObjectName();
        if (proxy instanceof GenericProxy) {
            this.genericHandles.remove(objectName);
        } else {
            this.proxyHandles.remove(objectName);
        }
    }

    private byte[] sendHttp(ArrayList arrayList, boolean bl) throws Exception {
        Object object;
        block28: {
            Object object2;
            Object object32;
            String string;
            Object object4;
            Object object5;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            Iterator iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                objectOutputStream.writeObject(iterator.next());
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (this.authSchemeInfoList != null) {
                if (this.authSchemeInfoList.get(Thread.currentThread()) == null) {
                    this.authSchemeInfoList.put(Thread.currentThread(), new AuthSchemeInfo("CRAM-MD5"));
                }
                if ((object5 = (AuthSchemeInfo)this.authSchemeInfoList.get(Thread.currentThread())) != null && (object = ((AuthSchemeInfo)object5).getChallenge()) != null) {
                    object4 = new String();
                    try {
                        object = ((String)object).substring((String.valueOf(((AuthSchemeInfo)object5).getAuthScheme()) + " ").length());
                        byte[] byArray2 = new BASE64Decoder().decodeBuffer((String)object);
                        string = this.httpConnAddr.getAuthInfo().getLogin();
                        object32 = this.httpConnAddr.getAuthInfo().getPassword().getBytes();
                        object2 = this.HMAC_MD5(byArray2, (byte[])object32);
                        String string2 = String.valueOf(string) + " " + (String)object2;
                        int n = 57;
                        String string3 = null;
                        int n2 = string2.length() / 57;
                        int n3 = string2.length() % 57;
                        int n4 = 0;
                        while (n4 < n2) {
                            string3 = string2.substring(n4 * 57, (n4 + 1) * 57);
                            object4 = String.valueOf(object4) + new BASE64Encoder().encode(string3.getBytes());
                            ++n4;
                        }
                        if (n3 > 0) {
                            string3 = string2.substring(n2 * 57);
                            object4 = String.valueOf(object4) + new BASE64Encoder().encode(string3.getBytes());
                        }
                    }
                    catch (IOException iOException) {}
                    ((AuthSchemeInfo)object5).setResponse(String.valueOf(((AuthSchemeInfo)object5).getAuthScheme()) + " " + (String)object4);
                    ((AuthSchemeInfo)object5).setChallenge(null);
                }
            }
            object5 = null;
            object = null;
            try {
                try {
                    int n;
                    object5 = this.factory.createSocket(this.httpConnAddr.getHost(), this.httpConnAddr.getPort(), this);
                    object32 = ((Socket)object5).getOutputStream();
                    if (byArray.length != 0) {
                        ((OutputStream)object32).write(byArray);
                    }
                    ((OutputStream)object32).flush();
                    object2 = ((Socket)object5).getInputStream();
                    object = new ByteArrayOutputStream();
                    while ((n = ((InputStream)object2).read()) != -1) {
                        ((ByteArrayOutputStream)object).write((byte)n);
                    }
                }
                catch (UnauthorizedSecurityException unauthorizedSecurityException) {
                    if (this.authSchemeInfoList == null || bl) {
                        throw unauthorizedSecurityException;
                    }
                    object4 = this.sendHttp(arrayList, true);
                    string = null;
                    if (object5 != null) {
                        try {
                            try {
                                ((Socket)object5).close();
                            }
                            catch (IOException iOException) {
                            }
                            object2 = null;
                            object5 = null;
                        }
                        catch (Throwable throwable) {
                            object2 = null;
                            object5 = null;
                            throw throwable;
                        }
                    }
                    return object4;
                }
                catch (Exception exception) {
                    throw exception;
                }
                string = null;
                if (object5 == null) break block28;
            }
            catch (Throwable throwable) {
                string = null;
                if (object5 != null) {
                    try {
                        try {
                            ((Socket)object5).close();
                        }
                        catch (IOException iOException) {
                        }
                        object2 = null;
                        object5 = null;
                    }
                    catch (Throwable object32) {
                        object2 = null;
                        object5 = null;
                        throw object32;
                    }
                }
                throw throwable;
            }
            try {
                try {
                    ((Socket)object5).close();
                }
                catch (IOException iOException) {
                }
                object2 = null;
                object5 = null;
            }
            catch (Throwable object32) {
                object2 = null;
                object5 = null;
                throw object32;
            }
        }
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.isTraceOn()) {
            this.trace("setAttribute", "setAttribute");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add("setAttribute");
        arrayList.add(objectName);
        arrayList.add(attribute);
        try {
            this.invokeRemoteOperation(arrayList);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw attributeNotFoundException;
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw invalidAttributeValueException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("setAttribute", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("setAttribute", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException {
        if (this.isTraceOn()) {
            this.trace("setAttributes", "setAttributes");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add("setAttributes");
        arrayList.add(objectName);
        arrayList.add(attributeList);
        try {
            return (AttributeList)this.invokeRemoteOperation(arrayList);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("setAttributes", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("setAttributes", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    public int setCacheSize(int n, boolean bl) throws JMRuntimeException {
        if (this.isTraceOn()) {
            this.trace("setCacheSize", "setCacheSize");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        return this.notificationClientHandler.setCacheSize(n, bl);
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (this.isTraceOn()) {
            this.trace("setClassLoader", "setClassLoader");
        }
        this.classloader = classLoader;
    }

    public void setHeartBeatPeriod(int n) {
        if (this.isTraceOn()) {
            this.trace("setHeartBeatPeriod", "setHeartBeatPeriod");
        }
        this.heartbeatClientHandler.setHeartBeatPeriod(n);
    }

    public void setHeartBeatRetries(int n) {
        if (this.isTraceOn()) {
            this.trace("setHeartBeatRetries", "setHeartBeatRetries");
        }
        this.heartbeatClientHandler.setHeartBeatRetries(n);
    }

    public void setMapper(Mapper mapper) {
        if (this.isTraceOn()) {
            this.trace("setMapper", "setMapper");
        }
        if (mapper == null) {
            mapper = this.defaultMapper;
        } else {
            this.mapper = mapper;
        }
    }

    public void setMode(int n) throws IllegalArgumentException {
        if (this.isTraceOn()) {
            this.trace("setMode", "setMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setMode(n);
    }

    public void setOverflowCount(int n) {
        if (this.isTraceOn()) {
            this.trace("setOverflowCount", "setOverflowCount");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setOverflowCount(n);
    }

    public void setOverflowMode(int n) throws IllegalArgumentException {
        if (this.isTraceOn()) {
            this.trace("setOverflowMode", "setOverflowMode");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setOverflowMode(n);
    }

    public void setPeriod(int n) {
        if (this.isTraceOn()) {
            this.trace("setPeriod", "setPeriod");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        this.notificationClientHandler.setPeriod(n);
    }

    ConnectorAddress startPush() {
        if (this.isTraceOn()) {
            this.trace("startPush", "startPush");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        if (this.notificationReceiver == null) {
            try {
                if (this.isDebugOn()) {
                    this.debug("startPush", "Create new NotificationReceiver");
                }
                this.notificationReceiver = this.getNotificationReceiver(this, this.notificationClientHandler);
            }
            catch (CommunicationException communicationException) {
                throw communicationException;
            }
            catch (Exception exception) {
                throw new CommunicationException(exception);
            }
        }
        if (this.isDebugOn()) {
            this.debug("startPush", "Start receiving events");
        }
        this.notificationReceiver.startListening();
        return this.notificationReceiver.getConnectorAddress();
    }

    void stopPush() {
        if (this.isTraceOn()) {
            this.trace("stopPush", "stopPush");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        if (this.notificationReceiver != null) {
            this.notificationReceiver.stopListening();
        }
    }

    private void trace(String string, String string2) {
        Trace.send(1, 3856, "GenericHttpConnectorClient", string, string2);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 3856, string, string2, string3);
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.isTraceOn()) {
            this.trace("unregisterMBean", "unregisterMBean");
        }
        if (!this.connected) {
            throw new CommunicationException("ConnectorClient not connected");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add("unregisterMBean");
        arrayList.add(objectName);
        try {
            this.invokeRemoteOperation(arrayList);
            this.proxyHandles.remove(objectName);
            this.genericHandles.remove(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("unregisterMBean", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("unregisterMBean", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    private class NotificationHandlerInternal
    implements ClientNotificationHandlerInternal {
        private GenericHttpConnectorClient connector;

        public NotificationHandlerInternal(GenericHttpConnectorClient genericHttpConnectorClient2) {
            this.connector = genericHttpConnectorClient2;
        }

        public Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
            return this.connector.remoteRequest(n, objectArray);
        }

        public ConnectorAddress startPush() {
            return this.connector.startPush();
        }

        public void stopPush(ConnectorAddress connectorAddress) {
            this.connector.stopPush();
        }
    }

    private class HeartBeatInternalClientHandlerImpl
    implements HeartBeatInternalClientHandler {
        private GenericHttpConnectorClient connector;

        public HeartBeatInternalClientHandlerImpl(GenericHttpConnectorClient genericHttpConnectorClient2) {
            this.connector = genericHttpConnectorClient2;
        }

        public RemoteMBeanServer getRemoteMBeanServer() {
            return this.connector;
        }

        public String pingHeartBeatServer(String string, int n, int n2, Long l) {
            return this.connector.pingHeartBeatServer(string, n, n2, l);
        }
    }
}

