/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.CommunicatorServer;
import javax.management.MBeanServer;
import javax.management.ObjectName;

abstract class ClientHandler
implements Runnable {
    protected CommunicatorServer adaptorServer = null;
    protected int requestId = -1;
    protected MBeanServer mbs = null;
    protected ObjectName objectName = null;
    protected Thread thread = null;
    protected boolean interruptCalled = false;
    protected String dbgTag = null;

    public ClientHandler(CommunicatorServer communicatorServer, int n, MBeanServer mBeanServer, ObjectName objectName) {
        this.adaptorServer = communicatorServer;
        this.requestId = n;
        this.mbs = mBeanServer;
        this.objectName = objectName;
        this.interruptCalled = false;
        this.dbgTag = this.makeDebugTag();
        this.thread = new Thread(this);
    }

    protected void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    protected void debug(String string, String string2, String string3) {
        Trace.send(2, 16, string, string2, string3);
    }

    public abstract void doRun();

    public void interrupt() {
        if (this.isTraceOn()) {
            this.trace("interrupt", "start");
        }
        this.interruptCalled = true;
        this.thread.interrupt();
        if (this.isTraceOn()) {
            this.trace("interrupt", "end");
        }
    }

    protected boolean isDebugOn() {
        return Trace.isSelected(2, 16);
    }

    protected boolean isTraceOn() {
        return Trace.isSelected(1, 16);
    }

    public void join() {
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    protected String makeDebugTag() {
        return "ClientHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "][" + this.requestId + "]";
    }

    public void run() {
        try {
            this.adaptorServer.notifyClientHandlerCreated(this);
            this.doRun();
        }
        finally {
            Object var2_1 = null;
            this.adaptorServer.notifyClientHandlerDeleted(this);
        }
    }

    protected void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    protected void trace(String string, String string2, String string3) {
        Trace.send(1, 16, string, string2, string3);
    }
}

