# Copyright 10/11/01 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)serengeti-platadmin-d.x	1.41 01/10/11 Sun Microsystems"

[ use MANAGED-MODULE ]
[ load serengeti-platadmin-m.x ]
[ load serengeti-platadmin-models-d.x ]
[ requires template serengeti-platadmin-family-j ]
[ requires package spltadm ]

_procedures = {
        [ use PROC ]
        [ source serengeti-platadmin-d.prc ]
        [ source serengeti-platadmin-d.flt]
}

[use _procedures]

activateActions(post)		= setparams loadcache loadtraps subscribe register
activateService(setparams)	= .iso*serengeti-platadmin.daq
activateCommand(setparams)	= setparams
activateService(loadcache)	= .services.snmp
activateCommand(loadcache)	= cache load serengeti-platadmin-oids
activateService(loadtraps)	= .services.trap
activateCommand(loadtraps)	= loadActions serengeti-platadmin-traps
activateService(subscribe)	= .services.snmp

#
#remoteIPAddress is taken from domain-config.x which is set during setup
#

activateMethod(subscribe)	= addNotifySubscription serengetiplatadmin trapOID {^1\\.3\\.6\\.1\\.4\\.1\\.42\\.2\\.70\\.18} agentAddr [ toe_send [ locate .iso*serengeti-platadmin ] lookup -d "" value remoteIPAddress ] tag true
activateService(register)	= _self
activateCommand(register)	= registertohdregmodule


deactivateActions(pre)		= unsubscribe unload unregister
deactivateService(unload)	= .services.trap
deactivateCommand(unload)	= unloadActions serengeti-platadmin-traps
deactivateService(unsubscribe)	= .services.snmp
deactivateMethod(unsubscribe)	= removeNotifySubscription serengetiplatadmin
deactivateService(unregister)	= _self
deactivateCommand(unregister)	= unregisterfromhdregmodule

persistentSlices = [lookup -d "" value serengetiadmindata]

_services = { [ use SERVICE ] 
    sh = {
        command = "pipe://localhost//bin/sh;transport=shell"
        max = 10
    }
}


_rules = { [use PROC]
   [ source serengeti-platadmin-d.rul]
}


adhocCommand(tree) = [ lookup -d "" value serengetipltadmintree ]
adhocCommand(schema) = probeserver -c serengeti-platadmin-schema.sh

communityChanged = {
    type               = active
    refreshService     = _internal
    refreshCommand     = list "null"
    refreshInterval    = 0
}

tableListTorefresh = { 
    type               = active
    refreshService     = _internal
    refreshCommand     = list ""
    refreshInterval    = 0
    initInterval       = 0
    initHoldoff        = 3
}

sunSmTreePropRefreshNode = { [use  _procedures]
    type               = active
    refreshService     = _internal
    refreshCommand     = refreshAllSunSmTreeProp
}

#
#SC is networked or not
#
scnetworked = { [use _procedures _rules ]
    type               = active
    defaultvalue       = 0
    refreshService     = .services.io.icmp
    refreshCommand     = ping %[valueOf remoteIPAddress]
    refreshFilter      = scnetworkedFilter
    refreshInterval    = 5
    initInterval       = 0
    initHoldoff        = 3
}

scagentstatus = { [use _procedures] 
    type               = active
    serviceEvaluator   = refreshSCAgentStatus
    snmpService        = .services.snmp
    refreshService     = _internal
    refreshCommand     = get %[valueOf remoteIPAddress] %targetPort -1 {{sym/.iso.org.dod.internet.private.enterprises.sun.products.serengeti.chassis.chassisTable.chassisEntry.chassisIndex#0 }} -community %[valueOf serengeti-platadmin.communitystrings.platformreadcommunity ] -version %snmpVersion -securityLevel %securityLevel
    refreshInterval    = 5
    initInterval       = 0
    initHoldoff        = 3
}

#
#system for PV/LV
#

system = { [ use templates.serengeti-platadmin-family-j.platformview ]
    sunSmTreeProp = { [ use _procedures]
	type               = active
	refreshService     = _internal
	refreshCommand     = list "system:platform.chassis.chassisTable:null:1:0:-:null:null:null:null:null"
	refreshInterval    = 0
    }
    sunSmNodeName = { [ use _procedures]
	type               = active
	refreshService     = _internal
	refreshCommand     = list "system"
	refreshInterval    = 0
    }
    machine = { [ use _procedures]
	type               = active
	refreshService     = _internal
	refreshCommand     = list "sun4u"
	refreshInterval    = 0
    }
    platform = { [ use _procedures]
	type               = derived
	refreshService     = _internal
	refreshCommand     = refreshSystemPlatform
        refreshTrigger     = serengeti-platadmin.platform.chassis.chassisTable:refresh
	refreshInterval    = 31104000
    }
    total_config_changes = { [ use _procedures ]
	type               = active
        refreshService     = _internal
	refreshCommand     = refresh_total_config_changes
        refreshTrigger     = serengeti-platadmin.sunSmTreePropRefreshNode:refresh
	refreshInterval    = 0
    }
}

#
#IP Address Of the serengeti SC 
#

remoteIPAddress = { [ use _procedures]
    type               = active
    refreshInterval    = 0
    refreshService     = _internal
    refreshCommand     = getRemoteIPAddress
    initInterval       = 0
    initHoldoff        = 2
}

#
#community strings
#

communitystrings = { [ use _procedures]

    #
    # Deny all SNMP access
    #

    userAccess(%adminUsers,read)             = none
    userAccess(%operatorUsers,read)          = none
    userAccess(%generalUsers,read)           = none

    userAccess(%adminUsers,write)            = none
    userAccess(%operatorUsers,write)         = none
    userAccess(%generalUsers,write)          = none

    userAccess(%adminCommunities,read)       = none
    userAccess(%operatorCommunities,read)    = none
    userAccess(%generalCommunities,read)     = none

    userAccess(%adminCommunities,write)      = none
    userAccess(%operatorCommunities,write)   = none
    userAccess(%generalCommunities,write)    = none

    groupAccess(%adminGroups,read)           = none
    groupAccess(%operatorGroups,read)        = none
    groupAccess(%generalGroups,read)         = none

    groupAccess(%adminGroups,write)          = none
    groupAccess(%operatorGroups,write)       = none
    groupAccess(%generalGroups,write)        = none

    type               = active
    refreshInterval    = 0
    refreshService     = _internal
    refreshCommand     = getCommunityStrings
    initInterval       = 0
    initHoldoff        = 2

}


discovery = {
        oid              = 100
    magic_number = {
        type             = active
        refreshService   = _internal
        refreshCommand   = list "53444f54"
        refreshInterval  = 0
        initInterval     = 2
        initHoldoff      = 5
    }
    discoveryObjectTable = { [ use _procedures ]
        type             = derived
	checkService	 = iso*serengeti-platadmin.scagentstatus
	checkCommand	 = ilookup -d "" data 0
	checkInterval	 = 60
        refreshService   = _internal
        refreshCommand   = refreshDiscoveryObjectTable
        refreshTrigger   = *serengeti-platadmin.platform.domains.domainTable:refresh
        refreshInterval  = 31104000
    }
}

dummyNode = { 
    oid              = 101
    type             = active
    refreshService   = _internal
    refreshCommand   = list 1
    refreshInterval  = 0
}


#
# The the new DAQ managed object
#
[ load serengeti-platadmin-daq-d.x ]

#
#platform view
#

platform = {  [ use templates.serengeti-platadmin-family-j.platformview ]
    #
    #Deny all the access here and then later configure the access
    #

    userAccess(%adminUsers,read)             = none
    userAccess(%operatorUsers,read)          = none
    userAccess(%generalUsers,read)           = none

    userAccess(%adminUsers,write)            = none
    userAccess(%operatorUsers,write)         = none
    userAccess(%generalUsers,write)          = none

    userAccess(%adminCommunities,read)       = none
    userAccess(%operatorCommunities,read)    = none
    userAccess(%generalCommunities,read)     = none

    userAccess(%adminCommunities,write)      = none
    userAccess(%operatorCommunities,write)   = none
    userAccess(%generalCommunities,write)    = none

    groupAccess(%adminGroups,read)           = none
    groupAccess(%operatorGroups,read)        = none
    groupAccess(%generalGroups,read)         = none

    groupAccess(%adminGroups,write)          = none
    groupAccess(%operatorGroups,write)       = none
    groupAccess(%generalGroups,write)        = none

    #
    #Give write and read permission to platform admin and
    #read only permission to platform operator.
    #

    groupAccess(spltop,read)           = auth
    groupAccess(spltadm,read)          = auth
    groupAccess(spltadm,write)         = auth
  

    chassis = { [ use templates.serengeti-platadmin-family-j.chassis ]

	chassisTable = { [ use _procedures ] 
		type                     = derived
		refreshTrigger		 = *serengeti-platadmin.daq.chassis:refresh
		refreshService           = _internal
		refreshCommand		 = spltadmGet platform chassis

		chassisEntry = { 

                    chassisLogHost = { [ use _rules ]
                        alarmRules                  = rspa1006
                    }
                    chassisTrapHosts = { [ use _rules ]
                        alarmRules                  = rspa1006
                    }
                    chassisModel = { [ use _procedures ]
                        updateFilter                  = chassisModelFilter
                    }
                    chassisPartitionMode = { [ use _procedures ]
                        updateFilter                  = chassisPartitionModeFilter
                    }
                    sunSmTreeProp = { 
                        refreshInterval               = 0
                        type                          = active
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null:null:null"
                    }
                    sunSmNodeName = { 
                        type                          = active
                        refreshInterval               = 0
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null"
                    }
		    CmdNode = { [ use _procedures ]
			access                        = rw
			type                          = derived
                        defaultvalue                  = ""
			refreshTrigger                = chassisTable:refresh
			refreshService                = _internal
			refreshCommand                = refreshCmdNode
			lsnmpService                  = .services.snmp
			setActions                    = chassisoperation
			setService(chassisoperation)  = _internal
			setCommand(chassisoperation) = chassisOperation %value %index %rowname
		    }
		    CmdStatusNode = { [ use _procedures ]
			access                        = rw
			type                          = derived
                        defaultvalue                  = ""
			refreshTrigger                = chassisTable:refresh
			refreshService                = _internal
			refreshCommand                = refreshCmdNode
		    }
		    machine = { [ use _procedures]
			type               = active
			refreshService     = _internal
			refreshCommand     = list "sun4u"
			refreshInterval    = 0
		    }
		    platform = { [ use _procedures]
			type               = derived
			refreshService     = _internal
			refreshCommand     = refreshSystemPlatform
			refreshTrigger     = serengeti-platadmin.platform.chassis.chassisTable:refresh
			refreshInterval    = 31104000
		    }

		}
	}
    }

    slots = { [ use templates.serengeti-platadmin-family-j.slots ]
        originalTables = {
	    slotTable = { [ use _procedures ]
		type                     = derived
		refreshTrigger		 = *serengeti-platadmin.daq.slots:refresh *serengeti-platadmin.daq.domain:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet platform slots

                slotEntry = {
                    slotBoardType = { [use _procedures ]
                        updateFilter   = slotBoardTypeFilter
                    }
                    slotState = { [use _procedures ]
                        updateFilter   = slotStateFilter
                    }
                    slotTestStatus = { [use _procedures ]
                        updateFilter   = slotTestStatusFilter
                    }
                    slotPowerStatus = { [use _procedures ]
                        updateFilter   = slotPowerStatusFilter
                    }
                    slotDomain = { [use _procedures ]
                        updateFilter   = slotDomainFilter
                    }
                    slotStatus = { [use _procedures ]
                        updateFilter   = slotStatusFilter
                    }
                    sunSmTreeProp = { 
                        refreshInterval               = 0
                        type                          = active
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null:null:null"
                    }
                    sunSmNodeName = { 
                        type                          = active
                        refreshInterval               = 0
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null"
                    }
               }
	    }
	    cpuBoardTable = { [ use _procedures ]
		type                     = derived
                refreshTrigger           = *serengeti-platadmin.daq.cpuBoard:refresh *serengeti-platadmin.daq.domain:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet platform cpuBoard

                cpuBoardEntry = {
               }
	    }
	    ioBoardTable = { [use _procedures ] 
		type                     = derived
                refreshTrigger           = *serengeti-platadmin.daq.ioBoard:refresh *serengeti-platadmin.daq.domain:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet platform ioBoard

                ioBoardEntry = {
                    ioBoardType = { [use _procedures ]
                        updateFilter   = ioBoardTypeFilter
                    }
               }
	    }
	    l2BoardTable = { [ use _procedures ]
		type                     = derived
		refreshTrigger		 = *serengeti-platadmin.daq.l2Board:refresh *serengeti-platadmin.daq.domain:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet platform l2Board

                l2BoardEntry = {
               }
	    }
	    fanTable = { [ use _procedures ]
		type                     = derived
                refreshTrigger           = *serengeti-platadmin.daq.fan:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet platform fan
                fanEntry = {
                    fanType = { [use _procedures ]
                        updateFilter   = fanTypeFilter
                    }
               }
	    }
	    psTable = { [ use _procedures ]
		type                     = derived
                refreshTrigger           = *serengeti-platadmin.daq.powerSupply:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet platform powerSupply

                psEntry = {
                    psType = { [use _procedures ]
                        updateFilter   = psTypeFilter
                    }
               }
	    }
	    scTable = { [use _procedures ]
		type                     = derived
                refreshTrigger           = *serengeti-platadmin.daq.systemController:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet platform systemController

                scEntry = {
 		    scVersion = { [ use _rules ]
                         alarmRules                  = rspa1009
                    }
               }
	   }
	}
        emptySlots = { [ use templates.serengeti-platadmin-family-j.emptyslots ]

	    emptySlotTable = { [use _procedures ]
		type              = derived
                refreshTrigger   = originalTables.slotTable:refresh
                refreshService   = _internal
                refreshCommand   = refreshEmptySlots P

		slotEntry = { 
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = emptySlotTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname P
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = emptySlotTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        cpuBoards = { [ use templates.serengeti-platadmin-family-j.cpuboards ]
	    cpuBrdTable = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.cpuBoardTable:refresh
                refreshService   = _internal
	        refreshCommand   = refreshCPUBoards P

		cpuBoardEntry = { 
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
                    sunSmTreeProp = { 
                        refreshInterval               = 0
                        type                          = active
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null:null:null"
                    }
                    sunSmNodeName = { 
                        type                          = active
                        refreshInterval               = 0
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null"
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = cpuBrdTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname P
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = cpuBrdTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        ioBoards = { [ use templates.serengeti-platadmin-family-j.ioboards ]
	    ioBrdTable = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.ioBoardTable:refresh
                refreshService   = _internal
	        refreshCommand   = refreshIOBoards P

		ioBoardEntry = { 
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
                    sunSmTreeProp = { 
                        refreshInterval               = 0
                        type                          = active
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null:null:null"
                    }
                    sunSmNodeName = { 
                        type                          = active
                        refreshInterval               = 0
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null"
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = ioBrdTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname P
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = ioBrdTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        l2Repeaters = { [ use templates.serengeti-platadmin-family-j.l2repeaters ]
	    l2RepeaterTable = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.l2BoardTable:refresh
                refreshService   = _internal
	        refreshCommand   = refreshL2Repeaters P

		l2RepeaterEntry = { 
                    l2RepeaterState = { [use _procedures ]
                        updateFilter   = slotStateFilterNA
                    }
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
                    sunSmTreeProp = { 
                        refreshInterval               = 0
                        type                          = active
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null:null:null"
                    }
                    sunSmNodeName = { 
                        type                          = active
                        refreshInterval               = 0
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null"
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = l2RepeaterTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname P
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = l2RepeaterTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        fanTrays = { [ use templates.serengeti-platadmin-family-j.fantrays ]
	    fanTrayTable = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.fanTable:refresh
                refreshService   = _internal
	        refreshCommand   = refreshFanTrays P

		fanEntry = { 
                    fanState = { [use _procedures ]
                        updateFilter   = slotStateFilterNA
                    }
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
                    fanSpeed = { [use _procedures ]
                        updateFilter   = fanSpeedFilter
                    }
                    sunSmTreeProp = { 
                        refreshInterval               = 0
                        type                          = active
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null:null:null"
                    }
                    sunSmNodeName = { 
                        type                          = active
                        refreshInterval               = 0
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null"
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = fanTrayTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname P
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = fanTrayTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        powerSupply = { [ use templates.serengeti-platadmin-family-j.powersupply ]
	    powerSupplyTable = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.psTable:refresh
                refreshService   = _internal
	        refreshCommand   = refreshPowerSupply P

		powerSupplyEntry = { 
                    powerSupplyState = { [use _procedures ]
                        updateFilter   = slotStateFilterNA
                    }
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
                    powerSupplyLowHighInput = { [use _procedures ]
                        updateFilter   = powerSupplyLowHighInputFilter
                    }
                    sunSmTreeProp = { 
                        refreshInterval               = 0
                        type                          = active
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null:null:null"
                    }
                    sunSmNodeName = { 
                        type                          = active
                        refreshInterval               = 0
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null"
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = powerSupplyTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname P
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = powerSupplyTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        systemController = { [ use templates.serengeti-platadmin-family-j.systemcontroller ]
	    systemControllerTable = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.scTable:refresh
                refreshService   = _internal
	        refreshCommand   = refreshSystemController P

		systemControllerEntry = { 
                    systemControllerState = { [use _procedures ]
                        updateFilter   = slotStateFilterNA
                    }
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
                    systemControllerMasterSlave = { [use _procedures ]
                        updateFilter   = systemControllerMasterSlaveFilter
                    }
                    systemControllerNetConf = { [use _procedures ]
                        updateFilter   = systemControllerNetConfFilter
                    }
                    systemControllerDate = { [use _procedures ]
                        updateFilter   = dateFilter
                    }
                    #systemControllerState = { [use _procedures ]
                    #    updateFilter   = systemControllerStateFilter
                    #}
                    sunSmTreeProp = { 
                        refreshInterval               = 0
                        type                          = active
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null:null:null"
                    }
                    sunSmNodeName = { 
                        type                          = active
                        refreshInterval               = 0
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null"
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = systemControllerTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname P
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = systemControllerTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        unknownBoards = { 
	    unknownBrdTable = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.slotTable:refresh
                refreshService   = _internal
	        refreshCommand   = refreshUnknownBoards P

		unknownBoardEntry = { 
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = unknownBrdTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname P
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = unknownBrdTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
	}
    }

    fru = { 
	fruTable = { [ use _procedures ]
		type                     = derived
		refreshTrigger		 = *serengeti-platadmin.daq.fru
		refreshService           = _internal
		refreshCommand           = spltadmGet platform fru
	}
    }

    components = { [ use templates.serengeti-platadmin-family-j.components ]

        cpuMod = { [ use templates.serengeti-platadmin-family-j.cpumodule ]
	    cpuModTable = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger           = *serengeti-platadmin.daq.cpuMod:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet platform cpuMod

		cpuModEntry = { 
                    cpuModStatus = { [use _procedures _rules]
                        updateFilter   = cpuModStatusFilter
			alarmRules   = rspa1008
                    }
                    sunSmTreeProp = { 
                        refreshInterval               = 0
                        type                          = active
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null:null:null"
                    }
                    sunSmNodeName = { 
                        type                          = active
                        refreshInterval               = 0
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null"
                    }
                }
	    }
        }




        dimm = { [ use templates.serengeti-platadmin-family-j.dimm ]
	    dimmTable = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger           = *serengeti-platadmin.daq.dimm:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet platform dimm

                dimmEntry = {
                    sunSmTreeProp = { 
                        refreshInterval               = 0
                        type                          = active
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null:null:null"
                    }
                    sunSmNodeName = { 
                        type                          = active
                        refreshInterval               = 0
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null"
                    }
               }
	    }
        }

        ecache = { [ use templates.serengeti-platadmin-family-j.ecache ]
	    ecacheTable = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger           = *serengeti-platadmin.daq.ecache:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet platform ecache

                ecacheEntry = {
                    sunSmTreeProp = { 
                        refreshInterval               = 0
                        type                          = active
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null:null:null"
                    }
                    sunSmNodeName = { 
                        type                          = active
                        refreshInterval               = 0
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null"
                    }
               }
	    }
        }


        wci = { [ use templates.serengeti-platadmin-family-j.wcimod ]
	    wciModTable = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger           = *serengeti-platadmin.daq.wci:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet platform wci

		wciModEntry = { 
                    wciModStatus = { [use _procedures ]
                        updateFilter   = wciModStatusFilter
                    }
                    wciModMode = { [use _procedures ]
                        updateFilter   = wciModModeFilter
                    }
                    sunSmTreeProp = { 
                        refreshInterval               = 0
                        type                          = active
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null:null:null"
                    }
                    sunSmNodeName = { 
                        type                          = active
                        refreshInterval               = 0
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null"
                    }
                }
	    }
        }

        wciPort = { [ use templates.serengeti-platadmin-family-j.wciport ]
	    wciPortTable = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger           = *serengeti-platadmin.daq.wciPort:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet platform wciPort

		wciPortEntry = { 
                    wciPortStatus = { [use _procedures ]
                        updateFilter   = wciPortStatusFilter
                    }
                    sunSmTreeProp = { 
                        refreshInterval               = 0
                        type                          = active
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null:null:null"
                    }
                    sunSmNodeName = { 
                        type                          = active
                        refreshInterval               = 0
                        refreshService                = _internal
                        refreshCommand                = list ""
                        defaultvalue                  = "null"
                    }
                }
	    }
        }

    }


    domains = { [ use templates.serengeti-platadmin-family-j.domains ]
        domainTable = { [ use _procedures ]
                type                     = derived
                refreshTrigger           = *serengeti-platadmin.daq.domain:refresh
                refreshService           = _internal
                refreshCommand           = spltadmGet platform domain

            domainEntry = { 
		domainDomain = { [use _procedures ]
		    updateFilter   = slotDomainFilter
		}
		domainLogHost = { [use _rules ]
		    alarmRules   = rspa1006
		}
		domainTrapHosts = { [use _rules ]
		    alarmRules   = rspa1006
		}
		domainStatus = { [use _procedures _rules ]
		    updateFilter   = domainStatusFilter
                    alarmRules     = rspa1002
		}
		domainSsmMode = { [use _procedures ]
		    updateFilter   = domainSsmModeFilter
		}
		domainKeySwitch = { [use _procedures ]
		    updateFilter   = domainKeySwitchFilter
		}
		snmpAgentPort = { [use _procedures]
                        type              = derived
		        defaultvalue      = 161
                        refreshTrigger    = domainTable:refresh
                        refreshService    = _internal
                        refreshCommand    = refreshsnmpAgentPort
		}
                slotsNotInACL = { [ use _procedures]
			type              = derived
		        defaultvalue      = ""
                        refreshTrigger    = domainTable:refresh
                        refreshService    = _internal
                        refreshCommand    = refreshslotsNotInACL
                }
		sunSmTreeProp = { 
                        refreshInterval               = 0
                        type                          = active
                        refreshService                = _internal
                        refreshCommand                = list ""
		        defaultvalue                  = "null:null:null"
		}
		sunSmNodeName = { 
                        type                          = active
                        refreshInterval               = 0
                        refreshService                = _internal
                        refreshCommand                = list ""
		        defaultvalue                  = "null"
		}
                CmdNode = { [ use _procedures ] 
                    access            = rw
                    type              = derived
		    defaultvalue                  = ""
                    refreshTrigger    = domainTable:refresh 
                    refreshService    = _internal
                    refreshCommand    = refreshCmdNode

                    lsnmpService      = .services.snmp
                    setActions         = domainopearion
                    setService(domainopearion) = _internal
                    setCommand(domainopearion) = domainOperation %value %index %rowname P
                }
                CmdStatusNode = { [ use _procedures ] 
                    access            = rw
                    type              = derived
		    defaultvalue                  = ""
                    refreshTrigger    = domainTable:refresh 
                    refreshService    = _internal
                    refreshCommand    = refreshCmdNode
                }

            }
        }
    }
}

#
#Domain A View
#

domainA = { [ use templates.serengeti-platadmin-family-j.domainAview ] 
    #
    #Deny all the access here and then later configure the access
    #

    userAccess(%adminUsers,read)             = none
    userAccess(%operatorUsers,read)          = none
    userAccess(%generalUsers,read)           = none

    userAccess(%adminUsers,write)            = none
    userAccess(%operatorUsers,write)         = none
    userAccess(%generalUsers,write)          = none

    userAccess(%adminCommunities,read)       = none
    userAccess(%operatorCommunities,read)    = none
    userAccess(%generalCommunities,read)     = none

    userAccess(%adminCommunities,write)      = none
    userAccess(%operatorCommunities,write)   = none
    userAccess(%generalCommunities,write)    = none

    groupAccess(%adminGroups,read)           = none
    groupAccess(%operatorGroups,read)        = none
    groupAccess(%generalGroups,read)         = none

    groupAccess(%adminGroups,write)          = none
    groupAccess(%operatorGroups,write)       = none
    groupAccess(%generalGroups,write)        = none

    #
    #Give write and read permission to domainA admin and
    #read only permission to domainA operator.
    #

    groupAccess(sdaop,read)           = auth
    groupAccess(sdaadm,read)          = auth
    groupAccess(sdaadm,write)         = auth

    slots = { [ use templates.serengeti-platadmin-family-j.slots ]
        originalTables = {
	    slotTableA = { [ use _procedures ]
		type                     = derived
		refreshTrigger		 = *serengeti-platadmin.daq.slots:refresh *serengeti-platadmin.daq.domain:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet domainA slots
                slotEntry = {
                    slotBoardType = { [use _procedures ]
                        updateFilter   = slotBoardTypeFilter
                    }
                    slotState = { [use _procedures ]
                        updateFilter   = slotStateFilter
                    }
                    slotTestStatus = { [use _procedures ]
                        updateFilter   = slotTestStatusFilter
                    }
                    slotPowerStatus = { [use _procedures ]
                        updateFilter   = slotPowerStatusFilter
                    }
                    slotDomain = { [use _procedures ]
                        updateFilter   = slotDomainFilter
                    }
                    slotStatus = { [use _procedures ]
                        updateFilter   = slotStatusFilter
                    }
                }
	    }
	    cpuBoardTableA = { [ use _procedures ]
		type                     = derived
		refreshTrigger		 = *serengeti-platadmin.daq.cpuBoard:refresh *serengeti-platadmin.daq.domain:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet domainA cpuBoard
	    }
	    ioBoardTableA = { [use _procedures ] 
		type                     = derived
		refreshTrigger		 = *serengeti-platadmin.daq.ioBoard:refresh *serengeti-platadmin.daq.domain:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet domainA ioBoard
                ioBoardEntry = {
                    ioBoardType = { [use _procedures ]
                        updateFilter   = ioBoardTypeFilter
                    }
               }
	    }
	}
        emptySlots = { [ use templates.serengeti-platadmin-family-j.emptyslots ]

	    emptySlotTable = { [use _procedures ]
		type                     = derived
                refreshTrigger   = originalTables.slotTableA:refresh
                refreshService   = _internal
                refreshCommand   = refreshEmptySlots A

		slotEntry = { 
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = emptySlotTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname A
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = emptySlotTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        cpuBoards = { [ use templates.serengeti-platadmin-family-j.cpuboards ]
	    cpuBrdTableA = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.cpuBoardTableA:refresh
                refreshService   = _internal
	        refreshCommand   = refreshCPUBoards A

		cpuBoardEntry = { 

                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = cpuBrdTableA:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname A
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = cpuBrdTableA:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        ioBoards = { [ use templates.serengeti-platadmin-family-j.ioboards ]
	    ioBrdTableA = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.ioBoardTableA:refresh
                refreshService   = _internal
	        refreshCommand   = refreshIOBoards A

		ioBoardEntry = { 
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = ioBrdTableA:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname A
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = ioBrdTableA:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }

        unknownBoards = { 
	    unknownBrdTableA = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.slotTableA:refresh
                refreshService   = _internal
	        refreshCommand   = refreshUnknownBoards A

		unknownBoardEntry = { 
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = unknownBrdTableA:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname A
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = unknownBrdTableA:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
    }

    fru = { 
	fruTableA = { [ use _procedures ]
		type                     = derived
		refreshTrigger		 = *serengeti-platadmin.daq.fru:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet domainA fru
	}
    }

    components = { [ use templates.serengeti-platadmin-family-j.components ]

        cpuMod = { [ use templates.serengeti-platadmin-family-j.cpumodule ]
	    cpuModTableA = { [ use _procedures ]
		type                     = derived
		refreshTrigger		 = *serengeti-platadmin.daq.cpuMod:refresh *serengeti-platadmin.daq.domain:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet domainA cpuMod

		cpuModEntry = { 
                    cpuModStatus = { [use _procedures _rules]
                        updateFilter   = cpuModStatusFilter
			alarmRules   = rspa1008
                    }
                }
	    }
        }




        dimm = { [ use templates.serengeti-platadmin-family-j.dimm ]
	    dimmTableA = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	     = *serengeti-platadmin.daq.dimm:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainA dimm
	    }
        }

        ecache = { [ use templates.serengeti-platadmin-family-j.ecache ]
	    ecacheTableA = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	     = *serengeti-platadmin.daq.ecache:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainA ecache
	    }
        }


        wci = { [ use templates.serengeti-platadmin-family-j.wcimod ]
	    wciModTableA = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	     = *serengeti-platadmin.daq.wci:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainA wci
		wciModEntry = { 
                    wciModStatus = { [use _procedures ]
                        updateFilter   = wciModStatusFilter
                    }
                    wciModMode = { [use _procedures ]
                        updateFilter   = wciModModeFilter
                    }
                }
	    }
        }

        wciPort = { [ use templates.serengeti-platadmin-family-j.wciport ]
	    wciPortTableA = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	     = *serengeti-platadmin.daq.wciPort:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainA wciPort
		wciPortEntry = { 
                    wciPortStatus = { [use _procedures ]
                        updateFilter   = wciPortStatusFilter
                    }
                }
	    }
        }

    }


    domains = { [ use templates.serengeti-platadmin-family-j.domains ]
        domainTableA = { [ use _procedures ]
                type                     = derived
		refreshTrigger	         = *serengeti-platadmin.daq.domain:refresh
                refreshService           = _internal
                refreshCommand           = spltadmGet domainA domain
            domainEntry = { 
		domainDomain = { [use _procedures ]
		    updateFilter   = slotDomainFilter
		}
		domainTrapHosts = { [use _rules ]
		    alarmRules   = rspa1006
		}
		domainStatus = { [use _procedures _rules ]
		    updateFilter   = domainStatusFilter
                    alarmRules     = rspa1002
		}
		domainSsmMode = { [use _procedures ]
		    updateFilter   = domainSsmModeFilter
		}
		domainKeySwitch = { [use _procedures _rules ]
		    updateFilter   = domainKeySwitchFilter
                    alarmRules     = rspa1003
		}
		snmpAgentPort = { [use _procedures]
                        type              = derived
		        defaultvalue      = 161
                        refreshTrigger    = domainTableA:refresh
                        refreshService    = _internal
                        refreshCommand    = refreshsnmpAgentPort
		}
                slotsNotInACL = { [ use _procedures]
			type              = derived
		        defaultvalue      = ""
                        refreshTrigger    = domainTableA:refresh
                        refreshService    = _internal
                        refreshCommand    = refreshslotsNotInACL
                }
                CmdNode = { [ use _procedures ] 
                    access            = rw
                    type              = derived
		    defaultvalue                  = ""
                    refreshTrigger    = domainTableA:refresh 
                    refreshService    = _internal
                    refreshCommand    = refreshCmdNode

                    lsnmpService      = .services.snmp
                    setActions         = domainopearion
                    setService(domainopearion) = _internal
                    setCommand(domainopearion) = domainOperation %value %index %rowname A
                }
                CmdStatusNode = { [ use _procedures ] 
                    access            = rw
                    type              = derived
		    defaultvalue                  = ""
                    refreshTrigger    = domainTableA:refresh 
                    refreshService    = _internal
                    refreshCommand    = refreshCmdNode
                }

            }
        }
    }
}

#
#Domain B View
#

domainB = { [ use templates.serengeti-platadmin-family-j.domainBview ]
    #
    #Deny all the access here and then later configure the access
    #

    userAccess(%adminUsers,read)             = none
    userAccess(%operatorUsers,read)          = none
    userAccess(%generalUsers,read)           = none

    userAccess(%adminUsers,write)            = none
    userAccess(%operatorUsers,write)         = none
    userAccess(%generalUsers,write)          = none

    userAccess(%adminCommunities,read)       = none
    userAccess(%operatorCommunities,read)    = none
    userAccess(%generalCommunities,read)     = none

    userAccess(%adminCommunities,write)      = none
    userAccess(%operatorCommunities,write)   = none
    userAccess(%generalCommunities,write)    = none

    groupAccess(%adminGroups,read)           = none
    groupAccess(%operatorGroups,read)        = none
    groupAccess(%generalGroups,read)         = none

    groupAccess(%adminGroups,write)          = none
    groupAccess(%operatorGroups,write)       = none
    groupAccess(%generalGroups,write)        = none

    #
    #Give write and read permission to domainB admin and
    #read only permission to domainB operator.
    #

    groupAccess(sdbop,read)           = auth
    groupAccess(sdbadm,read)          = auth
    groupAccess(sdbadm,write)         = auth



    slots = { [ use templates.serengeti-platadmin-family-j.slots ]
        originalTables = {
	    slotTableB = { [ use _procedures ]
		type                     = derived
		refreshTrigger	         = *serengeti-platadmin.daq.slots:refresh *serengeti-platadmin.daq.domain:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet domainB slots
                slotEntry = {
                    slotBoardType = { [use _procedures ]
                        updateFilter   = slotBoardTypeFilter
                    }
                    slotState = { [use _procedures ]
                        updateFilter   = slotStateFilter
                    }
                    slotTestStatus = { [use _procedures ]
                        updateFilter   = slotTestStatusFilter
                    }
                    slotPowerStatus = { [use _procedures ]
                        updateFilter   = slotPowerStatusFilter
                    }
                    slotDomain = { [use _procedures ]
                        updateFilter   = slotDomainFilter
                    }
                    slotStatus = { [use _procedures ]
                        updateFilter   = slotStatusFilter
                    }
                }
	    }
	    cpuBoardTableB = { [ use _procedures ]
		type                     = derived
		refreshTrigger	         = *serengeti-platadmin.daq.cpuBoard:refresh *serengeti-platadmin.daq.domain:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet domainB cpuBoard
	    }
	    ioBoardTableB = { [use _procedures ] 
		type                     = derived
		refreshTrigger	         = *serengeti-platadmin.daq.ioBoard:refresh *serengeti-platadmin.daq.domain:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet domainB ioBoard
                ioBoardEntry = {
                    ioBoardType = { [use _procedures ]
                        updateFilter   = ioBoardTypeFilter
                    }
               }
	    }
	}
        emptySlots = { [ use templates.serengeti-platadmin-family-j.emptyslots ]

	    emptySlotTable = { [use _procedures ]
		type                     = derived
                refreshTrigger   = originalTables.slotTableB:refresh
                refreshService   = _internal
                refreshCommand   = refreshEmptySlots B

		slotEntry = { 
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = emptySlotTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname B
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = emptySlotTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        cpuBoards = { [ use templates.serengeti-platadmin-family-j.cpuboards ]
	    cpuBrdTableB = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.cpuBoardTableB:refresh
                refreshService   = _internal
	        refreshCommand   = refreshCPUBoards B

		cpuBoardEntry = { 
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = cpuBrdTableB:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname B
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = cpuBrdTableB:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        ioBoards = { [ use templates.serengeti-platadmin-family-j.ioboards ]
	    ioBrdTableB = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.ioBoardTableB:refresh
                refreshService   = _internal
	        refreshCommand   = refreshIOBoards B

		ioBoardEntry = { 

                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = ioBrdTableB:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname B
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = ioBrdTableB:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        unknownBoards = { 
	    unknownBrdTableB = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.slotTableB:refresh
                refreshService   = _internal
	        refreshCommand   = refreshUnknownBoards B

		unknownBoardEntry = { 
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = unknownBrdTableB:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname B
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = unknownBrdTableB:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
    }

    fru = { 
	fruTableB = { [ use _procedures ]
		type                     = derived
		refreshTrigger	         = *serengeti-platadmin.daq.fru:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet domainB fru
	}
    }

    components = { [ use templates.serengeti-platadmin-family-j.components ]

        cpuMod = { [ use templates.serengeti-platadmin-family-j.cpumodule ]
	    cpuModTableB = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	     = *serengeti-platadmin.daq.cpuMod:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainB cpuMod
		cpuModEntry = { 
                    cpuModStatus = { [use _procedures _rules]
                        updateFilter   = cpuModStatusFilter
			alarmRules   = rspa1008
                    }
                }
	    }
        }




        dimm = { [ use templates.serengeti-platadmin-family-j.dimm ]
	    dimmTableB = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	         = *serengeti-platadmin.daq.dimm:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainB dimm
	    }
        }

        ecache = { [ use templates.serengeti-platadmin-family-j.ecache ]
	    ecacheTableB = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	         = *serengeti-platadmin.daq.ecache:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainB ecache
	    }
        }


        wci = { [ use templates.serengeti-platadmin-family-j.wcimod ]
	    wciModTableB = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	     = *serengeti-platadmin.daq.wci:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainB wci
		wciModEntry = { 
                    wciModStatus = { [use _procedures ]
                        updateFilter   = wciModStatusFilter
                    }
                    wciModMode = { [use _procedures ]
                        updateFilter   = wciModModeFilter
                    }
                }
	    }
        }

        wciPort = { [ use templates.serengeti-platadmin-family-j.wciport ]
	    wciPortTableB = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	     = *serengeti-platadmin.daq.wciPort:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainB wciPort
		wciPortEntry = { 
                    wciPortStatus = { [use _procedures ]
                        updateFilter   = wciPortStatusFilter
                    }
                }
	    }
        }

    }


    domains = { [ use templates.serengeti-platadmin-family-j.domains ]
        domainTableB = { [ use _procedures ]
                type                     = derived
		refreshTrigger	         = *serengeti-platadmin.daq.domain:refresh
                refreshService           = _internal
                refreshCommand           = spltadmGet domainB domain
		domainEntry = { 
		domainDomain = { [use _procedures ]
		    updateFilter   = slotDomainFilter
		}
		domainLogHost = { [use _rules ]
		    alarmRules   = rspa1006
		}
		domainTrapHosts = { [use _rules ]
		    alarmRules   = rspa1006
		}
		domainStatus = { [use _procedures _rules ]
		    updateFilter   = domainStatusFilter
                    alarmRules     = rspa1002
		}
		domainSsmMode = { [use _procedures ]
		    updateFilter   = domainSsmModeFilter
		}
		domainKeySwitch = { [use _procedures _rules ]
		    updateFilter   = domainKeySwitchFilter
                    alarmRules     = rspa1003
		}
		snmpAgentPort = { [use _procedures]
                        type              = derived
		        defaultvalue      = 161
                        refreshTrigger    = domainTableB:refresh
                        refreshService    = _internal
                        refreshCommand    = refreshsnmpAgentPort
		}
                slotsNotInACL = { [ use _procedures]
			type              = derived
		        defaultvalue      = ""
                        refreshTrigger    = domainTableB:refresh
                        refreshService    = _internal
                        refreshCommand    = refreshslotsNotInACL
                }
                CmdNode = { [ use _procedures ] 
                    access            = rw
                    type              = derived
		    defaultvalue                  = ""
                    refreshTrigger    = domainTableB:refresh 
                    refreshService    = _internal
                    refreshCommand    = refreshCmdNode

                    lsnmpService      = .services.snmp
                    setActions         = domainopearion
                    setService(domainopearion) = _internal
                    setCommand(domainopearion) = domainOperation %value %index %rowname B
                }
                CmdStatusNode = { [ use _procedures ] 
                    access            = rw
                    type              = derived
		    defaultvalue                  = ""
                    refreshTrigger    = domainTableB:refresh 
                    refreshService    = _internal
                    refreshCommand    = refreshCmdNode
                }

            }
        }
    }
}

#
#Domain C View
#

domainC = { [ use templates.serengeti-platadmin-family-j.domainCview ]
    #
    #Deny all the access here and then later configure the access
    #

    userAccess(%adminUsers,read)             = none
    userAccess(%operatorUsers,read)          = none
    userAccess(%generalUsers,read)           = none

    userAccess(%adminUsers,write)            = none
    userAccess(%operatorUsers,write)         = none
    userAccess(%generalUsers,write)          = none

    userAccess(%adminCommunities,read)       = none
    userAccess(%operatorCommunities,read)    = none
    userAccess(%generalCommunities,read)     = none

    userAccess(%adminCommunities,write)      = none
    userAccess(%operatorCommunities,write)   = none
    userAccess(%generalCommunities,write)    = none

    groupAccess(%adminGroups,read)           = none
    groupAccess(%operatorGroups,read)        = none
    groupAccess(%generalGroups,read)         = none

    groupAccess(%adminGroups,write)          = none
    groupAccess(%operatorGroups,write)       = none
    groupAccess(%generalGroups,write)        = none


    #
    #Give write and read permission to domainC admin and
    #read only permission to domainC operator.
    #

    groupAccess(sdcop,read)           = auth
    groupAccess(sdcadm,read)          = auth
    groupAccess(sdcadm,write)         = auth


    slots = { [ use templates.serengeti-platadmin-family-j.slots ]
        originalTables = {
	    slotTableC = { [ use _procedures ]
		type                     = derived
		refreshTrigger	         = *serengeti-platadmin.daq.slots:refresh *serengeti-platadmin.daq.domain:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet domainC slots
                slotEntry = {
                    slotBoardType = { [use _procedures ]
                        updateFilter   = slotBoardTypeFilter
                    }
                    slotState = { [use _procedures ]
                        updateFilter   = slotStateFilter
                    }
                    slotTestStatus = { [use _procedures ]
                        updateFilter   = slotTestStatusFilter
                    }
                    slotPowerStatus = { [use _procedures ]
                        updateFilter   = slotPowerStatusFilter
                    }
                    slotDomain = { [use _procedures ]
                        updateFilter   = slotDomainFilter
                    }
                    slotStatus = { [use _procedures ]
                        updateFilter   = slotStatusFilter
                    }
                }
	    }
	    cpuBoardTableC = { [ use _procedures ]
		type                     = derived
		refreshTrigger	         = *serengeti-platadmin.daq.cpuBoard:refresh *serengeti-platadmin.daq.domain:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet domainC cpuBoard
	    }
	    ioBoardTableC = { [use _procedures ] 
		type                     = derived
		refreshTrigger	         = *serengeti-platadmin.daq.ioBoard:refresh *serengeti-platadmin.daq.domain:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet domainC ioBoard
                ioBoardEntry = {
                    ioBoardType = { [use _procedures ]
                        updateFilter   = ioBoardTypeFilter
                    }
               }
	    }
	}
        emptySlots = { [ use templates.serengeti-platadmin-family-j.emptyslots ]

	    emptySlotTable = { [use _procedures ]
		type                     = derived
                refreshTrigger   = originalTables.slotTableC:refresh
                refreshService   = _internal
                refreshCommand   = refreshEmptySlots C

		slotEntry = { 
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = emptySlotTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname C
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = emptySlotTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        cpuBoards = { [ use templates.serengeti-platadmin-family-j.cpuboards ]
	    cpuBrdTableC = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.cpuBoardTableC:refresh
                refreshService   = _internal
	        refreshCommand   = refreshCPUBoards C

		cpuBoardEntry = { 
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = cpuBrdTableC:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname C
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = cpuBrdTableC:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        ioBoards = { [ use templates.serengeti-platadmin-family-j.ioboards ]
	    ioBrdTableC = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.ioBoardTableC:refresh
                refreshService   = _internal
	        refreshCommand   = refreshIOBoards C

		ioBoardEntry = { 

                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = ioBrdTableC:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname C
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = ioBrdTableC:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        unknownBoards = { 
	    unknownBrdTable = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.slotTableC:refresh
                refreshService   = _internal
	        refreshCommand   = refreshUnknownBoards C

		unknownBoardEntry = { 
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = unknownBrdTableC:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname C
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = unknownBrdTableC:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
    }

    fru = { 
	fruTableC = { [ use _procedures ]
		type                     = derived
		refreshTrigger	         = *serengeti-platadmin.daq.fru:refresh
		refreshService           = _internal
		refreshCommand           = spltadmGet domainC fru
	}
    }

    components = { [ use templates.serengeti-platadmin-family-j.components ]

        cpuMod = { [ use templates.serengeti-platadmin-family-j.cpumodule ]
	    cpuModTableC = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	     = *serengeti-platadmin.daq.cpuMod:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainC cpuMod
		cpuModEntry = { 
                    cpuModStatus = { [use _procedures _rules]
                        updateFilter   = cpuModStatusFilter
			alarmRules   = rspa1008
                    }
                }
	    }
        }




        dimm = { [ use templates.serengeti-platadmin-family-j.dimm ]
	    dimmTableC = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	     = *serengeti-platadmin.daq.dimm:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainC dimm
	    }
        }

        ecache = { [ use templates.serengeti-platadmin-family-j.ecache ]
	    ecacheTableC = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	     = *serengeti-platadmin.daq.ecache:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainC ecache
	    }
        }


        wci = { [ use templates.serengeti-platadmin-family-j.wcimod ]
	    wciModTableC = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	     = *serengeti-platadmin.daq.wci:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainC wci
		wciModEntry = { 
                    wciModStatus = { [use _procedures ]
                        updateFilter   = wciModStatusFilter
                    }
                    wciModMode = { [use _procedures ]
                        updateFilter   = wciModModeFilter
                    }
                }
	    }
        }

        wciPort = { [ use templates.serengeti-platadmin-family-j.wciport ]
	    wciPortTableC = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	     = *serengeti-platadmin.daq.wciPort:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainC wciPort
		wciPortEntry = { 
                    wciPortStatus = { [use _procedures ]
                        updateFilter   = wciPortStatusFilter
                    }
                }
	    }
        }

    }


    domains = { [ use templates.serengeti-platadmin-family-j.domains ]
        domainTableC = { [ use _procedures ]
                type                     = derived
		refreshTrigger	         = *serengeti-platadmin.daq.domain:refresh
                refreshService           = _internal
                refreshCommand           = spltadmGet domainC domain
            domainEntry = { 
		domainDomain = { [use _procedures ]
		    updateFilter   = slotDomainFilter
		}
		domainLogHost = { [use _rules ]
		    alarmRules   = rspa1006
		}
		domainTrapHosts = { [use _rules ]
		    alarmRules   = rspa1006
		}
		domainStatus = { [use _procedures _rules ]
		    updateFilter   = domainStatusFilter
                    alarmRules     = rspa1002
		}
		domainSsmMode = { [use _procedures ]
		    updateFilter   = domainSsmModeFilter
		}
		domainKeySwitch = { [use _procedures _rules ]
		    updateFilter   = domainKeySwitchFilter
                    alarmRules     = rspa1003
		}
		snmpAgentPort = { [use _procedures]
                        type              = derived
		        defaultvalue      = 161
                        refreshTrigger    = domainTableC:refresh
                        refreshService    = _internal
                        refreshCommand    = refreshsnmpAgentPort
		}
                slotsNotInACL = { [ use _procedures]
			type              = derived
		        defaultvalue      = ""
                        refreshTrigger    = domainTableC:refresh
                        refreshService    = _internal
                        refreshCommand    = refreshslotsNotInACL
                }
                CmdNode = { [ use _procedures ] 
                    access            = rw
                    type              = derived
		    defaultvalue                  = ""
                    refreshTrigger    = domainTableC:refresh 
                    refreshService    = _internal
                    refreshCommand    = refreshCmdNode

                    lsnmpService      = .services.snmp
                    setActions         = domainopearion
                    setService(domainopearion) = _internal
                    setCommand(domainopearion) = domainOperation %value %index %rowname C
                }
                CmdStatusNode = { [ use _procedures ] 
                    access            = rw
                    type              = derived
		    defaultvalue                  = ""
                    refreshTrigger    = domainTableC:refresh 
                    refreshService    = _internal
                    refreshCommand    = refreshCmdNode
                }

            }
        }
    }
}

#
#Domain D View
#

domainD = { [ use templates.serengeti-platadmin-family-j.domainDview ]
    #
    #Deny all the access here and then later configure the access
    #

    userAccess(%adminUsers,read)             = none
    userAccess(%operatorUsers,read)          = none
    userAccess(%generalUsers,read)           = none

    userAccess(%adminUsers,write)            = none
    userAccess(%operatorUsers,write)         = none
    userAccess(%generalUsers,write)          = none

    userAccess(%adminCommunities,read)       = none
    userAccess(%operatorCommunities,read)    = none
    userAccess(%generalCommunities,read)     = none

    userAccess(%adminCommunities,write)      = none
    userAccess(%operatorCommunities,write)   = none
    userAccess(%generalCommunities,write)    = none

    groupAccess(%adminGroups,read)           = none
    groupAccess(%operatorGroups,read)        = none
    groupAccess(%generalGroups,read)         = none

    groupAccess(%adminGroups,write)          = none
    groupAccess(%operatorGroups,write)       = none
    groupAccess(%generalGroups,write)        = none


    #
    #Give write and read permission to domainD admin and
    #read only permission to domainD operator.
    #

    groupAccess(sddop,read)           = auth
    groupAccess(sddadm,read)          = auth
    groupAccess(sddadm,write)         = auth


    slots = { [ use templates.serengeti-platadmin-family-j.slots ]
        originalTables = {
	    slotTableD = { [ use _procedures ]
		type                     = derived
		refreshTrigger	         = *serengeti-platadmin.daq.slots:refresh *serengeti-platadmin.daq.domain:refresh
		refreshService           = _internal
		refreshCommand		 = spltadmGet domainD slots
                slotEntry = {
                    slotBoardType = { [use _procedures ]
                        updateFilter   = slotBoardTypeFilter
                    }
                    slotState = { [use _procedures ]
                        updateFilter   = slotStateFilter
                    }
                    slotTestStatus = { [use _procedures ]
                        updateFilter   = slotTestStatusFilter
                    }
                    slotPowerStatus = { [use _procedures ]
                        updateFilter   = slotPowerStatusFilter
                    }
                    slotDomain = { [use _procedures ]
                        updateFilter   = slotDomainFilter
                    }
                    slotStatus = { [use _procedures ]
                        updateFilter   = slotStatusFilter
                    }
                }
    }
	    cpuBoardTableD = { [ use _procedures ]
		type                     = derived
		refreshTrigger	         = *serengeti-platadmin.daq.cpuBoard:refresh *serengeti-platadmin.daq.domain:refresh
		refreshService           = _internal
		refreshCommand		 = spltadmGet domainD cpuBoard
	    }
	    ioBoardTableD = { [use _procedures ] 
		type                     = derived
		refreshTrigger	         = *serengeti-platadmin.daq.ioBoard:refresh *serengeti-platadmin.daq.domain:refresh
		refreshService           = _internal
		refreshCommand		 = spltadmGet domainD ioBoard
                ioBoardEntry = {
                    ioBoardType = { [use _procedures ]
                        updateFilter   = ioBoardTypeFilter
                    }
               }
	    }
	}
        emptySlots = { [ use templates.serengeti-platadmin-family-j.emptyslots ]

	    emptySlotTable = { [use _procedures ]
		type                     = derived
                refreshTrigger   = originalTables.slotTableD:refresh
                refreshService   = _internal
                refreshCommand   = refreshEmptySlots D

		slotEntry = { 
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = emptySlotTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname D
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = emptySlotTable:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        cpuBoards = { [ use templates.serengeti-platadmin-family-j.cpuboards ]
	    cpuBrdTableD = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.cpuBoardTableD:refresh
                refreshService   = _internal
	        refreshCommand   = refreshCPUBoards D

		cpuBoardEntry = { 
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = cpuBrdTableD:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname D
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = cpuBrdTableD:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        ioBoards = { [ use templates.serengeti-platadmin-family-j.ioboards ]
	    ioBrdTableD = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.ioBoardTableD:refresh
                refreshService   = _internal
	        refreshCommand   = refreshIOBoards D

		ioBoardEntry = { 
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = ioBrdTableD:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname D
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = ioBrdTableD:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
        unknownBoards = { 
	    unknownBrdTable = { [use _procedures ]
		type             = derived
                refreshTrigger   = originalTables.slotTableD:refresh
                refreshService   = _internal
	        refreshCommand   = refreshUnknownBoards D

		unknownBoardEntry = { 
                    slotStatus = { [ use _rules ]
                        alarmRules                    = rspa1000
                    }
		    CmdNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = unknownBrdTableD:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
                        lsnmpService                  = .services.snmp
                        setActions                    = slotoperation
                        setService(slotoperation)     = _internal
                        setCommand(slotoperation)     = slotOperation %value %index %rowname D
		    }
		    CmdStatusNode = { [use _procedures ] 
                        access                        = rw
                        type                          = derived
                        defaultvalue                  = ""
                        refreshTrigger                = unknownBrdTableD:refresh
                        refreshService                = _internal
                        refreshCommand                = refreshCmdNode
		    }
		}
	    }
        }
    }

    fru = { 

	fruTableD = { [ use _procedures ]
		type                     = derived
		refreshTrigger	         = *serengeti-platadmin.daq.fru:refresh
		refreshService           = _internal
		refreshCommand		 = spltadmGet domainD fru
	}
    }


    components = { [ use templates.serengeti-platadmin-family-j.components ]

        cpuMod = { [ use templates.serengeti-platadmin-family-j.cpumodule ]
	    cpuModTableD = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	     = *serengeti-platadmin.daq.cpuMod:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainD cpuMod
		cpuModEntry = { 
                    cpuModStatus = { [use _procedures _rules]
                        updateFilter   = cpuModStatusFilter
			alarmRules   = rspa1008
                    }
                }
	    }
        }




        dimm = { [ use templates.serengeti-platadmin-family-j.dimm ]
	    dimmTableD = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	     = *serengeti-platadmin.daq.dimm:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainD dimm
	    }
        }

        ecache = { [ use templates.serengeti-platadmin-family-j.ecache ]
	    ecacheTableD = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	     = *serengeti-platadmin.daq.ecache:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainD ecache
	    }
        }


        wci = { [ use templates.serengeti-platadmin-family-j.wcimod ]
	    wciModTableD = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	     = *serengeti-platadmin.daq.wci:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainD wci
		wciModEntry = { 
                    wciModStatus = { [use _procedures ]
                        updateFilter   = wciModStatusFilter
                    }
                    wciModMode = { [use _procedures ]
                        updateFilter   = wciModModeFilter
                    }
                }
	    }
        }

        wciPort = { [ use templates.serengeti-platadmin-family-j.wciport ]
	    wciPortTableD = { [ use _procedures ]
		    type                     = derived
		    refreshTrigger	     = *serengeti-platadmin.daq.wciPort:refresh *serengeti-platadmin.daq.domain:refresh
		    refreshService           = _internal
		    refreshCommand           = spltadmGet domainD wciPort
		wciPortEntry = { 
                    wciPortStatus = { [use _procedures ]
                        updateFilter   = wciPortStatusFilter
                    }
                }
	    }
        }

    }


    domains = { [ use templates.serengeti-platadmin-family-j.domains ]
        domainTableD = { [ use _procedures ]
                type                     = derived
		refreshTrigger	         = *serengeti-platadmin.daq.domain:refresh
                refreshService           = _internal
                refreshCommand           = spltadmGet domainD domain

            domainEntry = { 
		domainDomain = { [use _procedures ]
		    updateFilter   = slotDomainFilter
		}
		domainLogHost = { [use _rules ]
		    alarmRules   = rspa1006
		}
		domainTrapHosts = { [use _rules ]
		    alarmRules   = rspa1006
		}
		domainStatus = { [use _procedures _rules ]
		    updateFilter   = domainStatusFilter
                    alarmRules     = rspa1002
		}
		domainSsmMode = { [use _procedures ]
		    updateFilter   = domainSsmModeFilter
		}
		domainKeySwitch = { [use _procedures _rules ]
		    updateFilter   = domainKeySwitchFilter
                    alarmRules     = rspa1003
		}
		snmpAgentPort = { [use _procedures]
                        type              = derived
		        defaultvalue      = 161
                        refreshTrigger    = domainTableD:refresh
                        refreshService    = _internal
                        refreshCommand    = refreshsnmpAgentPort
		}
                slotsNotInACL = { [ use _procedures]
			type              = derived
		        defaultvalue      = ""
                        refreshTrigger    = domainTableD:refresh
                        refreshService    = _internal
                        refreshCommand    = refreshslotsNotInACL
                }
                CmdNode = { [ use _procedures ] 
                    access            = rw
                    type              = derived
		    defaultvalue                  = ""
                    refreshTrigger    = domainTableD:refresh 
                    refreshService    = _internal
                    refreshCommand    = refreshCmdNode

                    lsnmpService      = .services.snmp
                    setActions         = domainopearion
                    setService(domainopearion) = _internal
                    setCommand(domainopearion) = domainOperation %value %index %rowname D
                }
                CmdStatusNode = { [ use _procedures ] 
                    access            = rw
                    type              = derived
		    defaultvalue                  = ""
                    refreshTrigger    = domainTableD:refresh 
                    refreshService    = _internal
                    refreshCommand    = refreshCmdNode
                }

            }
        }
    }
}

#
#Rules related nodes
#

rules = { [ use templates.serengeti-platadmin-family-j.rules ]
    rspa1001 = { [ use _rules ]
	type               = active
	refreshService     = _internal
	refreshCommand     = list 1
	refreshInterval    = 31104000
	alarmRules         = rspa1001
    }

    rspa1004 = { [ use _rules ]
	type               = active
	refreshService     = _internal
	refreshCommand     = list 1
	refreshInterval    = 31104000
	alarmRules         = rspa1004
    }

    rspa1005 = { [ use _rules ]
	type               = active
	refreshService     = _internal
	refreshCommand     = list 1
	refreshInterval    = 31104000
	alarmRules         = rspa1005
    }
    rspa1007 = { [use _procedures]
                 [ use _rules ]
        type               = derived
        refreshService     = _internal
        refreshCommand     = refreshrspa1007
        refreshTrigger     = serengeti-platadmin.scagentstatus:refresh serengeti-platadmin.scagentstatus:set
        alarmRules         = rspa1007
    }

}
