#!/sbin/sh -
# $Id: include.do.sh,v 1.5.65.4.2.1 2003/02/27 00:36:20 poornaa Exp $
#ident "$Source: /project/unixvm-cvs/src/sol/cmd/vxvm/voladm/include.do.sh,v $"

# Copyright (c) 2001 VERITAS Software Corporation.  ALL RIGHTS RESERVED.
# UNPUBLISHED -- RIGHTS RESERVED UNDER THE COPYRIGHT
# LAWS OF THE UNITED STATES.  USE OF A COPYRIGHT NOTICE
# IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION
# OR DISCLOSURE.
# 
# THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND
# TRADE SECRETS OF VERITAS SOFTWARE.  USE, DISCLOSURE,
# OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
# EXPRESS WRITTEN PERMISSION OF VERITAS SOFTWARE.
# 
#               RESTRICTED RIGHTS LEGEND
# USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT IS
# SUBJECT TO RESTRICTIONS AS SET FORTH IN SUBPARAGRAPH
# (C) (1) (ii) OF THE RIGHTS IN TECHNICAL DATA AND
# COMPUTER SOFTWARE CLAUSE AT DFARS 252.227-7013.
#               VERITAS SOFTWARE
# 1600 PLYMOUTH STREET, MOUNTAIN VIEW, CA 94043

: ${VOLROOT_DIR:=$__VXVM_ROOT_DIR}
. ${VOL_SCRIPTS_LIB:-$VOLROOT_DIR/usr/lib/vxvm/lib}/vxcommon


#
# Parameters : 	$1 - pathname (/dev/rdsk/...)
#		$2 - major (an 'out' parameter)
#		$3 - minor (an 'out' parameter)
#
get_longlisting()
{
	longlisting=`ls -l $DISK_RAWPATH/$1`
	set -- $longlisting
	shift 10
	longlisting=`ls -l $DISK_RAWPATH/$1`
	longlisting=`echo $longlisting | sed 's/,/ /'`
	set -- $longlisting
	echo $5 $6
}

include_all()
{
	if [ $1 = vxvm ]
	then
		ewritemsg -M vxvmshm:1136 \
"All disks will be visible to VxVM as a result of this operation."
	else
		ewritemsg -M vxvmshm:1135 \
"All disks will be multipathed by vxdmp as a result of this operation. If any
  devices were excluded from VxVM, they will become visible to VxVM after this
  operation."
	fi

	voladm_yorn -M vxvmshm:115 "Continue operation?" n
	if [ $? -ne 0 ]
	then
		quit 0
	fi
	vxdmpadm include vxvm all 2>/dev/null
	if [ $1 = vxdmp ]
	then
		vxdmpadm include vxdmp all 2>/dev/null
	fi
	touch $excltmpfile1
}

match_vidpid()
{
	if [ "X$1" = "X:" ]
	then
		false
		return
	fi

	input_len=`strlen "$1"`

	match_len=`expr "$1" : '\*:\*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	match_len=`expr "$1" : '[^\*][^\*]*:\*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	match_len=`expr "$1" : '[^\*][^\*]*\*:\*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	match_len=`expr "$1" : '\*:[^\*][^\*]*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	match_len=`expr "$1" : '[^\*][^\*]*:[^\*][^\*]*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	match_len=`expr "$1" : '[^\*][^\*]*\*:[^\*][^\*]*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	match_len=`expr "$1" : '\*:[^\*][^\*]*\*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	match_len=`expr "$1" : '[^\*][^\*]*:[^\*][^\*]*\*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	match_len=`expr "$1" : '[^\*][^\*]*\*:[^\*][^\*]*\*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	false
	return
}

do_include_ctlr()
{
	if [ $1 = vxvm ]
	then
		vxdmpadm checkexclude vxvm ctlr=$2:$3 2>/dev/null
		ret=$?
		if [ $ret -eq 1 ]
		then
			cntrl=$2; export cntrl; ewritemsg -M vxvmshm:1308 \
"All paths under controller $cntrl are already included in VxVM."
			voladm_continue -n
			return 1
		fi

		cntrl=$2; export cntrl; ewritemsg -M vxvmshm:1305 \
"All paths through controller $cntrl will be made visible VxVM again as a result of
  this operation."
		voladm_yorn -M vxvmshm:115 "Continue operation?" y
		
		if [ $? -ne 0 ]
		then
			return 1
		fi
		vxdmpadm enable ctlr=$2 2>/dev/null
		vxdmpadm include vxvm ctlr=$2:$3 2>/dev/null
		# check if any paths are left out
		vxdmpadm checkexclude vxvm ctlr=$2:$3 2>/dev/null
		if [ $? -eq 4 ]
		then
			paths_on_ctlr=`ls $DISK_RAWPATH | grep $2 | grep "s2$"`
			if [ -z "$paths_on_ctlr" ]
			then
				paths_on_ctlr=`ls $DISK_RAWPATH | grep $2 | grep "c$"`
			fi
			for p in $paths_on_ctlr
			do
				vxdmpadm enable path=$p 2>/dev/null
				vxdmpadm include vxvm path=$p:0,0 2>/dev/null
			done
		fi
	else
		vxdmpadm checkexclude vxvm ctlr=$2:$3 2>/dev/null
		ret=$?
		if [ $ret -eq 0 ]
		then
			cntrl=$2; export cntrl; ewritemsg -M vxvmshm:1309 \
"All paths under controller $cntrl are currently excluded from VxVM. Include these
  paths in VxVM to proceed with this operation."
			voladm_continue -n
			quit
		fi

		if [ $ret -eq 3 ]
		then
			ewritemsg -M vxvmshm:1125 \
"All devices are currently excluded from VxVM. Include all devices in VxVM to
  to proceed with this operation."
			voladm_continue -n
			quit
		fi

		vxdmpadm checkexclude vxdmp ctlr=$2:$3 2>/dev/null
		ret=$?
		if [ $ret -ne 0 -a $ret -ne 4 ]
		then
			cntrl=$2; export cntrl; ewritemsg -M vxvmshm:1307 \
"All paths under controller $cntrl are already included for multipathing by vxdmp."
			voladm_continue -n
			return 1
		fi
		ctlrpaths=`vxdmpadm getsubpaths ctlr=$2 2>/dev/null | tail +3 | awk '{ print $1; }'`
		if [ -z "$ctlrpaths" ]
		then
			cntrl=$2; export cntrl; ewritemsg -M vxvmshm:1311 \
"Controller $cntrl is not currently visible to vxdmp. Please check if it has
  already been excluded from vxdmp."
			voladm_continue -n
			return 1
		fi

		allpaths=
		for p in $ctlrpaths
		do
			path_disk=`vxdmpadm getdmpnode nodename=$p 2>/dev/null | tail +3 | awk '{ print $1; }'`
			disk_paths=`vxdmpadm getsubpaths dmpnodename=$path_disk 2>/dev/null | tail +3 | awk '{ print $1; }'`
			allpaths="$allpaths $disk_paths"
		done

		cntrl=$2; export cntrl; ewritemsg -M vxvmshm:1300 \
"All disks having a path through controller $cntrl will be multipathed by vxdmp
  again as a result of this operation."
		voladm_yorn -M vxvmshm:115 "Continue operation?" y
		
		if [ $? -ne 0 ]
		then
			return 1
		fi

		set -- $allpaths
		while [ $# -gt 0 ]
		do
			savebuf=$@
			pathname=`basename $1`
			set -- `get_longlisting $pathname`
			vxdmpadm include vxdmp path=$pathname:$1,$2 2>/dev/null
			set -- $savebuf
			shift 1
		done
	fi

	return 0
}

include_ctlr()
{
	case $1 in
		VXVM)	include=vxvm
			heading=VxVM;;
		DMP)	include=vxdmp
			heading=DMP;;
	esac

	while true
	do
		export heading; voladm_begin_screen -M vxvmshm:1192 \
"Re-include controllers in $heading"

		if [ $heading = VxVM ]
		then
			ewritemsg -M vxvmshm:1252 \
"Use this operation to make all paths through a controller visible to VxVM
  again.  

  As a result of this operation, all paths through the specified controller
  will be made visible to VxVM again."
		else
			ewritemsg -M vxvmshm:1254 \
"Use this operation to make vxdmp multipath all disks on a controller again.

  As a result of this operation, all disks having a path through the specified
  controller will be multipathed by vxdmp again."
  
		fi

		ewritemsg -M vxvmshm:1264 \
"You can specify a controller name at the prompt. A controller name is of
  the form c#, example c3, c11 etc. Enter 'all' to include all paths on all
  controllers on the host."

		# Make sure prompt is displayed on the next line.
		prompt=`egettxt "Enter a controller name" vxvmshm:1287`
		read_input "$prompt [<ctlr-name>,all,list,list-exclude,q,?]"
		if [ -z "$input" ]
		then
			continue
		fi

		set -- $input
		if [ $# -gt 1 ]
		then
			ewritemsg -M vxvmshm:1196 "Specify a single controller."
			voladm_continue -n
			continue
		fi

		if [ $1 = "l" -o $1 = "list" ]
		then
			ctlrlist=`vxdmpadm listctlr all 2>/dev/null | tail +3 | awk '{ print $1; }' | grep -v mc | uniq`
			if [ -z "$ctlrlist" ]
			then
				ewritemsg -M vxvmshm:1181 \
"No controllers were found !!"
				voladm_continue -n
				return
			fi
			ewritemsg -M vxvmshm:1214 \
"The following controllers were found on the system :"
			print_line $ctlrlist
			voladm_continue -n
			continue
		fi

		if [ $1 = "list-exclude" ]
		then
			vxdmpadm listexclude | voladm_display
			echo;echo
			voladm_continue
			continue
		fi

		if [ $1 = "all" ]
		then
			include_all $include
			quit
		fi

#		ctlr_len=`strlen $input`
#		match_len=`expr $input : 'c[0-9][0-9]*'`
#		if not [ "$ctlr_len" -eq "$match_len" ]
		if not dogi_name_is_cntrlr $input
		then
			ewritemsg -M vxvmshm:1224 \
"The input is not in proper format."
			echo;echo
			voladm_continue
			continue
		fi

		includepaths=`ls $DISK_RAWPATH/$input* 2>/dev/null`
		if [ $? -ne 0 ]
		then
			export input; ewritemsg -M vxvmshm:1122 \
"$input is not a valid controller ."
			echo;echo
			voladm_continue
			continue
		fi

		lctlr=$input
		pctlr=$lctlr	# for the include option of vxdmpadm, the
				# physical controller name is just a dummy
		do_include_ctlr $include $lctlr $pctlr

		if [ $? -eq 0 ]
		then
			touch $excltmpfile1
		fi
		voladm_yorn -M vxvmshm:1162 \
"Do you wish to include more controllers ?" n
		if [ $? -eq 0 ]
		then
			continue
		else
			quit
		fi
	done
}

include_path()
{
	case $1 in
		VXVM)	include=vxvm
			heading=VxVM;;
		DMP)	include=vxdmp
			heading=DMP;;
	esac

	while true
	do
		export heading; voladm_begin_screen -M vxvmshm:1193 "Re-include paths in $heading"

		if [ $heading = VxVM ]
		then
			ewritemsg -M vxvmshm:1253 \
"Use this operation to make one or more paths visible to VxVM again.  

  As a result of this operation,the specified paths will become visible to
  VxVM again."
		else
			ewritemsg -M vxvmshm:1256 \
"Use this operation to make vxdmp multipath one or more disks again.

  As a result of this operation, all disks corresponding to the specified
  paths will be multipathed by vxdmp again."
  
		fi

		ewritemsg -M vxvmshm:1265 \
"You can specify a pathname or a pattern at the prompt.  Here are
  some path selection examples:

  all:		all paths
  c4t2:		all paths on controller 4, target 2
  c3t4d2:	a single path"

		# Make sure prompt is displayed on the next line.
		prompt=`egettxt "Enter a pathname or pattern :" vxvmshm:1288`
		read_input "$prompt [<pattern>,all,list,list-exclude,q,?]"
		if [ -z "$input" ]
		then
			continue
		fi

		set -- $input
		if [ $# -gt 1 ]
		then
			ewritemsg -M vxvmshm:1197 "Specify a single path/pattern."
			voladm_continue -n
			continue
		fi

		if [ $1 = "list" -o $1 = "l" ]
		then
			list_dmpnode_paths | voladm_display
			voladm_continue
			continue
		fi

		if [ $1 = "list-exclude" ]
		then
			vxdmpadm listexclude | voladm_display
			echo;echo
			voladm_continue
			continue
		fi

		if [ $1 = "all" ]
		then
			include_all $include
			quit
		fi

		if match_slice_path $1
		then
			in_path=${input}
		elif match_lun_path $1
		then
			in_path=${input}s*
		elif match_vpath_path $1
		then
			in_path=${input}c
		elif match_target_path $1
		then
			in_path=${input}d*
		else
			ewritemsg -M vxvmshm:1225 \
"The input is not in valid format."
			echo;echo
			voladm_continue
			continue
		fi

		includepaths=`ls $DISK_RAWPATH/$in_path* 2>/dev/null | grep "s2"`
		if [ -z "$includepaths" ]
		then
			includepaths=`ls $DISK_RAWPATH/$in_path* 2>/dev/null | grep "c"`
		fi

		if [ -z "$includepaths" ]
		then
			ewritemsg -M vxvmshm:1183 \
"No paths were found matching the input pattern."
			echo;echo
			voladm_continue
			continue
		fi

		if [ $heading = DMP ]
		then
			vxdmpadm checkexclude vxvm all 2>/dev/null
			if [ $? -eq 3 ]
			then
				ewritemsg -M vxvmshm:1125 \
"All devices are currently excluded from VxVM. Include all devices in VxVM to
  to proceed with this operation."
				voladm_continue -n
				return 1
			fi

			allpaths=
			for p in $includepaths
			do
				tmpp=`basename $p`
				dmpnode=`vxdmpadm getdmpnode nodename=$tmpp 2>/dev/null | tail +3 | awk '{ print $1; }'`
				tmppaths=`vxdmpadm getsubpaths dmpnodename=$dmpnode 2>/dev/null | tail +3 | awk '{ print $1; }'`
				set -- $tmppaths
				while [ $# -gt 0 ]
				do
					present=`echo $allpaths | grep $1`	
					if [ -z "$present" ]
					then
						allpaths="$allpaths $1"	
					fi
					shift 1
				done
			done
			includepaths=$allpaths
		fi

		if [ -z "$includepaths" ]
		then
			ewritemsg -M vxvmshm:1151 \
"Could not get paths to the specified disk"
			voladm_continue -n
			quit 1
		fi

		if [ $heading = VxVM ]
		then
			ewritemsg -M vxvmshm:1222 \
"The following paths will be made visible to VxVM as a result of this
  operation :"
		else
			ewritemsg -M vxvmshm:1223 \
"The following paths will become available for multipathing by vxdmp as a
  result of this operation :"
		fi
		includedevs=`slice_to_device $includepaths`
		print_line $includedevs

		voladm_yorn -M vxvmshm:115 "Continue operation?" y
		if [ $? -ne 0 ]
		then
			quit 0
		fi

		pcount=zero
		set -- $includepaths
		while [ $# -gt 0 ]
		do
			pathname=`basename $1`
			device=`slice_to_device $pathname`
			if [ $heading = DMP ]
			then
				vxdmpadm checkexclude vxvm path=$pathname:$pathname 2>/dev/null
				ret=$?
				if [ $ret -eq 0 ]
				then
					export device; ewritemsg -M vxvmshm:1228 \
"The path $device is currently excluded from VxVM. Include this path in VxVM
  to proceed with the operation."
					echo
					voladm_continue -n
					shift 1
					continue
				fi

				vxdmpadm checkexclude vxdmp path=$pathname:$pathname 2>/dev/null
				ret=$?
				if [ $ret -eq 1 ]
				then
					export device; ewritemsg -M vxvmshm:1227 \
"The path $device is already included for multipathing by vxdmp."
					echo
					voladm_continue -n
					shift 1
					continue
				else
					vxdmpadm include $include path=$pathname:$pathname 2>/dev/null
					pcount=nonzero
				fi
			else
				vxdmpadm checkexclude vxvm path=$pathname:$pathname 2>/dev/null
				if [ $? -eq 1 ]
				then
					export device; ewritemsg -M vxvmshm:1229 \
"The path $device is currently not excluded from VxVM."
					echo
					voladm_continue -n
				else
					vxdmpadm enable path=$pathname 2>/dev/null
					vxdmpadm include $include path=$pathname:$pathname 2>/dev/null
					pcount=nonzero
				fi
			fi
			shift 1
		done

		if [ "$pcount" = "nonzero" ]
		then
			if [ $include = vxvm ]
			then
				touch $excltmpfile1
			elif [ $include = vxdmp ]
			then
				touch $excltmpfile1
			fi
		fi

		voladm_yorn -M vxvmshm:1163 "Do you wish to include more paths ?" n
		if [ $? -eq 0 ]
		then
			continue
		else
			quit
		fi
	done
}

include_vidpid()
{
	case $1 in
		VXVM)	include=vxvm
			heading=VxVM;;
		DMP)	include=vxdmp
			heading=DMP;;
	esac

	while true
	do
		export heading; voladm_begin_screen -M vxvmshm:1174 \
"Make VID:PID visible to $heading"
 
		if [ $heading = VxVM ]
		then
			ewritemsg -M vxvmshm:1251 \
"Use this operation to make all disks returning a specified VendorID:ProductID
  combination visible to VxVM again.

  As a result of this operation, disks that return VendorID:ProductID matching
  the specified combination will be made visible to VxVM again."
		else
			ewritemsg -M vxvmshm:1255 \
"Use this operation to make vxdmp multipath disks returning a specified
  VendorID:ProductID combination again.

  As a result of this operation, all disks that return VID:PID matching the
  specified combination will be multipathed by vxdmp again."
		fi

		export MAX_VENDORID MAX_PRODUCTID; ewritemsg -M vxvmshm:1407 \
"You can specify a VID:PID combination at the prompt. The specification
  can be as follows :
 
 	VID:PID		where VID stands for Vendor  ID
			      PID stands for Product ID
			      (The command vxdmpinq in /etc/vx/diag.d can be
			       used to obtain the Vendor ID and Product ID)

	Both VID and PID can have an optional '*' (asterisk) following them.
	If a '*' follows VID, it will result in the inclusion of all disks
	returning Vendor ID starting with the specified VID. The same is true
	for Product ID as well. Both VID and PID should be non NULL. The
	maximum allowed lengths for Vendor ID and Product ID are $MAX_VENDORID
	and $MAX_PRODUCTID characters respectively.

	Some examples of VID:PID specification are:

	all		- Include all disks
	aaa:123 	- Include all disks having VID 'aaa' and PID '123'
	aaa*:123 	- Include all disks having VID starting with 'aaa' 
			  and PID '123'
	aaa:123* 	- Include all disks having VID 'aaa' and PID starting
			  with '123'
	aaa:*		- Include all disks having VID 'aaa' and any PID"

		# Make sure prompt is displayed on the next line.
		prompt=`egettxt "Enter a VID:PID combination:" vxvmshm:1286`
		read_input "$prompt [<pattern>,all,list-exclude,q,?]"
		if [ -z "$input" ]
		then
			continue
		fi

		eval set -- "$input"
		if [ $# -gt 1 ]
		then
			ewritemsg -M vxvmshm:1195 \
"Specify a single VID:PID combination."
			voladm_continue -n
			continue
		fi

		if [ "$1" = "list-exclude" ]
		then
			vxdmpadm listexclude | voladm_display
			echo;echo
			voladm_continue
			continue
		fi

		if [ "$1" = "all" ]
		then
			include_all $include
			quit
		fi

		match_vidpid "$1" || {
			ewritemsg -M vxvmshm:1224 \
"The input is not in proper format."
			echo;echo
			voladm_continue
			continue
		}

		vxdmpadm checkexclude $include product="$1" 2>/dev/null
		if [ $? -eq 2 ]
		then
			ewritemsg -M vxvmshm:1165 \
"Either VID or PID exceeds the maximum allowed length. Please ensure that they
  don't exceed the specified maximum allowed lengths."
			voladm_continue -n
			continue
		fi

		if [ $heading = DMP ]
		then
			vxdmpadm checkexclude vxvm product="$1" 2>/dev/null
			ret=$?
			if [ $ret -eq 0 ]
			then
				combstr="$1"; export combstr; ewritemsg -M vxvmshm:1319 \
"The VID:PID combination $combstr is currently excluded from VxVM. Include this
  VID:PID combination in VxVM to proceed with the operation."
				voladm_continue -n
				return 1
			fi

			if [ $ret -eq 3 ]
			then
				ewritemsg -M vxvmshm:1125 \
"All devices are currently excluded from VxVM. Include all devices in VxVM to
  to proceed with this operation."
				voladm_continue -n
				return 1
			fi
		fi

		vxdmpadm checkexclude $include product="$1" 2>/dev/null
		if [ $? -ne 0 ]
		then
			if [ $heading = VxVM ]
			then
				combstr="$1"; export combstr; ewritemsg -M vxvmshm:1320 \
"The VID:PID combination $combstr is currently not excluded from VxVM."
			else
				combstr="$1"; export combstr; ewritemsg -M vxvmshm:1321 \
"The VID:PID combination $combstr is currently not excluded from multipathing by
  vxdmp."
			fi
			echo;echo
			voladm_continue
			continue
		fi

		if [ $heading = VxVM ]
		then
			combstr="$1"; export combstr; ewritemsg -M vxvmshm:1303 \
"All disks returning VID:PID matching the combination $combstr will be
  included in VxVM as a result of this operation."
		else
			combstr="$1"; export combstr; ewritemsg -M vxvmshm:1304 \
"All disks returning VID:PID matching the combination $combstr will be
  multipathed by vxdmp as a result of this operation."
		fi

		voladm_yorn -M vxvmshm:115 "Continue operation?" y
		if [ $? -ne 0 ]
		then
			quit 0
		fi
		
		vxdmpadm include $include product="$1" 2>/dev/null

		touch $excltmpfile1

		voladm_yorn -M vxvmshm:1161 \
"Do you wish to include more Vendor ID:Product ID combinations ?" n
		if [ $? -eq 0 ]
		then
			continue
		else
			quit
		fi
	done
}

rm_pathgroup()
{
	while true
	do
		voladm_begin_screen -M vxvmshm:1194 \
"Remove a pathgroup definition"

		ewritemsg -M vxvmshm:1258 \
"Use this operation to remove the definition of pathgroup. Specify the
  serial numbers of the pathgroups at the prompt. This can be obtained by
  typing list-exclude at the prompt."

		# Make sure prompt is displayed on the next line.
		prompt=`egettxt "Enter pathgroup number(s):" vxvmshm:1290`
		read_input "$prompt [<number>,list-exclude,q,?]"
		if [ -z "$input" ]
		then
			continue
		fi

		set -- $input
		if [ $1 = "list-exclude" ]
		then
			vxdmpadm listexclude | voladm_display
			echo;echo
			voladm_continue
			continue
		fi

		while [ $# -gt 0 ]
		do
			input_len=`strlen $1`
			match_len=`expr $1 : '[1-9][0-9]*'`
			if [ $input_len -ne $match_len ]
			then
				path=$1;  export path;ewritemsg -M vxvmshm:1299 \
"$path is an invalid pathgroup specification."
				echo
				voladm_continue
				continue 2
			fi
			vxdmpadm listexclude | grep "^$1" 2>/dev/null 1>&2
			if [ $? -ne 0 ]
			then
				path=$1; export path; ewritemsg -M vxvmshm:1317 \
"Pathgroup $path doesn't exist."
				echo
				voladm_continue
				continue 2
			fi
			shift 1
		done

		vxdmpadm rmgroup $input 2>/dev/null
		touch $excltmpfile1

		voladm_yorn -M vxvmshm:1164 \
"Do you wish to remove more pathgroups ?" n
		if [ $? -eq 0 ]
		then
			continue
		else
			quit
		fi
	done
}

set_OS_variables

voladm_menu_push $1-$2

case $1 in
	PATH)
		include_path $2;;
	CTLR)	
		include_ctlr $2;;
	VIDPID)
		include_vidpid $2;;
	PATHGROUP)
		rm_pathgroup $2;;
esac

quit 0
