/* $Id: libvxvmsc.h,v 1.4.45.2 2001/09/28 03:10:53 niranjan Exp $ */
/* #ident "$Source: /project/unixvm-cvs/src/sol/lib/vxvm/libvxvmsc/libvxvmsc.h,v $" */

/*
 * Copyright (c) 2001 VERITAS Software Corporation.  ALL RIGHTS RESERVED.
 * UNPUBLISHED -- RIGHTS RESERVED UNDER THE COPYRIGHT
 * LAWS OF THE UNITED STATES.  USE OF A COPYRIGHT NOTICE
 * IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION
 * OR DISCLOSURE.
 * 
 * THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND
 * TRADE SECRETS OF VERITAS SOFTWARE.  USE, DISCLOSURE,
 * OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
 * EXPRESS WRITTEN PERMISSION OF VERITAS SOFTWARE.
 * 
 *               RESTRICTED RIGHTS LEGEND
 * USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT IS
 * SUBJECT TO RESTRICTIONS AS SET FORTH IN SUBPARAGRAPH
 * (C) (1) (ii) OF THE RIGHTS IN TECHNICAL DATA AND
 * COMPUTER SOFTWARE CLAUSE AT DFARS 252.227-7013.
 *               VERITAS SOFTWARE
 * 1600 PLYMOUTH STREET, MOUNTAIN VIEW, CA 94043
 */

#ifndef _LIBVXVMSC_H
#define _LIBVXVMSC_H

#include <sys/types.h>
#include <vxvm/vxtypes.h>
#include <sys/stat.h>
#include <sys/param.h>

#define	LIBVXVM_MAJOR_VERSION	1
#define	LIBVXVM_MINOR_VERSION	1
#define	LIBVXVM_MAKE_VERSION(maj, min)	((maj) << 8 | (min))
#define	LIBVXVM_GET_MAJOR_VERSION(ver)	((ver) >> 8)
#define	LIBVXVM_GET_MINOR_VERSION(ver)	((ver) & 0xff)

#define	IMPORT_OPT_FORCE	0x1
#define	IMPORT_OPT_TEMPNAME	0x2
#define	IMPORT_OPT_CLEARIMPORT	0x4
#define	IMPORT_OPT_REMINOR	0x8
#define	IMPORT_OPT_MASK		0xf

#define	LIBVXVM_NAME_SIZE	1
#define	LIBVXVM_PATH_SIZE	2
#define	LIBVXVM_DEVNAME_SZ	3

typedef vx_u32_t	vm_major_t;
typedef vx_u32_t	vm_minor_t;
typedef char		vm_name_t[];
typedef char		vm_path_t[];

#if defined(__STDC__)

extern int libvxvm_get_version(int version);
extern int libvxvm_get_conf(int param);
extern int libvxvm_get_dgs(int len, vm_name_t namep[]);
extern int libvxvm_get_dginfo(vm_name_t dgname, vm_name_t dgid,
	vm_major_t *majorp, vm_minor_t *minorp,
	vx_u32_t *maxvolp, vx_u32_t *nvolp);
extern int libvxvm_get_disks(vm_name_t dgname, int len, vm_path_t pathp[]);
extern int libvxvm_get_volumes(vm_name_t dgname, int len, vm_name_t namep[]);
extern int libvxvm_get_volinfo(vm_name_t dgname, vm_name_t volname,
	struct stat *statp);
extern int libvxvm_import_dg(vm_name_t dgname, vm_name_t newname,
	vx_u32_t flags, vm_minor_t newminor);
extern int libvxvm_deport_dg(vm_name_t dgname, vm_name_t newname,
	vm_name_t newhostid);
extern int libvxvm_get_subpaths(char *dmp_nodename, int *numpaths,
						char **pathnamep);

#else   /* __STDC__ */

extern int libvxvm_get_version();
extern int libvxvm_get_conf();
extern int libvxvm_get_dgs();
extern int libvxvm_get_dginfo();
extern int libvxvm_get_disks();
extern int libvxvm_get_volumes();
extern int libvxvm_get_volinfo();
extern int libvxvm_import_dg();
extern int libvxvm_deport_dg();
extern int libvxvm_get_subpaths();

#endif  /* __STDC__ */

#endif  /* _LIBVXVMSC_H */
