#!/bin/sh
# $Id: skel.vras.sh,v 2.2.6.9 2003/04/24 18:02:38 ddang Exp $
#ident "$Source: /project/vras-cvs/src/sol/cmd/vras/init.d/skel.vras.sh,v $"
#
#
# Copyright (c) 2001 VERITAS Software Corporation.  ALL RIGHTS RESERVED.
#
# UNPUBLISHED -- RIGHTS RESERVED UNDER THE COPYRIGHT
# LAWS OF THE UNITED STATES.  USE OF A COPYRIGHT NOTICE
# IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION
# OR DISCLOSURE.
#
# THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND
# TRADE SECRETS OF VERITAS SOFTWARE.  USE, DISCLOSURE,
# OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
# EXPRESS WRITTEN PERMISSION OF VERITAS SOFTWARE.
#
#               RESTRICTED RIGHTS LEGEND
# USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT IS
# SUBJECT TO RESTRICTIONS AS SET FORTH IN SUBPARAGRAPH
# (C) (1) (ii) OF THE RIGHTS IN TECHNICAL DATA AND
# COMPUTER SOFTWARE CLAUSE AT DFARS 252.227-7013.
#               VERITAS SOFTWARE
# 1600 PLYMOUTH STREET, MOUNTAIN VIEW, CA 94043
#


# Volume Replicator Administrative Services (VRAS) Daemon Script 
# start up / shut down vradmind daemon
# Starts vradmind daemon only if VVR license is installed

PATH=/usr/lib/vxvm/bin/:$PATH

. ${VOLADM_LIB:-/usr/lib/vxvm/voladm.d/lib}/vxadm_lib.sh

progname=$0
daemon="vradmind"

# Set the locale information for message localization. This
# function can be used at boot time or called by other
# commands in user space (such as vxinstall.) At boot time
# we do not want localized messages, so we check for an
# environment variable to see when we are called. The variable
# will not exist at boot time.

OLC_MESSAGES=LC_MESSAGES
export OLC_MESSAGES
if [ $L10N_CMD ]
then
	#  L10N_CMD exists and is set to require localized
	#  messages.

	if [ $L10N_CMD = 1 ]
	then
		LC_MESSAGES=C
		export LC_MESSAGES
	fi
else
	#  L10N_CMD does not exist (or could be set to NULL)
	#  Assume we are booting the system and no localized
	#  messages are required.

	LC_MESSAGES=C
	export LC_MESSAGES
fi

#
# All environment variables used by vradmind are defined in this file
#
ENVFILE=/etc/vx/vras/vras_env

findproc() {		# return pid of the named process(es)
	pid=`/usr/bin/ps -e -o pid,comm |
		 /usr/bin/grep "$1" | /usr/bin/grep -v grep |
		 /usr/bin/awk '{ print $1 }'`
}

check_vvr_license() { 		# return 0 if has vvr license 
							# and return 1 otherwise
	/sbin/vxlictest -n "VERITAS Volume Manager" -f "VVR" >/dev/null 2>&1
	if [ "$?" -eq 0 ]; then
		return 0
	else
		return 1
	fi
}

if [ ! -d /usr/sbin ]
then					# /usr not mounted
	exit
fi

case "$1" in
'start')		
	# check for vvr license
	check_vvr_license;
	if [ "$?" -eq 1 ]; then
		exit 1
	fi
	
	# make sure file install-db does not exist
	if [ -f /etc/vx/reconfig.d/state.d/install-db ]; then
		export daemon; ewritemsg -M vras.mesg:2410 \
			"VM installation not complete; $daemon not started."
		exit 1
	fi

	# check if vradmind is already running
	findproc vradmind;
	if [ "$pid" <> "" ]; then
		exit 0
	fi

	# source the environment variables defined in ENVFILE
	if [ -f ${ENVFILE} ]; then
		. ${ENVFILE}
	fi

	# start vradmind
	/usr/sbin/vradmind 
    ;;
'stop')
	findproc vradmind;
	if [ "$pid" <> "" ]; then
		/bin/kill -15 $pid
	fi
	;;
*)
	export progname; ewritemsg -M vras.mesg:2408 \
    	"Usage: $progname { start | stop }"
    exit 1
    ;;
esac

exit 0
