/*
 * Copyright 1986-1990,1995-2002 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*	Copyright (c) 1984, 1986, 1987, 1988, 1989 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 * +++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *		PROPRIETARY NOTICE (Combined)
 *
 * This source code is unpublished proprietary information
 * constituting, or derived under license from AT&T's UNIX(r) System V.
 * In addition, portions of such source code were derived from Berkeley
 * 4.3 BSD under license from the Regents of the University of
 * California.
 *
 *
 *
 *		Copyright Notice
 *
 * Notice of copyright on this source code product does not indicate
 * publication.
 *
 *	Copyright (c) 1983-1989 by AT&T.
 *	All rights reserved.
 */

#ifndef	_VM_SEG_H
#define	_VM_SEG_H

#pragma ident	"@(#)seg.h	1.67	02/06/18 SMI"
/*	From:	SVr4.0	"kernel:vm/seg.h	1.10"		*/

#include <sys/vnode.h>
#include <sys/avl.h>
#include <vm/seg_enum.h>
#include <vm/faultcode.h>
#include <vm/hat.h>

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * VM - Segments.
 */

/*
 * kstat statistics for segment advise
 */
typedef struct {
	kstat_named_t MADV_FREE_hit;
	kstat_named_t MADV_FREE_miss;
} segadvstat_t;

/*
 * memory object ids
 */
typedef struct memid { u_longlong_t val[2]; } memid_t;

/*
 * An address space contains a set of segments, managed by drivers.
 * Drivers support mapped devices, sharing, copy-on-write, etc.
 *
 * The seg structure contains a lock to prevent races, the base virtual
 * address and size of the segment, a back pointer to the containing
 * address space, pointers to maintain an AVL tree of segments in the
 * same address space, and procedure and data hooks for the driver.
 * The AVL tree of segments for the address space is sorted by
 * ascending base addresses and overlapping segments are not allowed.
 *
 * After a segment is created, faults may occur on pages of the segment.
 * When a fault occurs, the fault handling code must get the desired
 * object and set up the hardware translation to the object.  For some
 * objects, the fault handling code also implements copy-on-write.
 *
 * When the hat wants to unload a translation, it can call the unload
 * routine which is responsible for processing reference and modify bits.
 *
 * Each segment is protected by it's containing address space lock.  To
 * access any field in the segment structure, the "as" must be locked.
 * If a segment field is to be modified, the address space lock must be
 * write locked.
 */

struct seg {
	caddr_t	s_base;			/* base virtual address */
	size_t	s_size;			/* size in bytes */
	uint_t	s_szc;			/* max page size code */
	struct	as *s_as;		/* containing address space */
	avl_node_t s_tree;		/* AVL tree links to segs in this as */
	struct	seg_ops *s_ops;		/* ops vector: see below */
	void *s_data;			/* private data for instance */
};

struct	seg_ops {
	int	(*dup)(struct seg *, struct seg *);
	int	(*unmap)(struct seg *, caddr_t, size_t);
	void	(*free)(struct seg *);
	faultcode_t (*fault)(struct hat *, struct seg *, caddr_t, size_t,
	    enum fault_type, enum seg_rw);
	faultcode_t (*faulta)(struct seg *, caddr_t);
	int	(*setprot)(struct seg *, caddr_t, size_t, uint_t);
	int	(*checkprot)(struct seg *, caddr_t, size_t, uint_t);
	int	(*kluster)(struct seg *, caddr_t, ssize_t);
	size_t	(*swapout)(struct seg *);
	int	(*sync)(struct seg *, caddr_t, size_t, int, uint_t);
	size_t	(*incore)(struct seg *, caddr_t, size_t, char *);
	int	(*lockop)(struct seg *, caddr_t, size_t, int, int, ulong_t *,
			size_t);
	int	(*getprot)(struct seg *, caddr_t, size_t, uint_t *);
	u_offset_t	(*getoffset)(struct seg *, caddr_t);
	int	(*gettype)(struct seg *, caddr_t);
	int	(*getvp)(struct seg *, caddr_t, struct vnode **);
	int	(*advise)(struct seg *, caddr_t, size_t, uint_t);
	void	(*dump)(struct seg *);
	int	(*pagelock)(struct seg *, caddr_t, size_t, struct page ***,
			enum lock_type, enum seg_rw);
	int	(*setpagesize)(struct seg *, caddr_t, size_t, uint_t);
	int	(*getmemid)(struct seg *, caddr_t, memid_t *);
	struct lgrp_mem_policy_info	*(*getpolicy)(struct seg *, caddr_t);
};

#ifdef _KERNEL
/*
 * Generic segment operations
 */
extern	void	seg_init(void);
extern	struct	seg *seg_alloc(struct as *as, caddr_t base, size_t size);
extern	int	seg_attach(struct as *as, caddr_t base, size_t size,
			struct seg *seg);
extern	void	seg_unmap(struct seg *seg);
extern	void	seg_free(struct seg *seg);

/*
 * functions for pagelock cache support
 */
extern	void	seg_ppurge(struct seg *seg);
extern	void	seg_pinactive(struct seg *seg, caddr_t addr, size_t len,
			struct page **pp, enum seg_rw rw, void (*callback)());
extern	int	seg_pinsert_check(struct seg *seg, size_t len, uint_t flags);
extern	int	seg_pinsert(struct seg *seg, caddr_t addr, size_t len,
			struct page **pp, enum seg_rw rw, uint_t flags,
			void (*callback)());
extern	struct	page **seg_plookup(struct seg *seg, caddr_t addr,
			size_t len, enum seg_rw rw);
extern	void	seg_pasync_thread(void);
extern	void	seg_preap(void);

extern	int	seg_preapahead;
extern	segadvstat_t  segadvstat;
/*
 * Flags for pagelock cache support
 */
#define	SEGP_ASYNC_FLUSH	0x1	/* flushed by async thread */
#define	SEGP_FORCE_WIRED	0x2	/* skip check against seg_pwindow */

/*
 * Return values for seg_pinsert and seg_pinsert_check functions.
 */
#define	SEGP_SUCCESS		0	/* seg_pinsert() succeeded */
#define	SEGP_FAIL		1	/* seg_pinsert() failed */

/* Page status bits for segop_incore */
#define	SEG_PAGE_INCORE		0x01	/* VA has a page backing it */
#define	SEG_PAGE_LOCKED		0x02	/* VA has a page that is locked */
#define	SEG_PAGE_HASCOW		0x04	/* VA has a page with a copy-on-write */
#define	SEG_PAGE_SOFTLOCK	0x08	/* VA has a page with softlock held */
#define	SEG_PAGE_VNODEBACKED	0x10	/* Segment is backed by a vnode */
#define	SEG_PAGE_ANON		0x20	/* VA has an anonymous page */
#define	SEG_PAGE_VNODE		0x40	/* VA has a vnode page backing it */

#define	SEGOP_DUP(s, n)		    (*(s)->s_ops->dup)((s), (n))
#define	SEGOP_UNMAP(s, a, l)	    (*(s)->s_ops->unmap)((s), (a), (l))
#define	SEGOP_FREE(s)		    (*(s)->s_ops->free)((s))
#define	SEGOP_FAULT(h, s, a, l, t, rw) \
		(*(s)->s_ops->fault)((h), (s), (a), (l), (t), (rw))
#define	SEGOP_FAULTA(s, a)	    (*(s)->s_ops->faulta)((s), (a))
#define	SEGOP_SETPROT(s, a, l, p)   (*(s)->s_ops->setprot)((s), (a), (l), (p))
#define	SEGOP_CHECKPROT(s, a, l, p) (*(s)->s_ops->checkprot)((s), (a), (l), (p))
#define	SEGOP_KLUSTER(s, a, d)	    (*(s)->s_ops->kluster)((s), (a), (d))
#define	SEGOP_SWAPOUT(s)	    (*(s)->s_ops->swapout)((s))
#define	SEGOP_SYNC(s, a, l, atr, f) \
		(*(s)->s_ops->sync)((s), (a), (l), (atr), (f))
#define	SEGOP_INCORE(s, a, l, v)    (*(s)->s_ops->incore)((s), (a), (l), (v))
#define	SEGOP_LOCKOP(s, a, l, atr, op, b, p) \
		(*(s)->s_ops->lockop)((s), (a), (l), (atr), (op), (b), (p))
#define	SEGOP_GETPROT(s, a, l, p)   (*(s)->s_ops->getprot)((s), (a), (l), (p))
#define	SEGOP_GETOFFSET(s, a)	    (*(s)->s_ops->getoffset)((s), (a))
#define	SEGOP_GETTYPE(s, a)	    (*(s)->s_ops->gettype)((s), (a))
#define	SEGOP_GETVP(s, a, vpp)	    (*(s)->s_ops->getvp)((s), (a), (vpp))
#define	SEGOP_ADVISE(s, a, l, b)    (*(s)->s_ops->advise)((s), (a), (l), (b))
#define	SEGOP_DUMP(s)		    (*(s)->s_ops->dump)((s))
#define	SEGOP_PAGELOCK(s, a, l, p, t, rw) \
		(*(s)->s_ops->pagelock)((s), (a), (l), (p), (t), (rw))
#define	SEGOP_SETPAGESIZE(s, a, l, szc) \
		(*(s)->s_ops->setpagesize)((s), (a), (l), (szc))
#define	SEGOP_GETMEMID(s, a, mp)    (*(s)->s_ops->getmemid)((s), (a), (mp))
#define	SEGOP_GETPOLICY(s, a)	    (*(s)->s_ops->getpolicy)((s), (a))

#define	seg_page(seg, addr) \
	(((uintptr_t)((addr) - (seg)->s_base)) >> PAGESHIFT)

#define	seg_pages(seg) \
	(((uintptr_t)((seg)->s_size + PAGEOFFSET)) >> PAGESHIFT)

#define	IE_NOMEM	-1	/* internal to seg layer */
#define	IE_RETRY	-2	/* internal to seg layer */
#define	IE_REATTACH	-3	/* internal to seg layer */

/* Delay/retry factors for seg_p_mem_config_pre_del */
#define	SEGP_PREDEL_DELAY_FACTOR	4
#define	SEGP_STALL_THRESHOLD		2

#ifdef VMDEBUG

uint_t	seg_page(struct seg *, caddr_t);
uint_t	seg_pages(struct seg *);

#endif	/* VMDEBUG */

#endif	/* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _VM_SEG_H */
