/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTMib;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.MibTree;
import com.sun.jdmk.tools.mibgen.SemanticException;
import com.sun.jdmk.tools.mibgen.Trace;
import java.util.Enumeration;
import java.util.Hashtable;

public class ModulesHandler {
    protected Hashtable modules = new Hashtable();
    protected Hashtable id_resolvers = new Hashtable();
    protected Hashtable ind_resolvers;
    protected Hashtable ref_resolvers = new Hashtable();
    private static final String sccs_id = "@(#)ModulesHandler.java 4.8 03/20/00 SMI";

    public ModulesHandler() {
        this.ind_resolvers = new Hashtable();
    }

    public void addMibModule(String string, ASTMib aSTMib) throws SemanticException {
        ASTMib aSTMib2 = (ASTMib)this.modules.get(string);
        if (aSTMib2 != null) {
            throw new SemanticException(MessageHandler.getMessage("compile.error.duplicate.module", string));
        }
        this.modules.put(string, aSTMib);
        Trace.info(MessageHandler.getMessage("compile.info.endParse", string));
    }

    public boolean buildMibTrees() {
        boolean bl = true;
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            ASTMib aSTMib = (ASTMib)enumeration.nextElement();
            boolean bl2 = aSTMib.buildMibTree();
            if (bl2) continue;
            bl = false;
        }
        return bl;
    }

    private boolean checkSymbolClosure() {
        boolean bl = true;
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            ASTMib aSTMib = (ASTMib)enumeration.nextElement();
            if (aSTMib.printUndefinedSymbols()) continue;
            bl = false;
        }
        return bl;
    }

    private boolean computeValues() {
        boolean bl = true;
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            ASTMib aSTMib = (ASTMib)enumeration.nextElement();
            if (aSTMib.computeValues()) continue;
            bl = false;
        }
        return bl;
    }

    public void dumpMibTrees(String string) {
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            ASTMib aSTMib = (ASTMib)enumeration.nextElement();
            aSTMib.printMibTree(string);
        }
    }

    public MibNode findNodeWithName(String string) {
        MibNode mibNode = null;
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            ASTMib aSTMib = (ASTMib)enumeration.nextElement();
            MibTree mibTree = aSTMib.getMibTree();
            MibNode mibNode2 = mibTree.getRoot();
            mibNode = mibNode2.findNodeWithName(string);
            if (mibNode == null) continue;
            return mibNode;
        }
        return mibNode;
    }

    public static String getClassVersion() {
        return sccs_id;
    }

    private void globalResolve() {
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            ASTMib aSTMib = (ASTMib)enumeration.nextElement();
            aSTMib.globalResolve(this.id_resolvers, this.ref_resolvers, this.ind_resolvers);
        }
    }

    private void localResolve() {
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            ASTMib aSTMib = (ASTMib)enumeration.nextElement();
            aSTMib.localResolve();
            this.id_resolvers.put(aSTMib.getModuleName(), aSTMib.getIdResolver());
            this.ref_resolvers.put(aSTMib.getModuleName(), aSTMib.getRefResolver());
            this.ind_resolvers.put(aSTMib.getModuleName(), aSTMib.getIndexResolver());
        }
    }

    public Enumeration mibElements() {
        return this.modules.elements();
    }

    public void removeMibModule(String string) {
        this.modules.remove(string);
    }

    public boolean resolve() {
        this.localResolve();
        this.globalResolve();
        if (!this.checkSymbolClosure()) {
            return false;
        }
        return this.computeValues();
    }
}

