/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools;

import com.sun.jdmk.Introspector;
import com.sun.jdmk.tools.ProxyGenClassLoader;
import com.sun.jdmk.tools.proxygen.MOGenerator;
import com.sun.jdmk.tools.proxygen.MOStubGenerator;
import com.sun.jdmk.tools.proxygen.MOStubGeneratorRO;
import com.sun.jdmk.tools.proxygen.MessageHandler;
import com.sun.jdmk.tools.proxygen.Trace;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;

public final class ProxyGen {
    String program;
    OutputStream out;
    private boolean readOnly = false;
    private boolean noSuperClass = false;
    private boolean noPerformer = false;
    private boolean noCascading = false;
    private boolean inheritance = false;
    private boolean ownInterfaces = false;
    private boolean allInterfaces = false;
    private Vector v;
    private String classPathString;
    private static String targetDir = "";
    private String specificLevelName = null;
    private String specificPackageName = null;
    private ProxyGenClassLoader classLoader = null;
    private static final String sccs_id = "@(#)ProxyGen.java 4.31 10/12/00 SMI";

    private ProxyGen(OutputStream outputStream, String string) {
        this.out = outputStream;
        Trace.setOutput(this.out);
        this.program = string;
    }

    public static int compile(String[] stringArray) {
        ProxyGen proxyGen = new ProxyGen(System.out, "proxygen");
        return proxyGen.startCompile(stringArray) ? 0 : 1;
    }

    private boolean doCompile() throws NotCompliantMBeanException {
        int n = this.v.size() - 1;
        while (n >= 0) {
            String string = (String)this.v.elementAt(n);
            Trace.info(String.valueOf(MessageHandler.getMessage("compile.info.start", string)) + "\n");
            Class clazz = this.getClassByName(string);
            if (clazz == null) {
                return false;
            }
            try {
                if (this.specificPackageName != null && (this.specificPackageName.startsWith("java.") || this.specificPackageName.startsWith("javax."))) {
                    Trace.info(MessageHandler.getMessage("compile.error"));
                    Trace.info(String.valueOf(MessageHandler.getMessage("compile.error.javax", this.specificPackageName)) + "\n");
                    return false;
                }
                if (!this.generateSources(clazz, string)) {
                    return false;
                }
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                Trace.info(String.valueOf(MessageHandler.getMessage("compile.error.compliance", string)) + "\n");
                throw notCompliantMBeanException;
            }
            --n;
        }
        return true;
    }

    private int error(String string) {
        Trace.error(string);
        Trace.info(MessageHandler.getMessage("compile.error.stop"));
        return 1;
    }

    private boolean generateSources(Class clazz, String string) throws NotCompliantMBeanException {
        MBeanInfo mBeanInfo;
        if (clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.")) {
            Trace.info(MessageHandler.getMessage("compile.warning"));
            Trace.info(String.valueOf(MessageHandler.getMessage("compile.warning.javax", clazz.getName())) + "\n");
        }
        if ((mBeanInfo = Introspector.testCompliance((Class)clazz)) == null) {
            Trace.info(String.valueOf(MessageHandler.getMessage("compile.error.dynamic", string)) + "\n");
            return false;
        }
        boolean bl = true;
        MOStubGenerator mOStubGenerator = this.readOnly ? new MOStubGeneratorRO(clazz, mBeanInfo, null, this.specificPackageName, targetDir) : new MOStubGenerator(clazz, mBeanInfo, null, this.specificPackageName, targetDir);
        MOGenerator mOGenerator = new MOGenerator(clazz, mBeanInfo, null, this.specificPackageName, targetDir);
        try {
            mOStubGenerator.generateCode();
            mOGenerator.generateCode();
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    private Class getClassByName(String string) {
        try {
            if (this.classLoader == null) {
                return Class.forName(string);
            }
            return this.classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.error(MessageHandler.getMessage("compile.error.noClass", string));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.error(MessageHandler.getMessage("compile.error.noClass", string));
        }
        catch (Exception exception) {
            this.error(MessageHandler.getMessage("compile.error.noClass", string));
        }
        return null;
    }

    private static String gettargetDir() {
        return targetDir;
    }

    public static void main(String[] stringArray) {
        System.exit(ProxyGen.compile(stringArray));
    }

    private void output(String string) {
        try {
            int n = 0;
            while (n < string.length()) {
                this.out.write(string.charAt(n));
                ++n;
            }
            this.out.write(10);
        }
        catch (IOException iOException) {}
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseArgs(String[] stringArray) {
        this.classPathString = System.getProperty("java.class.path");
        this.v = new Vector();
        if (stringArray.length == 0) {
            this.usage();
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-classpath")) {
                if (n + 1 >= stringArray.length) {
                    this.error("-classpath requires argument");
                    this.usage();
                    return false;
                }
                this.classPathString = stringArray[++n];
                Properties properties = System.getProperties();
                String string = (String)((Hashtable)properties).get("path.separator");
                String string2 = (String)((Hashtable)properties).get("java.class.path");
                string2 = new String(String.valueOf(string2) + string + this.classPathString);
                ((Hashtable)properties).put("java.class.path", string2);
                System.setProperties(properties);
                this.classPathString = System.getProperty("java.class.path");
                this.classLoader = new ProxyGenClassLoader(this.classPathString);
            } else if (stringArray[n].equals("-d")) {
                if (n + 1 >= stringArray.length) {
                    this.error(MessageHandler.getMessage("compile.error.option.level", "-d"));
                    this.usage();
                    return false;
                }
                if (!(targetDir = stringArray[++n]).endsWith(System.getProperty("file.separator"))) {
                    targetDir = String.valueOf(targetDir) + System.getProperty("file.separator");
                }
                if (!this.validTargetDir()) {
                    return false;
                }
                Trace.info("\n" + MessageHandler.getMessage("compile.info.destination", targetDir) + "\n");
            } else if (stringArray[n].equals("-ro")) {
                this.readOnly = true;
            } else if (stringArray[n].equals("-tp")) {
                if (n + 1 >= stringArray.length) {
                    this.error(MessageHandler.getMessage("compile.error.option.level", "-tp"));
                    this.usage();
                    return false;
                }
                this.specificPackageName = stringArray[++n];
            } else {
                if (stringArray[n].equals("-help")) {
                    this.usage();
                    return false;
                }
                if (stringArray[n].equals("-h")) {
                    this.usage();
                    return false;
                }
                if (stringArray[n].startsWith("-")) {
                    this.usage();
                    return false;
                }
                this.v.addElement(stringArray[n]);
            }
            ++n;
        }
        if (targetDir.equals("")) {
            targetDir = "." + System.getProperty("file.separator");
            if (!this.validTargetDir()) {
                this.usage();
                return false;
            }
            Trace.info(String.valueOf(MessageHandler.getMessage("compile.info.destination", targetDir)) + "\n");
        }
        return true;
    }

    private void run() {
        block2: {
            if (this.v == null || this.v.size() <= 0) break block2;
            try {
                this.doCompile();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {}
        }
    }

    private synchronized boolean startCompile(String[] stringArray) {
        if (!this.parseArgs(stringArray)) {
            return false;
        }
        if (this.v.size() == 0) {
            this.usage();
            return false;
        }
        try {
            return this.doCompile();
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            return false;
        }
    }

    private void usage() {
        Trace.info("Usage: " + this.program + " <options> <classes>");
        Trace.info("\n" + MessageHandler.getMessage("usage.where"));
        Trace.info("  -d <dir>\t\t" + MessageHandler.getMessage("usage.d"));
        Trace.info("  -ro\t\t\t" + MessageHandler.getMessage("usage.ro"));
        Trace.info("  -tp <pkgName>\t\t" + MessageHandler.getMessage("usage.tp"));
        Trace.info("  -classpath <path>\t" + MessageHandler.getMessage("usage.classpath"));
        Trace.info("  -help\t\t\t" + MessageHandler.getMessage("usage.help"));
    }

    private boolean validTargetDir() {
        File file;
        try {
            file = new File(targetDir);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        if (!file.exists()) {
            this.error(MessageHandler.getMessage("compile.error.noDir", targetDir));
            return false;
        }
        if (!file.canWrite()) {
            this.error(MessageHandler.getMessage("compile.error.noWritePermission", targetDir));
            return false;
        }
        return true;
    }
}

