/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools;

import com.sun.jdmk.DefaultPaths;
import com.sun.jdmk.tools.mibgen.ASTMib;
import com.sun.jdmk.tools.mibgen.ASTMibs;
import com.sun.jdmk.tools.mibgen.CodeGenerator;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.ModulesHandler;
import com.sun.jdmk.tools.mibgen.ParseException;
import com.sun.jdmk.tools.mibgen.Parser;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.SimpleNode;
import com.sun.jdmk.tools.mibgen.StoreGenerator;
import com.sun.jdmk.tools.mibgen.SyntaxMapper;
import com.sun.jdmk.tools.mibgen.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public final class MibGen {
    private String program;
    private OutputStream out;
    private String genericPrefix = "";
    private String standardPrefix = "";
    private String specificPackageName = "";
    private String targetDir = ".";
    private String prefix = "";
    private boolean generateCode = true;
    private boolean generateMgrCode = true;
    private boolean generateMgrCodeOnly = false;
    private boolean standAlone = false;
    private boolean forAll = false;
    private String lastFile = "";
    private ASTMibs lastMib;
    private boolean status = true;
    private boolean commentRequested = false;
    private boolean defaultMibCore = true;
    private int gentype = 1;
    private Vector fileList;
    private static final String sccs_id = "@(#)MibGen.java 4.27 07/05/02 SMI";

    private MibGen(OutputStream outputStream, String string) {
        this.out = outputStream;
        Trace.setOutput(this.out);
        this.program = string;
    }

    public static int compile(String[] stringArray) {
        MibGen mibGen = new MibGen(System.out, "mibgen");
        return mibGen.startCompile(stringArray) ? 0 : 1;
    }

    private synchronized boolean doCompile() {
        SimpleNode simpleNode;
        Object object;
        boolean bl = true;
        ModulesHandler modulesHandler = new ModulesHandler();
        ASTMibs aSTMibs = null;
        if (this.defaultMibCore) {
            String string = System.getProperty("mibcore.file");
            if (string == null) {
                string = DefaultPaths.getEtcDir((String)("mibgen" + File.separator + "mib_core.txt"));
            }
            Trace.info(MessageHandler.getMessage("compile.info.start.mibcore", string));
            object = null;
            try {
                object = new Parser(new FileInputStream(string));
                aSTMibs = ((Parser)object).Mibs(modulesHandler);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Trace.warning(MessageHandler.getMessage("compile.error.noMibCoreFile", string));
            }
            catch (ParseException parseException) {
                Trace.error(parseException.getMessage());
                bl = false;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                Trace.error(exception.getMessage());
                bl = false;
            }
        }
        int n = this.fileList.size() - 1;
        while (n >= 0) {
            String string = (String)this.fileList.elementAt(n);
            Trace.info(MessageHandler.getMessage("compile.info.start", string));
            object = null;
            try {
                object = new Parser(new FileInputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                Trace.error(MessageHandler.getMessage("compile.error.noFile", string));
                return false;
            }
            try {
                simpleNode = ((Parser)object).Mibs(modulesHandler);
                this.lastMib = simpleNode;
            }
            catch (ParseException parseException) {
                Trace.error(parseException.getMessage());
                bl = false;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                Trace.error(exception.getMessage());
                bl = false;
            }
            --n;
        }
        if (!modulesHandler.resolve()) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        if (!modulesHandler.buildMibTrees()) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        if (this.defaultMibCore && aSTMibs != null) {
            object = aSTMibs.mibElements();
            while (object.hasMoreElements()) {
                simpleNode = (ASTMib)object.nextElement();
                modulesHandler.removeMibModule(simpleNode.getModuleName());
            }
        }
        this.status = this.generateAgentCode(modulesHandler) && this.generateMgrCode(modulesHandler) && bl;
        return this.status;
    }

    private int error(String string) {
        Trace.error(string);
        Trace.info(MessageHandler.getMessage("compile.error.stop"));
        return 1;
    }

    private boolean generateAgentCode(ModulesHandler modulesHandler) {
        if (!this.generateCode) {
            return true;
        }
        if (this.lastMib == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        Enumeration enumeration = this.forAll ? modulesHandler.mibElements() : this.lastMib.mibElements();
        if (enumeration == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        boolean bl = true;
        Context context = new Context();
        context.packageName = this.specificPackageName;
        context.prefix = this.prefix;
        context.dir = this.targetDir;
        context.genericPrefix = this.genericPrefix;
        context.standardPrefix = this.standardPrefix;
        context.modules = modulesHandler;
        CodeGenerator codeGenerator = new CodeGenerator(new ResourceManager(), context);
        while (enumeration.hasMoreElements()) {
            ASTMib aSTMib = (ASTMib)enumeration.nextElement();
            aSTMib.setDescriptionHandling(this.commentRequested);
            aSTMib.setModulesHandler(modulesHandler);
            Trace.info(MessageHandler.getMessage("compile.info.start.agent", aSTMib.getModuleName()));
            try {
                codeGenerator.generateCode(aSTMib, this.gentype);
            }
            catch (IOException iOException) {
                Trace.error(MessageHandler.getMessage("compile.error.io", aSTMib.getModuleName()));
                bl = false;
            }
        }
        return bl;
    }

    private boolean generateMgrCode(ModulesHandler modulesHandler) {
        if (!this.generateMgrCode && !this.generateMgrCodeOnly) {
            return true;
        }
        if (this.lastMib == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        Enumeration enumeration = this.forAll ? modulesHandler.mibElements() : this.lastMib.mibElements();
        if (enumeration == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        Context context = new Context();
        context.packageName = this.specificPackageName;
        context.prefix = this.prefix;
        context.dir = this.targetDir;
        context.modules = modulesHandler;
        StoreGenerator storeGenerator = new StoreGenerator(new ResourceManager(), context);
        while (enumeration.hasMoreElements()) {
            ASTMib aSTMib;
            context.mib = aSTMib = (ASTMib)enumeration.nextElement();
            aSTMib.setModulesHandler(modulesHandler);
            Trace.info(MessageHandler.getMessage("compile.info.start.oidtable", aSTMib.getModuleName()));
            try {
                storeGenerator.generateCode(aSTMib);
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static void main(String[] stringArray) {
        String string = MessageHandler.getMessage("compile.error.internal.outmemory");
        try {
            int n = MibGen.compile(stringArray);
            Trace.conclude();
            System.exit(n);
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                Trace.error(string);
            } else {
                Trace.error(MessageHandler.getMessage("compile.error.internal", throwable.toString()));
                throwable.printStackTrace();
                Trace.conclude();
            }
            System.exit(1);
        }
    }

    private void output(String string) {
        try {
            int n = 0;
            while (n < string.length()) {
                this.out.write(string.charAt(n));
                ++n;
            }
            this.out.write(10);
        }
        catch (IOException iOException) {}
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseArgs(String[] stringArray) {
        boolean bl = false;
        this.fileList = new Vector();
        boolean bl2 = false;
        if (stringArray.length == 0) {
            this.usage();
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-tp")) {
                if (n + 1 >= stringArray.length) {
                    Trace.error(MessageHandler.getMessage("compile.error.option.level", "-tp"));
                    this.usage();
                    return false;
                }
                this.specificPackageName = stringArray[++n];
            } else if (stringArray[n].equals("-d")) {
                if (n + 1 >= stringArray.length) {
                    Trace.error(MessageHandler.getMessage("compile.error.option.level", "-d"));
                    this.usage();
                    return false;
                }
                this.targetDir = stringArray[++n];
            } else if (stringArray[n].equals("-p")) {
                if (n + 1 >= stringArray.length) {
                    Trace.error(MessageHandler.getMessage("compile.error.option.level", "-p"));
                    this.usage();
                    return false;
                }
                this.prefix = stringArray[++n];
            } else if (stringArray[n].equals("-n")) {
                bl2 = true;
                this.generateCode = false;
                this.generateMgrCode = false;
            } else if (stringArray[n].equals("-g")) {
                this.gentype = 2;
            } else if (stringArray[n].equals("-gp")) {
                if (n + 1 >= stringArray.length) {
                    Trace.error(MessageHandler.getMessage("compile.error.option.level", "-gp"));
                    this.usage();
                    return false;
                }
                this.genericPrefix = stringArray[++n];
            } else if (stringArray[n].equals("-sp")) {
                if (n + 1 >= stringArray.length) {
                    Trace.error(MessageHandler.getMessage("compile.error.option.level", "-sp"));
                    this.usage();
                    return false;
                }
                this.standardPrefix = stringArray[++n];
            } else if (stringArray[n].equals("-mo")) {
                this.generateMgrCodeOnly = true;
                this.generateCode = false;
                this.generateMgrCode = false;
            } else if (stringArray[n].equals("-a")) {
                this.forAll = true;
            } else {
                if (stringArray[n].equals("-help")) {
                    this.usage();
                    return false;
                }
                if (stringArray[n].equals("-h")) {
                    this.usage();
                    return false;
                }
                if (stringArray[n].equals("-desc")) {
                    this.commentRequested = true;
                } else if (stringArray[n].equals("-mc")) {
                    this.defaultMibCore = false;
                } else if (stringArray[n].equals("-ulong")) {
                    bl = true;
                } else {
                    if (stringArray[n].startsWith("-")) {
                        Trace.error(MessageHandler.getMessage("compile.error.option.invalid", stringArray[n]));
                        this.usage();
                        return false;
                    }
                    this.fileList.addElement(stringArray[n]);
                    this.lastFile = stringArray[n];
                }
            }
            ++n;
        }
        SyntaxMapper.fillTable(bl);
        if (bl2 && this.generateMgrCodeOnly) {
            Trace.error(MessageHandler.getMessage("compile.error.option.incompat", "-n", "-mo"));
            this.usage();
            return false;
        }
        return this.validTargetDir();
    }

    private void run() {
        if (this.fileList != null && this.fileList.size() > 0) {
            this.status = this.doCompile();
        }
    }

    private synchronized boolean startCompile(String[] stringArray) {
        if (!this.parseArgs(stringArray)) {
            return false;
        }
        if (this.fileList.size() == 0) {
            this.usage();
            return false;
        }
        return this.doCompile();
    }

    private void usage() {
        Trace.info("Usage: " + this.program + " <options> <mib files>");
        Trace.info("\n" + MessageHandler.getMessage("usage.where"));
        Trace.info("  -n\t\t" + MessageHandler.getMessage("usage.n"));
        Trace.info("  -d <dir>\t" + MessageHandler.getMessage("usage.dir"));
        Trace.info("  -tp <pkgName>\t" + MessageHandler.getMessage("usage.tp"));
        Trace.info("  -desc\t\t" + MessageHandler.getMessage("usage.desc"));
        Trace.info("  -mo\t\t" + MessageHandler.getMessage("usage.mo"));
        Trace.info("  -mc\t\t" + MessageHandler.getMessage("usage.mc"));
        Trace.info("  -a\t\t" + MessageHandler.getMessage("usage.a"));
        Trace.info("  -g\t\t" + MessageHandler.getMessage("usage.g"));
        Trace.info("  -gp\t\t" + MessageHandler.getMessage("usage.gp"));
        Trace.info("  -sp\t\t" + MessageHandler.getMessage("usage.sp"));
        Trace.info("  -p <prefix>\t" + MessageHandler.getMessage("usage.p"));
        Trace.info("  -ulong\t\t" + MessageHandler.getMessage("usage.un"));
        Trace.info("  -help\t\t" + MessageHandler.getMessage("usage.help"));
    }

    private boolean validTargetDir() {
        File file;
        if (!this.generateCode) {
            return true;
        }
        try {
            file = new File(this.targetDir);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        if (!file.exists()) {
            this.error(MessageHandler.getMessage("compile.error.noDir", this.targetDir));
            return false;
        }
        if (!file.canWrite()) {
            this.error(MessageHandler.getMessage("compile.error.noWritePermission", this.targetDir));
            return false;
        }
        return true;
    }
}

