/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerDelegateMBean;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class MBeanServerDelegate
implements MBeanServerDelegateMBean,
NotificationBroadcaster {
    private String mbeanServerId;
    private NotificationBroadcasterSupport broadcaster = null;
    private static Long oldStamp = new Long(0L);

    public MBeanServerDelegate() {
        String string = "";
        Long l = null;
        Properties properties = System.getProperties();
        Long l2 = oldStamp;
        synchronized (l2) {
            l = new Long(new Date().getTime());
            if (oldStamp >= l) {
                l = new Long(oldStamp + 1L);
            }
            oldStamp = l;
        }
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        this.mbeanServerId = new String(String.valueOf(string) + "_" + l.toString());
        ((Hashtable)properties).put("jmx.specification.name", "Java Management Extensions");
        ((Hashtable)properties).put("jmx.specification.version", "1.0 Final Release");
        ((Hashtable)properties).put("jmx.specification.vendor", "Sun Microsystems");
        ((Hashtable)properties).put("jmx.implementation.name", "JDMK");
        ((Hashtable)properties).put("jmx.implementation.vendor", "Sun Microsystems");
        ((Hashtable)properties).put("jmx.implementation.version", "4.2/Java2");
        System.setProperties(properties);
        this.broadcaster = new NotificationBroadcasterSupport();
    }

    public synchronized void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    public String getImplementationName() {
        return System.getProperty("jmx.implementation.name", "JDMK");
    }

    public String getImplementationVendor() {
        return System.getProperty("jmx.implementation.vendor", "Sun Microsystems");
    }

    public String getImplementationVersion() {
        return System.getProperty("jmx.implementation.version", "4.2/Java2");
    }

    public String getMBeanServerId() {
        return this.mbeanServerId;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{"JMX.mbean.unregistered", "JMX.mbean.registered"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, "MBeanServerNotification", "Notifications sent by the MBeanServerDelegate MBean")};
        return mBeanNotificationInfoArray;
    }

    public String getSpecificationName() {
        return System.getProperty("jmx.specification.name", "Java Management Extensions");
    }

    public String getSpecificationVendor() {
        return System.getProperty("jmx.specification.vendor", "Sun Microsystems");
    }

    public String getSpecificationVersion() {
        return System.getProperty("jmx.specification.version", "1.0 Final Release");
    }

    public synchronized void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(notificationListener);
    }

    public synchronized void sendNotification(Notification notification) {
        this.broadcaster.sendNotification(notification);
    }
}

