/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.manager;

import com.sun.jdmk.Task;
import com.sun.jdmk.TaskServer;
import com.sun.jdmk.Trace;
import com.sun.jdmk.snmp.SnmpPduFactoryBER;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.management.snmp.SnmpMessage;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.SnmpPduPacket;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpTooBigException;
import javax.management.snmp.manager.SnmpEventReportHandler;
import javax.management.snmp.manager.SnmpEventReportListener;
import javax.management.snmp.manager.SnmpInformListener;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpTrapListener;

public class SnmpEventReportDispatcher
implements Runnable {
    private int port = 162;
    private DatagramSocket dSocket = null;
    private final ObjectList trapListeners = new ObjectList();
    private final ObjectList informListeners = new ObjectList();
    private SnmpPduFactory pduFactory = new SnmpPduFactoryBER();
    private TaskServer taskServer = null;
    private final ObjectList eventReportReceivers = new ObjectList();
    private static final String InterruptSysCallMsg = "Interrupted system call";
    String dbgTag = "SnmpEventReportDispatcher";

    public SnmpEventReportDispatcher() throws SocketException {
        this(162);
    }

    public SnmpEventReportDispatcher(int n) throws SocketException {
        this.port = n;
        this.dSocket = new DatagramSocket(this.port);
    }

    public SnmpEventReportDispatcher(int n, TaskServer taskServer) throws SocketException {
        this.port = n;
        this.dSocket = new DatagramSocket(this.port);
        this.taskServer = taskServer;
    }

    public void addEventReportListener(SnmpEventReportListener snmpEventReportListener) {
        ObjectList objectList = this.eventReportReceivers;
        synchronized (objectList) {
            this.eventReportReceivers.add(snmpEventReportListener);
        }
    }

    public void addInformListener(SnmpInformListener snmpInformListener) {
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            this.informListeners.add(snmpInformListener);
        }
    }

    public void addTrapListener(SnmpTrapListener snmpTrapListener) {
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            this.trapListeners.add(snmpTrapListener);
        }
    }

    private boolean checkPduType(SnmpPduPacket snmpPduPacket) {
        if (snmpPduPacket.type == 166) {
            return true;
        }
        if (this.isDebugOn()) {
            this.debug("checkPduType", "cannot respond to this kind of PDU");
        }
        return false;
    }

    public boolean containsEventReportReceiver(SnmpEventReportListener snmpEventReportListener) {
        ObjectList objectList = this.eventReportReceivers;
        synchronized (objectList) {
            boolean bl = this.eventReportReceivers.contains(snmpEventReportListener);
            Object var4_4 = null;
            return bl;
        }
    }

    public boolean containsInformListener(SnmpInformListener snmpInformListener) {
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            boolean bl = this.informListeners.contains(snmpInformListener);
            Object var4_4 = null;
            return bl;
        }
    }

    public boolean containsTrapListener(SnmpTrapListener snmpTrapListener) {
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            boolean bl = this.trapListeners.contains(snmpTrapListener);
            Object var4_4 = null;
            return bl;
        }
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }

    public Enumeration getEventReportListeners() {
        ObjectList objectList = this.eventReportReceivers;
        synchronized (objectList) {
            Enumeration enumeration = this.eventReportReceivers.elements();
            Object var3_3 = null;
            return enumeration;
        }
    }

    public Enumeration getInformListeners() {
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            Enumeration enumeration = this.informListeners.elements();
            Object var3_3 = null;
            return enumeration;
        }
    }

    public SnmpPduFactory getPduFactory() {
        return this.pduFactory;
    }

    public Enumeration getTrapListeners() {
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            Enumeration enumeration = this.trapListeners.elements();
            Object var3_3 = null;
            return enumeration;
        }
    }

    private final void handleInform(DatagramPacket datagramPacket, SnmpPduPacket snmpPduPacket) {
        SnmpPduPacket snmpPduPacket2;
        block14: {
            snmpPduPacket2 = snmpPduPacket;
            DatagramPacket datagramPacket2 = this.makeResponsePacket(datagramPacket, snmpPduPacket2);
            if (this.isTraceOn() && datagramPacket2 != null) {
                this.trace("run", "Response packet to be sent:\n" + SnmpMessage.dumpHexBuffer(datagramPacket2.getData(), 0, datagramPacket2.getLength()));
            }
            if (datagramPacket2 != null) {
                try {
                    this.dSocket.send(datagramPacket2);
                }
                catch (SocketException socketException) {
                    if (this.isDebugOn()) {
                        if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                            this.debug("run", "interrupted");
                        } else {
                            this.debug("run", "i/o exception");
                            this.debug("run", socketException);
                        }
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (this.isDebugOn()) {
                        this.debug("run", "interrupted");
                    }
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block14;
                    this.debug("run", "failure when sending response");
                    this.debug("run", exception);
                }
            }
        }
        snmpPduPacket2.type = 166;
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            int n = this.informListeners.size;
            Object[] objectArray = this.informListeners.list;
            int n2 = 0;
            while (n2 < n) {
                SnmpInformListener snmpInformListener = (SnmpInformListener)objectArray[n2];
                this.submitHandlerTask(new HandlerTask(snmpInformListener, snmpPduPacket2));
                ++n2;
            }
        }
    }

    private final void handlePacket(DatagramPacket datagramPacket) {
        block14: {
            try {
                SnmpMessage snmpMessage = new SnmpMessage();
                snmpMessage.address = datagramPacket.getAddress();
                snmpMessage.port = datagramPacket.getPort();
                snmpMessage.decodeMessage(datagramPacket.getData(), datagramPacket.getLength());
                SnmpPduPacket snmpPduPacket = this.pduFactory.decodePdu(snmpMessage);
                if (snmpPduPacket.type == 164 || snmpPduPacket.type == 167) {
                    if (this.isTraceOn()) {
                        if (snmpPduPacket.type == 164) {
                            this.trace("run", "Received an SNMP trap V1");
                        } else {
                            this.trace("run", "Received an SNMP trap V2");
                        }
                    }
                    this.handleTrap(datagramPacket, snmpPduPacket);
                } else if (snmpPduPacket.type == 166) {
                    if (this.isTraceOn()) {
                        this.trace("run", "Received an Inform Request");
                    }
                    this.handleInform(datagramPacket, snmpPduPacket);
                } else {
                    if (this.isTraceOn()) {
                        this.trace("run", "trashed the packet: bad PDU type.");
                    }
                    if (this.isDebugOn()) {
                        this.debug("run", "trashed the packet because it's not an SNMP event report or get request (timeliness discovery)");
                    }
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                if (this.isDebugOn()) {
                    this.debug("run", "packet decoding failed " + snmpStatusException);
                }
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) break block14;
                this.debug("run", exception);
            }
        }
    }

    private final void handleTrap(DatagramPacket datagramPacket, SnmpPduPacket snmpPduPacket) {
        Object object;
        int n;
        Object[] objectArray;
        int n2;
        SnmpPduPacket snmpPduPacket2 = snmpPduPacket;
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            n2 = this.trapListeners.size;
            objectArray = this.trapListeners.list;
            n = 0;
            while (n < n2) {
                object = (SnmpTrapListener)objectArray[n];
                this.submitHandlerTask(new HandlerTask((SnmpTrapListener)object, snmpPduPacket2));
                ++n;
            }
        }
        objectList = this.eventReportReceivers;
        synchronized (objectList) {
            n2 = this.eventReportReceivers.size;
            objectArray = this.eventReportReceivers.list;
            n = 0;
            while (n < n2) {
                object = (SnmpEventReportListener)objectArray[n];
                this.submitHandlerTask(new HandlerTask((SnmpEventReportListener)object, snmpPduPacket2));
                ++n;
            }
        }
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    private SnmpMessage makeResponseMessage(DatagramPacket datagramPacket, SnmpPduPacket snmpPduPacket) {
        SnmpMessage snmpMessage;
        block10: {
            snmpMessage = null;
            SnmpPduPacket snmpPduPacket2 = null;
            if (snmpPduPacket != null) {
                snmpPduPacket2 = this.makeResponsePdu(snmpPduPacket);
            }
            if (snmpPduPacket2 == null) break block10;
            try {
                snmpMessage = this.pduFactory.encodePdu(snmpPduPacket2, datagramPacket.getData().length);
            }
            catch (SnmpStatusException snmpStatusException) {
                if (this.isDebugOn()) {
                    this.debug("makeResponseMessage", "failure when encoding the response message");
                    this.debug("makeResponseMessage", snmpStatusException);
                }
                snmpMessage = null;
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.isDebugOn()) {
                    this.debug("makeResponseMessage", "response message is too big");
                }
                try {
                    snmpPduPacket2 = this.newTooBigPdu(snmpPduPacket);
                    snmpMessage = this.pduFactory.encodePdu(snmpPduPacket2, datagramPacket.getData().length);
                }
                catch (SnmpTooBigException snmpTooBigException2) {
                    if (this.isDebugOn()) {
                        this.debug("makeResponseMessage", "'too big' is 'too big' !!!");
                    }
                    snmpMessage = null;
                }
                catch (Exception exception) {
                    snmpMessage = null;
                }
            }
        }
        return snmpMessage;
    }

    private DatagramPacket makeResponsePacket(DatagramPacket datagramPacket, SnmpPduPacket snmpPduPacket) {
        DatagramPacket datagramPacket2;
        block6: {
            datagramPacket2 = null;
            SnmpMessage snmpMessage = this.makeResponseMessage(datagramPacket, snmpPduPacket);
            if (snmpMessage == null) break block6;
            try {
                datagramPacket.setLength(snmpMessage.encodeMessage(datagramPacket.getData()));
                datagramPacket2 = datagramPacket;
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.isDebugOn()) {
                    this.debug("makeResponsePacket", "response message is too big");
                }
                try {
                    SnmpPduPacket snmpPduPacket2 = this.newTooBigPdu(snmpPduPacket);
                    snmpMessage = this.pduFactory.encodePdu(snmpPduPacket2, datagramPacket.getData().length);
                    datagramPacket.setLength(snmpMessage.encodeMessage(datagramPacket.getData()));
                    datagramPacket2 = datagramPacket;
                }
                catch (SnmpStatusException snmpStatusException) {
                    throw new InternalError();
                }
                catch (SnmpTooBigException snmpTooBigException2) {
                    if (!this.isDebugOn()) break block6;
                    this.debug("makeResponsePacket", "'too big' is 'too big' !!!");
                }
            }
        }
        return datagramPacket2;
    }

    private SnmpPduPacket makeResponsePdu(SnmpPduPacket snmpPduPacket) {
        SnmpPduPacket snmpPduPacket2 = null;
        if (this.checkPduType(snmpPduPacket)) {
            snmpPduPacket2 = snmpPduPacket;
            snmpPduPacket2.type = 162;
        }
        return snmpPduPacket2;
    }

    private SnmpPduPacket newTooBigPdu(SnmpPduPacket snmpPduPacket) {
        SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
        snmpPduRequest.type = snmpPduPacket.type;
        snmpPduRequest.version = snmpPduPacket.version;
        snmpPduRequest.community = snmpPduPacket.community;
        snmpPduRequest.requestId = snmpPduPacket.requestId;
        snmpPduRequest.address = snmpPduPacket.address;
        snmpPduRequest.port = snmpPduPacket.port;
        snmpPduRequest.errorStatus = 1;
        snmpPduRequest.errorIndex = 0;
        snmpPduRequest.varBindList = null;
        return snmpPduRequest;
    }

    public void removeEventReportListener(SnmpEventReportListener snmpEventReportListener) {
        ObjectList objectList = this.eventReportReceivers;
        synchronized (objectList) {
            this.eventReportReceivers.add(snmpEventReportListener);
        }
    }

    public void removeInformListener(SnmpInformListener snmpInformListener) {
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            this.informListeners.remove(snmpInformListener);
        }
    }

    public void removeTrapListener(SnmpTrapListener snmpTrapListener) {
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            this.trapListeners.remove(snmpTrapListener);
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    byte[] byArray = new byte[SnmpPeer.defaultSnmpRequestPktSize];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, SnmpPeer.defaultSnmpRequestPktSize);
                    this.dSocket.setSoTimeout(0);
                    if (this.isTraceOn()) {
                        this.trace("run", "Now waiting for event reports...");
                    }
                    this.dSocket.receive(datagramPacket);
                    if (this.isTraceOn()) {
                        this.trace("run", "Received a packet from : " + datagramPacket.getAddress().toString() + ", Length = " + datagramPacket.getLength());
                    }
                    this.taskServer.submitTask(new PacketTask(datagramPacket));
                }
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) continue;
                this.debug("run", exception);
                continue;
            }
            break;
        }
    }

    public void setPduFactory(SnmpPduFactory snmpPduFactory) {
        if (snmpPduFactory == null) {
            snmpPduFactory = new SnmpPduFactoryBER();
        }
        this.pduFactory = snmpPduFactory;
    }

    private final void submitHandlerTask(HandlerTask handlerTask) {
        if (this.taskServer == null) {
            handlerTask.run();
        } else {
            this.taskServer.submitTask(handlerTask);
        }
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    private static class ObjectList {
        public static int DEFAULT_CAPACITY = 10;
        public static int DEFAULT_INCREMENT = 10;
        private int DELTA;
        private int size = 0;
        public Object[] list;

        ObjectList() {
            this(DEFAULT_CAPACITY, DEFAULT_INCREMENT);
        }

        ObjectList(int n) {
            this(n, DEFAULT_INCREMENT);
        }

        ObjectList(int n, int n2) {
            this.DELTA = n2;
            this.list = this.allocate(n);
        }

        public final void add(int n, Object object) {
            if (n > this.size) {
                throw new IndexOutOfBoundsException();
            }
            if (n >= this.list.length) {
                this.resize();
            }
            if (n == this.size) {
                this.list[this.size++] = object;
                return;
            }
            System.arraycopy(this.list, n, this.list, n + 1, this.size - n);
            this.list[n] = object;
            ++this.size;
        }

        public final boolean add(Object object) {
            if (object == null) {
                return false;
            }
            if (this.size >= this.list.length) {
                this.resize();
            }
            this.list[this.size++] = object;
            return true;
        }

        private final Object[] allocate(int n) {
            return new Object[n];
        }

        public final boolean contains(Object object) {
            return this.indexOf(object) > -1;
        }

        public final java.util.Enumeration elements() {
            class Com_sun_jdmk_snmp_manager_SnmpEventReportDispatcher$1 {
                /* synthetic */ Com_sun_jdmk_snmp_manager_SnmpEventReportDispatcher$1() {
                }
            }
            return new Enumeration();
        }

        public final int indexOf(Object object) {
            if (object == null) {
                return -1;
            }
            int n = this.size;
            Object[] objectArray = this.list;
            int n2 = 0;
            while (n2 < n) {
                if (objectArray[n2] == object) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        public final Object remove(int n) {
            if (n >= this.size) {
                return null;
            }
            Object object = this.list[n];
            this.list[n] = null;
            if (n == --this.size) {
                return object;
            }
            System.arraycopy(this.list, n + 1, this.list, n, this.size - n);
            return object;
        }

        public final boolean remove(Object object) {
            if (object == null) {
                return false;
            }
            int n = this.size;
            Object[] objectArray = this.list;
            int n2 = 0;
            while (n2 < n) {
                if (objectArray[n2] == object) {
                    this.remove(n2);
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private final void resize() {
            Object[] objectArray = this.allocate(this.list.length + this.DELTA);
            System.arraycopy(this.list, 0, objectArray, 0, this.size);
            this.list = objectArray;
        }

        public final int size() {
            return this.size;
        }

        private final class Enumeration
        implements java.util.Enumeration {
            private int next = 0;

            private Enumeration() {
            }

            public boolean hasMoreElements() {
                ObjectList objectList = ObjectList.this;
                synchronized (objectList) {
                    boolean bl = this.next < ObjectList.this.size();
                    Object var3_3 = null;
                    return bl;
                }
            }

            public Object nextElement() {
                ObjectList objectList = ObjectList.this;
                synchronized (objectList) {
                    if (this.next < ObjectList.this.size()) {
                        Object object = ObjectList.this.list[this.next++];
                        Object var3_3 = null;
                        return object;
                    }
                    throw new NoSuchElementException();
                }
            }
        }
    }

    private final class PacketTask
    implements Task {
        private final DatagramPacket packet;

        PacketTask(DatagramPacket datagramPacket) {
            this.packet = datagramPacket;
        }

        public void cancel() {
        }

        public void run() {
            block2: {
                try {
                    SnmpEventReportDispatcher.this.handlePacket(this.packet);
                }
                catch (Exception exception) {
                    if (!SnmpEventReportDispatcher.this.isDebugOn()) break block2;
                    SnmpEventReportDispatcher.this.debug("Unexpected exception, failed to handle packet: ", exception);
                }
            }
        }
    }

    private static final class HandlerTask
    extends SnmpEventReportHandler
    implements Task {
        public HandlerTask(SnmpEventReportListener snmpEventReportListener, SnmpPduPacket snmpPduPacket) {
            super(snmpEventReportListener, snmpPduPacket);
        }

        public HandlerTask(SnmpInformListener snmpInformListener, SnmpPduPacket snmpPduPacket) {
            super(snmpInformListener, snmpPduPacket);
        }

        public HandlerTask(SnmpTrapListener snmpTrapListener, SnmpPduPacket snmpPduPacket) {
            super(snmpTrapListener, snmpPduPacket);
        }

        public void cancel() {
        }
    }
}

