/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.SnmpInformRequest;
import com.sun.jdmk.comm.SnmpQManager;
import java.util.Vector;

class WaitQ
extends Vector {
    boolean isBeingDestroyed = false;

    WaitQ(int n, int n2) {
        super(n, n2);
    }

    public synchronized void addWaiting(SnmpInformRequest snmpInformRequest) {
        long l = snmpInformRequest.getAbsMaxTimeToWait();
        int n = this.size();
        while (n > 0) {
            if (l < this.getRequestAt(n - 1).getAbsMaxTimeToWait()) break;
            --n;
        }
        if (n == this.size()) {
            this.addElement(snmpInformRequest);
            this.notifyClients();
        } else {
            this.insertElementAt(snmpInformRequest, n);
        }
    }

    public SnmpInformRequest getRequestAt(int n) {
        return (SnmpInformRequest)this.elementAt(n);
    }

    public synchronized SnmpInformRequest getTimeoutRequests() {
        if (this.waitUntilReady()) {
            SnmpInformRequest snmpInformRequest = (SnmpInformRequest)this.lastElement();
            --this.elementCount;
            return snmpInformRequest;
        }
        return null;
    }

    private synchronized void notifyClients() {
        this.notifyAll();
    }

    public synchronized SnmpInformRequest removeRequest(long l) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            SnmpInformRequest snmpInformRequest = this.getRequestAt(n2);
            if (l == (long)snmpInformRequest.getRequestId()) {
                this.removeElementAt(n2);
                return snmpInformRequest;
            }
            ++n2;
        }
        return null;
    }

    public synchronized void waitOnThisQueue(long l) {
        if (l == 0L && !this.isEmpty() && SnmpQManager.isDebugOn()) {
            SnmpQManager.debug("waitOnThisQueue", "[" + Thread.currentThread().toString() + "]:" + "Fatal BUG :: Blocking on waitq permenantly. But size = " + this.size());
        }
        try {
            this.wait(l);
        }
        catch (InterruptedException interruptedException) {}
    }

    public synchronized boolean waitUntilReady() {
        while (!this.isBeingDestroyed) {
            long l = 0L;
            if (!this.isEmpty()) {
                long l2 = System.currentTimeMillis();
                SnmpInformRequest snmpInformRequest = (SnmpInformRequest)this.lastElement();
                l = snmpInformRequest.getAbsMaxTimeToWait() - l2;
                if (l <= 0L) {
                    return true;
                }
            }
            this.waitOnThisQueue(l);
        }
        return false;
    }
}

