/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Trace;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.HeartBeatServerHandler;
import com.sun.jdmk.comm.ServerNotificationDispatcher;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

abstract class RmiConnectorServerObjectCommon
extends UnicastRemoteObject {
    private String host;
    private String serviceName = null;
    private int port;
    private boolean isActive = false;
    ServerNotificationDispatcher serverNotificationDispatcher = null;
    HeartBeatServerHandler heartbeatServerHandler = null;

    public RmiConnectorServerObjectCommon(String string, int n, ServerNotificationDispatcher serverNotificationDispatcher, HeartBeatServerHandler heartBeatServerHandler) throws RemoteException {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            this.host = "localhost";
        }
        this.serviceName = string;
        this.port = n;
        this.serviceName = RmiConnectorServerObjectCommon.makeManagedObjFactoryName(this.host, n, string);
        this.serverNotificationDispatcher = serverNotificationDispatcher;
        this.heartbeatServerHandler = heartBeatServerHandler;
    }

    void bind() throws CommunicationException, RemoteException {
        Registry registry = null;
        try {
            if (this.isDebugOn()) {
                this.debug("bind", "Register object in RmiRegistry ; name=" + this.serviceName);
            }
            Naming.bind(this.serviceName, this);
            if (this.isDebugOn()) {
                this.debug("bind", "Done");
            }
        }
        catch (AlreadyBoundException alreadyBoundException) {
            throw new CommunicationException(alreadyBoundException, "Failed to register " + this.serviceName);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CommunicationException(malformedURLException, "Failed to register " + this.serviceName);
        }
        catch (AccessException accessException) {
            throw new CommunicationException(accessException, "Failed to register " + this.serviceName);
        }
        catch (RemoteException remoteException) {
            if (this.isDebugOn()) {
                this.debug("bind", "Create Rmi registry port=" + this.port);
            }
            registry = LocateRegistry.createRegistry(this.port);
            if (this.isDebugOn()) {
                this.debug("bind", "Done");
            }
            try {
                if (this.isDebugOn()) {
                    this.debug("bind", "Register object in RmiRegistry ; name=" + this.serviceName);
                }
                Naming.bind(this.serviceName, this);
                if (this.isDebugOn()) {
                    this.debug("bind", "Done");
                }
            }
            catch (Exception exception) {
                throw new CommunicationException(exception, "Failed to register " + this.serviceName);
            }
        }
        this.isActive = true;
    }

    void debug(String string, String string2) {
        this.debug(this.getLocalClassName(), string, string2);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, this.getInfoType(), string, string2, string3);
    }

    abstract int getInfoType();

    abstract String getLocalClassName();

    boolean isDebugOn() {
        return Trace.isSelected(2, this.getInfoType());
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, this.getInfoType());
    }

    static String makeManagedObjFactoryName(String string, int n, String string2) {
        return "rmi://" + string + ":" + n + "/" + string2;
    }

    void stopIfNotActive(String string) throws RemoteException {
        if (!this.isActive) {
            if (this.isTraceOn()) {
                this.trace(string, "Connector is OFFLINE.");
            }
            throw new RemoteException("Connector is OFFLINE.");
        }
    }

    void trace(String string, String string2) {
        this.trace(this.getLocalClassName(), string, string2);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, this.getInfoType(), string, string2, string3);
    }

    void unbind() {
        try {
            if (this.isDebugOn()) {
                this.debug("unbind", "Unregister object in RmiRegistry ; name=" + this.serviceName);
            }
            Naming.unbind(this.serviceName);
            if (this.isDebugOn()) {
                this.debug("unbind", "Done");
            }
        }
        catch (Exception exception) {}
        this.isActive = false;
    }
}

