/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.HttpBody;
import com.sun.jdmk.comm.MalformedHttpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class HttpMessage {
    String httpVersion = null;
    static final String CRLF = "\r\n";
    static final String[] KNOWN_HEADERS = new String[]{"Content-Length", "Content-Type", "Date", "Connection", "WWW-Authenticate", "Authorization"};
    static final int CONTENT_LENGTH_HEADER = 0;
    static final int CONTENT_TYPE_HEADER = 1;
    static final int DATE_HEADER = 2;
    static final int CONNECTION_HEADER = 3;
    static final int WWW_AUTHENTICATE_HEADER = 4;
    static final int AUTHORIZATION_HEADER = 5;
    private String[] headers = new String[KNOWN_HEADERS.length];
    private HttpBody body;

    HttpMessage(HttpBody httpBody) {
        if (httpBody == null) {
            throw new IllegalArgumentException("HttpBody cannot be null");
        }
        this.body = httpBody;
        this.setContentLength();
    }

    byte[] getContentBytes() {
        return this.body.getBytes();
    }

    int getContentLength() {
        return this.body.getByteCount();
    }

    String getHeader(int n) {
        return this.headers[n];
    }

    boolean hasKeepAliveFlag() {
        String string = this.getHeader(3);
        if (string == null) {
            return false;
        }
        return string.toLowerCase().equals("keep-alive");
    }

    void readBodyFrom(InputStream inputStream, int n) throws IOException {
        this.body.readFrom(inputStream, n);
        this.setContentLength();
    }

    abstract void readFrom(InputStream var1) throws IOException, MalformedHttpException;

    private void setContentLength() {
        int n = this.body.getByteCount();
        String string = n > 0 ? Integer.toString(n) : null;
        this.setHeader(0, string);
    }

    void setHeader(int n, String string) {
        this.headers[n] = string;
    }

    void writeHeadersAndBodyTo(OutputStream outputStream, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(CRLF);
        int n = 0;
        while (n < KNOWN_HEADERS.length) {
            String string2 = this.getHeader(n);
            if (string2 != null) {
                stringBuffer.append(KNOWN_HEADERS[n]).append(": ").append(string2).append(CRLF);
            }
            ++n;
        }
        stringBuffer.append(CRLF);
        outputStream.write(stringBuffer.toString().getBytes());
        this.body.writeTo(outputStream);
    }

    abstract void writeTo(OutputStream var1) throws IOException;
}

