/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanParameterInfo;

public class MBeanOperationInfo
extends MBeanFeatureInfo
implements Serializable,
Cloneable {
    static final long serialVersionUID = -6178860474881375330L;
    public static final int INFO = 0;
    public static final int ACTION = 1;
    public static final int ACTION_INFO = 2;
    public static final int UNKNOWN = 3;
    private transient Method method = null;
    private String type = null;
    private MBeanParameterInfo[] signature = null;
    private int impact = 3;

    public MBeanOperationInfo(String string, String string2, MBeanParameterInfo[] mBeanParameterInfoArray, String string3, int n) {
        super(string, string2);
        this.signature = mBeanParameterInfoArray;
        this.type = string3;
        this.impact = n;
    }

    public MBeanOperationInfo(String string, Method method) {
        super(method.getName(), string);
        this.method = method;
        this.findMethodReturnType();
        this.findMethodParameterTypes();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void findMethodParameterTypes() {
        String[] stringArray = this.findSignatures(this.method.getParameterTypes());
        if (stringArray != null) {
            int n = stringArray.length;
            this.signature = new MBeanParameterInfo[n];
            int n2 = 0;
            while (n2 < n) {
                this.signature[n2] = new MBeanParameterInfo("", stringArray[n2], "");
                ++n2;
            }
        }
    }

    private void findMethodReturnType() {
        this.type = this.method.getReturnType().getName();
    }

    private String findSignature(Class clazz) {
        return clazz.getName();
    }

    private String[] findSignatures(Class[] classArray) {
        String[] stringArray = new String[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            stringArray[n] = this.findSignature(classArray[n]);
            ++n;
        }
        return stringArray;
    }

    public int getImpact() {
        return this.impact;
    }

    public String getReturnType() {
        return this.type;
    }

    public MBeanParameterInfo[] getSignature() {
        if (this.signature != null) {
            int n = this.signature.length;
            MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[n];
            int n2 = 0;
            while (n2 < n) {
                mBeanParameterInfoArray[n2] = (MBeanParameterInfo)this.signature[n2].clone();
                ++n2;
            }
            return mBeanParameterInfoArray;
        }
        return new MBeanParameterInfo[0];
    }
}

