/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.agent;

import com.sun.jdmk.snmp.agent.SnmpMibGroup;
import com.sun.jdmk.snmp.agent.SnmpMibNode;
import com.sun.jdmk.snmp.agent.SnmpMibSubRequest;
import com.sun.jdmk.snmp.agent.SnmpRequestTree;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBind;

public class SnmpMibOid
extends SnmpMibNode
implements Serializable {
    private NonSyncVector children = new NonSyncVector(1);
    private int nbChildren = 0;

    public void check(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        Enumeration enumeration = snmpMibSubRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            SnmpStatusException snmpStatusException = new SnmpStatusException(6);
            snmpMibSubRequest.registerCheckException(snmpVarBind, snmpStatusException);
        }
    }

    void exportChildren(SnmpMibOid snmpMibOid) throws IllegalAccessException {
        if (snmpMibOid == null) {
            return;
        }
        long[] lArray = new long[1];
        int n = 0;
        while (n < this.nbChildren) {
            SnmpMibNode snmpMibNode = (SnmpMibNode)this.children.elementAt(n);
            if (snmpMibNode != null) {
                lArray[0] = this.varList[n];
                snmpMibOid.registerNode(lArray, 0, snmpMibNode);
            }
            ++n;
        }
    }

    void findHandlingNode(SnmpVarBind snmpVarBind, long[] lArray, int n, SnmpRequestTree snmpRequestTree) throws SnmpStatusException {
        int n2 = lArray.length;
        Object var6_6 = null;
        if (snmpRequestTree == null) {
            throw new SnmpStatusException(5);
        }
        if (n > n2) {
            throw SnmpMibNode.noSuchObjectException;
        }
        if (n == n2) {
            throw SnmpMibNode.noSuchInstanceException;
        }
        SnmpMibNode snmpMibNode = this.getChild(lArray[n]);
        if (snmpMibNode == null) {
            snmpRequestTree.add(this, n, snmpVarBind);
        } else {
            snmpMibNode.findHandlingNode(snmpVarBind, lArray, n + 1, snmpRequestTree);
        }
    }

    long[] findNextHandlingNode(SnmpVarBind snmpVarBind, long[] lArray, int n, int n2, SnmpRequestTree snmpRequestTree) throws SnmpStatusException {
        int n3 = lArray.length;
        Object var7_7 = null;
        if (snmpRequestTree == null) {
            throw SnmpMibNode.noSuchObjectException;
        }
        Object object = snmpRequestTree.getUserData();
        if (n >= n3) {
            long[] lArray2 = new long[1];
            if (this.varList == null || this.varList.length < 1) {
                throw SnmpMibNode.noSuchObjectException;
            }
            lArray2[0] = this.varList[0];
            return this.findNextHandlingNode(snmpVarBind, lArray2, 0, n2, snmpRequestTree);
        }
        long[] lArray3 = new long[1];
        long l = lArray[n];
        while (true) {
            try {
                SnmpMibNode snmpMibNode = this.getChild(l);
                long[] lArray4 = null;
                if (snmpMibNode == null) {
                    throw SnmpMibNode.noSuchObjectException;
                }
                lArray4 = snmpMibNode.findNextHandlingNode(snmpVarBind, lArray, n + 1, n2 + 1, snmpRequestTree);
                lArray4[n2] = l;
                return lArray4;
            }
            catch (SnmpStatusException snmpStatusException) {
                lArray3[0] = l = this.getNextVarId(l, object);
                n = 1;
                lArray = lArray3;
                continue;
            }
            break;
        }
    }

    public void get(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        Enumeration enumeration = snmpMibSubRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            SnmpStatusException snmpStatusException = new SnmpStatusException(225);
            snmpMibSubRequest.registerGetException(snmpVarBind, snmpStatusException);
        }
    }

    private SnmpMibNode getChild(long l) throws SnmpStatusException {
        int n = this.getInsertAt(l);
        if (n >= this.nbChildren) {
            throw SnmpMibNode.noSuchObjectException;
        }
        if (this.varList[n] != (int)l) {
            throw new SnmpStatusException(5);
        }
        SnmpMibNode snmpMibNode = null;
        try {
            snmpMibNode = (SnmpMibNode)this.children.elementAtNonSync(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw SnmpMibNode.noSuchObjectException;
        }
        if (snmpMibNode == null) {
            throw SnmpMibNode.noSuchInstanceException;
        }
        return snmpMibNode;
    }

    private int getInsertAt(long l) {
        int n = 0;
        int n2 = (int)l;
        if (this.varList == null) {
            return -1;
        }
        int n3 = this.varList.length - 1;
        int n4 = 0;
        int n5 = n + (n3 - n) / 2;
        while (n <= n3) {
            n4 = this.varList[n5];
            if (n2 == n4) {
                return n5;
            }
            if (n4 < n2) {
                n = n5 + 1;
            } else {
                n3 = n5 - 1;
            }
            n5 = n + (n3 - n) / 2;
        }
        return n5;
    }

    public void getRootOid(Vector vector) {
        if (this.nbChildren != 1) {
            return;
        }
        vector.addElement(new Integer(this.varList[0]));
        ((SnmpMibNode)this.children.firstElement()).getRootOid(vector);
    }

    public void registerNode(String string, SnmpMibNode snmpMibNode) throws IllegalAccessException {
        SnmpOid snmpOid = new SnmpOid(string);
        this.registerNode(snmpOid.longValue(), 0, snmpMibNode);
    }

    void registerNode(long[] lArray, int n, SnmpMibNode snmpMibNode) throws IllegalAccessException {
        if (n >= lArray.length) {
            throw new IllegalAccessException();
        }
        long l = lArray[n];
        int n2 = this.retrieveIndex(l);
        if (n2 == this.nbChildren) {
            ++this.nbChildren;
            this.varList = new int[this.nbChildren];
            this.varList[0] = (int)l;
            n2 = 0;
            if (n + 1 == lArray.length) {
                this.children.insertElementAt(snmpMibNode, n2);
                return;
            }
            SnmpMibOid snmpMibOid = new SnmpMibOid();
            this.children.insertElementAt(snmpMibOid, n2);
            snmpMibOid.registerNode(lArray, n + 1, snmpMibNode);
            return;
        }
        if (n2 == -1) {
            int[] nArray = new int[this.nbChildren + 1];
            nArray[this.nbChildren] = (int)l;
            System.arraycopy(this.varList, 0, nArray, 0, this.nbChildren);
            this.varList = nArray;
            ++this.nbChildren;
            SnmpMibNode.sort(this.varList);
            int n3 = this.retrieveIndex(l);
            this.varList[n3] = (int)l;
            if (n + 1 == lArray.length) {
                this.children.insertElementAt(snmpMibNode, n3);
                return;
            }
            SnmpMibOid snmpMibOid = new SnmpMibOid();
            this.children.insertElementAt(snmpMibOid, n3);
            snmpMibOid.registerNode(lArray, n + 1, snmpMibNode);
            return;
        }
        SnmpMibNode snmpMibNode2 = (SnmpMibNode)this.children.elementAt(n2);
        if (n + 1 == lArray.length) {
            if (snmpMibNode2 == snmpMibNode) {
                return;
            }
            if (snmpMibNode2 != null && snmpMibNode != null) {
                if (snmpMibNode instanceof SnmpMibGroup) {
                    ((SnmpMibOid)snmpMibNode2).exportChildren((SnmpMibOid)snmpMibNode);
                    this.children.setElementAt(snmpMibNode, n2);
                    return;
                }
                if (snmpMibNode instanceof SnmpMibOid && snmpMibNode2 instanceof SnmpMibGroup) {
                    ((SnmpMibOid)snmpMibNode).exportChildren((SnmpMibOid)snmpMibNode2);
                    return;
                }
                if (snmpMibNode instanceof SnmpMibOid) {
                    ((SnmpMibOid)snmpMibNode2).exportChildren((SnmpMibOid)snmpMibNode);
                    this.children.setElementAt(snmpMibNode, n2);
                    return;
                }
            }
            this.children.setElementAt(snmpMibNode, n2);
            return;
        }
        if (snmpMibNode2 == null) {
            throw new IllegalAccessException();
        }
        ((SnmpMibOid)snmpMibNode2).registerNode(lArray, n + 1, snmpMibNode);
    }

    private int retrieveIndex(long l) {
        int n = 0;
        int n2 = (int)l;
        if (this.varList == null || this.varList.length < 1) {
            return this.nbChildren;
        }
        int n3 = this.varList.length - 1;
        int n4 = n + (n3 - n) / 2;
        int n5 = 0;
        while (n <= n3) {
            n5 = this.varList[n4];
            if (n2 == n5) {
                return n4;
            }
            if (n5 < n2) {
                n = n4 + 1;
            } else {
                n3 = n4 - 1;
            }
            n4 = n + (n3 - n) / 2;
        }
        return -1;
    }

    public void set(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        Enumeration enumeration = snmpMibSubRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            SnmpStatusException snmpStatusException = new SnmpStatusException(6);
            snmpMibSubRequest.registerSetException(snmpVarBind, snmpStatusException);
        }
    }

    class NonSyncVector
    extends Vector {
        public NonSyncVector(int n) {
            super(n);
        }

        final void addNonSyncElement(Object object) {
            this.ensureCapacity(this.elementCount + 1);
            this.elementData[this.elementCount++] = object;
        }

        final Object elementAtNonSync(int n) {
            return this.elementData[n];
        }
    }
}

