/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ConnectorAddress;
import java.net.InetAddress;

public class RmiConnectorAddress
implements ConnectorAddress {
    private String host = null;
    private int defaultPort;
    private int port = this.defaultPort = 1099;
    private String defaultServiceName;
    private String serviceName = this.defaultServiceName = "name=RmiConnectorServer";

    public RmiConnectorAddress() {
        if (System.getProperty("useIpAddresses") != null) {
            try {
                this.host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                this.host = "127.0.0.1";
            }
        } else {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                this.host = "localhost";
            }
        }
    }

    public RmiConnectorAddress(String string, int n, String string2) {
        if (System.getProperty("useIpAddresses") != null) {
            try {
                this.host = InetAddress.getByName(string).getHostAddress();
            }
            catch (Exception exception) {
                this.host = "127.0.0.1";
            }
        } else {
            try {
                this.host = InetAddress.getByName(string).getHostName();
            }
            catch (Exception exception) {
                this.host = "localhost";
            }
        }
        this.port = n;
        this.serviceName = string2;
    }

    public String getConnectorType() {
        return "SUN RMI";
    }

    public String getHost() {
        return this.host;
    }

    public String getName() {
        return this.serviceName;
    }

    public int getPort() {
        return this.port;
    }

    public void setHost(String string) {
        if (System.getProperty("useIpAddresses") != null) {
            try {
                this.host = InetAddress.getByName(string).getHostAddress();
            }
            catch (Exception exception) {
                this.host = "127.0.0.1";
            }
        } else {
            this.host = string;
        }
    }

    public void setName(String string) {
        this.serviceName = string;
    }

    public void setPort(int n) {
        this.port = n;
    }
}

