/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ClientNotificationDispatcher;
import com.sun.jdmk.comm.GenericHttpConnectorClient;
import com.sun.jdmk.comm.GenericHttpNotificationReceiver;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpSocket;

class HttpNotificationReceiver
extends GenericHttpNotificationReceiver {
    private int timeout = 60000;

    public HttpNotificationReceiver(GenericHttpConnectorClient genericHttpConnectorClient, ClientNotificationDispatcher clientNotificationDispatcher) {
        super(2, 0, genericHttpConnectorClient, clientNotificationDispatcher);
    }

    GenericHttpSocket createSocket() {
        HttpSocket httpSocket = new HttpSocket();
        httpSocket.setTimeout(this.getTimeout());
        return httpSocket;
    }

    public String getProtocol() {
        return "http";
    }

    public int getTimeout() {
        if (this.sockListen != null) {
            return this.sockListen.getTimeout();
        }
        return this.timeout;
    }

    protected String makeDebugTag() {
        return "HttpNotificationReceiver[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    public void setTimeout(int n) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.timeout = n;
        if (this.sockListen != null) {
            this.sockListen.setTimeout(n);
        }
    }
}

