/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.JdmkThreadLocal;

public class ThreadContext
implements Cloneable {
    private ThreadContext previous;
    private String key;
    private Object value;
    private static JdmkThreadLocal localContext = new JdmkThreadLocal();

    private ThreadContext(ThreadContext threadContext, String string, Object object) {
        this.previous = threadContext;
        this.key = string;
        this.value = object;
    }

    public static boolean contains(String string) throws IllegalArgumentException {
        return ThreadContext.contextContaining(string) != null;
    }

    private static ThreadContext contextContaining(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null key");
        }
        ThreadContext threadContext = ThreadContext.getContext();
        while (threadContext != null) {
            if (string.equals(threadContext.key)) {
                return threadContext;
            }
            threadContext = threadContext.previous;
        }
        return null;
    }

    public static Object get(String string) throws IllegalArgumentException {
        ThreadContext threadContext = ThreadContext.contextContaining(string);
        if (threadContext == null) {
            return null;
        }
        return threadContext.value;
    }

    private static ThreadContext getContext() {
        return (ThreadContext)localContext.get();
    }

    public static ThreadContext getThreadContext() {
        return ThreadContext.getContext();
    }

    public static ThreadContext push(String string, Object object) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null key");
        }
        ThreadContext threadContext = ThreadContext.getContext();
        if (threadContext == null) {
            threadContext = new ThreadContext(null, null, null);
        }
        ThreadContext threadContext2 = new ThreadContext(threadContext, string, object);
        ThreadContext.setContext(threadContext2);
        return threadContext;
    }

    public static void restore(ThreadContext threadContext) throws NullPointerException, IllegalArgumentException {
        if (threadContext == null) {
            throw new NullPointerException();
        }
        ThreadContext threadContext2 = ThreadContext.getContext();
        while (threadContext2 != threadContext) {
            if (threadContext2 == null) {
                throw new IllegalArgumentException("Restored context is not contained in current context");
            }
            threadContext2 = threadContext2.previous;
        }
        if (threadContext.key == null) {
            threadContext = null;
        }
        ThreadContext.setContext(threadContext);
    }

    private static void setContext(ThreadContext threadContext) {
        localContext.set(threadContext);
    }

    public void setInitialContext(ThreadContext threadContext) throws IllegalArgumentException {
        if (ThreadContext.getContext() != null) {
            throw new IllegalArgumentException("previous context not empty");
        }
        ThreadContext.setContext(threadContext);
    }
}

